/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.common;

import com.kingdee.eas.base.wssc.util.SafeFilterUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class MapUtil {
    private static Logger logger = Logger.getLogger(MapUtil.class);
    private static Properties properties = new Properties();

    public static String getValue(String key) {
        return properties.getProperty(key);
    }

    public static void load(String fileName) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(fileName);
            properties.load(fileInputStream);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    public static void clearCache() {
        properties.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh(String fileName) {
        Properties prop = new Properties();
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(fileName);
            prop.load(fs);
            MapUtil.setProperties(prop);
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SafeFilterUtils.safeClose(fs);
                throw throwable;
            }
            SafeFilterUtils.safeClose((InputStream)fs);
        }
        SafeFilterUtils.safeClose((InputStream)fs);
    }

    public static void setProperties(Properties prop) {
        if (prop == null || prop.isEmpty()) {
            return;
        }
        Set<Object> keys = prop.keySet();
        if (keys != null) {
            for (String string : keys) {
                properties.setProperty(string, prop.getProperty(string));
            }
        }
    }
}

