/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.monitor.core.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.ssc.monitor.core.Enum.BigEnum;
import com.kingdee.eas.base.ssc.monitor.core.Enum.EqualEmum;
import com.kingdee.eas.base.ssc.monitor.core.Enum.NotEqualEnum;
import com.kingdee.eas.base.ssc.monitor.core.Enum.SmallEnum;
import com.kingdee.eas.base.ssc.monitor.core.model.Field;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class MonitorUtils {
    public static String[] analysisInnerRule(String innerRule) {
        innerRule = innerRule.trim();
        String[] innerRuleArray = innerRule.split("inner");
        return innerRuleArray;
    }

    public static Object deeplyCopy(Serializable obj) throws Exception {
        try {
            return MonitorUtils.bytes2object(MonitorUtils.object2bytes(obj));
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    private static byte[] object2bytes(Serializable obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.close();
        baos.close();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object bytes2object(byte[] bytes) throws IOException, ClassNotFoundException {
        Object var3;
        try (ObjectInputStream ois = null;){
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ois = new ObjectInputStream(bais);
            var3 = ois.readObject();
        }
        return var3;
    }

    public static List<String[]> openExpression(String exprssion) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        String[] array = new String[2];
        String[] oper = new String[1];
        if (exprssion.contains("<>")) {
            array = exprssion.split("<>");
            oper[0] = "<>";
        } else if (exprssion.contains(">")) {
            array = exprssion.split(">");
            oper[0] = ">";
        } else if (exprssion.contains("<")) {
            array = exprssion.split("<");
            oper[0] = "<";
        } else if (exprssion.contains("inner")) {
            array = exprssion.split("inner");
            oper[0] = "inner";
        } else if (exprssion.contains("=")) {
            array[0] = exprssion.substring(0, StringUtils.ordinalIndexOf((String)exprssion, (String)"=", (int)2));
            array[1] = exprssion.substring(StringUtils.ordinalIndexOf((String)exprssion, (String)"=", (int)2) + 1, exprssion.length());
            oper[0] = "=";
        }
        list.add(array);
        list.add(oper);
        return list;
    }

    public static Enum getEnum(String oper) {
        if ("=".equals(oper)) {
            return EqualEmum.EQUAL;
        }
        if ("<>".equals(oper)) {
            return NotEqualEnum.NOTEQUAL;
        }
        if (">".equals(oper)) {
            return BigEnum.BIG;
        }
        if ("<".equals(oper)) {
            return SmallEnum.SMALL;
        }
        return null;
    }

    public static StringBuffer appendFieldsAnd(Field left, Field right, int leftAlia, int rightAlia) {
        StringBuffer sb = new StringBuffer("");
        String leftName = left.getFieldName().substring(2, left.getFieldName().length() - 1);
        String rightName = right.getFieldName().substring(2, right.getFieldName().length() - 1);
        sb.append("\"").append(left.getSqlId()).append("\"").append(".").append("\"").append(leftAlia).append(".").append("F").append(leftName).append("\"").append(" = ").append("\"").append(right.getSqlId()).append("\"").append(".").append("\"").append(rightAlia).append(".").append("F").append(rightName).append("\"").append(" and ");
        return sb;
    }

    public static StringBuffer appendFields(Field left, Field right, int leftAlia, int rightAlia) {
        StringBuffer sb = new StringBuffer("");
        String leftName = left.getFieldName().substring(2, left.getFieldName().length() - 1);
        String rightName = right.getFieldName().substring(2, right.getFieldName().length() - 1);
        sb.append("\"").append(left.getSqlId()).append("\"").append(".").append("\"").append(leftAlia).append(".").append("F").append(leftName).append("\"").append(" = ").append("\"").append(right.getSqlId()).append("\"").append(".").append("\"").append(rightAlia).append(".").append("F").append(rightName).append("\"");
        return sb;
    }
}

