/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.monitor.database;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.DataBaseCfgInfo;
import com.kingdee.eas.base.ssc.DataBaseType;
import com.kingdee.eas.base.ssc.MonitorInfo;
import com.kingdee.eas.base.ssc.monitor.core.model.Field;
import com.kingdee.eas.base.ssc.monitor.core.model.RowModel;
import com.kingdee.eas.base.ssc.monitor.core.model.SqlResultModel;
import com.kingdee.eas.base.ssc.tool.AESUtil;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractDataBase {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.monitor.database.AbstractDataBase");
    protected Context ctx;
    protected String host;
    protected int port;
    protected String user;
    protected String password;
    protected String dataBaseName;
    private static String CHARSET = "utf-8";
    public static final Map<DataBaseType, String> DRIVERNAME = new HashMap<DataBaseType, String>();

    public AbstractDataBase(Context ctx, DataBaseCfgInfo dataBaseCfgInfo) {
        this.ctx = ctx;
        this.host = dataBaseCfgInfo.getServerIp();
        this.port = dataBaseCfgInfo.getPort();
        this.user = dataBaseCfgInfo.getGrantUser();
        this.password = dataBaseCfgInfo.getPassword();
        this.dataBaseName = dataBaseCfgInfo.getDataBaseType().getValue().startsWith("Oracle") ? dataBaseCfgInfo.getServerName() : dataBaseCfgInfo.getDatabaseName();
    }

    public AbstractDataBase(Context ctx, String host, int port, String user, String password, String dataBaseName) {
        this.ctx = ctx;
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.dataBaseName = dataBaseName;
    }

    public static String getCHARSET() {
        return CHARSET;
    }

    public static void setCHARSET(String CHARSET) {
        AbstractDataBase.CHARSET = CHARSET;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public abstract String getUrl();

    public abstract String getDriverName();

    public Connection getConnection() throws ClassNotFoundException, SQLException {
        Class.forName(this.getDriverName());
        String password = "";
        try {
            password = AESUtil.getInstance().decryp(this.getPassword());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        Connection connection = DriverManager.getConnection(this.getUrl(), this.getUser(), password);
        return connection;
    }

    public boolean testConnection() throws SQLException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            AbstractDataBase.closeConn(connection);
        }
        return false;
    }

    public static void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getColumnNames(String sql, Object[] params) throws SQLException, ClassNotFoundException {
        ArrayList<String> arrayList;
        if (StringUtils.isEmpty((String)sql)) {
            logger.error((Object)"sql \u4e3a null;");
            throw new NullPointerException("sql \u4e3a null;");
        }
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(sql);
            if (params != null && params.length > 0) {
                for (int i = 1; i <= params.length; ++i) {
                    ps.setObject(i, params[i - 1]);
                }
            }
            rs = ps.executeQuery();
            ResultSetMetaData dm = rs.getMetaData();
            int columnCount = dm.getColumnCount();
            ArrayList<String> columnNames = new ArrayList<String>();
            for (int i = 1; i <= columnCount; ++i) {
                columnNames.add(dm.getColumnName(i));
            }
            arrayList = columnNames;
        }
        catch (Throwable throwable) {
            AbstractDataBase.closeConn(connection);
            AbstractDataBase.close(ps, rs);
            throw throwable;
        }
        AbstractDataBase.closeConn(connection);
        AbstractDataBase.close(ps, rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> executeQuery(Connection connection, String sql, Object[] params) throws SQLException {
        ArrayList<Map<String, Object>> arrayList;
        if (connection == null || StringUtils.isEmpty((String)sql)) {
            logger.error((Object)"connection \u6216 sql \u4e3a null;");
            throw new NullPointerException("connection \u6216 sql \u4e3a null;");
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = connection.prepareStatement(sql);
            if (params != null && params.length > 0) {
                for (int i = 1; i <= params.length; ++i) {
                    ps.setObject(i, params[i - 1]);
                }
            }
            rs = ps.executeQuery();
            ResultSetMetaData dm = rs.getMetaData();
            int columnCount = dm.getColumnCount();
            String[] columnNames = new String[columnCount];
            for (int i = 1; i <= columnCount; ++i) {
                columnNames[i - 1] = dm.getColumnName(i);
            }
            while (rs.next()) {
                HashMap<String, String> tmp = new HashMap<String, String>();
                for (int i = 0; i < columnCount; ++i) {
                    tmp.put(columnNames[i], rs.getString(columnNames[i]));
                }
                result.add(tmp);
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            AbstractDataBase.close(ps, rs);
            throw throwable;
        }
        AbstractDataBase.close(ps, rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SqlResultModel executeQuerySqlResultModel(Connection connection, String sql, String sqlId, Object[] params) throws SQLException {
        SqlResultModel sqlResultModel;
        if (connection == null || StringUtils.isEmpty((String)sql)) {
            logger.error((Object)"connection \u6216 sql \u4e3a null;");
            throw new NullPointerException("connection \u6216 sql \u4e3a null;");
        }
        HashMap result = new HashMap();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = connection.prepareStatement(sql);
            if (params != null && params.length > 0) {
                for (int i = 1; i <= params.length; ++i) {
                    ps.setObject(i, params[i - 1]);
                }
            }
            rs = ps.executeQuery();
            ResultSetMetaData dm = rs.getMetaData();
            int columnCount = dm.getColumnCount();
            String[] columnNames = new String[columnCount];
            String[] columnTypes = new String[columnCount];
            for (int i = 1; i <= columnCount; ++i) {
                columnNames[i - 1] = dm.getColumnName(i);
                columnTypes[i - 1] = dm.getColumnTypeName(i).equals("int") ? "int" : "VARCHAR(44)";
            }
            ArrayList<RowModel> list = new ArrayList<RowModel>();
            RowModel rowModel = null;
            SqlResultModel sqlResultModel2 = new SqlResultModel();
            while (rs.next()) {
                rowModel = new RowModel();
                ArrayList<Field> fieldList = new ArrayList<Field>();
                Field fieldKey = new Field();
                fieldKey.setFieldName("fmonitoruuid");
                fieldKey.setFieldValue(BOSUuid.create((BOSObjectType)new MonitorInfo().getBOSType()));
                fieldKey.setSqlId(sqlId);
                fieldKey.setFieldStruct("VARCHAR(44)");
                fieldList.add(fieldKey);
                for (int i = 0; i < columnCount; ++i) {
                    Field field = new Field();
                    field.setFieldName(columnNames[i]);
                    field.setFieldValue(rs.getString(columnNames[i]));
                    field.setSqlId(sqlId);
                    field.setFieldStruct(columnTypes[i]);
                    fieldList.add(field);
                }
                rowModel.setId(BOSUuid.create((BOSObjectType)new MonitorInfo().getBOSType()));
                rowModel.setFields(fieldList);
                list.add(rowModel);
            }
            sqlResultModel2.setRows(list);
            sqlResultModel = sqlResultModel2;
        }
        catch (Throwable throwable) {
            AbstractDataBase.close(ps, rs);
            throw throwable;
        }
        AbstractDataBase.close(ps, rs);
        return sqlResultModel;
    }

    private static void close(PreparedStatement ps, ResultSet rs) {
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlResultModel executeQuerySqlResultModel(String sql, String sqlId, Object[] params) throws SQLException, ClassNotFoundException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            SqlResultModel sqlResultModel = AbstractDataBase.executeQuerySqlResultModel(connection, sql, sqlId, params);
            return sqlResultModel;
        }
        finally {
            AbstractDataBase.closeConn(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> executeQuery(String sql, Object[] params) throws SQLException, ClassNotFoundException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            List<Map<String, Object>> list = AbstractDataBase.executeQuery(connection, sql, params);
            return list;
        }
        finally {
            AbstractDataBase.closeConn(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exist(Connection connection, String sql, Object[] params) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block5: {
            boolean bl;
            if (connection == null || StringUtils.isEmpty((String)sql)) {
                logger.error((Object)"connection \u6216 sql \u4e3a null;");
                throw new NullPointerException("connection \u6216 sql \u4e3a null;");
            }
            ps = null;
            rs = null;
            try {
                ps = connection.prepareStatement(sql);
                if (params != null && params.length > 0) {
                    for (int i = 1; i <= params.length; ++i) {
                        ps.setObject(i, params[i - 1]);
                    }
                }
                if (!(rs = ps.executeQuery()).next()) break block5;
                bl = true;
            }
            catch (Throwable throwable) {
                AbstractDataBase.close(ps, rs);
                throw throwable;
            }
            AbstractDataBase.close(ps, rs);
            return bl;
        }
        AbstractDataBase.close(ps, rs);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exist(String sql, Object[] params) throws SQLException, ClassNotFoundException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            boolean bl = AbstractDataBase.exist(connection, sql, params);
            return bl;
        }
        finally {
            AbstractDataBase.closeConn(connection);
        }
    }

    static {
        DRIVERNAME.put(DataBaseType.ORACLE, "oracle.jdbc.driver.OracleDriver");
        DRIVERNAME.put(DataBaseType.SQLSERVER, "com.microsoft.jdbc.sqlserver.SQLServerDriver");
        DRIVERNAME.put(DataBaseType.MYSQL, "com.mysql.jdbc.Driver");
        DRIVERNAME.put(DataBaseType.DB2, "com.ibm.db2.jcc.DB2Driver");
        DRIVERNAME.put(DataBaseType.DATACENTER, "");
        DRIVERNAME.put(DataBaseType.DM, "dm.jdbc.driver.DmDriver");
    }
}

