/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.thread;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.ssc.AnalysisEnum;
import com.kingdee.eas.base.ssc.BussinessAttributeFactory;
import com.kingdee.eas.base.ssc.BussinessAttributeInfo;
import com.kingdee.eas.base.ssc.CreditFilesNewInfo;
import com.kingdee.eas.base.ssc.JobHisFactory;
import com.kingdee.eas.base.ssc.JobHisInfo;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.base.ssc.JobState;
import com.kingdee.eas.base.ssc.PredictJobPoolFactory;
import com.kingdee.eas.base.ssc.SatisfactionBillInquireFactory;
import com.kingdee.eas.base.ssc.SatisfactionBillInquireInfo;
import com.kingdee.eas.base.ssc.YesOrNo;
import com.kingdee.eas.base.ssc.analysis.ThreadPoll.AnalysisFlowFactory;
import com.kingdee.eas.base.ssc.analysis.ThreadPoll.IAnalysisFlowCallback;
import com.kingdee.eas.base.ssc.analysis.util.AnalysisData;
import com.kingdee.eas.base.ssc.app.CreditShareAuditThread;
import com.kingdee.eas.base.ssc.app.SatisfactionHisAssess;
import com.kingdee.eas.base.ssc.app.SatisfactionHisSendEnum;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.JobUtils;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.base.ssc.tool.satisfaction.SatisfactionParamsUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class AfterJobApproveThread
implements Runnable {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.thread.AfterApproveJobThread");
    protected Context ctx;
    protected String jobId;
    protected JobInfo jobInfo;
    protected String userId;
    protected boolean isPass;
    protected boolean isSuccess;

    public AfterJobApproveThread(Context ctx, String jobId, JobInfo jobInfo, String userId, boolean isPass, boolean isSuccess) {
        this.ctx = ctx;
        this.jobId = jobId;
        this.jobInfo = jobInfo;
        this.userId = userId;
        this.isPass = isPass;
        this.isSuccess = isSuccess;
    }

    @Override
    public void run() {
        try {
            try {
                if (this.isSuccess && ShareCenterUtils.enablePullJob(this.ctx, ShareCenterUtils.getShareCenterIdBySSCUserId(this.ctx, this.userId))) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("job", (Object)this.jobId));
                    PredictJobPoolFactory.getLocalInstance(this.ctx).delete(filter);
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
            try {
                JobHisInfo jobhis = JobHisFactory.getLocalInstance(this.ctx).getJobHisInfo((IObjectPK)new ObjectUuidPK(this.jobId));
                if (jobhis.isIsLastLevel() && (jobhis.getJobState().getValue() == JobState.Passed.getValue() || jobhis.getJobState().getValue() == JobState.ToVouchered.getValue())) {
                    logger.error((Object)("toGetSatisfactionBillTask---" + this.jobId));
                    this.toGetSatisfactionBillTask(this.ctx, jobhis);
                } else {
                    logger.error((Object)("toGetSatisfactionBillTask---" + this.jobInfo.isIsLastLevel() + "---" + this.jobInfo.getJobState().getValue()));
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
            try {
                boolean isLastLevel = JobHisFactory.getLocalInstance(this.ctx).exists((IObjectPK)new ObjectUuidPK(this.jobId)) ? JobHisFactory.getLocalInstance(this.ctx).getJobHisInfo((IObjectPK)new ObjectUuidPK(this.jobId)).isIsLastLevel() : this.jobInfo.isIsLastLevel();
                CreditShareAuditThread creditShareAuditThread = new CreditShareAuditThread(this.ctx, this.jobInfo, isLastLevel, this.isPass, this.isSuccess);
                creditShareAuditThread.run();
            }
            catch (Exception e) {
                logger.error((Object)("---\u964d\u7ea7\u5931\u8d25jobid:" + this.jobInfo.getId().toString() + "message:" + e.getMessage()), (Throwable)e);
            }
            JobHisInfo jobHisInfo = null;
            try {
                jobHisInfo = JobHisFactory.getLocalInstance(this.ctx).getJobHisInfo((IObjectPK)new ObjectUuidPK(this.jobId));
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                throw e;
            }
            try {
                IAnalysisFlowCallback ctr = AnalysisFlowFactory.getInstanse("com.kingdee.eas.base.ssc.analysis.ThreadPoll.AnalysisThreadPool");
                AnalysisData analysisJobData = new AnalysisData();
                analysisJobData.setAnalysisType("job").setDate(new Date()).setUuid(jobHisInfo.getId().toString()).setOperateType(AnalysisEnum.JOB_FINISH);
                ctr.afterFlow(this.ctx, analysisJobData);
                if (jobHisInfo.isIsLastLevel()) {
                    AnalysisData analysisData = new AnalysisData();
                    analysisData.setAnalysisType("bill").setDate(new Date()).setUuid(jobHisInfo.getBillID()).setOperateType(AnalysisEnum.BILL_FINISH);
                    ctr.afterFlow(this.ctx, analysisData);
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)(" \u8ba1\u7b97\u5168\u6d41\u7a0b\u8017\u65f6\u5931\u8d25:" + e));
        }
    }

    protected void toGetSatisfactionBillTask(Context ctx, JobHisInfo jobhis) {
        try {
            String isSatisfaction = "";
            try {
                isSatisfaction = ParamManager.getParamValue((Context)ctx, (IObjectPK)H.PK(jobhis.getShareCenterID().getId().toString()), (String)"SSC_SatisfactionControl");
                if (!"true".equals(isSatisfaction)) {
                    logger.error((Object)("\u6ee1\u610f\u5ea6\u53c2\u6570\u6ca1\u6709\u5f00\u542f*******************SSC_SatisfactionControl**isSatisfaction" + isSatisfaction));
                    return;
                }
            }
            catch (EASBizException e) {
                logger.error((Object)("EASBizException \u83b7\u53d6\u6ee1\u610f\u5ea6\u53c2\u6570\u5931\u8d25" + isSatisfaction + "---" + (Object)((Object)e)));
                return;
            }
            boolean flag = SatisfactionParamsUtils.isMatchSatisfactionParam(ctx, jobhis.getId().toString());
            if (!flag) {
                logger.error((Object)("\u5355\u636e\u4e0d\u6ee1\u8db3\u6570\u636e\u8fc7\u6ee4\u89c4\u5219**isNeedToSatisfactionTaskByJobhis***+flag***" + flag + "jobid=" + jobhis.getId().toString()));
                return;
            }
            jobhis.setHisSendSatisfaction(YesOrNo.Yes);
            try {
                JobHisFactory.getLocalInstance(ctx).update(H.PK(jobhis.getId().toString()), (CoreBaseInfo)jobhis);
            }
            catch (Exception e) {
                logger.error((Object)("\u53cd\u5199his\u5931\u8d25\u4e86---" + e));
                return;
            }
            SatisfactionBillInquireInfo info = new SatisfactionBillInquireInfo();
            info.setJobhisid(jobhis);
            info.setShareCenterId(jobhis.getShareCenterID().getId().toString());
            BussinessAttributeInfo bussinessInfo = BussinessAttributeFactory.getLocalInstance(ctx).getBussinessAttributeInfo(H.PK(jobhis.getBussAttrID()));
            info.setBillTypeid(bussinessInfo.getBillType());
            CreditFilesNewInfo creditFilesInfo = JobUtils.getCreditFilesByJobHis(ctx, jobhis);
            info.setCreditFilesNew(creditFilesInfo);
            info.setSendOfdate(new Timestamp(new Date().getTime()));
            info.setSatisfactionHisSend(SatisfactionHisSendEnum.unSend);
            info.setIsEvaluate(SatisfactionHisAssess.nuAssess);
            SatisfactionBillInquireFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
        }
        catch (Exception e) {
            logger.error((Object)("\u4ea7\u751f\u6ee1\u610f\u5ea6bill\u5931\u8d25---" + e.getMessage()), (Throwable)e);
        }
    }
}

