/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.ExtendERPInfo;
import com.kingdee.eas.base.ssc.OrgCollection;
import com.kingdee.eas.base.ssc.OrgFactory;
import com.kingdee.eas.base.ssc.OrgInfo;
import com.kingdee.eas.base.ssc.RoleCollection;
import com.kingdee.eas.base.ssc.RoleFactory;
import com.kingdee.eas.base.ssc.RoleInfo;
import com.kingdee.eas.base.ssc.RoleOrgCollection;
import com.kingdee.eas.base.ssc.RoleOrgFactory;
import com.kingdee.eas.base.ssc.RoleOrgInfo;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.app.erp.ERPUtil;
import com.kingdee.eas.base.ssc.app.erp.ERPWebService;
import com.kingdee.eas.base.ssc.app.erp.ERPWebServiceOrg;
import com.kingdee.eas.base.ssc.tool.FillDataUtils;
import com.kingdee.eas.base.ssc.tool.FormatUtils;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.JobUtils;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OrgRoleUserUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.tool.OrgRoleUserUtils");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getUsersByRole(Context ctx, List<String> roleIds) {
        StringBuffer sb = new StringBuffer();
        sb.append(" select distinct u.fid");
        sb.append(" from t_ssc_role r,t_ssc_roleuser ru,t_ssc_user u");
        sb.append(" where r.fid = ru.froleidid");
        sb.append(" and ru.fuseridid = u.fid");
        if (roleIds != null && !roleIds.isEmpty()) {
            String roleStr = FormatUtils.list2Sql(roleIds);
            sb.append(" and r.fid in " + roleStr);
        }
        ArrayList<String> userIds = new ArrayList<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rs.next()) {
                userIds.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("sql:" + sb.toString()));
                logger.error((Object)"Query user permission exclude rule error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                JobUtils.closeRS(rs);
                throw throwable;
            }
            JobUtils.closeRS(rs);
        }
        JobUtils.closeRS(rs);
        return userIds;
    }

    public static RoleCollection getRolesByUser(Context ctx, String userId) {
        String sql = "select ru.froleidid from t_ssc_roleuser ru,t_ssc_user u where u.fid=ru.fuseridid and u.fid = '" + userId + "'";
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bussattr.*"));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        try {
            return RoleFactory.getLocalInstance(ctx).getRoleCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)"Query role of user permission error!", (Throwable)e);
            return null;
        }
    }

    public static RoleCollection getRolesByUserAndBussAttr(Context ctx, String userId, String bussAttrId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" select ru.froleidid");
        sb.append(" from t_ssc_roleuser ru,t_ssc_user u,t_ssc_rolebussattr rb");
        sb.append(" where u.fid=ru.fuseridid");
        sb.append(" and ru.FROLEIDID = rb.FPARENTID");
        sb.append(" and u.fid = '" + userId + "'");
        sb.append(" and rb.FBUSSNAMEID ='" + bussAttrId + "'");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        try {
            return RoleFactory.getLocalInstance(ctx).getRoleCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)"Query role of user permission error!", (Throwable)e);
            return null;
        }
    }

    public static boolean isImportOrgForImportOrg(Context ctx, OrgInfo orgInfo) throws EASBizException, BOSException {
        String orgID = orgInfo.getOrgID();
        String extendErpId = orgInfo.getExtendErp().getId().toString();
        String number = orgInfo.getNumber();
        String pk = OrgRoleUserUtils.existsOrgReturnPk(ctx, orgID, extendErpId);
        if (!pk.equals("")) {
            OrgRoleUserUtils.updateOrgById(ctx, orgInfo, extendErpId, pk);
            return false;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("extendErp.id", (Object)extendErpId));
        return !OrgFactory.getLocalInstance(ctx).exists(filter);
    }

    public static boolean isImportOrg(Context ctx, OrgInfo orgInfo) throws EASBizException, BOSException {
        String orgID = orgInfo.getOrgID();
        String extendErpId = orgInfo.getExtendErp().getId().toString();
        String number = orgInfo.getNumber();
        if (OrgRoleUserUtils.existsOrg(ctx, orgID, extendErpId)) {
            OrgRoleUserUtils.updateOrg(ctx, orgInfo, extendErpId);
            return false;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("extendErp.id", (Object)extendErpId));
        return !OrgFactory.getLocalInstance(ctx).exists(filter);
    }

    public static CoreBaseCollection getImportOrgs(Context ctx, ExtendERPInfo extendERPInfo, JSONArray childrenJsonArr) throws EASBizException, BOSException {
        CoreBaseCollection orgAddColl = new CoreBaseCollection();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("extendErp.id", (Object)extendERPInfo.getId()));
        view.setFilter(filter);
        OrgCollection collection = OrgFactory.getLocalInstance(ctx).getOrgCollection(view);
        HashMap<String, String> orgMap = new HashMap<String, String>();
        for (int i = 0; i < collection.size(); ++i) {
            OrgInfo info = collection.get(i);
            orgMap.put(info.getOrgID(), info.getNumber());
        }
        for (int k = 0; k < childrenJsonArr.length(); ++k) {
            try {
                Object child = childrenJsonArr.get(k);
                if (child instanceof JSONObject) {
                    JSONObject childJsonObj = (JSONObject)child;
                    OrgInfo orgInfo = OrgRoleUserUtils.jsonToOrgInfo(childJsonObj);
                    orgInfo.setExtendErp(extendERPInfo);
                    if (orgMap.containsKey(orgInfo.getId())) {
                        OrgRoleUserUtils.updateOrg(ctx, orgInfo, extendERPInfo.getId().toString());
                        continue;
                    }
                    if (orgMap.containsValue(orgInfo.getNumber())) continue;
                    FillDataUtils.fillAuditData(ctx, (ObjectBaseInfo)orgInfo);
                    orgAddColl.add((CoreBaseInfo)orgInfo);
                    continue;
                }
                logger.error((Object)"\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u63a5\u53e3\u8fd4\u56de\u7ec4\u7ec7child\u4fe1\u606f\uff0c\u6216\u4e0d\u662fjosnObject\u7c7b\u578b\u3002");
                continue;
            }
            catch (JSONException e) {
                logger.error((Object)"\u5bfc\u5165\u7ec4\u7ec7\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        return orgAddColl;
    }

    private static OrgInfo jsonToOrgInfo(JSONObject jsonObj) {
        OrgInfo orgInfo = new OrgInfo();
        try {
            orgInfo.setOrgID(jsonObj.getString("id"));
            orgInfo.setName(jsonObj.getString("name_l1"), LocaleUtils.locale_L1);
            orgInfo.setName(jsonObj.getString("name_l2"), LocaleUtils.locale_L2);
            orgInfo.setName(jsonObj.getString("name_l3"), LocaleUtils.locale_L3);
            orgInfo.setNumber(jsonObj.getString("number"));
            orgInfo.setLongNumber(jsonObj.getString("longNumber"));
            orgInfo.setParent(jsonObj.getString("parent"));
            orgInfo.setIsLeaf(jsonObj.getBoolean("isLeaf"));
            orgInfo.setLevel(jsonObj.getInt("level"));
            orgInfo.setDisplayName(jsonObj.getString("displayName"));
        }
        catch (JSONException e) {
            logger.error((Object)("jsonObj\uff1a" + jsonObj));
            logger.error((Object)"jsonToOrgInfo error\uff1a", (Throwable)e);
        }
        return orgInfo;
    }

    public static boolean isImportOrg(Context ctx, String orgID, String parentID, String extendErpId) throws EASBizException, BOSException {
        if (!OrgRoleUserUtils.existsOrg(ctx, orgID, parentID, extendErpId)) {
            logger.error((Object)"existsOrg(ctx, orgID, parentID, extendErpId):false");
            if (OrgRoleUserUtils.existsOrg(ctx, orgID, extendErpId)) {
                logger.error((Object)"existsOrg(ctx, orgID, extendErpId):true");
                String sql = "update t_ssc_org set fparent = ? where forgid = ? and fextendErpId = ?";
                logger.error((Object)(sql + "parentID:" + parentID + ", orgID:" + orgID + ", extendErpId:" + extendErpId));
                Object[] params = new Object[]{parentID, orgID, extendErpId};
                DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
                return false;
            }
            return true;
        }
        return false;
    }

    public static void updateOrg(Context ctx, OrgInfo orgInfo, String extendErpId) throws BOSException {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> paramList = new ArrayList<String>();
        sb.append(" update t_ssc_org set");
        if (StringUtils.isNotBlank((String)orgInfo.getName(LocaleUtils.locale_l1))) {
            sb.append(" fname_l1=?,");
            paramList.add(orgInfo.getName(LocaleUtils.locale_L1));
        }
        if (StringUtils.isNotBlank((String)orgInfo.getName(LocaleUtils.locale_L2))) {
            sb.append(" fname_l2=?,");
            paramList.add(orgInfo.getName(LocaleUtils.locale_L2));
        }
        if (StringUtils.isNotBlank((String)orgInfo.getName(LocaleUtils.locale_L3))) {
            sb.append(" fname_l3=?,");
            paramList.add(orgInfo.getName(LocaleUtils.locale_L3));
        }
        if (StringUtils.isNotBlank((String)orgInfo.getNumber())) {
            sb.append(" fnumber=?,");
            paramList.add(orgInfo.getNumber());
        }
        if (StringUtils.isNotBlank((String)orgInfo.getLongNumber())) {
            sb.append(" flongnumber=?,");
            paramList.add(orgInfo.getLongNumber());
        }
        if (StringUtils.isNotBlank((String)orgInfo.getParent())) {
            sb.append(" fparent=?,");
            paramList.add(orgInfo.getParent());
        }
        if (null != orgInfo.get("isLeaf")) {
            sb.append(" fisLeaf=?,");
            paramList.add(orgInfo.isIsLeaf() ? "1" : "0");
        }
        if (StringUtils.isNotBlank((String)orgInfo.getDisplayName(LocaleUtils.locale_L1))) {
            sb.append(" fdisplayName_l1=?,");
            paramList.add(orgInfo.getDisplayName(LocaleUtils.locale_L1));
        }
        if (StringUtils.isNotBlank((String)orgInfo.getDisplayName(LocaleUtils.locale_L2))) {
            sb.append(" fdisplayName_l2=?,");
            paramList.add(orgInfo.getDisplayName(LocaleUtils.locale_L2));
        }
        if (StringUtils.isNotBlank((String)orgInfo.getDisplayName(LocaleUtils.locale_L3))) {
            sb.append(" fdisplayName_l3=?,");
            paramList.add(orgInfo.getDisplayName(LocaleUtils.locale_L3));
        }
        if (paramList.size() == 0) {
            return;
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" where forgid = ?");
        sb.append(" and fextendErpId = ?");
        Object[] params = new Object[paramList.size() + 2];
        for (int i = 0; i < paramList.size(); ++i) {
            params[i] = paramList.get(i);
        }
        params[params.length - 2] = orgInfo.getOrgID();
        params[params.length - 1] = extendErpId;
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
        logger.error((Object)("updateOrg sql:" + sb.toString()));
        logger.error((Object)("params:" + params.toString()));
    }

    public static void updateOrgById(Context ctx, OrgInfo orgInfo, String extendErpId, String id) throws BOSException {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> paramList = new ArrayList<String>();
        sb.append(" update t_ssc_org set");
        if (StringUtils.isNotBlank((String)orgInfo.getName(LocaleUtils.locale_l1))) {
            sb.append(" fname_l1=?,");
            paramList.add(orgInfo.getName(LocaleUtils.locale_L1));
        }
        if (StringUtils.isNotBlank((String)orgInfo.getName(LocaleUtils.locale_L2))) {
            sb.append(" fname_l2=?,");
            paramList.add(orgInfo.getName(LocaleUtils.locale_L2));
        }
        if (StringUtils.isNotBlank((String)orgInfo.getName(LocaleUtils.locale_L3))) {
            sb.append(" fname_l3=?,");
            paramList.add(orgInfo.getName(LocaleUtils.locale_L3));
        }
        if (StringUtils.isNotBlank((String)orgInfo.getNumber())) {
            sb.append(" fnumber=?,");
            paramList.add(orgInfo.getNumber());
        }
        if (StringUtils.isNotBlank((String)orgInfo.getLongNumber())) {
            sb.append(" flongnumber=?,");
            paramList.add(orgInfo.getLongNumber());
        }
        if (StringUtils.isNotBlank((String)orgInfo.getParent())) {
            sb.append(" fparent=?,");
            paramList.add(orgInfo.getParent());
        }
        if (null != orgInfo.get("isLeaf")) {
            sb.append(" fisLeaf=?,");
            paramList.add(orgInfo.isIsLeaf() ? "1" : "0");
        }
        if (StringUtils.isNotBlank((String)orgInfo.getDisplayName(LocaleUtils.locale_L1))) {
            sb.append(" fdisplayName_l1=?,");
            paramList.add(orgInfo.getDisplayName(LocaleUtils.locale_L1));
        }
        if (StringUtils.isNotBlank((String)orgInfo.getDisplayName(LocaleUtils.locale_L2))) {
            sb.append(" fdisplayName_l2=?,");
            paramList.add(orgInfo.getDisplayName(LocaleUtils.locale_L2));
        }
        if (StringUtils.isNotBlank((String)orgInfo.getDisplayName(LocaleUtils.locale_L3))) {
            sb.append(" fdisplayName_l3=?,");
            paramList.add(orgInfo.getDisplayName(LocaleUtils.locale_L3));
        }
        if (paramList.size() == 0) {
            return;
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" where fid = ?");
        Object[] params = new Object[paramList.size() + 1];
        for (int i = 0; i < paramList.size(); ++i) {
            params[i] = paramList.get(i);
        }
        params[params.length - 1] = id;
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
    }

    public static String existsOrgReturnPk(Context ctx, String orgID, String extendErpId) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgID));
        if (StringUtils.isNotBlank((String)extendErpId)) {
            filter.getFilterItems().add(new FilterItemInfo("extendErp.id", (Object)extendErpId));
        }
        view.setFilter(filter);
        view.setSelector(sic);
        String pk = "";
        OrgCollection org = OrgFactory.getLocalInstance(ctx).getOrgCollection(view);
        if (org != null && org.size() != 0) {
            pk = org.get(0).getId().toString();
        }
        return pk;
    }

    public static boolean existsOrg(Context ctx, String orgID, String extendErpId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgID));
        if (StringUtils.isNotBlank((String)extendErpId)) {
            filter.getFilterItems().add(new FilterItemInfo("extendErp.id", (Object)extendErpId));
        }
        return OrgFactory.getLocalInstance(ctx).exists(filter);
    }

    public static boolean existsOrg(Context ctx, String orgID, String parentID, String extendErpId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgID));
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)parentID));
        if (StringUtils.isNotBlank((String)extendErpId)) {
            filter.getFilterItems().add(new FilterItemInfo("extendErp.id", (Object)extendErpId));
        }
        return OrgFactory.getLocalInstance(ctx).exists(filter);
    }

    public static OrgInfo existsOrgByNumber(Context ctx, String number, String extendErpId) throws BOSException {
        OrgInfo orgInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("extendErp.id", (Object)extendErpId));
        view.setFilter(filter);
        OrgCollection orgCollection = OrgFactory.getLocalInstance(ctx).getOrgCollection(view);
        if (orgCollection != null && orgCollection.size() != 0) {
            orgInfo = orgCollection.get(0);
        }
        return orgInfo;
    }

    public static void allotRoleOrg(Context ctx, String roleId, OrgCollection orgColl) throws BOSException, SSCException {
        OrgCollection allOrgColl = new OrgCollection();
        OrgRoleUserUtils.setOrgInfoId(ctx, orgColl);
        for (int i = 0; i < orgColl.size(); ++i) {
            allOrgColl = OrgRoleUserUtils.getAllOrg(ctx, orgColl.get(i), allOrgColl);
        }
        RoleOrgCollection allRoleOrgColl = OrgRoleUserUtils.getAllRoleOrgColl(ctx, roleId, allOrgColl);
        RoleOrgCollection oldRoleOrgColl = OrgRoleUserUtils.getOldRoleOrgColl(ctx, roleId);
        CoreBaseCollection needAddRoleOrgColl = OrgRoleUserUtils.removeRepeatedRoleOrg(allRoleOrgColl, oldRoleOrgColl);
        try {
            RoleOrgFactory.getLocalInstance(ctx).addnewBatchData(needAddRoleOrgColl);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static CoreBaseCollection removeRepeatedRoleOrg(RoleOrgCollection allRoleOrgColl, RoleOrgCollection oldRoleOrgColl) {
        CoreBaseCollection needAddRoleOrgColl = new CoreBaseCollection();
        for (int i = 0; i < allRoleOrgColl.size(); ++i) {
            String roleid = allRoleOrgColl.get(i).getRoleID().getId().toString();
            String orgid = allRoleOrgColl.get(i).getOrgID().getId().toString();
            String oldroleid = "";
            String oldorgid = "";
            boolean isOldRaletionFlag = false;
            for (int j = 0; j < oldRoleOrgColl.size(); ++j) {
                oldroleid = oldRoleOrgColl.get(j).getRoleID().getId().toString();
                oldorgid = oldRoleOrgColl.get(j).getOrgID().getId().toString();
                if (!roleid.equals(oldroleid) || !orgid.equals(oldorgid)) continue;
                isOldRaletionFlag = true;
                break;
            }
            if (isOldRaletionFlag) continue;
            needAddRoleOrgColl.add((CoreBaseInfo)allRoleOrgColl.get(i));
        }
        return needAddRoleOrgColl;
    }

    private static RoleOrgCollection getOldRoleOrgColl(Context ctx, String roleId) {
        RoleOrgCollection oldRoleOrgColl = new RoleOrgCollection();
        String oql = "select roleID,orgID where roleID='" + roleId + "'";
        try {
            oldRoleOrgColl = RoleOrgFactory.getLocalInstance(ctx).getRoleOrgCollection(oql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return oldRoleOrgColl;
    }

    private static RoleOrgCollection getAllRoleOrgColl(Context ctx, String roleId, OrgCollection allOrgColl) {
        RoleOrgCollection roleOrgColl = new RoleOrgCollection();
        RoleInfo roleInfo = new RoleInfo();
        roleInfo.setId(BOSUuid.read((String)roleId));
        for (int i = 0; i < allOrgColl.size(); ++i) {
            RoleOrgInfo roleOrgInfo = new RoleOrgInfo();
            roleOrgInfo.setRoleID(roleInfo);
            roleOrgInfo.setOrgID(allOrgColl.get(i));
            FillDataUtils.fillAuditData(ctx, (ObjectBaseInfo)roleOrgInfo);
            roleOrgColl.add(roleOrgInfo);
        }
        return roleOrgColl;
    }

    private static void setOrgInfoId(Context ctx, OrgCollection orgColl) throws BOSException, SSCException {
        OrgCollection newOrgColl = new OrgCollection();
        String currentShareCenterId = ShareCenterUtils.getShareCenterIdByCtx(ctx);
        String sql = "select fid from t_ssc_org where forgid= ? and fid in (select FOrgID from t_ssc_sysattrorgscmap where FShareCenterID = ?)";
        IRowSet rs = null;
        for (int i = 0; i < orgColl.size(); ++i) {
            BOSUuid id = orgColl.get(i).getId();
            if (null != id && StringUtils.isNotBlank((String)id.toString())) continue;
            Object[] params = new Object[]{orgColl.get(i).getOrgID(), currentShareCenterId};
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
                if (!rs.next()) continue;
                orgColl.get(i).setId(BOSUuid.read((String)rs.getString("fid")));
                newOrgColl.add(orgColl.get(i));
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        orgColl.clear();
        orgColl.addCollection(newOrgColl);
    }

    public static OrgCollection getAllOrg(Context ctx, OrgInfo orgInfo) {
        OrgCollection orgColl = new OrgCollection();
        OrgRoleUserUtils.getAllOrg(ctx, orgInfo, orgColl);
        return orgColl;
    }

    public static OrgCollection getAllOrg(Context ctx, OrgInfo orgInfo, OrgCollection orgColl) {
        OrgRoleUserUtils.getAllChildOrg(ctx, orgInfo, orgColl);
        orgColl.add(orgInfo);
        return orgColl;
    }

    public static void getAllChildOrg(Context ctx, OrgInfo orgInfo, OrgCollection orgColl) {
        if (orgInfo == null || orgInfo.getId() == null || orgColl == null) {
            return;
        }
        OrgCollection children = new OrgCollection();
        try {
            children = OrgFactory.getLocalInstance(ctx).getOrgCollection("where parent = '" + orgInfo.getOrgID() + "' and extendErp.id = '" + orgInfo.getExtendErp().getId().toString() + "'");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (children == null || children.isEmpty()) {
            return;
        }
        OrgRoleUserUtils.addChildToOrgColl(children, orgColl);
        for (int i = 0; i < children.size(); ++i) {
            OrgRoleUserUtils.getAllChildOrg(ctx, children.get(i), orgColl);
        }
    }

    private static void addChildToOrgColl(OrgCollection children, OrgCollection orgColl) {
        for (int i = 0; i < children.size(); ++i) {
            OrgInfo org = children.get(i);
            if (orgColl.contains(org)) {
                throw new IllegalArgumentException("\u53ef\u80fd\u4f1a\u5bfc\u81f4\u6b7b\u5faa\u73af\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
            }
            orgColl.add(org);
        }
    }

    public static OrgInfo getOrgByNumber(Context ctx, String extendErpId, String number) {
        OrgInfo tempInfo = new OrgInfo();
        try {
            ERPWebService service = ERPUtil.getERPWebServiceImplByERPId((Context)ctx, (String)extendErpId);
            if (service == null) {
                return null;
            }
            ArrayList<String> orgNumber = new ArrayList<String>();
            orgNumber.add(number);
            String orgJson = "";
            if (service instanceof ERPWebServiceOrg) {
                orgJson = ((ERPWebServiceOrg)service).getOrgByIds(ctx, extendErpId, orgNumber);
            }
            if (StringUtils.isEmpty((String)orgJson)) {
                return null;
            }
            HashMap map = JSONUtils.convertJsonToObject((Context)ctx, (String)orgJson);
            List orgInfos = (List)map.get("existList");
            for (int i = 0; i < orgInfos.size(); ++i) {
                Map orgMap = (Map)orgInfos.get(i);
                tempInfo.setOrgID((String)orgMap.get("id"));
                tempInfo.setParent((String)orgMap.get("parent"));
                tempInfo.setNumber((String)orgMap.get("number"));
                tempInfo.setName((String)orgMap.get("name_l1"), LocaleUtils.locale_L1);
                tempInfo.setName((String)orgMap.get("name_l2"), LocaleUtils.locale_L2);
                tempInfo.setName((String)orgMap.get("name_l3"), LocaleUtils.locale_L3);
                tempInfo.setIsLeaf(Integer.valueOf((String)orgMap.get("isLeaf")) == 1);
                tempInfo.setDisplayName((String)orgMap.get("displayName_l1"), LocaleUtils.locale_L1);
                tempInfo.setDisplayName((String)orgMap.get("displayName_l2"), LocaleUtils.locale_L2);
                tempInfo.setDisplayName((String)orgMap.get("displayName_l3"), LocaleUtils.locale_L3);
                tempInfo.setLevel(Integer.valueOf((String)orgMap.get("level")));
                tempInfo.setLongNumber((String)orgMap.get("longNumber"));
                tempInfo.setIsOUSealUp(Integer.valueOf((String)orgMap.get("isOUSealUp")) == 1);
            }
        }
        catch (Exception e) {
            logger.error((Object)("extendErpId:" + extendErpId + ",number:" + number));
            logger.error((Object)"getOrgByNumber error:", (Throwable)e);
        }
        return tempInfo;
    }

    public static List<String> getAllParentOrg(Context ctx, String orgId) {
        String parentOrgId;
        HashSet<String> orgSet = new HashSet<String>();
        orgSet.add(orgId);
        for (int i = 0; i < 50 && !StringUtils.isEmpty((String)(parentOrgId = OrgRoleUserUtils.getParentOrgId(ctx, orgId))); ++i) {
            orgSet.add(parentOrgId);
            orgId = parentOrgId;
        }
        return new ArrayList<String>(orgSet);
    }

    public static String getParentOrgId(Context ctx, String orgId) {
        try {
            OrgInfo orgInfo = OrgFactory.getLocalInstance(ctx).getOrgInfo(H.PK(orgId));
            if (orgInfo != null) {
                return orgInfo.getParentId().getId().toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)("getOrg error: orgId: " + orgId), (Throwable)e);
        }
        return "";
    }
}

