/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.ssc.BussinessAttributeCollection;
import com.kingdee.eas.base.ssc.BussinessAttributeFactory;
import com.kingdee.eas.base.ssc.BussinessAttributeInfo;
import com.kingdee.eas.base.ssc.SingleLoginFacadeFactory;
import com.kingdee.eas.base.ssc.SystemAttributeInfo;
import com.kingdee.eas.base.ssc.tool.FormatUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReviewCodesUtils {
    public static ArrayList<SystemAttributeInfo> getSystemAttributeInfo(Context ctx, Set bussinessIds) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)bussinessIds, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("billType.*");
        sic.add("billType.sysAttr.*");
        view.setFilter(filter);
        view.setSelector(sic);
        BussinessAttributeCollection bac = BussinessAttributeFactory.getLocalInstance(ctx).getBussinessAttributeCollection(view);
        ArrayList<SystemAttributeInfo> sysIds = new ArrayList<SystemAttributeInfo>();
        for (int i = 0; i < bac.size(); ++i) {
            try {
                sysIds.add(bac.get(i).getBillType().getSysAttr());
                continue;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return sysIds;
    }

    public static int getUserJobCount(Context ctx, List<String> sysids, String assignUser) throws BOSException {
        String sql = "select count(j.fid) from t_ssc_job j where j.FPersonnelIDID = '" + assignUser + "' and j.FJobPoolingType = '2'  and j.FBussAttrIDID in (select ba.fid from t_ssc_bussinessattribute ba inner join t_ssc_billType bt on ba.fbilltypeid=bt.fid inner join t_ssc_systemattribute sy on bt.fsysattrid=sy.fid where sy.fid in " + FormatUtils.list2Sql(sysids) + " )";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                int count;
                int n = count = rs.getInt(1);
                return n;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return 0;
    }

    public static HashMap<String, Integer> getMaxnumberAndJobCount(Context ctx, Set<String> bussIds, String user) throws BOSException {
        ArrayList<SystemAttributeInfo> arrayList = ReviewCodesUtils.getSystemAttributeInfo(ctx, bussIds);
        int count = 0;
        HashSet<String> sysids = new HashSet<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!sysids.add(arrayList.get(i).getId().toString())) continue;
            count += arrayList.get(i).getMaxNumber();
        }
        int jobCount = ReviewCodesUtils.getUserJobCount(ctx, new ArrayList<String>(sysids), user);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("maxNumber", count);
        map.put("userJobCount", jobCount);
        return map;
    }

    public static Set<String> getAllBussnessIds(String userid) throws EASBizException, BOSException {
        List userBussAttr = SingleLoginFacadeFactory.getRemoteInstance().getUserBussAttr(userid);
        HashSet<String> bussids = new HashSet<String>();
        for (int i = 0; i < userBussAttr.size(); ++i) {
            BussinessAttributeInfo bussAttrInfo = (BussinessAttributeInfo)userBussAttr.get(i);
            if (null == bussAttrInfo || null == bussAttrInfo.getBillType() || StringUtils.isEmpty((String)bussAttrInfo.getBillType().getNumber())) continue;
            bussids.add(bussAttrInfo.getId().toString());
        }
        return bussids;
    }
}

