/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SSCDbUtil
extends DbUtil {
    private static Logger logger = Logger.getLogger(SSCDbUtil.class);

    public static IRowSet executeQuery(Context ctx, String sql, Object[] params, int start, int rows) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
        try {
            JdbcRowSet localJdbcRowSet1;
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs, start, rows, true);
            jdbcRowSet = localJdbcRowSet1 = rowset;
        }
        catch (SQLException exc) {
            try {
                StringBuffer sb = new StringBuffer("");
                for (int i = 0; i < params.length; ++i) {
                    sb.append("param ").append(i).append(" is:").append(params[i]);
                }
                logger.error((Object)("sql is:" + sql + " param is:" + sb.toString()));
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return jdbcRowSet;
    }

    public static ResultSet executeQueryNoLimit(Context ctx, String sql) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
        try {
            statement = conn.createStatement();
            ResultSet exc = rs = statement.executeQuery(sql);
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)("333 sql is:" + sql), (Throwable)exc);
                throw new BOSException("Sql3 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return exc;
    }

    public static int executeUpdate(Context ctx, String sql, Object[] params) throws BOSException {
        int count = 0;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            count = ps.executeUpdate();
        }
        catch (SQLException exc) {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < params.length; ++i) {
                sb.append("param ").append(i).append(" is:").append(params[i]);
            }
            logger.error((Object)("222 sql is:" + sql + " param is:" + sb.toString()), (Throwable)exc);
            throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }
        return count;
    }
}

