/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.AllotOperationFacadeFactory;
import com.kingdee.eas.base.ssc.BillTypeFactory;
import com.kingdee.eas.base.ssc.BillTypeInfo;
import com.kingdee.eas.base.ssc.BussinessAttributeFactory;
import com.kingdee.eas.base.ssc.BussinessAttributeInfo;
import com.kingdee.eas.base.ssc.ConsignationCollection;
import com.kingdee.eas.base.ssc.ConsignationFactory;
import com.kingdee.eas.base.ssc.ConsignationInfo;
import com.kingdee.eas.base.ssc.ConsignationStatusEnum;
import com.kingdee.eas.base.ssc.ConsignationTaskTypeEnum;
import com.kingdee.eas.base.ssc.ExtendERPInfo;
import com.kingdee.eas.base.ssc.IConsignation;
import com.kingdee.eas.base.ssc.IOrg;
import com.kingdee.eas.base.ssc.ISysAttrOrgSCMap;
import com.kingdee.eas.base.ssc.JobFactory;
import com.kingdee.eas.base.ssc.JobHisFactory;
import com.kingdee.eas.base.ssc.JobHisInfo;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.base.ssc.OrgCollection;
import com.kingdee.eas.base.ssc.OrgFactory;
import com.kingdee.eas.base.ssc.OrgInfo;
import com.kingdee.eas.base.ssc.ParamSetFacadeFactory;
import com.kingdee.eas.base.ssc.RoleBussattrInfo;
import com.kingdee.eas.base.ssc.RoleFactory;
import com.kingdee.eas.base.ssc.RoleInfo;
import com.kingdee.eas.base.ssc.RoleTypeInfo;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.SysAttrOrgSCMapCollection;
import com.kingdee.eas.base.ssc.SysAttrOrgSCMapFactory;
import com.kingdee.eas.base.ssc.SysAttrOrgSCMapInfo;
import com.kingdee.eas.base.ssc.SystemAttributeInfo;
import com.kingdee.eas.base.ssc.UserFactory;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.app.StopAssignEnum;
import com.kingdee.eas.base.ssc.app.erp.ERPUtil;
import com.kingdee.eas.base.ssc.app.erp.eas.EASCfgUtil;
import com.kingdee.eas.base.ssc.tool.FormatUtils;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.JobUtils;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.json.util.JSONUtils;
import org.apache.log4j.Logger;

public class SSCUtil {
    private static Logger logger = Logger.getLogger(SSCUtil.class);
    private static final String ADD_FOR_COMPEL = "addForCompel";
    private static final String ADD_FOR_CONSIGN = "addForConsign";
    private static ISysAttrOrgSCMap iSysAttrOrgSCMap = null;
    private static IOrg iOrg = null;
    private static IConsignation iConsignation = null;
    private static final String ROOT_CU = "00000000-0000-0000-0000-000000000000CCE7AED4";

    public static String getSscUserIdForWorkflow(Context ctx, String jobId) throws BOSException {
        String userId = null;
        ExtendERPInfo erpInfo = ERPUtil.getExtendERPInfo((Context)ctx, (String)jobId);
        String userNumber = EASCfgUtil.getValue((Context)ctx, (ExtendERPInfo)erpInfo, (String)"userName");
        StringBuffer sb = new StringBuffer();
        sb.append("select fid from t_ssc_user a where a.ferpusernumber = ?  ");
        IRowSet tIRowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{userNumber});
        try {
            if (tIRowSet.next()) {
                userId = tIRowSet.getString(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u67e5\u8be2" + userNumber + "  \u81ea\u52a8\u5ba1\u6279\u4eba\u5931\u8d25!"), (Throwable)e);
        }
        return userId;
    }

    public static List<UserInfo> getAssignee(Context ctx, String consignerId, String bussAttrId) throws BOSException {
        return SSCUtil.getAssignee(ctx, consignerId, bussAttrId, ConsignationTaskTypeEnum.shareJob);
    }

    public static List<UserInfo> getAssignee(Context ctx, String consignerId, String bussAttrIdOrBilltypeId, ConsignationTaskTypeEnum taskType) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("assignee.*"));
        FilterInfo filter = new FilterInfo();
        String sql = "0".equals(taskType.getValue()) ? "select fparentid from t_ssc_ConsignationEntry where FBussTypeID = '" + bussAttrIdOrBilltypeId + "'" : "select fparentid from t_ssc_ConsignationEntry where fbillType = '" + bussAttrIdOrBilltypeId + "'";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)ConsignationStatusEnum.Effected));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)ConsignationStatusEnum.Received));
        filter.getFilterItems().add(new FilterItemInfo("consigner", (Object)consignerId));
        filter.getFilterItems().add(new FilterItemInfo("beginTime", (Object)new Timestamp(System.currentTimeMillis()), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endTime", (Object)new Timestamp(System.currentTimeMillis()), CompareType.GREATER_EQUALS));
        filter.setMaskString("#0 and (#1 or #2) and #3 and #4 and #5");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(sic);
        iConsignation = ctx == null ? ConsignationFactory.getRemoteInstance() : ConsignationFactory.getLocalInstance(ctx);
        ConsignationCollection cc = iConsignation.getConsignationCollection(view);
        List<UserInfo> userInfos = new ArrayList<UserInfo>();
        for (int i = 0; i < cc.size(); ++i) {
            userInfos.add(cc.get(i).getAssignee());
        }
        userInfos = JobUtils.getEnabledUser(ctx, userInfos);
        return userInfos;
    }

    private static UserInfo getLessTaskUserIgnoreOrg(Context ctx, String bussAttrId, List<String> userIds) {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" select distinct u.fid,");
            sb.append(" (select count(1) from t_ssc_job j");
            sb.append(" where j.FPersonnelIDID = u.fid");
            sb.append(" and j.FJobPoolingType = '2'");
            sb.append(" and j.FBussAttrIDID in");
            sb.append(" (select ba.fid from t_ssc_bussinessattribute ba inner join t_ssc_billType bt on ba.fbilltypeid=bt.fid inner join t_ssc_systemattribute sy on bt.fsysattrid=sy.fid where sy.fid =");
            sb.append(" (select sy.fid from t_ssc_bussinessattribute ba inner join t_ssc_billType bt on ba.fbilltypeid=bt.fid inner join t_ssc_systemattribute sy on bt.fsysattrid=sy.fid where ba.fid = ?)");
            sb.append(" )");
            sb.append(" ) as operatingCount ");
            sb.append(" from t_ssc_user u,t_ssc_role r,t_ssc_roleuser ru");
            sb.append(" where ru.FROLEIDID = r.FID");
            sb.append(" and ru.FUSERIDID = u.FID ");
            sb.append(" and r.FBUSSATTRIDID = ?");
            sb.append(" and u.FISENABLED = 1");
            if (userIds != null && !userIds.isEmpty()) {
                String userStr = FormatUtils.list2Sql(userIds);
                sb.append(" and u.FID in " + userStr);
            }
            sb.append(" order by operatingCount asc");
            Object[] param = new Object[]{bussAttrId, bussAttrId};
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
            String assignUserId = "";
            if (rs.next()) {
                assignUserId = rs.getString(1);
            }
            if (!StringUtils.isEmpty((String)assignUserId)) {
                return UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)assignUserId)));
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (UuidException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static Set getConsignerCollection(Context ctx, String assignee) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("assignee", (Object)assignee));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)ConsignationStatusEnum.Effected));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("consigner.*");
        view.setSelector(sic);
        iConsignation = ctx == null ? ConsignationFactory.getRemoteInstance() : ConsignationFactory.getLocalInstance(ctx);
        ConsignationCollection cc = iConsignation.getConsignationCollection(view);
        if (cc == null || cc.size() == 0) {
            return new HashSet();
        }
        HashSet<String> result = new HashSet<String>();
        Iterator itor = cc.iterator();
        while (itor.hasNext()) {
            ConsignationInfo consignationInfo = (ConsignationInfo)itor.next();
            UserInfo consigner = consignationInfo.getConsigner();
            if (!consigner.isIsEnabled()) continue;
            result.add(consigner.getId().toString());
        }
        return result;
    }

    public static String convertSet2String(Collection collection) {
        StringBuffer result = new StringBuffer();
        Iterator itor = collection.iterator();
        while (itor.hasNext()) {
            result.append("'").append((String)itor.next()).append("',");
        }
        return result.toString().substring(0, result.length() - 1);
    }

    public static String convertObjectToPlaceholder(Object obj) {
        if (obj == null) {
            return "";
        }
        StringBuffer fids = new StringBuffer();
        List list = new ArrayList();
        if (obj instanceof List) {
            list = (List)obj;
        } else if (obj instanceof String) {
            list = com.kingdee.bos.util.backport.Arrays.asList((Object[])obj.toString().split(","));
        }
        for (int i = 0; i < list.size(); ++i) {
            if (i == list.size() - 1) {
                fids.append("?");
                continue;
            }
            fids.append("?,");
        }
        return fids.toString();
    }

    public static int objectLength(Object obj) {
        if (obj == null) {
            return 0;
        }
        List list = new ArrayList();
        if (obj instanceof List) {
            list = (List)obj;
        } else if (obj instanceof String) {
            list = com.kingdee.bos.util.backport.Arrays.asList((Object[])obj.toString().split(","));
        }
        return list.size();
    }

    public static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static void singleComplete(Context ctx, ConsignationInfo consignationInfo) throws BOSException, EASBizException {
        UserInfo consigner = consignationInfo.getConsigner();
        UserInfo assignee = consignationInfo.getAssignee();
        String isReturnToOriginalPerson = ParamSetFacadeFactory.getLocalInstance(ctx).getSSCParam().getIsReturnToOriginalPerson();
        if (consigner == null || consigner.getId() == null || assignee == null || assignee.getId() == null) {
            return;
        }
        if (Boolean.parseBoolean(isReturnToOriginalPerson) && consigner.isIsEnabled() && StopAssignEnum.normal == consigner.getIsStopAssign()) {
            String jobSql = "select fid from t_ssc_job where fjobpoolingtype = ? and FPersonnelIDID = ? and FConsignerID=? ";
            HashSet<String> jobIdSet = new HashSet<String>();
            IRowSet rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)jobSql, (Object[])new Object[]{"2", assignee.getId().toString(), consigner.getId().toString()});
                while (rs.next()) {
                    jobIdSet.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (jobIdSet == null || jobIdSet.size() == 0) {
                return;
            }
            String updateJobSql = "update t_ssc_job set FPersonnelIDID =?,FConsignerID=? where fid = ?";
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (String jobId : jobIdSet) {
                Object[] param = new Object[]{consigner.getId().toString(), null, jobId};
                params.add(param);
                if (params.size() % 500 != 0) continue;
                DbUtil.executeBatch((Context)ctx, (String)updateJobSql, params);
                params = new ArrayList();
            }
            if (params.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)updateJobSql, params);
            }
        }
    }

    public static void genAndAllotCompelRole(Context ctx, String bussAttrId, String userId, String shareCenterId, boolean isConsignation) throws BOSException, EASBizException {
        SSCUtil.genAndAllotCompelRole(ctx, bussAttrId, userId, shareCenterId, isConsignation, ConsignationTaskTypeEnum.shareJob);
    }

    public static void genAndAllotCompelRole(Context ctx, String roleBussOrBillId, String userId, String shareCenterId, boolean isConsignation, ConsignationTaskTypeEnum taskType) throws BOSException, EASBizException {
        String roleId = SSCUtil.genCompelRoleByBussAttrIdIfNotExit(ctx, roleBussOrBillId, shareCenterId, isConsignation, taskType);
        ArrayList<String> roleList = new ArrayList<String>();
        roleList.add(roleId);
        AllotOperationFacadeFactory.getLocalInstance(ctx).allotRole(userId, roleList);
    }

    @Deprecated
    public static String genCompelRoleByBussAttrIdIfNotExit(Context ctx, String bussAttrId, String shareCenterId, boolean isConsignation) throws BOSException {
        return SSCUtil.genCompelRoleByBussAttrIdIfNotExit(ctx, bussAttrId, shareCenterId, isConsignation, ConsignationTaskTypeEnum.shareJob);
    }

    private static String getRoleBizSql(boolean isConsignation) {
        StringBuffer sql = new StringBuffer(300);
        sql.append(" SELECT r.fid FROM T_SSC_ROLE r ").append(" where r.FID in(").append(" select rb.FPARENTID from T_SSC_ROLEBUSSATTR rb").append(" where rb.FBUSSNAMEID = ?").append(" group by rb.FPARENTID").append(" having count(1) = 1)").append("and r.FRoleTypeIDID = 'F68lZzqpRWC1K1nV8ZYPgS0WZ4A='");
        if (isConsignation) {
            sql.append(" and r.fnumber LIKE 'addForConsign%' ");
        } else {
            sql.append(" and r.fnumber LIKE 'addForCompel%' ");
        }
        return sql.toString();
    }

    private static String getRoleAuditOrLaterSql(boolean isConsignation, ConsignationTaskTypeEnum taskType) {
        String roleTypeId = "";
        if (taskType.equals((Object)ConsignationTaskTypeEnum.qualityJob)) {
            roleTypeId = "BqMHsn0QTrafsG4XPzjMpC0WZ4A=";
        } else if (taskType.equals((Object)ConsignationTaskTypeEnum.spotCheckJob)) {
            roleTypeId = "o9Taq/+5QSKDMQrAQo+1uS0WZ4A=";
        }
        StringBuffer sql = new StringBuffer(300);
        sql.append(" SELECT r.fid FROM T_SSC_ROLE r").append(" where r.FID in(").append(" select rb.FPARENTID from T_SSC_ROLEBUSSATTR rb").append(" where rb.FBillNameID = ?").append(" group by rb.FPARENTID").append(" having count(1) = 1)").append(" and r.FRoleTypeIDID = '" + roleTypeId + "'");
        if (isConsignation) {
            sql.append(" and r.fnumber LIKE 'addForConsign%' ");
        } else {
            sql.append(" and r.fnumber LIKE 'addForCompel%' ");
        }
        return sql.toString();
    }

    private static void setRoleParamsByRoleBiz(Context ctx, String bussId, RoleInfo roleInfo) throws BOSException, EASBizException {
        BussinessAttributeInfo baInfo = BussinessAttributeFactory.getLocalInstance(ctx).getBussinessAttributeInfo((IObjectPK)new ObjectUuidPK(bussId));
        RoleBussattrInfo roleAttr = new RoleBussattrInfo();
        roleAttr.setBussName(baInfo);
        roleAttr.setBussNumber(baInfo.getNumber());
        roleInfo.getBussattr().add(roleAttr);
        RoleTypeInfo rtInfo = new RoleTypeInfo();
        rtInfo.setId(BOSUuid.read((String)"F68lZzqpRWC1K1nV8ZYPgS0WZ4A="));
        roleInfo.setRoleTypeID(rtInfo);
    }

    private static void setRoleParamsByRoleAuditOrLater(Context ctx, String billTypeId, RoleInfo roleInfo, ConsignationTaskTypeEnum taskType) throws BOSException, EASBizException {
        BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance(ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK(billTypeId));
        RoleBussattrInfo roleAttr = new RoleBussattrInfo();
        roleAttr.setBillName(billTypeInfo);
        roleAttr.setBillNumber(billTypeInfo.getNumber());
        roleInfo.getBussattr().add(roleAttr);
        RoleTypeInfo rtInfo = new RoleTypeInfo();
        if (taskType.equals((Object)ConsignationTaskTypeEnum.qualityJob)) {
            rtInfo.setId(BOSUuid.read((String)"BqMHsn0QTrafsG4XPzjMpC0WZ4A="));
        } else if (taskType.equals((Object)ConsignationTaskTypeEnum.spotCheckJob)) {
            rtInfo.setId(BOSUuid.read((String)"o9Taq/+5QSKDMQrAQo+1uS0WZ4A="));
        }
        roleInfo.setRoleTypeID(rtInfo);
    }

    public static String genCompelRoleByBussAttrIdIfNotExit(Context ctx, String roleBussOrBillId, String shareCenterId, boolean isConsignation, ConsignationTaskTypeEnum taskType) throws BOSException {
        String sql = taskType.equals((Object)ConsignationTaskTypeEnum.shareJob) ? SSCUtil.getRoleBizSql(isConsignation) : SSCUtil.getRoleAuditOrLaterSql(isConsignation, taskType);
        String ret = null;
        try {
            Object[] params = new Object[]{roleBussOrBillId};
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            while (rs.next()) {
                String roleId = rs.getString(1);
                if (StringUtils.isEmpty((String)roleId)) continue;
                ret = roleId;
                break;
            }
            if (StringUtils.isEmpty(ret)) {
                RoleInfo roleInfo = new RoleInfo();
                if (taskType.equals((Object)ConsignationTaskTypeEnum.shareJob)) {
                    SSCUtil.setRoleParamsByRoleBiz(ctx, roleBussOrBillId, roleInfo);
                } else {
                    SSCUtil.setRoleParamsByRoleAuditOrLater(ctx, roleBussOrBillId, roleInfo, taskType);
                }
                if (isConsignation) {
                    roleInfo.setName(ADD_FOR_CONSIGN + System.currentTimeMillis());
                    roleInfo.setNumber(ADD_FOR_CONSIGN + System.currentTimeMillis());
                } else {
                    roleInfo.setName(ADD_FOR_COMPEL + System.currentTimeMillis());
                    roleInfo.setNumber(ADD_FOR_COMPEL + System.currentTimeMillis());
                }
                roleInfo.setCompel(1);
                roleInfo.setShareCenterID(shareCenterId);
                IObjectPK pk = RoleFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)roleInfo);
                ret = pk.toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    public static boolean checkPermission(Context ctx, UserInfo userInfo, JobInfo jobInfo) throws BOSException {
        boolean ret = false;
        String userId = userInfo.getId().toString();
        String bussAttrId = jobInfo.getBussAttrID().getId().toString();
        StringBuffer permSQL = new StringBuffer("select distinct tem.fid ");
        permSQL.append("from t_ssc_bussinessAttribute ba ");
        permSQL.append("inner join (select role.fid,role.FRoleTypeIDID,rb.fbussnameid from T_SSC_RoleBussattr rb left join  t_ssc_role role on role.fid= rb.fparentid) tem ");
        permSQL.append("on ba.fid=tem.fbussnameid ");
        permSQL.append("left join t_ssc_roletype rt on rt.fid=tem.FRoleTypeIDID ");
        permSQL.append("left join t_ssc_roleuser ru on tem.fid = ru.FRoleIDID ");
        permSQL.append("where ba.fid='").append(bussAttrId).append("' and ru.fuseridid='").append(userId).append("' and rt.FNUMBER ='ROLE_BIZ'");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)permSQL.toString());
            ret = rs.next();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    public static boolean checkPermissionNotCompel(Context ctx, UserInfo userInfo, JobInfo jobInfo) throws BOSException {
        boolean ret = false;
        String userId = userInfo.getId().toString();
        String bussAttrId = jobInfo.getBussAttrID().getId().toString();
        StringBuffer permSQL = new StringBuffer("select distinct tem.fid ");
        permSQL.append("from t_ssc_bussinessAttribute ba ");
        permSQL.append("inner join (select role.fid,role.FRoleTypeIDID,rb.fbussnameid,role.fnumber from T_SSC_RoleBussattr rb left join  t_ssc_role role on role.fid= rb.fparentid) tem ");
        permSQL.append("on ba.fid=tem.fbussnameid ");
        permSQL.append("left join t_ssc_roletype rt on rt.fid=tem.FRoleTypeIDID ");
        permSQL.append("left join t_ssc_roleuser ru on tem.fid = ru.FRoleIDID ");
        permSQL.append("where ba.fid='").append(bussAttrId).append("' and ru.fuseridid='").append(userId).append("' and rt.FNUMBER ='ROLE_BIZ' and tem.fnumber not like 'addForCompel%'");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)permSQL.toString());
            ret = rs.next();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    public static boolean checkPermission(Context ctx, String userId, String bussAttrId) throws BOSException {
        boolean ret = false;
        StringBuffer permSQL = new StringBuffer("select distinct tem.fid ");
        permSQL.append("from t_ssc_bussinessAttribute ba ");
        permSQL.append("inner join (select role.fid,role.FRoleTypeIDID,rb.fbussnameid from T_SSC_RoleBussattr rb left join  t_ssc_role role on role.fid= rb.fparentid ) tem ");
        permSQL.append("on ba.fid=tem.fbussnameid ");
        permSQL.append("left join t_ssc_roletype rt on rt.fid=tem.FRoleTypeIDID ");
        permSQL.append("left join t_ssc_roleuser ru on tem.fid = ru.FRoleIDID ");
        permSQL.append("where ba.fid='").append(bussAttrId).append("' and ru.fuseridid='").append(userId).append("' and  rt.FNUMBER ='ROLE_BIZ'");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)permSQL.toString());
            ret = rs.next();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    public static SysAttrOrgSCMapCollection getSysAttrOrgSCMapCollection(Context ctx, String orgId, String systemAttributeId) throws BOSException {
        if (StringUtils.isEmpty((String)orgId) || StringUtils.isEmpty((String)systemAttributeId)) {
            return new SysAttrOrgSCMapCollection();
        }
        SysAttrOrgSCMapCollection result = new SysAttrOrgSCMapCollection();
        try {
            iSysAttrOrgSCMap = ctx == null ? SysAttrOrgSCMapFactory.getRemoteInstance() : SysAttrOrgSCMapFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("org", (Object)orgId));
            filter.getFilterItems().add(new FilterItemInfo("systemAttribute", (Object)systemAttributeId));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("org.id");
            sic.add("org.parent");
            sic.add("org.name");
            sic.add("org.number");
            sic.add("org.isLeaf");
            sic.add("org.level");
            sic.add("org.longNumber");
            sic.add("systemAttribute.id");
            sic.add("systemAttribute.name");
            sic.add("systemAttribute.number");
            sic.add("systemAttribute.extendErp.id");
            sic.add("shareCenterID");
            view.setSelector(sic);
            result = iSysAttrOrgSCMap.getSysAttrOrgSCMapCollection(view);
        }
        catch (Exception e) {
            logger.error((Object)"_createJobNew getSysAttrOrgSCMap error", (Throwable)e);
        }
        return result;
    }

    public static SysAttrOrgSCMapInfo getSysAttrOrgSCMapByParent(Context ctx, String orgId, String systemAttributeId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgId) || StringUtils.isEmpty((String)systemAttributeId)) {
            return null;
        }
        iOrg = ctx == null ? OrgFactory.getRemoteInstance() : OrgFactory.getLocalInstance(ctx);
        OrgInfo orgInfo = iOrg.getOrgInfo("select parent where id ='" + orgId + "'");
        String erpOrgParentId = orgInfo.getParent();
        OrgInfo orgParentInfo = iOrg.getOrgInfo("select id where orgID ='" + erpOrgParentId + "'");
        String orgParentId = orgParentInfo != null && orgParentInfo.getId() != null ? orgParentInfo.getId().toString() : null;
        SysAttrOrgSCMapCollection somColl = SSCUtil.getSysAttrOrgSCMapCollection(ctx, orgParentId, systemAttributeId);
        if (somColl != null && somColl.size() > 0) {
            return somColl.get(0);
        }
        if (ROOT_CU.equals(orgId) || ROOT_CU.equals(erpOrgParentId)) {
            return null;
        }
        return SSCUtil.getSysAttrOrgSCMapByParent(ctx, orgParentId, systemAttributeId);
    }

    public static SysAttrOrgSCMapInfo getSysAttrOrgSCMapByParent(Context ctx, String orgId, String systemAttributeId, String erpId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgId) || StringUtils.isEmpty((String)systemAttributeId)) {
            return null;
        }
        iOrg = ctx == null ? OrgFactory.getRemoteInstance() : OrgFactory.getLocalInstance(ctx);
        OrgInfo orgInfo = iOrg.getOrgInfo("select parent where id ='" + orgId + "'");
        String erpOrgParentId = orgInfo.getParent();
        OrgInfo orgParentInfo = iOrg.getOrgInfo("select id where orgID ='" + erpOrgParentId + "' and extendErp.id = '" + erpId + "' ");
        String orgParentId = orgParentInfo != null && orgParentInfo.getId() != null ? orgParentInfo.getId().toString() : null;
        SysAttrOrgSCMapCollection somColl = SSCUtil.getSysAttrOrgSCMapCollection(ctx, orgParentId, systemAttributeId);
        if (somColl != null && somColl.size() > 0) {
            return somColl.get(0);
        }
        if (ROOT_CU.equals(orgId) || ROOT_CU.equals(erpOrgParentId)) {
            return null;
        }
        return SSCUtil.getSysAttrOrgSCMapByParent(ctx, orgParentId, systemAttributeId, erpId);
    }

    public static void allotSysAttrOrg(Context ctx, String orgId, String systemAttributeId, String shareCenterId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgId) || StringUtils.isEmpty((String)systemAttributeId) || StringUtils.isEmpty((String)shareCenterId)) {
            return;
        }
        iSysAttrOrgSCMap = ctx == null ? SysAttrOrgSCMapFactory.getRemoteInstance() : SysAttrOrgSCMapFactory.getLocalInstance(ctx);
        SysAttrOrgSCMapInfo info = new SysAttrOrgSCMapInfo();
        OrgInfo orgInfo = new OrgInfo();
        orgInfo.setId(BOSUuid.read((String)orgId));
        info.setOrg(orgInfo);
        SystemAttributeInfo sysAttrInfo = new SystemAttributeInfo();
        sysAttrInfo.setId(BOSUuid.read((String)systemAttributeId));
        info.setSystemAttribute(sysAttrInfo);
        info.setShareCenterID(shareCenterId);
        info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        iSysAttrOrgSCMap.addnew((CoreBaseInfo)info);
    }

    public static boolean checBussAttributeBelongToShareCenter(Context ctx, String bussAttrId, String shareCenterId) throws BOSException {
        boolean result = false;
        if (StringUtils.isEmpty((String)bussAttrId) || StringUtils.isEmpty((String)shareCenterId)) {
            return true;
        }
        String shareCenterParentIds = ShareCenterUtils.getShareCenterParentIDs(ctx, new StringBuffer(), shareCenterId);
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from t_ssc_bussinessattribute ");
        sql.append("where fbilltypeid in (");
        sql.append("select fid from t_ssc_billtype where fsysattrid in (");
        sql.append("select fsystemattributeid from t_ssc_sysattrorgscmap where fsharecenterid = '").append(shareCenterId).append("')) ");
        sql.append("and fshareCenterId in (").append(shareCenterParentIds).append(") ");
        sql.append("and fid = '").append(bussAttrId).append("' ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            result = rs.next();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static IRowSet getConsignationRowSet(Context ctx, String assId) throws BOSException, SSCException {
        DataBaseInfo scInfo = ShareCenterUtils.getShareCenterInfo(ctx);
        String shareCenterFilter = ShareCenterUtils.getShareCenterParentIDs(ctx, new StringBuffer(), scInfo != null && scInfo.getId() != null ? scInfo.getId().toString() : null);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT busAttr.FNUMBER number,busAttr.fid id FROM T_SSC_User u ");
        sql.append("INNER JOIN T_SSC_RoleUser ru ON u.FID = ru.FUserIDID ");
        sql.append("INNER JOIN ");
        sql.append("(select role.fid,role.FRoleTypeIDID,rb.fbussnameid ");
        sql.append("from T_SSC_RoleBussattr rb inner join  t_ssc_role role on role.fid= rb.fparentid ");
        sql.append(") tem ON ru.FRoleIDID = tem.FID ");
        sql.append("inner join t_ssc_roletype rt on tem.FRoleTypeIDID = rt.fid and rt.fnumber = 'ROLE_BIZ' ");
        sql.append("INNER JOIN T_SSC_BussinessAttribute busAttr ON tem.fbussnameid = busAttr.FID ");
        sql.append("WHERE u.fid = ? ");
        sql.append("and busAttr.fbilltypeid in (select fid from t_ssc_billtype where fsysattrid in ");
        sql.append("(select fsystemattributeid from t_ssc_sysattrorgscmap where fsharecenterid = ?) )");
        sql.append("and busAttr.fsharecenterid in (");
        sql.append(shareCenterFilter);
        sql.append(")");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{assId, scInfo.getId().toString()});
    }

    public static IRowSet getConsignationRowSetByparam(Context ctx, String assId, String roleTypeNumber) throws BOSException, SSCException {
        DataBaseInfo scInfo = ShareCenterUtils.getShareCenterInfo(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT distinct bt.FNUMBER number,bt.fid id,bt.FNAME_l2 name FROM t_ssc_billtype bt inner join T_SSC_RoleBussattr rb on bt.fid = rb.FBILLNAMEID");
        sql.append(" inner join T_SSC_ROLE rl on rb.FPARENTID = rl.fid");
        sql.append(" inner join T_SSC_ROLETYPE rt on rl.FROLETYPEIDID = rt.FID");
        sql.append(" inner join t_ssc_roleuser ru on rl.fid = ru.FROLEIDID");
        sql.append(" where ru.FUSERIDID = ? and rt.FNUMBER = ?");
        sql.append(" and bt.fsysattrid in (select fsystemattributeid from t_ssc_sysattrorgscmap where fsharecenterid = ?)");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{assId, roleTypeNumber, scInfo.getId().toString()});
    }

    public static String getOrgTreeIdSql(Context ctx, String shareCenterId, String systemAttributeIds) throws BOSException {
        int i;
        String[] sysAttrId = systemAttributeIds.split(",");
        Object[] params = new Object[sysAttrId.length * 2];
        int maxLevel = 5;
        StringBuffer sql = new StringBuffer();
        sql.append(" select max(flevel) maxLevel ");
        sql.append(" from t_ssc_org org ");
        for (int i2 = 0; i2 < sysAttrId.length; ++i2) {
            String alias = "map" + i2;
            sql.append(" inner join t_ssc_sysAttrOrgSCMap " + alias);
            sql.append(" on " + alias + ".forgid = org.fid ");
            sql.append(" and " + alias + ".fsharecenterid = ? ");
            sql.append(" and " + alias + ".fsystemattributeid = ? ");
            params[i2 * 2] = shareCenterId;
            params[i2 * 2 + 1] = sysAttrId[i2];
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        try {
            if (rs != null && rs.next()) {
                maxLevel = rs.getInt("maxLevel");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql = new StringBuffer();
        sql.append(" select org.fid fid");
        sql.append(" from t_ssc_org org");
        for (i = 0; i < sysAttrId.length; ++i) {
            String alias = "map" + i;
            sql.append(" inner join t_ssc_sysAttrOrgSCMap " + alias + "");
            sql.append(" on " + alias + ".forgid = org.fid");
            sql.append(" and " + alias + ".fsharecenterid = '").append(shareCenterId).append("' ");
            sql.append(" and " + alias + ".fsystemattributeid = '").append(sysAttrId[i]).append("' ");
        }
        for (i = 1; i < maxLevel; ++i) {
            sql.append(" union all ");
            sql.append(SSCUtil.getOrgTreeLevelsql(shareCenterId, systemAttributeIds, i));
        }
        return sql.toString();
    }

    private static String getOrgTreeLevelsql(String shareCenterId, String systemAttributeIds, int level) {
        int i;
        String[] sysAttrId = systemAttributeIds.split(",");
        StringBuffer sql = new StringBuffer();
        sql.append("select fid fid ");
        sql.append("from t_ssc_org where fid in ( ");
        for (i = 1; i < level; ++i) {
            sql.append("select fparentid ");
            sql.append("from t_ssc_org where fid in ( ");
        }
        sql.append("select org.fparentid ");
        sql.append("from t_ssc_org org ");
        for (i = 0; i < sysAttrId.length; ++i) {
            String alias = "map" + i;
            sql.append(" inner join t_ssc_sysAttrOrgSCMap " + alias + "");
            sql.append(" on " + alias + ".forgid = org.fid ");
            sql.append(" and " + alias + ".fsharecenterid = '").append(shareCenterId).append("' ");
            sql.append(" and " + alias + ".fsystemattributeid = '").append(sysAttrId[i]).append("' ");
        }
        for (i = 1; i < level; ++i) {
            sql.append(") ");
        }
        sql.append(") ");
        return sql.toString();
    }

    public static List getAllRecrodsOfIds(String queryPK, String queryUuid) throws BOSException {
        if (queryPK == null || "".equalsIgnoreCase(queryPK) || queryUuid == null || "".equalsIgnoreCase(queryUuid)) {
            return null;
        }
        Uuid uuid = Uuid.read((String)queryUuid);
        if (uuid == null) {
            return null;
        }
        IQueryExecutor queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(queryPK));
        List list = queryExecutor.getQueryKeys(uuid);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list.size() > 0) {
            for (Object[] idObj : list) {
                if (idObj == null) continue;
                arrayList.add(idObj[0].toString());
            }
        }
        return arrayList;
    }

    public static Set getJobOrgIDs(Context ctx, String shareCenterId, String systemAttributeId, Set orgIdSet) throws BOSException {
        HashSet<String> result = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct forgidid from t_ssc_job ");
        sql.append("where forgidid in (").append(SSCUtil.convertSet2String(orgIdSet)).append(") ");
        sql.append("and fsharecenterid = '").append(shareCenterId).append("' ");
        sql.append("and fbussattridid in (");
        sql.append("select fid from t_ssc_bussinessattribute where fbilltypeid in (");
        sql.append("select fid from t_ssc_billtype where fsysattrid = '").append(systemAttributeId).append("')");
        sql.append(")");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                result.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static String getImgEval(Context ctx, String jobId) throws EASBizException {
        String imgEval = null;
        try {
            if (JobFactory.getRemoteInstance().exists(H.PK(jobId))) {
                JobInfo jobInfo = JobFactory.getRemoteInstance().getJobInfo(H.PK(jobId));
                if (jobInfo.getJobState().getValue() == "1") {
                    imgEval = "0";
                }
            } else {
                JobHisInfo jobHisInfo = JobHisFactory.getRemoteInstance().getJobHisInfo(H.PK(jobId));
                if (jobHisInfo.getJobState().getValue() == "1") {
                    imgEval = "0";
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return imgEval;
    }

    public static OrgInfo getSscOrgParent(Context ctx, String erpOrgParentId, String erpId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)erpOrgParentId) || StringUtils.isEmpty((String)erpId)) {
            return null;
        }
        iOrg = ctx == null ? OrgFactory.getRemoteInstance() : OrgFactory.getLocalInstance(ctx);
        OrgCollection orgColl = iOrg.getOrgCollection(" select *, extendErp.* where orgID = '" + erpOrgParentId + "' and extendErp.id = '" + erpId + "' ");
        if (orgColl != null && orgColl.size() > 0) {
            return orgColl.get(0);
        }
        logger.error((Object)("\u521b\u5efa\u4efb\u52a1\u5f15\u5165\u7ec4\u7ec7\uff0c\u672a\u627e\u5230\u8be5\u7ec4\u7ec7\u5728\u5171\u4eab\u4e2d\u5fc3\u7684\u7236\u7ec4\u7ec7 \u7236\u7ec4\u7ec7id = " + erpOrgParentId + " \u5916\u90e8\u7cfb\u7edfID = " + erpId));
        throw new BOSException("\u521b\u5efa\u4efb\u52a1\u5f15\u5165\u7ec4\u7ec7\uff0c\u672a\u627e\u5230\u8be5\u7ec4\u7ec7\u5728\u5171\u4eab\u4e2d\u5fc3\u7684\u7236\u7ec4\u7ec7 \u7236\u7ec4\u7ec7id = " + erpOrgParentId + " \u5916\u90e8\u7cfb\u7edfID = " + erpId);
    }

    public static String getRoleOrgTreeIdSql(Context ctx, String shareCenterId, String systemAttributeIds, String roleId) throws BOSException {
        int i;
        String[] sysAttrId = systemAttributeIds.split(",");
        Object[] params = new Object[sysAttrId.length * 2 + 1];
        int maxLevel = 5;
        StringBuilder sql = new StringBuilder();
        sql.append("select max(flevel) maxLevel ");
        sql.append("from t_ssc_org org ");
        sql.append("inner join T_SSC_RoleOrg roleorg on org.fid = roleorg.FOrgIDID and roleorg.FRoleIDID = ? ");
        params[0] = roleId;
        for (int i2 = 0; i2 < sysAttrId.length; ++i2) {
            String alias = "map" + i2;
            sql.append(" inner join t_ssc_sysAttrOrgSCMap " + alias);
            sql.append(" on " + alias + ".forgid = org.fid ");
            sql.append(" and " + alias + ".fsharecenterid = ? ");
            sql.append(" and " + alias + ".fsystemattributeid = ? ");
            params[i2 * 2 + 1] = shareCenterId;
            params[i2 * 2 + 2] = sysAttrId[i2];
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        try {
            if (rs != null && rs.next()) {
                maxLevel = rs.getInt("maxLevel");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql = new StringBuilder();
        for (i = 0; i < sysAttrId.length; ++i) {
            sql.append("select org.fid fid ");
            sql.append("from t_ssc_org org ");
            sql.append("inner join T_SSC_RoleOrg roleorg on org.fid = roleorg.FOrgIDID ");
            sql.append("and roleorg.FRoleIDID = '").append(roleId).append("' ");
            String alias = "map" + i;
            sql.append(" inner join t_ssc_sysAttrOrgSCMap " + alias);
            sql.append(" on " + alias + ".forgid = org.fid ");
            sql.append(" and " + alias + ".fsharecenterid = '" + shareCenterId + "' ");
            sql.append(" and " + alias + ".fsystemattributeid = '" + sysAttrId[i] + "' ");
            if (sysAttrId.length - 1 == i) continue;
            sql.append(" union all ");
        }
        for (i = 1; i < maxLevel; ++i) {
            sql.append(" union all ");
            sql.append(SSCUtil.getRoleOrgTreeLevelsql(shareCenterId, systemAttributeIds, i, roleId));
        }
        return sql.toString();
    }

    private static String getRoleOrgTreeLevelsql(String shareCenterId, String systemAttributeIds, int level, String roleId) {
        int i;
        String[] sysAttrId = systemAttributeIds.split(",");
        StringBuilder sql = new StringBuilder();
        sql.append("select fid fid ");
        sql.append("from t_ssc_org where fid in ( ");
        for (i = 1; i < level; ++i) {
            sql.append("select fparentid ");
            sql.append("from t_ssc_org where fid in ( ");
        }
        for (i = 0; i < sysAttrId.length; ++i) {
            sql.append("select org.fparentid ");
            sql.append("from t_ssc_org org ");
            sql.append("inner join T_SSC_RoleOrg roleorg on org.fid = roleorg.FOrgIDID ");
            sql.append("and roleorg.FRoleIDID = '").append(roleId).append("' ");
            String alias = "map" + i;
            sql.append(" inner join t_ssc_sysAttrOrgSCMap " + alias);
            sql.append(" on " + alias + ".forgid = org.fid ");
            sql.append(" and " + alias + ".fsharecenterid = '" + shareCenterId + "' ");
            sql.append(" and " + alias + ".fsystemattributeid = '" + sysAttrId[i] + "' ");
            if (sysAttrId.length - 1 == i) continue;
            sql.append(" union all ");
        }
        for (i = 1; i < level; ++i) {
            sql.append(") ");
        }
        sql.append(") ");
        return sql.toString();
    }

    public static String getDocumentOrgTreeIdSql(Context ctx, String shareCenterId, String systemAttributeId, String documentId) throws BOSException {
        int maxLevel = 5;
        StringBuffer sql = new StringBuffer();
        sql.append("select max(flevel) maxLevel ");
        sql.append("from t_ssc_org org ");
        sql.append("inner join t_ssc_sysAttrOrgSCMap map on map.forgid = org.fid ");
        sql.append("inner join T_ssc_documentorgrelation dor on org.fid = dor.FOrgID ");
        sql.append("where map.fsharecenterid = ? ");
        sql.append("and map.fsystemattributeid = ? ");
        sql.append("and dor.fdocumentId = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{shareCenterId, systemAttributeId, documentId});
        try {
            if (rs != null && rs.next()) {
                maxLevel = rs.getInt("maxLevel");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql = new StringBuffer();
        sql.append("select org.fid fid ");
        sql.append("from t_ssc_org org ");
        sql.append("inner join t_ssc_sysAttrOrgSCMap map on map.forgid = org.fid ");
        sql.append("inner join T_ssc_documentorgrelation dor on org.fid = dor.FOrgID ");
        sql.append("where map.fsharecenterid = '").append(shareCenterId).append("' ");
        sql.append("and map.fsystemattributeid = '").append(systemAttributeId).append("' ");
        sql.append("and dor.fdocumentId = '").append(documentId).append("' ");
        for (int i = 1; i < maxLevel; ++i) {
            sql.append(" union all ");
            sql.append(SSCUtil.getDocumentOrgTreeLevelsql(shareCenterId, systemAttributeId, i, documentId));
        }
        return sql.toString();
    }

    private static String getDocumentOrgTreeLevelsql(String shareCenterId, String systemAttributeId, int level, String documentId) {
        int i;
        StringBuffer sql = new StringBuffer();
        sql.append("select fid fid ");
        sql.append("from t_ssc_org where fid in ( ");
        for (i = 1; i < level; ++i) {
            sql.append("select fparentid ");
            sql.append("from t_ssc_org where fid in ( ");
        }
        sql.append("select org.fparentid ");
        sql.append("from t_ssc_org org ");
        sql.append("inner join t_ssc_sysAttrOrgSCMap map on map.forgid = org.fid ");
        sql.append("inner join T_ssc_documentorgrelation dor on org.fid = dor.FOrgID ");
        sql.append("where map.fsharecenterid = '").append(shareCenterId).append("' ");
        sql.append("and map.fsystemattributeid = '").append(systemAttributeId).append("' ");
        sql.append("and dor.fdocumentId = '").append(documentId).append("' ");
        for (i = 1; i < level; ++i) {
            sql.append(") ");
        }
        sql.append(") ");
        return sql.toString();
    }

    public static String getCheckPointOrgTreeIdSql(Context ctx, String shareCenterId, String systemAttributeId, String checkPointId) throws BOSException {
        int maxLevel = 5;
        StringBuffer sql = new StringBuffer();
        sql.append("select max(flevel) maxLevel ");
        sql.append("from t_ssc_org org ");
        sql.append("inner join t_ssc_sysAttrOrgSCMap map on map.forgid = org.fid ");
        sql.append("inner join T_SSC_CheckpointOrgRelation cporg on org.fid = cporg.FOrgID ");
        sql.append("where map.fsharecenterid = ? ");
        sql.append("and map.fsystemattributeid = ? ");
        sql.append("and cporg.FIntelligentAuditCheckpointID = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{shareCenterId, systemAttributeId, checkPointId});
        try {
            if (rs != null && rs.next()) {
                maxLevel = rs.getInt("maxLevel");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql = new StringBuffer();
        sql.append("select org.fid fid ");
        sql.append("from t_ssc_org org ");
        sql.append("inner join t_ssc_sysAttrOrgSCMap map on map.forgid = org.fid ");
        sql.append("inner join T_SSC_CheckpointOrgRelation cporg on org.fid = cporg.FOrgID ");
        sql.append("where map.fsharecenterid = '").append(shareCenterId).append("' ");
        sql.append("and map.fsystemattributeid = '").append(systemAttributeId).append("' ");
        sql.append("and cporg.FIntelligentAuditCheckpointID = '").append(checkPointId).append("' ");
        for (int i = 1; i < maxLevel; ++i) {
            sql.append(" union all ");
            sql.append(SSCUtil.getCheckPointOrgTreeLevelsql(shareCenterId, systemAttributeId, i, checkPointId));
        }
        return sql.toString();
    }

    private static String getCheckPointOrgTreeLevelsql(String shareCenterId, String systemAttributeId, int level, String checkPointId) {
        int i;
        StringBuffer sql = new StringBuffer();
        sql.append("select fid fid ");
        sql.append("from t_ssc_org where fid in ( ");
        for (i = 1; i < level; ++i) {
            sql.append("select fparentid ");
            sql.append("from t_ssc_org where fid in ( ");
        }
        sql.append("select org.fparentid ");
        sql.append("from t_ssc_org org ");
        sql.append("inner join t_ssc_sysAttrOrgSCMap map on map.forgid = org.fid ");
        sql.append("inner join T_SSC_CheckpointOrgRelation cporg on org.fid = cporg.FOrgID ");
        sql.append("where map.fsharecenterid = '").append(shareCenterId).append("' ");
        sql.append("and map.fsystemattributeid = '").append(systemAttributeId).append("' ");
        sql.append("and cporg.FIntelligentAuditCheckpointID = '").append(checkPointId).append("' ");
        for (i = 1; i < level; ++i) {
            sql.append(") ");
        }
        sql.append(") ");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getConsignerCollection(Context ctx, String assigneeId, String bussAttrId) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT c.FCONSIGNERID");
        sb.append(" FROM T_ssc_consignation c,t_ssc_consignationentry ce,t_ssc_user u");
        sb.append(" where ce.fparentid = c.FID");
        sb.append(" and c.FassigneeID = ?");
        sb.append(" and ce.fbusstypeid = ?");
        sb.append(" and c.FSTATUS = ?");
        sb.append(" and c.FCONSIGNERID = u.FID");
        sb.append(" and u.FISENABLED = 1");
        Object[] params = new Object[]{assigneeId, bussAttrId, "30"};
        HashSet<String> result = new HashSet<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
            while (rs.next()) {
                result.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("sql:" + sb.toString()));
                logger.error((Object)JSONUtils.valueToString((Object)params));
                logger.error((Object)"Query consigner relation error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                JobUtils.closeRS(rs);
                throw throwable;
            }
            JobUtils.closeRS(rs);
        }
        JobUtils.closeRS(rs);
        return result;
    }
}

