/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.SysParamMgerCollection;
import com.kingdee.eas.base.ssc.SysParamMgerFactory;
import com.kingdee.eas.base.ssc.SysParamMgerInfo;
import com.kingdee.eas.base.ssc.UserCollection;
import com.kingdee.eas.base.ssc.UserFactory;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.app.erp.WebServiceSetDao;
import com.kingdee.eas.base.ssc.common.ConstantUtil;
import com.kingdee.eas.base.ssc.common.ParamUtil;
import com.kingdee.eas.base.ssc.tool.FormatUtils;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ShareCenterUtils {
    public static final String SHARECENTER_BOSTYPE = "04610304";
    public static final String SHARECENTER_RELATION_TYPEID = "O1i2ytABHVXgU6hCqMC7Ng/p+LU=";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.tool.ShareCenterUtils");

    public static DataBaseInfo getShareCenterInfo(Context ctx, String shareCenterId) {
        try {
            Class<?> tClass = Class.forName("com.kingdee.eas.basedata.orgext.ShareCenterOrgUnitFactory");
            Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
            Object object = tMethod.invoke(null, ctx);
            Method tMethodService = object.getClass().getMethod("getShareCenterOrgUnitInfo", IObjectPK.class);
            return (DataBaseInfo)tMethodService.invoke(object, H.PK(shareCenterId));
        }
        catch (SecurityException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static DataBaseInfo getShareCenterInfo(Context ctx) throws BOSException, SSCException {
        String shareCenterId = ShareCenterUtils.getShareCenterIdByCtx(ctx);
        return ShareCenterUtils.getShareCenterInfo(ctx, shareCenterId);
    }

    public static List<DataBaseInfo> getAllShareCenterInfo(Context ctx) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        CoreBaseCollection collection = ShareCenterUtils.getShareCenterInfo(ctx, entityViewInfo);
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return new ArrayList<DataBaseInfo>(0);
        }
        int size = collection.size();
        ArrayList<DataBaseInfo> result = new ArrayList<DataBaseInfo>(size);
        for (int i = 0; i < size; ++i) {
            result.add((DataBaseInfo)collection.get(i));
        }
        return result;
    }

    public static List<DataBaseInfo> getAllValidShareCenterInfo(Context ctx) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("isSealUp", (Object)"0");
        filter.getFilterItems().add(new FilterItemInfo("isSealUp", null));
        filter.appendFilterItem("isBizUnit", (Object)"1");
        filter.setMaskString("(#0 or #1) and #2");
        entityViewInfo.setFilter(filter);
        CoreBaseCollection collection = ShareCenterUtils.getShareCenterInfo(ctx, entityViewInfo);
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return new ArrayList<DataBaseInfo>(0);
        }
        int size = collection.size();
        ArrayList<DataBaseInfo> result = new ArrayList<DataBaseInfo>(size);
        for (int i = 0; i < size; ++i) {
            result.add((DataBaseInfo)collection.get(i));
        }
        return result;
    }

    public static List<UserInfo> getSCAdminUser(Context ctx, String[] userIds, String shareCenterId) throws BOSException {
        UserCollection collection;
        StringBuffer sb = new StringBuffer();
        sb.append(" where id in (");
        sb.append(" select ru.fuserIdid from t_ssc_roleUser ru,t_ssc_role r,t_ssc_roleType rt");
        sb.append(" where ru.froleIdid = r.fid");
        sb.append(" and r.froleTypeIdid = rt.fid");
        sb.append(" and rt.fid = '/4qlL+q5zE2iZxXCPaHgBC0WZ4A=')");
        if (StringUtils.isEmpty((String)shareCenterId)) {
            sb.append(" and shareCenterId = '").append(shareCenterId).append("'");
        }
        if (null != userIds && userIds.length > 0) {
            sb.append(" and id in" + FormatUtils.str2Sql(userIds));
        }
        if ((collection = UserFactory.getLocalInstance(ctx).getUserCollection(sb.toString())) == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return new ArrayList<UserInfo>(0);
        }
        int size = collection.size();
        ArrayList<UserInfo> result = new ArrayList<UserInfo>(size);
        for (int i = 0; i < size; ++i) {
            result.add(collection.get(i));
        }
        return result;
    }

    public static DataBaseInfo getShareCenterInfoByNumber(Context ctx, String shareCenterNumber) {
        try {
            Class<?> tClass = Class.forName("com.kingdee.eas.basedata.orgext.ShareCenterOrgUnitFactory");
            Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
            Object object = tMethod.invoke(null, ctx);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            entityViewInfo.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)shareCenterNumber));
            Method tMethodService = object.getClass().getMethod("getCollection", EntityViewInfo.class);
            CoreBaseCollection collection = (CoreBaseCollection)tMethodService.invoke(object, entityViewInfo);
            if (collection == null || collection.isEmpty()) {
                return null;
            }
            return (DataBaseInfo)collection.get(0);
        }
        catch (SecurityException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static CoreBaseCollection getShareCenterInfo(Context ctx, EntityViewInfo entityViewInfo) {
        try {
            Class<?> tClass = Class.forName("com.kingdee.eas.basedata.orgext.ShareCenterOrgUnitFactory");
            Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
            Object object = tMethod.invoke(null, ctx);
            Method tMethodService = object.getClass().getMethod("getCollection", EntityViewInfo.class);
            CoreBaseCollection collection = (CoreBaseCollection)tMethodService.invoke(object, entityViewInfo);
            return collection;
        }
        catch (SecurityException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static UserInfo getSSCUserInfoByEASUserId(Context ctx, String easUserId) throws BOSException, SSCException {
        UserInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("easUserId", (Object)easUserId));
        view.setFilter(filter);
        UserCollection userInfoColl = UserFactory.getLocalInstance(ctx).getUserCollection(view);
        if (userInfoColl != null && userInfoColl.size() > 0) {
            for (int i = 0; i < userInfoColl.size(); ++i) {
                if (!userInfoColl.get(i).isIsEnabled()) continue;
                info = userInfoColl.get(i);
                break;
            }
            if (info == null) {
                throw new SSCException(SSCException.UNKNOW, new Object[]{"\u6b64\u7528\u6237\u5df2\u7ecf\u88ab\u7981\u7528\uff01"});
            }
        } else {
            throw new SSCException(SSCException.UNKNOW, new Object[]{"\u672a\u5728\u5171\u4eab\u670d\u52a1\u4e2d\u5fc3\u5f15\u5165\u5bf9\u5e94\u7684\u7528\u6237\uff01"});
        }
        return info;
    }

    public static String getShareCenterIdByEASUserId(Context ctx, String easUserId) throws BOSException, SSCException {
        UserInfo info = ShareCenterUtils.getSSCUserInfoByEASUserId(ctx, easUserId);
        return info.getShareCenterId();
    }

    public static String getShareCenterIdByEASUserId(Context ctx) throws BOSException, SSCException {
        String easUserId = ShareCenterUtils.getEASUserInfoByCtx(ctx);
        UserInfo info = ShareCenterUtils.getSSCUserInfoByEASUserId(ctx, easUserId);
        return info.getShareCenterId();
    }

    public static String getShareCenterIdBySSCUserId(Context ctx, String sscUserId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)sscUserId)) {
            return null;
        }
        UserInfo userInfo = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(sscUserId));
        return userInfo.getShareCenterId();
    }

    public static UserInfo getSSCUserInfoByCtx(Context ctx) throws BOSException, SSCException {
        String easUserId = ShareCenterUtils.getEASUserInfoByCtx(ctx);
        return ShareCenterUtils.getSSCUserInfoByEASUserId(ctx, easUserId);
    }

    public static String getEASUserInfoByCtx(Context ctx) {
        if (ctx.getCaller() != null) {
            return ctx.getCaller().toString();
        }
        com.kingdee.eas.base.permission.UserInfo curUser = (com.kingdee.eas.base.permission.UserInfo)ctx.get((Object)"UserInfo");
        return curUser.getId().toString();
    }

    public static String getShareCenterIdByCtx(Context ctx) throws BOSException, SSCException {
        String easUserId = ShareCenterUtils.getEASUserInfoByCtx(ctx);
        return ShareCenterUtils.getShareCenterIdByEASUserId(ctx, easUserId);
    }

    public static String getShareCenterNameByCtx(Context ctx) throws BOSException, SSCException {
        return ShareCenterUtils.getShareCenterInfo(ctx).getName();
    }

    public static String getShareCenterNameById(Context ctx, String shareCenterId) throws BOSException {
        return ShareCenterUtils.getShareCenterInfo(ctx, shareCenterId).getName();
    }

    public static Boolean isTopShareCenter(Context ctx, String shareCenterId) throws BOSException, SSCException {
        return ShareCenterUtils.isTopShareCenter(ctx, ShareCenterUtils.getShareCenterInfo(ctx, shareCenterId));
    }

    public static Boolean isTopShareCenterByNumber(Context ctx, String shareCenterNumber) throws BOSException, SSCException {
        return ShareCenterUtils.isTopShareCenter(ctx, ShareCenterUtils.getShareCenterInfoByNumber(ctx, shareCenterNumber));
    }

    public static Boolean isTopShareCenter(Context ctx, DataBaseInfo shareCenter) throws BOSException, SSCException {
        String sscAdminEASUserId = "Wp3rRSFxRCaPFjuE2apQjRO33n8=";
        UserInfo sscAdminUserInfo = ShareCenterUtils.getSSCUserInfoByEASUserId(ctx, sscAdminEASUserId);
        if (sscAdminUserInfo.getShareCenterId().equals(shareCenter.getId().toString())) {
            return true;
        }
        return false;
    }

    public static DataBaseInfo getTopShareCenter(Context ctx) throws BOSException, SSCException {
        String sscAdminEASUserId = "Wp3rRSFxRCaPFjuE2apQjRO33n8=";
        UserInfo sscAdminUserInfo = ShareCenterUtils.getSSCUserInfoByEASUserId(ctx, sscAdminEASUserId);
        String topShareCenterId = sscAdminUserInfo.getShareCenterId();
        DataBaseInfo topShareCenterInfo = ShareCenterUtils.getShareCenterInfo(ctx, topShareCenterId);
        return topShareCenterInfo;
    }

    public static String getEntrustOrgIDByShareCenterID(Context ctx, String shareCenterID) throws BOSException, EASBizException {
        String sql = "select FTOUNITID from T_ORG_UNITRELATION where FTYPERELATIONID = ? and FFROMUNITID = ?";
        String orgID = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{SHARECENTER_RELATION_TYPEID, shareCenterID});
            if (rs.next()) {
                orgID = rs.getString(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u67e5\u8be2shareCenterID:" + shareCenterID + "\u5bf9\u5e94\u7684\u884c\u653f\u7ec4\u7ec7\u59d4\u6258\u51fa\u73b0\u5f02\u5e38,\u5c06\u8fd4\u56de\u7a7a.ctx.getAIS():" + ctx.getAIS()), (Throwable)e);
        }
        return orgID;
    }

    public static String getCompanyOrgIDByShareCenterID(Context ctx, String shareCenterID) throws BOSException, EASBizException {
        String sql = "select FTOUNITID from T_ORG_UNITRELATION where FTYPERELATIONID = ? and FFROMUNITID = ?";
        String orgID = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{"hZewdKNBa73gUzA/qMBwPw/p+LU=", shareCenterID});
            if (rs.next()) {
                orgID = rs.getString(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u67e5\u8be2shareCenterID:" + shareCenterID + "\u5bf9\u5e94\u7684\u884c\u653f\u7ec4\u7ec7\u59d4\u6258\u51fa\u73b0\u5f02\u5e38,\u5c06\u8fd4\u56de\u7a7a.ctx.getAIS():" + ctx.getAIS()), (Throwable)e);
        }
        return orgID;
    }

    public static boolean isCurrentUserSSCAdmin(Context ctx, UserInfo userInfo) {
        return "sscAdmin".equalsIgnoreCase(userInfo.getNumber()) && "Wp3rRSFxRCaPFjuE2apQjRO33n8=".equals(userInfo.getEasUserId());
    }

    public static String getShareCenterParentIDs(Context ctx, StringBuffer result, String shareCenterId) {
        if (StringUtils.isEmpty((String)shareCenterId)) {
            return "''";
        }
        String sql = "select fparentid from t_org_sharecenterorgunit where fid = ?";
        String parentId = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{shareCenterId});
            if (rs.next()) {
                parentId = rs.getString(1);
            }
            if (result.length() == 0) {
                result.append("'").append(shareCenterId).append("',");
            }
            if (!StringUtils.isEmpty((String)parentId)) {
                result.append("'").append(parentId).append("',");
            }
            if (!StringUtils.isEmpty((String)parentId) && !"00000000-0000-0000-0000-000000000000CCE7AED4".equals(parentId)) {
                ShareCenterUtils.getShareCenterParentIDs(ctx, result, parentId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"getShareCenterParentIDs error", (Throwable)e);
        }
        return result.toString().substring(0, result.length() - 1);
    }

    public static SysParamMgerInfo getSysParamMgerInfoByCtx(Context ctx) throws BOSException, EASBizException {
        String sid = ShareCenterUtils.getShareCenterIdByCtx(ctx);
        SysParamMgerCollection smColl = SysParamMgerFactory.getLocalInstance(ctx).getSysParamMgerCollection("select * where shareCenterId='" + sid + "'");
        if (smColl.size() > 0) {
            return smColl.get(0);
        }
        return ShareCenterUtils.initSysParamMgerInfo(ctx, sid);
    }

    public static SysParamMgerInfo getSysParamMgerInfo(Context ctx, String shareCenterId) throws BOSException, EASBizException {
        SysParamMgerCollection smColl = SysParamMgerFactory.getLocalInstance(ctx).getSysParamMgerCollection("select * where shareCenterId='" + shareCenterId + "'");
        if (smColl.size() > 0) {
            return smColl.get(0);
        }
        return ShareCenterUtils.initSysParamMgerInfo(ctx, shareCenterId);
    }

    public static SysParamMgerInfo initSysParamMgerInfo(Context ctx, String shareCenterId) throws BOSException, EASBizException {
        SysParamMgerInfo smInfo = new SysParamMgerInfo();
        Properties prop1 = WebServiceSetDao.getProperties((String)ParamUtil.getAbsoluteFORMULA_PATH());
        Properties prop2 = WebServiceSetDao.getProperties((String)ParamUtil.getAbsoluteSSCParam_PATH());
        smInfo.setShareCenterId(shareCenterId);
        smInfo.setJobCount(Integer.parseInt(prop1.getProperty(ConstantUtil.JOBCOUNT)));
        smInfo.setEfficiency(Integer.parseInt(prop1.getProperty(ConstantUtil.EFFICIENCY)));
        smInfo.setIsReturnToOriginalPerso(false);
        smInfo.setIsShowJobAttachment(true);
        smInfo.setIsHideDimission(false);
        smInfo.setId(BOSUuid.create((String)"7CBC8857"));
        smInfo.setEnableEqualDivision(false);
        smInfo.setEqualDivisionMaxNumber(0);
        smInfo.setShowAuditor(true);
        smInfo.setEnableYzjChat(false);
        smInfo.setRefreshFrequency(60.0f);
        SysParamMgerFactory.getLocalInstance(ctx).addnew(smInfo);
        return smInfo;
    }

    public static String getUserIdByErpUserId(Context ctx, String erpUserId) throws BOSException {
        if (erpUserId == null || "".equals(erpUserId)) {
            throw new BOSException("\u5916\u90e8\u7cfb\u7edf\u7528\u6237ID\u4e3a\u7a7a");
        }
        ObjectUuidPK uuidPK = new ObjectUuidPK(erpUserId);
        String bosType = uuidPK.getObjectType().toString();
        String userId = null;
        userId = "8063D27B".equals(bosType) ? erpUserId : ShareCenterUtils.getSSCUserInfoByErpUserId(ctx, erpUserId).getId().toString();
        return userId;
    }

    public static UserInfo getSSCUserInfoByErpUserId(Context ctx, String erpUserId) throws BOSException {
        UserInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("userId", (Object)erpUserId));
        filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)"1"));
        view.setFilter(filter);
        UserCollection userInfoColl = UserFactory.getLocalInstance(ctx).getUserCollection(view);
        if (userInfoColl == null || userInfoColl.size() <= 0) {
            throw new BOSException("\u5171\u4eab\u4e2d\u5fc3\u6ca1\u6709\u5bf9\u5e94\u7684\u5916\u90e8\u7cfb\u7edf\u7528\u6237\uff01");
        }
        info = userInfoColl.get(0);
        return info;
    }

    public static boolean enablePullJob(Context ctx, String shareCenterId) {
        try {
            return ShareCenterUtils.getSysParamMgerInfo(ctx, shareCenterId).isEnablePullJob();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

