/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool.credit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssc.CreditParamsCollection;
import com.kingdee.eas.base.ssc.CreditParamsEntryCollection;
import com.kingdee.eas.base.ssc.CreditParamsFactory;
import com.kingdee.eas.base.ssc.CreditScoreCollection;
import com.kingdee.eas.base.ssc.CreditScoreFactory;
import com.kingdee.eas.base.ssc.CreditScoreLdRuleCollection;
import com.kingdee.eas.base.ssc.CreditScoreLdRuleFactory;
import com.kingdee.eas.base.ssc.CreditScoreLdRuleInfo;
import com.kingdee.eas.base.ssc.tool.cache.SSCCacheManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CreditCache {
    private static Logger logger = Logger.getLogger(CreditCache.class);

    public static BigDecimal getAddScorePerBill(Context ctx, String scId) {
        Properties cacheObj = (Properties)SSCCacheManager.getValue("creditParamsCacheMap_creditScoreLdRule_map");
        if (null == cacheObj || null == cacheObj.get(scId)) {
            CreditCache.reloadCreditUpOrReduceGrade(ctx, scId);
        }
        if (null == (cacheObj = (Properties)SSCCacheManager.getValue("creditParamsCacheMap_creditScoreLdRule_map")) || null == cacheObj.get(scId)) {
            logger.error((Object)"\u83b7\u53d6\u4fe1\u7528\u5347\u964d\u7ea7\u53c2\u6570\u7f13\u5b58\u5931\u8d25\uff01\u9ed8\u8ba4\u8fd4\u56de0");
            return new BigDecimal(0);
        }
        return ((CreditScoreLdRuleInfo)cacheObj.get(scId)).getAddtionalCreditScore();
    }

    public static BigDecimal getMaxMinusScorePerBill(Context ctx, String scId) {
        Properties cacheObj = (Properties)SSCCacheManager.getValue("creditParamsCacheMap_creditScoreLdRule_map");
        if (null == cacheObj || null == cacheObj.get(scId)) {
            CreditCache.reloadCreditUpOrReduceGrade(ctx, scId);
        }
        if (null == (cacheObj = (Properties)SSCCacheManager.getValue("creditParamsCacheMap_creditScoreLdRule_map")) || null == cacheObj.get(scId)) {
            logger.error((Object)"\u83b7\u53d6\u4fe1\u7528\u5347\u964d\u7ea7\u53c2\u6570\u7f13\u5b58\u5931\u8d25\uff01\u9ed8\u8ba4\u8fd4\u56de0");
            return new BigDecimal(0);
        }
        return ((CreditScoreLdRuleInfo)cacheObj.get(scId)).getMaxReduceCreditScore();
    }

    public static synchronized void reloadCreditUpOrReduceGrade(Context ctx, String scId) {
        try {
            Properties cacheObj = new Properties();
            CreditScoreLdRuleInfo creditScroeLdRuleMap = null;
            CreditScoreLdRuleCollection creditScoreLdRuleColls = CreditScoreLdRuleFactory.getLocalInstance(ctx).getCreditScoreLdRuleCollection("where scOrg is not null");
            if (creditScoreLdRuleColls != null && !creditScoreLdRuleColls.isEmpty()) {
                for (int i = 0; i < creditScoreLdRuleColls.size(); ++i) {
                    creditScroeLdRuleMap = creditScoreLdRuleColls.get(i);
                    cacheObj.put(creditScroeLdRuleMap.getScOrg().getId().toString(), creditScroeLdRuleMap);
                }
                SSCCacheManager.put("creditParamsCacheMap_creditScoreLdRule_map", cacheObj);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static List<String> getCreditBillType(Context ctx, String scId) {
        Properties cacheObj = (Properties)SSCCacheManager.getValue("creditBillTypeMap_map");
        if (null == cacheObj || null == cacheObj.get(scId)) {
            CreditCache.reloadCreditParam(ctx, scId);
        }
        if (null == (cacheObj = (Properties)SSCCacheManager.getValue("creditBillTypeMap_map")) || null == cacheObj.get(scId)) {
            logger.error((Object)"\u83b7\u53d6CreditBillType\u7f13\u5b58\u5931\u8d25\uff01\u9ed8\u8ba4\u8fd4\u56de\u7a7aList");
            return Collections.EMPTY_LIST;
        }
        return (List)cacheObj.get(scId);
    }

    public static synchronized void reloadCreditParam(Context ctx, String scId) {
        try {
            Properties cacheObj = new Properties();
            CreditParamsCollection creditParamsCollection = CreditParamsFactory.getLocalInstance(ctx).getCreditParamsCollection("where sharecenter is not null");
            if (creditParamsCollection != null && !creditParamsCollection.isEmpty()) {
                for (int i = 0; i < creditParamsCollection.size(); ++i) {
                    CreditParamsEntryCollection creditParamsEntryColl = creditParamsCollection.get(i).getEntrys();
                    ArrayList<String> list = new ArrayList<String>();
                    for (int j = 0; j < creditParamsEntryColl.size(); ++j) {
                        list.add(creditParamsEntryColl.get(j).getBillType().getId().toString());
                    }
                    cacheObj.put(creditParamsCollection.get(i).getShareCenter().getId().toString(), list);
                }
                SSCCacheManager.put("creditBillTypeMap_map", cacheObj);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static CreditScoreCollection getCreditScoreColl(Context ctx) {
        Object cacheObj = SSCCacheManager.getValue("creditScore_map");
        if (null == cacheObj) {
            CreditCache.reloadCreditGrade(ctx);
        }
        return (CreditScoreCollection)((Object)SSCCacheManager.getValue("creditScore_map"));
    }

    public static synchronized void reloadCreditGrade(Context ctx) {
        try {
            CreditScoreCollection cacheObj = CreditScoreFactory.getLocalInstance(ctx).getCreditScoreCollection("order by seqNo asc");
            SSCCacheManager.put("creditScore_map", (Object)cacheObj);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

