/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool.credit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.ssc.CreditParamsEntryCollection;
import com.kingdee.eas.base.ssc.CreditParamsEntryInfo;
import com.kingdee.eas.base.ssc.CreditParamsFacadeFactory;
import com.kingdee.eas.base.ssc.CreditParamsInfo;
import com.kingdee.eas.base.ssc.DataFilteringRuleEntryCollection;
import com.kingdee.eas.base.ssc.DataFilteringRuleEntryInfo;
import com.kingdee.eas.base.ssc.DataFilteringRuleFactory;
import com.kingdee.eas.base.ssc.DataFilteringRuleInfo;
import com.kingdee.eas.base.ssc.DynValueHisCollection;
import com.kingdee.eas.base.ssc.DynValueHisFactory;
import com.kingdee.eas.base.ssc.DynamicAttributeFactory;
import com.kingdee.eas.base.ssc.DynamicAttributeInfo;
import com.kingdee.eas.base.ssc.FieldType;
import com.kingdee.eas.base.ssc.JobHisFactory;
import com.kingdee.eas.base.ssc.JobHisInfo;
import com.kingdee.eas.base.ssc.app.InfluenceCreditTypeEnum;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.SSCCompareUtils;
import com.kingdee.eas.base.ssc.tool.credit.DealInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CreditParamsUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.tool.credit");

    public static boolean isMatchCredit(Context ctx, String shareCenterId, String jobId, InfluenceCreditTypeEnum type) {
        try {
            String isCredit = ParamManager.getParamValue((Context)ctx, (IObjectPK)H.PK(shareCenterId), (String)"SSC_CREDIT_MANAGER");
            if (!"true".equalsIgnoreCase(isCredit)) {
                logger.error((Object)"\u4fe1\u7528\u53c2\u6570\u672a\u542f\u7528\uff0c\u5982\u9700\u4f7f\u7528\u4fe1\u7528\uff0c\u8bf7\u5f00\u542f\u4fe1\u7528\u53c2\u6570");
                return false;
            }
            return CreditParamsUtils.isMatchCreditParam(ctx, jobId, type);
        }
        catch (Exception e) {
            logger.error((Object)("\u4fe1\u7528\u53c2\u6570-\u53d1\u751f\u4e86Exception\u6700\u7ec8\u5339\u914d\u7684\u7ed3\u679c\u662ffalse-[shareCenterId:[" + shareCenterId + "]jobId:" + jobId + ",type:" + type + "]"));
            logger.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public static boolean isMatchCreditParam(Context ctx, String jobId, InfluenceCreditTypeEnum type) {
        try {
            JobHisInfo jobHisInfo = JobHisFactory.getLocalInstance(ctx).getJobHisInfo("select *, bussAttrID.* where id = '" + jobId + "'");
            CreditParamsInfo creditParamsInfo = CreditParamsFacadeFactory.getLocalInstance(ctx).getCreditParamsInfoInCache(jobHisInfo.getShareCenterID().getId().toString());
            if (InfluenceCreditTypeEnum.sharedAudit.equals((Object)type)) {
                if (!creditParamsInfo.isSharedAudit()) {
                    logger.error((Object)("\u4fe1\u7528\u53c2\u6570-\u5171\u4eab\u5ba1\u6838\u5f71\u54cd\u4fe1\u7528-\u914d\u7f6e\u4e86\u5426-[jobId:" + jobId + ",type:" + type + "]"));
                    return false;
                }
            } else if (InfluenceCreditTypeEnum.sharedReview.equals((Object)type)) {
                if (!creditParamsInfo.isSharedReview()) {
                    logger.error((Object)("\u4fe1\u7528\u53c2\u6570-\u5171\u4eab\u62bd\u68c0\u5f71\u54cd\u4fe1\u7528-\u914d\u7f6e\u4e86\u5426-[jobId:" + jobId + ",type:" + type + "]"));
                    return false;
                }
            } else if (InfluenceCreditTypeEnum.auditQuality.equals((Object)type) && !creditParamsInfo.isAuditQuality()) {
                logger.error((Object)("\u4fe1\u7528\u53c2\u6570-\u5ba1\u8ba1\u8d28\u68c0\u5f71\u54cd\u4fe1\u7528-\u914d\u7f6e\u4e86\u5426-[jobId:" + jobId + ",type:" + type + "]"));
                return false;
            }
            CreditParamsEntryCollection paramsEntryColl = creditParamsInfo.getEntrys();
            for (int i = 0; paramsEntryColl != null && i < paramsEntryColl.size(); ++i) {
                CreditParamsEntryInfo entryInfo = paramsEntryColl.get(i);
                if (!entryInfo.getBillType().getId().toString().equals(jobHisInfo.getBussAttrID().getBillType().getId().toString())) continue;
                String dataFilteringRule = entryInfo.getDataFilteringRule();
                if (StringUtils.isBlank((CharSequence)dataFilteringRule)) {
                    return true;
                }
                return CreditParamsUtils.isMatchCreditRule(ctx, dataFilteringRule, jobHisInfo);
            }
            logger.error((Object)("\u4fe1\u7528\u53c2\u6570-\u6700\u7ec8\u5339\u914d\u7684\u7ed3\u679c\u662ffalse-[jobId:" + jobId + ",type:" + type + "]"));
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("\u4fe1\u7528\u53c2\u6570-\u53d1\u751f\u4e86Exception\u6700\u7ec8\u5339\u914d\u7684\u7ed3\u679c\u662ffalse-[jobId:" + jobId + ",type:" + type + "]"));
            logger.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public static boolean isMatchCreditRule(Context ctx, String dataFilteringRule, JobHisInfo jobHisInfo) throws EASBizException, BOSException, SQLException {
        DataFilteringRuleInfo dataFilterInfo = DataFilteringRuleFactory.getLocalInstance(ctx).getDataFilteringRuleInfo(" select *,entrys.* where id = '" + dataFilteringRule + "'");
        DataFilteringRuleEntryCollection ruleEntryColl = dataFilterInfo.getEntrys();
        if (ruleEntryColl == null || ruleEntryColl.size() == 0) {
            return true;
        }
        ArrayList<DealInfo> listBool = new ArrayList<DealInfo>();
        for (int i = 0; ruleEntryColl != null && i < ruleEntryColl.size(); ++i) {
            DealInfo dealInfo = new DealInfo();
            DataFilteringRuleEntryInfo entryInfo = ruleEntryColl.get(i);
            String comparisonValue = entryInfo.getComparisonValue();
            String propId = entryInfo.getPropertyId();
            if (StringUtils.isBlank((CharSequence)propId)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(" SELECT b.FDYNAMICIDID ,b.FDINAMICVALUE ,c.FNUMBER,a.FISLASTLEVEL ,a.FSHARECENTERID   FROM t_ssc_jobhis a ");
                buffer.append(" inner join T_SSC_DynValueHis b on a.FID =b.fjobidid ");
                buffer.append(" inner join T_SSC_DynamicAttribute c on c.FID =b.fdynamicidid ");
                buffer.append(" where a.fid = ? and c.fnumber = ? ");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])new Object[]{jobHisInfo.getId().toString(), entryInfo.getProperty()});
                if (rs.next()) {
                    propId = rs.getString("FDYNAMICIDID");
                } else {
                    logger.error((Object)("\u6ee1\u610f\u5ea6\u6839\u636e\u52a8\u6001\u5c5e\u6027\u540d\u79f0\u548c\u4efb\u52a1id\u67e5\u8be2\u52a8\u6001\u5c5e\u6027id\u4e3a\u7a7a;[dataFilteringRule:" + dataFilteringRule + ";jobHisInfo:" + jobHisInfo.getId().toString() + "]"));
                    return false;
                }
            }
            DynamicAttributeInfo dyAttrInfo = DynamicAttributeFactory.getLocalInstance(ctx).getDynamicAttributeInfo(H.PK(propId));
            DynValueHisCollection dyValueColl = DynValueHisFactory.getLocalInstance(ctx).getDynValueHisCollection("select * where jobID.id = '" + jobHisInfo.getId().toString() + "' and dynamicID.id = '" + propId + "'");
            String comparKey = "";
            if (dyValueColl != null && dyValueColl.size() > 0) {
                comparKey = FieldType.NUMBER.equals((Object)dyAttrInfo.getType()) ? dyValueColl.get(0).getDigiValue().toString() : dyValueColl.get(0).getDinamicValue();
            }
            dealInfo.setLeftBracket(entryInfo.getLeftBracket());
            dealInfo.setRightBracket(entryInfo.getRightBracket());
            boolean b = SSCCompareUtils.compareS(entryInfo.getComparisonOper(), comparKey, comparisonValue);
            dealInfo.setBool(b);
            dealInfo.setLeftBracket(entryInfo.getLeftBracket());
            dealInfo.setRightBracket(entryInfo.getRightBracket());
            dealInfo.setLuogi(entryInfo.getLogicalCondition());
            listBool.add(dealInfo);
        }
        boolean endBool = true;
        String luoj = " && ";
        if (listBool.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < listBool.size(); ++j) {
                DealInfo dealInfo = (DealInfo)listBool.get(j);
                sb.append(StringUtils.isEmpty((CharSequence)dealInfo.getLeftBracket()) ? "" : dealInfo.getLeftBracket());
                sb.append(dealInfo.isBool());
                sb.append(StringUtils.isEmpty((CharSequence)dealInfo.getRightBracket()) ? "" : dealInfo.getRightBracket());
                String luoji = dealInfo.getLuogi();
                if (luoji != null && "and".equalsIgnoreCase(luoji.trim())) {
                    dealInfo.setLuogi(" && ");
                } else if (luoji != null && "or".equalsIgnoreCase(luoji.trim())) {
                    dealInfo.setLuogi(" || ");
                }
                dealInfo.setLuogi(" " + dealInfo.getLuogi() + " ");
                if (j >= listBool.size() - 1) continue;
                if (!StringUtils.isEmpty((CharSequence)luoji)) {
                    sb.append(dealInfo.getLuogi());
                    continue;
                }
                sb.append(luoj);
            }
            try {
                ScriptEngineManager manager = new ScriptEngineManager();
                ScriptEngine engine = manager.getEngineByName("JavaScript");
                engine.eval("function t() {return " + sb.toString() + ";}");
                Invocable invocable = (Invocable)((Object)engine);
                Object o = invocable.invokeFunction("t", new Object[0]);
                endBool = Boolean.parseBoolean(o.toString());
                return endBool;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return endBool;
    }
}

