/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssccommon.utils.httputils;

import java.io.IOException;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpPostUtil {
    private static Logger logger = Logger.getLogger(HttpPostUtil.class);

    public static String postInterface(String url, String params, boolean outPutLog) throws Exception {
        return HttpPostUtil.postInterface(url, params, null, outPutLog);
    }

    public static String postInterface(String url, String params, Map<String, String> header, boolean outPutLog) throws Exception {
        if (outPutLog) {
            logger.error((Object)("url[" + url + "]--params[" + params + "]"));
        } else {
            logger.debug((Object)("url[" + url + "]--params[" + params + "]"));
        }
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-Type", "application/json");
        if (header != null) {
            for (String key : header.keySet()) {
                httpPost.setHeader(key, header.get(key));
            }
        }
        String charSet = "UTF-8";
        StringEntity entity = new StringEntity(params, charSet);
        entity.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json"));
        entity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpPost);
            StatusLine status = response.getStatusLine();
            int state = status.getStatusCode();
            if (state == 200) {
                HttpEntity responseEntity = response.getEntity();
                String jsonString = EntityUtils.toString((HttpEntity)responseEntity);
                if (outPutLog) {
                    logger.error((Object)("response--state:" + state + ",response--jsonString:" + jsonString));
                } else {
                    logger.debug((Object)("response--state:" + state + ",response--jsonString:" + jsonString));
                }
                String string = jsonString;
                return string;
            }
            try {
                throw new Exception("URL:" + url + ";HttpStatusCode:" + status.toString());
            }
            catch (IOException e) {
                throw new Exception(e);
            }
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
            try {
                httpclient.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }
}

