/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uict.BizConfigureFactory;
import com.kingdee.eas.base.uict.BizConfigureInfo;
import com.kingdee.eas.base.uict.IOrgUict;
import com.kingdee.eas.base.uict.OrgUictFactory;
import com.kingdee.eas.base.uict.client.AbstractBizConfigureListUI;
import com.kingdee.eas.base.uict.client.BizAliasUI;
import com.kingdee.eas.base.uict.client.ConfigureParam;
import com.kingdee.eas.base.uict.client.DefaultPermissionEditorUI;
import com.kingdee.eas.base.uict.client.OrgTypeUtils;
import com.kingdee.eas.base.uict.client.UictAccreditUI;
import com.kingdee.eas.base.uict.client.UictProgressDlgUI;
import com.kingdee.eas.base.uict.client.cfgbiz.DeployMenu;
import com.kingdee.eas.base.uict.client.ie.UictExportRun;
import com.kingdee.eas.base.uict.client.ie.UictImportRun;
import com.kingdee.eas.base.uict.client.util.BizConfigureHelper;
import com.kingdee.eas.base.uict.client.util.DeleteConfigureUI;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.f7.OrgViewF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BizConfigureListUI
extends AbstractBizConfigureListUI {
    public static final String VIEWNAME = "com_kingdee_eas_base_bizunit";
    public static final String CONFIGURED = "configured";
    private static final Logger logger = CoreUIObject.getLogger((Class)BizConfigureListUI.class);
    private BizUnitInfo selectedConfiguredBizUnit = null;
    private KDPopupMenu popMenu = new KDPopupMenu();
    private JMenuItem modifyAlias = new JMenuItem("\u4fee\u6539\u522b\u540d");
    private JMenuItem deployListUIMenu = new JMenuItem("\u53d1\u5e03\u5e8f\u65f6\u8584\u754c\u9762\u83dc\u5355");
    private JMenuItem deployEditUIMenu = new JMenuItem("\u53d1\u5e03\u7f16\u8f91\u754c\u9762\u83dc\u5355");
    private Map bizUnitMap = new HashMap();
    private boolean isIncludeChild = false;
    private static Map orgTypeAliasMap = new HashMap();
    private static OrgViewType[] orgViewTypes;

    public BizConfigureListUI() throws Exception {
        this.updateToCustomSchem.setVisible(false);
        if (this.useCustomizedPlatform()) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u5982\u679c\u8981\u4f7f\u7528\u754c\u9762\u914d\u7f6e\uff0c\u8bf7\u8fdb\u5165\u53c2\u6570\u5e73\u53f0\uff0c\u4fee\u6539isUseCustomizedPlatform\u503c\u4e3afalse");
            SysUtil.abort();
        }
    }

    private void initPopupmenu() {
        this.modifyAlias.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BizConfigureListUI.this.modifyAlias_actionPerformed(e);
            }
        });
        this.popMenu.add(this.modifyAlias);
        this.deployListUIMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BizConfigureListUI.this.deployListUIMenu_actionPerformed(e);
            }
        });
        this.popMenu.add(this.deployListUIMenu);
        this.deployEditUIMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BizConfigureListUI.this.deployEditUIMenu_actionPerformed(e);
            }
        });
        this.popMenu.add(this.deployEditUIMenu);
    }

    protected void modifyAlias_actionPerformed(ActionEvent e) {
        if (this.selectedConfiguredBizUnit != null) {
            UIContext uiContext = new UIContext((Object)this);
            try {
                uiContext.put("BizUnitInfo", this.selectedConfiguredBizUnit);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(BizAliasUI.class.getName(), (Map)uiContext);
                uiWindow.show();
            }
            catch (UIException e1) {
                logger.error((Object)e1);
            }
        }
    }

    protected void delCfgItem_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(DeleteConfigureUI.class.getName(), (Map)uiContext);
            uiWindow.show();
        }
        catch (UIException e1) {
            logger.error((Object)e1);
        }
    }

    protected void deployListUIMenu_actionPerformed(ActionEvent e) {
        if (this.selectedConfiguredBizUnit != null) {
            String listUIPK = this.selectedConfiguredBizUnit.getString("listUIPK");
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("uiClassName", listUIPK);
            data.put("uiOprt", "");
            DeployMenu dm = new DeployMenu();
            dm.deployReport(data, (IUIObject)this);
        }
    }

    protected void deployEditUIMenu_actionPerformed(ActionEvent e) {
        if (this.selectedConfiguredBizUnit != null) {
            String editUIPK = this.selectedConfiguredBizUnit.getString("editUIPK");
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("uiClassName", editUIPK);
            data.put("uiOprt", "ADDNEW");
            DeployMenu dm = new DeployMenu();
            dm.deployReport(data, (IUIObject)this);
        }
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void tree_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 1 && SwingUtilities.isRightMouseButton(e)) {
            DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
            this.modifyAlias.setEnabled(false);
            this.deployListUIMenu.setEnabled(false);
            this.deployEditUIMenu.setEnabled(false);
            this.selectedConfiguredBizUnit = null;
            if (treeNode != null && treeNode.getUserObject() != null && treeNode.getUserObject() instanceof MetaDataBriefInfo) {
                String configured;
                MetaDataBriefInfo mdInfo = (MetaDataBriefInfo)treeNode.getUserObject();
                if (mdInfo.isPackage()) {
                    return;
                }
                BizUnitInfo bizUnit = BizConfigureHelper.loadBizUnit(mdInfo.getMetaDataPK());
                if (bizUnit != null && "true".equals(configured = bizUnit.getExtendedProperty(CONFIGURED))) {
                    this.modifyAlias.setEnabled(true);
                    if (!StringUtils.isEmpty((String)bizUnit.getString("listUIPK"))) {
                        this.deployListUIMenu.setEnabled(true);
                    }
                    if (!StringUtils.isEmpty((String)bizUnit.getString("editUIPK"))) {
                        this.deployEditUIMenu.setEnabled(true);
                    }
                    this.selectedConfiguredBizUnit = bizUnit;
                }
            }
            this.popMenu.show((Component)this.tree, e.getX(), e.getY());
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        if (this.isBizUnitEmpty()) {
            return;
        }
        super.actionView_actionPerformed(e);
        this.refreshList();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isBizUnitEmpty()) {
            return;
        }
        this.checkCanEdit();
        this.checkIsReserver();
        super.actionEdit_actionPerformed(e);
        this.refreshList();
    }

    private void checkCanEdit() {
        String id;
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row != null && !StringUtils.isEmpty((String)(id = (String)row.getCell("OrgUnit.id").getValue())) && !this.getCurrentOrgUnit().getId().toString().equalsIgnoreCase(id)) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u53ea\u6709\u521b\u5efa\u7ec4\u7ec7\u624d\u80fd\u5bf9\u754c\u9762\u914d\u7f6e\u65b9\u6848\u8fdb\u884c\u4fee\u6539\u3001\u5220\u9664\u6216\u5206\u914d\uff01");
            SysUtil.abort();
        }
    }

    private void checkIsReserver() {
        ArrayList list = super.getSelectedIdValues();
        if (list.size() > 0) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)list.get(0))));
            BizConfigureInfo ov = null;
            try {
                ov = (BizConfigureInfo)this.getBizInterface().getValue((IObjectPK)pk);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (ov != null && ov.isReserver()) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u8be5\u65b9\u6848\u4e3a\u9884\u8bbe\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u6216\u5220\u9664\uff01");
                SysUtil.abort();
            }
        }
    }

    private boolean isBizUnitEmpty() {
        ICell cell;
        Object value;
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rowIndex.length > 0 && ((value = (cell = this.tblMain.getCell(rowIndex[0], "bizUnit")).getValue()) == null || StringUtils.isEmpty((String)cell.getValue().toString()))) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u754c\u9762\u914d\u7f6e\u65b9\u6848\u5bf9\u5e94\u7684\u4e1a\u52a1\u5355\u5143\u4e0d\u5b58\u5728\uff01");
            SysUtil.abort();
            return true;
        }
        return false;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanEdit();
        this.checkIsReserver();
        ArrayList list = super.getSelectedIdValues();
        String cfgID = null;
        if (list.size() > 0) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)list.get(0))));
            BizConfigureInfo ov = (BizConfigureInfo)this.getBizInterface().getValue((IObjectPK)pk);
            cfgID = ov.getId().toString();
        }
        super.actionRemove_actionPerformed(e);
        if (!StringUtils.isEmpty(cfgID)) {
            IOrgUict iou = OrgUictFactory.getRemoteInstance();
            iou.synAssign(cfgID);
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BizConfigureFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        BizConfigureInfo objectValue = new BizConfigureInfo();
        return objectValue;
    }

    private void initBizUnitMap(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return;
        }
        if (root.getUserObject() != null && root.getUserObject() instanceof MetaDataBriefInfo) {
            MetaDataBriefInfo mdInfo = (MetaDataBriefInfo)root.getUserObject();
            if (mdInfo.isPackage()) {
                int n = root.getChildCount();
                for (int i = 0; i < n; ++i) {
                    this.initBizUnitMap((DefaultKingdeeTreeNode)root.getChildAt(i));
                }
            } else if (!StringUtils.isEmpty((String)mdInfo.getAlias())) {
                this.bizUnitMap.put(mdInfo.getFullName(), mdInfo.getAlias());
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        OrgUnitInfo orgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        if (orgUnit != null) {
            this.prmtOrgUnit.setValue((Object)orgUnit.castToFullOrgUnitInfo());
        }
        this.prmtOrgUnit.setEditable(false);
        OrgViewF7 selector = new OrgViewF7((IUIObject)this);
        selector.setOrgViewTypes(orgViewTypes);
        selector.setMultiSelect(false);
        this.prmtOrgUnit.setSelector((KDPromptSelector)selector);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnRemove.setEnabled(true);
        this.isIncludeChild = this.chkIncludeChild.isSelected();
        DefaultKingdeeTreeNode root = SubSystemUtils.getKDTreeNode((IBriefViewTreeNode)SubSystemUtils.getRemoveEmptyPackageNode((IBriefViewTreeNode)SubSystemUtils.getSubSystemByName((String)VIEWNAME, (BOSObjectType)MetaDataTypeList.BIZUNIT)));
        ((KingdeeTreeModel)this.tree.getModel()).setRoot((TreeNode)root);
        this.initBizUnitMap(root);
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int firstRow = e.getFirstRow();
                int lastRow = e.getLastRow();
                for (int i = firstRow; i <= lastRow; ++i) {
                    Object oldValue = BizConfigureListUI.this.tblMain.getRow(i).getCell("bizUnit").getValue();
                    if (oldValue == null) continue;
                    BizConfigureListUI.this.tblMain.getRow(i).getCell("bizUnit").setValue(BizConfigureListUI.this.bizUnitMap.get(oldValue));
                }
            }
        });
        this.tree.setSelectionRow(0);
        this.tblMain.getViewManager().setFreezeView(0, 3);
        this.tblMain.setColumnMoveable(true);
        this.initPopupmenu();
    }

    public FullOrgUnitInfo getCurrentOrgUnit() {
        if (this.prmtOrgUnit.getValue() != null) {
            return (FullOrgUnitInfo)this.prmtOrgUnit.getValue();
        }
        OrgUnitInfo orgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        return orgUnit.castToFullOrgUnitInfo();
    }

    protected void tree_valueChanged(TreeSelectionEvent e) throws Exception {
        super.tree_valueChanged(e);
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() != null && treeNode.getUserObject() instanceof MetaDataBriefInfo) {
            String bizUnitPK = "";
            MetaDataBriefInfo mdInfo = (MetaDataBriefInfo)treeNode.getUserObject();
            FilterInfo filter = this.getDefaultFilterForQuery();
            this.mainQuery.setFilter(filter);
            this.refreshList();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() != null && treeNode.getUserObject() instanceof MetaDataBriefInfo) {
            MetaDataBriefInfo mdInfo = (MetaDataBriefInfo)treeNode.getUserObject();
            if (mdInfo.isPackage()) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5355\u5143");
                SysUtil.abort();
            } else {
                BizUnitInfo bizUnit = BizConfigureHelper.loadBizUnit(mdInfo.getMetaDataPK());
                if (bizUnit != null) {
                    String orgType;
                    String editUIPK = bizUnit.getString("editUIPK");
                    if (StringUtils.isEmpty((String)editUIPK)) {
                        MsgBox.showInfo((Component)((Object)this), (String)"\u6b64\u4e1a\u52a1\u5355\u5143\u6ca1\u6709\u5173\u8054\u754c\u9762ui\uff0c\u4e0d\u80fd\u8fdb\u884c\u754c\u9762\u914d\u7f6e\uff01");
                        SysUtil.abort();
                    }
                    if (!StringUtils.isEmpty((String)(orgType = bizUnit.getExtendedProperty("OrgType"))) && !"NONE".equalsIgnoreCase(orgType)) {
                        OrgType orgTypeEnum = BizConfigureHelper.getOrgType(orgType);
                        FullOrgUnitInfo orgUnit = this.getCurrentOrgUnit();
                        if (orgTypeEnum != null && !OrgTypeUtils.isOrgType((OrgUnitInfo)orgUnit, orgTypeEnum)) {
                            MsgBox.showInfo((Component)((Object)this), (String)("\u5f53\u524d\u7ec4\u7ec7\u4e0d\u662f" + orgTypeEnum.getAlias() + "\uff0c\u65e0\u6cd5\u521b\u5efa" + bizUnit.getAlias() + "\u7684\u4e1a\u52a1\u914d\u7f6e\u65b9\u6848\uff01"));
                            SysUtil.abort();
                        }
                    }
                }
            }
        }
        super.actionAddNew_actionPerformed(e);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        MetaDataBriefInfo mdInfo;
        DefaultKingdeeTreeNode treeNode;
        super.prepareUIContext(uiContext, e);
        ItemAction action = this.getActionFromActionEvent(e);
        if (action.equals(this.actionAddNew) && (treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent()) != null && treeNode.getUserObject() != null && treeNode.getUserObject() instanceof MetaDataBriefInfo && !(mdInfo = (MetaDataBriefInfo)treeNode.getUserObject()).isPackage()) {
            uiContext.put((Object)"bizUnitPK", (Object)mdInfo.getFullName());
        }
        ArrayList<Object> nameList = new ArrayList<Object>();
        HashMap<Object, Object> usedMap = new HashMap<Object, Object>();
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object used;
            Object name = this.tblMain.getCell(i, "name").getValue();
            if (name != null && name instanceof String) {
                nameList.add(name);
            }
            if (!((used = this.tblMain.getCell(i, "used").getValue()) instanceof Boolean)) {
                usedMap.put(name, new Boolean(false));
                continue;
            }
            usedMap.put(name, used);
        }
        uiContext.put((Object)"NAMELIST", nameList);
        uiContext.put((Object)"used", usedMap);
        if (this.prmtOrgUnit.getValue() != null) {
            uiContext.put((Object)"currentOrgUnit", this.prmtOrgUnit.getValue());
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        String orgUnitID = this.getCurrentOrgUnit().getId().toString();
        if (!StringUtils.isEmpty((String)orgUnitID)) {
            FilterInfo orgFilter = new FilterInfo();
            orgFilter.getFilterItems().add(new FilterItemInfo("orgType", null, CompareType.EQUALS));
            orgFilter.getFilterItems().add(new FilterItemInfo("OrgUict.orgID", (Object)orgUnitID, CompareType.EQUALS));
            orgFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitID, CompareType.EQUALS));
            orgFilter.getFilterItems().add(new FilterItemInfo("OrgUict.id", null, CompareType.EQUALS));
            orgFilter.setMaskString("#0 or #1 or (#2 and #3)");
            DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
            if (treeNode != null) {
                MetaDataBriefInfo mdInfo = (MetaDataBriefInfo)treeNode.getUserObject();
                String bizUnitPK = "";
                if (this.isIncludeChild && mdInfo.isPackage()) {
                    filter.getFilterItems().add(new FilterItemInfo("bizUnitPK", (Object)(mdInfo.getPackgeName() + ".%"), CompareType.LIKE));
                } else {
                    if (!mdInfo.isPackage()) {
                        bizUnitPK = mdInfo.getFullName();
                    }
                    filter.getFilterItems().add(new FilterItemInfo("bizUnitPK", (Object)bizUnitPK));
                }
                try {
                    filter.mergeFilter(orgFilter, "AND");
                }
                catch (BOSException e) {
                    logger.debug((Object)"filter merge error!");
                }
            }
        }
        return filter;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list = super.getSelectedIdValues();
        if (list.size() > 0) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)list.get(0))));
            BizConfigureInfo ov = (BizConfigureInfo)this.getBizInterface().getValue((IObjectPK)pk);
            IOrgUict iou = OrgUictFactory.getRemoteInstance();
            iou.updateUse(this.getCurrentOrgUnit().getId().toString(), ov.getId().toString(), ov.getBizUnitPK(), false);
            this.refreshList();
            this.tblMain_tableSelectChanged(null);
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list = super.getSelectedIdValues();
        if (list.size() > 0) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)list.get(0))));
            BizConfigureInfo ov = (BizConfigureInfo)this.getBizInterface().getValue((IObjectPK)pk);
            IOrgUict iou = OrgUictFactory.getRemoteInstance();
            iou.updateUse(this.getCurrentOrgUnit().getId().toString(), ov.getId().toString(), ov.getBizUnitPK(), true);
            this.refreshList();
            this.tblMain_tableSelectChanged(null);
        }
    }

    protected void chkIncludeChild_itemStateChanged(ItemEvent e) throws Exception {
        this.isIncludeChild = this.chkIncludeChild.isSelected();
        if (this.tree.getRowCount() == 0) {
            return;
        }
        this.tree_valueChanged(null);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        ArrayList blockList = this.tblMain.getSelectManager().getBlocks();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0 && rowIndex < this.tblMain.getRowCount() && blockList != null && blockList.size() > 0) {
            boolean isUsed = (Boolean)this.tblMain.getRow(rowIndex).getCell("used").getValue();
            if (isUsed) {
                this.actionCancel.setEnabled(true);
                this.actionCancelCancel.setEnabled(false);
                this.actionRemove.setEnabled(false);
                this.actionEdit.setEnabled(false);
            } else {
                this.actionCancel.setEnabled(false);
                this.actionCancelCancel.setEnabled(true);
                this.actionRemove.setEnabled(true);
                this.actionEdit.setEnabled(true);
            }
            boolean isDefault = (Boolean)this.tblMain.getRow(rowIndex).getCell("defaultCfg").getValue();
            if (isDefault) {
                this.btnDefaultCfg.setEnabled(false);
                this.btnDefaultCfgStop.setEnabled(true);
            } else {
                this.btnDefaultCfg.setEnabled(true);
                this.btnDefaultCfgStop.setEnabled(false);
            }
        } else {
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.btnDefaultCfg.setEnabled(false);
            this.btnDefaultCfgStop.setEnabled(false);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAssignOrg.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.btnAssignUser.setIcon(EASResource.getIcon((String)"imgTbtn_distributeuser"));
        this.btnDefaultCfg.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.btnDefaultCfgStop.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnPermission.setIcon(EASResource.getIcon((String)"imgTbtn_popedomsetting"));
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
    }

    public void actionAssignOrg_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanEdit();
        super.actionAssignOrg_actionPerformed(e);
        ArrayList list = super.getSelectedIdValues();
        if (list.size() > 0) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)list.get(0))));
            BizConfigureInfo ov = (BizConfigureInfo)this.getBizInterface().getValue((IObjectPK)pk);
            if (ov != null) {
                if (StringUtils.isEmpty((String)ov.getOrgType()) || "NONE".equalsIgnoreCase(ov.getOrgType()) || BizConfigureHelper.getOrgType(ov.getOrgType()) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)"\u8be5\u4e1a\u52a1\u5355\u5143\u6ca1\u6709\u5b9a\u4e49\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u7c7b\u578b\uff0c\u4e0d\u9700\u8981\u7ec4\u7ec7\u5206\u914d\uff01");
                    SysUtil.abort();
                }
                IOrgUict iou = OrgUictFactory.getRemoteInstance();
                OrgType orgType = BizConfigureHelper.getOrgType(ov.getOrgType());
                OrgViewF7 orgF7 = new OrgViewF7((IUIObject)this);
                orgF7.setOrgTypes(new OrgType[]{orgType});
                orgF7.setMultiSelect(true);
                orgF7.setNonSelect(true);
                List assOrgList = iou.getAssignOrgId(pk.toString());
                List newAssOrgList = this.assignOrgUnit(assOrgList, orgF7);
                if (newAssOrgList != null) {
                    String cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
                    iou.addBatch(newAssOrgList, pk.toString(), ov.getBizUnitPK(), cuId, true, false);
                }
            }
        }
    }

    public void actionAssignUser_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanEdit();
        super.actionAssignOrg_actionPerformed(e);
        ArrayList list = super.getSelectedIdValues();
        if (list.size() > 0) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)list.get(0))));
            BizConfigureInfo ov = (BizConfigureInfo)this.getBizInterface().getValue((IObjectPK)pk);
            if (ov != null) {
                UIContext uiContext = new UIContext((Object)this);
                try {
                    BizUnitInfo bizUnit = BizConfigureHelper.loadBizUnit((IMetaDataPK)new MetaDataPK(ov.getBizUnitPK()));
                    ConfigureParam cp = new ConfigureParam(bizUnit, ov.getId().toString(), ov.getName());
                    uiContext.put("BizConfigureInfo", cp);
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(UictAccreditUI.class.getName(), (Map)uiContext);
                    uiWindow.show();
                }
                catch (UIException e1) {
                    logger.error((Object)e1);
                }
            }
        }
    }

    protected void btnDefaultCfg_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list = super.getSelectedIdValues();
        if (list.size() > 0) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)list.get(0))));
            BizConfigureInfo ov = (BizConfigureInfo)this.getBizInterface().getValue((IObjectPK)pk);
            IOrgUict iou = OrgUictFactory.getRemoteInstance();
            iou.updateDefaultCfg(this.getCurrentOrgUnit().getId().toString(), ov.getId().toString(), ov.getBizUnitPK(), true);
            this.refreshList();
        }
    }

    protected void btnDefaultCfgStop_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list = super.getSelectedIdValues();
        if (list.size() > 0) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)list.get(0))));
            BizConfigureInfo ov = (BizConfigureInfo)this.getBizInterface().getValue((IObjectPK)pk);
            IOrgUict iou = OrgUictFactory.getRemoteInstance();
            iou.updateDefaultCfg(this.getCurrentOrgUnit().getId().toString(), ov.getId().toString(), ov.getBizUnitPK(), false);
            this.refreshList();
        }
    }

    public List assignOrgUnit(List assignedOrgs, OrgViewF7 orgF7) throws EASBizException, BOSException {
        HashSet orgSet = new HashSet();
        if (assignedOrgs != null && orgF7 != null) {
            int n = assignedOrgs.size();
            for (int i = 0; i < n; ++i) {
                orgSet.add(assignedOrgs.get(i));
            }
        }
        orgF7.setCheckedOrgIDs(orgSet);
        orgF7.show();
        if (!orgF7.isCanceled()) {
            ArrayList<String> newAss = new ArrayList<String>();
            OrgUnitInfo[] orgUnits = (OrgUnitInfo[])orgF7.getData();
            String currentOrgID = this.getCurrentOrgUnit().getId().toString();
            if (orgUnits != null) {
                int n = orgUnits.length;
                for (int i = 0; i < n; ++i) {
                    newAss.add(orgUnits[i].getId().toString());
                }
            }
            if (!newAss.contains(currentOrgID)) {
                newAss.add(currentOrgID);
            }
            return newAss;
        }
        return null;
    }

    protected void btnPermission_actionPerformed(ActionEvent e) throws Exception {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        IObjectCollection col = loader.getConfigureCollection(MetaDataTypeList.PERMISSION);
        PermissionInfo permission = null;
        if (col != null) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                PermissionInfo p;
                String fullName;
                IObjectValue obj = col.getObject(i);
                if (!(obj instanceof PermissionInfo) || !"base_bos".equals(fullName = (p = (PermissionInfo)obj).getFullName())) continue;
                permission = p;
                break;
            }
        }
        if (permission == null) {
            permission = new PermissionInfo();
            permission.setPackage("");
            permission.setName("base_bos");
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        try {
            uiContext.put("permission_info", permission);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(DefaultPermissionEditorUI.class.getName(), (Map)uiContext);
            uiWindow.show();
        }
        catch (UIException e1) {
            logger.error((Object)e1);
        }
    }

    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        FilterInfo filter = this.getDefaultFilterForQuery();
        this.mainQuery.setFilter(filter);
        this.refreshList();
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSet(e);
        if (this.mainQuery != null) {
            IRowSet rowSet = e.getRowSet();
            try {
                rowSet.beforeFirst();
                int columIndex = rowSet.findColumn("orgTypeAlias");
                while (rowSet.next()) {
                    String orgType = rowSet.getString("orgType");
                    if (!StringUtils.isEmpty((String)orgType)) {
                        orgType = orgType.toUpperCase();
                    }
                    String orgTypeAlias = orgTypeAliasMap.containsKey(orgType) ? (String)orgTypeAliasMap.get(orgType) : "\u65e0";
                    rowSet.updateString(columIndex, orgTypeAlias);
                }
                rowSet.beforeFirst();
            }
            catch (Exception ee) {
                logger.debug((Object)ee);
            }
        }
    }

    protected String getEditUIModal() {
        return UIFactoryName.NEWWIN;
    }

    protected void refresh(ActionEvent e) throws Exception {
        CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
        this.execQuery();
    }

    protected void btnImport_actionPerformed(ActionEvent e) throws Exception {
        String currentImportDir = System.getProperty("user.home");
        KDFileChooser choose = new KDFileChooser(currentImportDir);
        SimpleFileFilter ff = new SimpleFileFilter(new String[]{"zip"});
        choose.setMultiSelectionEnabled(false);
        choose.setFileFilter((FileFilter)ff);
        choose.setAcceptAllFileFilterUsed(false);
        int rVal = choose.showOpenDialog((Component)((Object)this));
        if (rVal == 0) {
            File file = choose.getSelectedFile();
            if (!file.exists()) {
                MsgBox.showError((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
                return;
            }
            UictImportRun work = new UictImportRun();
            work.setFile(file);
            work.setOwner(this);
            UIContext uiContext = new UIContext((Object)this);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(UictProgressDlgUI.class.getName(), (Map)uiContext);
            UictProgressDlgUI progressUI = (UictProgressDlgUI)uiWindow.getUIObject();
            work.setProgressDlgUI(progressUI);
            progressUI.setAction(work);
            uiWindow.show();
            if (progressUI.getResult()) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u5bfc\u5165\u5b8c\u6210\uff01");
                this.refreshList();
            }
        }
    }

    protected void btnExport_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        String[] cfgids = new String[rowIndex.length];
        if (rowIndex.length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u81f3\u5c11\u9700\u8981\u9009\u62e9\u4e00\u4e2a\u5bfc\u51fa\u65b9\u6848\uff01");
            SysUtil.abort();
        } else {
            for (int i = 0; i < rowIndex.length; ++i) {
                String id;
                cfgids[i] = id = (String)this.tblMain.getCell(rowIndex[i], "id").getValue();
            }
        }
        String currentImportDir = System.getProperty("user.home");
        KDFileChooser choose = new KDFileChooser(currentImportDir);
        choose.setFileSelectionMode(1);
        choose.setMultiSelectionEnabled(false);
        int rVal = choose.showOpenDialog((Component)((Object)this));
        if (rVal == 0) {
            File file = choose.getSelectedFile();
            if (!file.exists()) {
                MsgBox.showError((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
                return;
            }
            UictExportRun work = new UictExportRun();
            work.setFile(file);
            work.setCfgIDs(cfgids);
            work.setOwner(this);
            UIContext uiContext = new UIContext((Object)this);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(UictProgressDlgUI.class.getName(), (Map)uiContext);
            UictProgressDlgUI progressUI = (UictProgressDlgUI)uiWindow.getUIObject();
            work.setProgressDlgUI(progressUI);
            progressUI.setAction(work);
            uiWindow.show();
            if (progressUI.getResult()) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u5bfc\u51fa\u5b8c\u6210\uff01");
            }
        }
    }

    protected void btnStartAll_actionPerformed(ActionEvent e) throws Exception {
        IOrgUict iou = OrgUictFactory.getRemoteInstance();
        iou.startAll(null);
        this.refreshList();
        this.tblMain_tableSelectChanged(null);
    }

    protected void btnCancelAll_actionPerformed(ActionEvent e) throws Exception {
        IOrgUict iou = OrgUictFactory.getRemoteInstance();
        iou.cancelAll(null);
        this.refreshList();
        this.tblMain_tableSelectChanged(null);
    }

    protected void updateToCustomSchem_actionPerformed(ActionEvent e) throws Exception {
    }

    static {
        orgTypeAliasMap.put(OrgType.Admin.getName().toUpperCase(), OrgType.Admin.getAlias());
        orgTypeAliasMap.put(OrgType.Company.getName().toUpperCase(), OrgType.Company.getAlias());
        orgTypeAliasMap.put(OrgType.ControlUnit.getName().toUpperCase(), OrgType.ControlUnit.getAlias());
        orgTypeAliasMap.put(OrgType.CostCenter.getName().toUpperCase(), OrgType.CostCenter.getAlias());
        orgTypeAliasMap.put(OrgType.HRO.getName().toUpperCase(), OrgType.HRO.getAlias());
        orgTypeAliasMap.put(OrgType.NONE.getName().toUpperCase(), OrgType.NONE.getAlias());
        orgTypeAliasMap.put(OrgType.ProfitCenter.getName().toUpperCase(), OrgType.ProfitCenter.getAlias());
        orgTypeAliasMap.put(OrgType.Purchase.getName().toUpperCase(), OrgType.Purchase.getAlias());
        orgTypeAliasMap.put(OrgType.Quality.getName().toUpperCase(), OrgType.Quality.getAlias());
        orgTypeAliasMap.put(OrgType.Sale.getName().toUpperCase(), OrgType.Sale.getAlias());
        orgTypeAliasMap.put(OrgType.Storage.getName().toUpperCase(), OrgType.Storage.getAlias());
        orgTypeAliasMap.put(OrgType.Transport.getName().toUpperCase(), OrgType.Transport.getAlias());
        orgTypeAliasMap.put(OrgType.UnionDebt.getName().toUpperCase(), OrgType.UnionDebt.getAlias());
        orgViewTypes = new OrgViewType[]{OrgViewType.ADMIN, OrgViewType.COMPANY, OrgViewType.SALE, OrgViewType.PURCHASE, OrgViewType.STORAGE, OrgViewType.COSTCENTER, OrgViewType.PROFITCENTER, OrgViewType.HRO, OrgViewType.TRANSPORT, OrgViewType.QUALITY};
    }
}

