/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.service.permission.metadata.BizPropertyInfo;
import com.kingdee.bos.service.permission.metadata.BizRefInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uict.client.AbstractBizRefDialogUI;
import com.kingdee.eas.base.uict.client.SelectBizUI;
import com.kingdee.eas.base.uict.client.permission.EntityTreeCreator;
import com.kingdee.eas.base.uict.client.permission.FacadeTreeCreator;
import com.kingdee.eas.base.uict.client.permission.PermissionDefineHelper;
import com.kingdee.eas.base.uict.client.permission.UITreeCreator;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BizRefDialogUI
extends AbstractBizRefDialogUI {
    private static final Logger logger = CoreUIObject.getLogger((Class)BizRefDialogUI.class);
    private String EXIT_STATUS = null;
    public static final String CONFIRM_EXIT = "confirm";
    public static final String CANCEL_EXIT = "cancel";
    private BizRefInfo bizRefInfo = new BizRefInfo();
    private MetaDataInfo bizMetaDataInfo = new MetaDataInfo();
    private IObjectValue model;

    public BizRefDialogUI() throws Exception {
        this.tree.setShowCheckBox(true);
        this.tree.setSyncChecked(true);
        this.tree.setRootVisible(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"root");
        this.tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void btnRef_actionPerformed(ActionEvent e) throws Exception {
        String type = "";
        if (this.btnEntity.isSelected()) {
            type = "bizentity";
        } else {
            if (this.btnFacade.isSelected()) {
                type = "bizfacade";
                return;
            }
            if (this.btnUI.isSelected()) {
                type = "bizui";
            } else if (this.btnQuery.isSelected()) {
                type = "bizquery";
            }
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("selectBizType", type);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(SelectBizUI.class.getName(), (Map)uiContext);
        SelectBizUI sbUI = (SelectBizUI)uiWindow.getUIObject();
        uiWindow.show();
        if (CONFIRM_EXIT.equals(sbUI.getExitStatus())) {
            Object obj = sbUI.getReturnValue();
            if (obj == null || !(obj instanceof AbstractMetaDataValue)) {
                return;
            }
            AbstractMetaDataValue value = (AbstractMetaDataValue)obj;
            this.model = value;
            this.txtRef.setText(value.getFullName());
            if (value instanceof EntityObjectInfo) {
                EntityTreeCreator btc = new EntityTreeCreator();
                this.tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)btc.create((EntityObjectInfo)value)));
            } else if (value instanceof FacadeInfo) {
                FacadeTreeCreator ftc = new FacadeTreeCreator();
                this.tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)ftc.create((FacadeInfo)value)));
            } else if (value instanceof UIObjectInfo) {
                UITreeCreator utc = new UITreeCreator();
                this.tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)utc.create((UIObjectInfo)value)));
            } else if (value instanceof QueryInfo) {
                this.tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)new DefaultKingdeeTreeNode((Object)"root")));
            }
        }
    }

    public BizRefInfo getBizRefInfo() {
        return this.bizRefInfo;
    }

    public MetaDataInfo getBizMetaDataInfo() {
        return this.bizMetaDataInfo;
    }

    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.model != null) {
            this.bizMetaDataInfo.setPackage(((AbstractMetaDataValue)this.model).getPackage());
            this.bizMetaDataInfo.setName(((AbstractMetaDataValue)this.model).getName());
            if (MetaDataTypeList.JOINQUERY.equals((Object)this.model.getBOSType())) {
                this.bizMetaDataInfo.setMetaDataType(MetaDataTypeList.BASEQUERY.toString());
            } else {
                this.bizMetaDataInfo.setMetaDataType(this.model.getBOSType().toString());
            }
            ArrayList nodes = new ArrayList();
            PermissionDefineHelper.getCheckedNode((DefaultKingdeeTreeNode)this.tree.getModel().getRoot(), nodes);
            int size = nodes.size();
            for (int i = 0; i < size; ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)nodes.get(i);
                String p = "";
                if (node.getUserObject() instanceof MethodInfo) {
                    p = ((MethodInfo)node.getUserObject()).getString("innerID");
                } else if (node.getUserObject() instanceof ActionInfo) {
                    p = ((ActionInfo)node.getUserObject()).getClassName();
                }
                if (p == null) {
                    p = "";
                }
                BizPropertyInfo prop = new BizPropertyInfo();
                prop.setUserDefined(true);
                prop.setProperty(p);
                this.getBizRefInfo().getBizPropertys().add(prop);
            }
            this.getBizRefInfo().setBizMetadataInfo(this.bizMetaDataInfo);
        }
        this.EXIT_STATUS = CONFIRM_EXIT;
        this.destroyWindow();
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.EXIT_STATUS = CANCEL_EXIT;
        this.destroyWindow();
    }

    public String getExitStatus() {
        return this.EXIT_STATUS;
    }
}

