/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uict.BizConfigureItemCollection;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import com.kingdee.eas.base.uict.IBizConfigure;
import com.kingdee.eas.base.uict.client.BizConfigureEditUI;
import com.kingdee.eas.base.uict.client.BizConfigureTreeNode;
import com.kingdee.eas.base.uict.client.ExtendedPropertyUI;
import com.kingdee.eas.base.uict.client.ItemUI;
import com.kingdee.eas.base.uict.client.MetadataRefDetailUI;
import com.kingdee.eas.base.uict.client.ReItemUI;
import com.kingdee.eas.base.uict.client.designer.DefaultTableCalculator;
import com.kingdee.eas.base.uict.client.designer.Table;
import com.kingdee.eas.base.uict.client.designer.TableCell;
import com.kingdee.eas.base.uict.client.designer.TableRow;
import com.kingdee.eas.base.uict.client.util.BizConfigureHelper;
import com.kingdee.eas.base.uict.client.util.UictEditUIProxy;
import com.kingdee.eas.base.uict.client.util.UictEntityProxy;
import com.kingdee.eas.base.uict.client.util.UictListUIProxy;
import com.kingdee.eas.base.uict.client.util.UictQueryProxy;
import com.kingdee.eas.base.uict.client.util.UictRuleSetProxy;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class ItemUIManager {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.uict.client.ItemUICreator");
    private BizConfigureEditUI editUI;
    private BizConfigureHelper bizConfigureHelper;
    private UictEditUIProxy uictEditUIProxy;
    private UictEntityProxy uictEntityProxy;
    private UictQueryProxy uictQueryProxy;
    private UictListUIProxy uictListUIProxy;

    public ItemUIManager(BizConfigureHelper bizConfigureHelper, BizConfigureEditUI editUI) throws Exception {
        if (bizConfigureHelper == null || bizConfigureHelper.getBizUnit() == null || bizConfigureHelper.getBizUnit().getEntity() == null || bizConfigureHelper.getUIModel() == null) {
            throw new Exception("bizConfigureHelper\u3001bizunit\u3001entity\u6216uiModel\u4e3a\u7a7a");
        }
        this.bizConfigureHelper = bizConfigureHelper;
        this.editUI = editUI;
    }

    public void view(BizConfigureItemInfo item) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this.editUI);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(ItemUI.class.getName(), (Map)uiContext);
        IUIObject uiObject = uiWindow.getUIObject();
        uiObject.setOprtState("VIEW");
        uiObject.setDataObject((IObjectValue)item);
        uiObject.loadFields();
        uiWindow.show();
    }

    public void view(BizConfigureItemInfo item, BizConfigureTreeNode node) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this.editUI);
        uiContext.put("isEntry", BizConfigureHelper.isEntry(node));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(ItemUI.class.getName(), (Map)uiContext);
        IUIObject uiObject = uiWindow.getUIObject();
        uiObject.setOprtState("VIEW");
        uiObject.setDataObject((IObjectValue)item);
        uiObject.loadFields();
        uiWindow.show();
    }

    public boolean edit(BizConfigureItemInfo item, BizConfigureTreeNode node) throws Exception {
        if (node == null) {
            return false;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this.editUI);
        uiContext.put("isEntry", BizConfigureHelper.isEntry(node));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(ItemUI.class.getName(), (Map)uiContext);
        IUIObject uiObject = uiWindow.getUIObject();
        ItemUI itemUI = (ItemUI)uiObject;
        if (this.bizConfigureHelper.getBizUnit() != null && this.bizConfigureHelper.getBizUnit().getEntity() != null) {
            itemUI.setCurrentEntity(this.bizConfigureHelper.getBizUnit().getEntity());
        }
        uiObject.setOprtState("EDIT");
        uiObject.setDataObject((IObjectValue)item);
        uiObject.loadFields();
        uiWindow.show();
        boolean ret = false;
        if ("confirm".equals(itemUI.getExitStatus())) {
            ComponentInfo component;
            this.getUictEntityProxy().updateProperty(item);
            if (node.getUserObject() instanceof ComponentInfo && "com.kingdee.bos.ctrl.kdf.table.KDTable".equals((component = (ComponentInfo)node.getUserObject()).getClassType())) {
                this.getUictEditUIProxy().updateEntryComponent(item, node);
                this.getUictListUIProxy().updateKDTableProperty(item);
                this.getUictQueryProxy().updateQueryField(item);
                return true;
            }
            this.getUictEditUIProxy().updateComponent(item);
            this.getUictListUIProxy().updateKDTableProperty(item);
            this.getUictQueryProxy().updateQueryField(item);
            ret = true;
        }
        return ret;
    }

    public boolean addNew(BizConfigureTreeNode node) throws Exception {
        if (node == null) {
            logger.warn((Object)"node\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u5b57\u6bb5\u65b0\u589e\u64cd\u4f5c!");
            return false;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this.editUI);
        uiContext.put("isEntry", BizConfigureHelper.isEntry(node));
        uiContext.put("BizConfigureTreeNode", node);
        uiContext.put("BizUnitInfo", this.bizConfigureHelper.getBizUnit());
        BizConfigureItemInfo item = new BizConfigureItemInfo();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(ItemUI.class.getName(), (Map)uiContext);
        IUIObject uiObject = uiWindow.getUIObject();
        uiObject.setOprtState("ADDNEW");
        uiObject.setDataObject((IObjectValue)item);
        uiWindow.show();
        boolean ret = false;
        if ("confirm".equals(((ItemUI)uiObject).getExitStatus())) {
            ComponentInfo component;
            if (node.getUserObject() instanceof ComponentInfo && "com.kingdee.bos.ctrl.kdf.table.KDTable".equals((component = (ComponentInfo)node.getUserObject()).getClassType())) {
                PropertyInfo pInfo = this.getUictEntityProxy().createProperty(item, node);
                item.setProperty(pInfo);
                this.getUictEditUIProxy().createEntryComponent(item, node, pInfo);
                BizConfigureItemCollection items = node.getConfigureItems();
                items.add(item);
                ((BizConfigureTreeNode)((Object)node.getRoot())).setUseUILayout(true);
                EntityObjectInfo subEntity = BizConfigureHelper.getSubEntityByComponentInfo(this.bizConfigureHelper.getBizUnit(), component);
                if (subEntity != null) {
                    subEntity.getProperties().add(pInfo);
                    boolean isExistSubEntity = this.existSubEntity(subEntity.getName(), this.bizConfigureHelper.getBizUnit().getQuery());
                    if (isExistSubEntity) {
                        this.getUictQueryProxy().createEntryQueryField(item, node);
                        this.getUictListUIProxy().createKDTableProperty(item);
                    }
                    return true;
                }
                return false;
            }
            Table table = node.getTable();
            if (table == null) {
                logger.info((Object)"\u5f53\u524d\u8282\u70b9\u6ca1\u6709\u5e03\u5c40\u8868\u683c\u5bf9\u8c61\uff0c\u65e0\u6cd5\u6dfb\u52a0\u5b57\u6bb5\uff0c\u8bf7\u9009\u62e9\u5176\u5b83\u8282\u70b9...");
                return false;
            }
            TableRow row = table.getRow(table.getRowCount() - 1);
            int columnNum = table.getColumnCount();
            boolean newRow = true;
            int insertColumnIndex = 0;
            for (int i = 0; i < columnNum; ++i) {
                if (row.getCell(i).getData() != null || row.getCell(i).isMerged()) continue;
                newRow = false;
                insertColumnIndex = i;
                break;
            }
            if (newRow) {
                int newTop = row.getTop() + row.getHeight() + DefaultTableCalculator.VSPACE;
                row = table.addRow();
                row.setTop(newTop);
                row.setHeight(DefaultTableCalculator.VLARGESPACE);
            }
            TableCell cell = row.getCell(insertColumnIndex);
            int x = table.getColumn(insertColumnIndex).getLeft();
            int y = row.getTop();
            int height = row.getHeight();
            int width = 270;
            item.setBounds(new Rectangle(x, y, width, height));
            item.setWidth(1);
            item.setHeight(1);
            cell.setData(item);
            PropertyInfo pInfo = this.getUictEntityProxy().createProperty(item, node);
            ComponentInfo cInfo = this.getUictEditUIProxy().createComponent(item, node, pInfo);
            item.setProperty(pInfo);
            cInfo.setConstraint((Object)item.getBounds());
            item.setComponent(cInfo);
            BizConfigureItemCollection items = node.getConfigureItems();
            items.add(item);
            ((BizConfigureTreeNode)((Object)node.getRoot())).getConfigureItems().add(item);
            BizConfigureItemCollection list = node.getList();
            list.add(item);
            ((BizConfigureTreeNode)((Object)node.getRoot())).setUseUILayout(true);
            EntityObjectInfo entity = this.bizConfigureHelper.getBizUnit().getEntity();
            entity.getProperties().add(pInfo);
            this.getUictQueryProxy().createQueryField(item);
            this.getUictListUIProxy().createKDTableProperty(item);
            UIObjectInfo uiObj = this.bizConfigureHelper.getUIModel();
            uiObj.getComponents().add(cInfo);
            BizFieldInfo field = new BizFieldInfo();
            field.setName(item.getName());
            field.setControlName(cInfo.getName());
            field.setBizDataType(ItemUIManager.getBizDataType(pInfo));
            this.bizConfigureHelper.getBizUnit().getFields().add(field);
            ret = true;
        }
        return ret;
    }

    public boolean delete(BizConfigureItemInfo item, BizConfigureTreeNode node, IBizConfigure controller, String cfgID) throws Exception {
        if (item == null || node == null || controller == null) {
            logger.warn((Object)"item, node, controller\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u5b57\u6bb5\u5220\u9664\u64cd\u4f5c!");
            return false;
        }
        boolean isTable = BizConfigureHelper.isEntry(node);
        EntityObjectInfo entity = this.bizConfigureHelper.getBizUnit().getEntity();
        if (isTable) {
            entity = BizConfigureHelper.getSubEntityByComponentInfo(this.bizConfigureHelper.getBizUnit(), (ComponentInfo)node.getUserObject());
        }
        if (entity != null) {
            boolean isRef = controller.isOtherRef(entity.getFullName(), item.getProperty().getName(), cfgID);
            if (isRef) {
                MsgBox.showInfo((String)"\u5b58\u5728\u5176\u4ed6\u65b9\u6848\u5bf9\u8be5\u5b57\u6bb5\u7684\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5f7b\u5e95\u5220\u9664\u7684\u64cd\u4f5c\uff01");
                return false;
            }
        } else {
            return false;
        }
        if (!isTable) {
            this.deleteItemInAllList(item, (BizConfigureTreeNode)((Object)node.getRoot()));
        } else {
            node.getConfigureItems().remove(item);
        }
        logger.info((Object)("\u5220\u9664item:" + item.getName() + "..."));
        this.getUictQueryProxy().deleteQueryField(item);
        String itemPropName = item.getProperty().getName();
        if (StringUtils.isEmpty((String)itemPropName)) {
            return false;
        }
        int n = entity.getProperties().size();
        for (int i = 0; i < n; ++i) {
            String entityPropName = entity.getProperties().get(i).getName();
            if (StringUtils.isEmpty((String)entityPropName) || !entityPropName.equalsIgnoreCase(itemPropName)) continue;
            logger.info((Object)("\u5220\u9664\u5b9e\u4f53\u5c5e\u6027:" + entityPropName + "..."));
            entity.getProperties().remove(entity.getProperties().get(i));
            break;
        }
        if (isTable) {
            ComponentInfo cInfo = (ComponentInfo)node.getUserObject();
            this.getUictEditUIProxy().delKDTableColumn(cInfo, item);
            this.getUictListUIProxy().delKDTableColumn(item);
        } else {
            UIObjectInfo uiObj = this.bizConfigureHelper.getUIModel();
            uiObj.getComponents().remove(item.getComponent());
            this.getUictListUIProxy().delKDTableColumn(item);
        }
        UictRuleSetProxy.deleteRule(item, node);
        DataTableInfo table = entity.getTable();
        String tableName = null;
        String columnName = null;
        String columnName2 = null;
        if (table != null && item.getProperty() != null) {
            PropertyInfo propertyInfo = item.getProperty();
            if (propertyInfo.getMappingField() != null) {
                tableName = table.getName();
            } else if (propertyInfo.getExtendedField() != null) {
                tableName = propertyInfo.getExtendedField().getExtendedTable().getName();
            }
            columnName = "F" + StringUtils.headCharUpperCase((String)item.getProperty().getName());
            columnName2 = "CF" + StringUtils.headCharUpperCase((String)item.getProperty().getName());
            ArrayList<String> nameList = new ArrayList<String>(3);
            nameList.add(columnName);
            nameList.add(columnName2);
            logger.info((Object)("\u5220\u9664\u6570\u636e\u5e93:" + columnName + "\u5217\u7684\u6570\u636e..."));
            controller.deleteData(tableName, nameList);
        }
        return true;
    }

    public boolean deleteComponent(BizConfigureItemInfo item, BizConfigureTreeNode node) throws Exception {
        if (item == null || node == null) {
            logger.warn((Object)"item, node, controller\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u5b57\u6bb5\u5220\u9664\u64cd\u4f5c!");
            return false;
        }
        boolean isTable = false;
        if (!BizConfigureHelper.isEntry(node)) {
            this.deleteItemInAllList(item, (BizConfigureTreeNode)((Object)node.getRoot()));
        } else {
            node.getConfigureItems().remove(item);
            isTable = true;
        }
        logger.info((Object)("\u5220\u9664item:" + item.getName() + "..."));
        if (isTable) {
            ComponentInfo cInfo = (ComponentInfo)node.getUserObject();
            this.getUictEditUIProxy().delKDTableColumn(cInfo, item);
            this.getUictListUIProxy().delKDTableColumn(item);
        } else {
            UIObjectInfo uiObj = this.bizConfigureHelper.getUIModel();
            uiObj.getComponents().remove(item.getComponent());
            this.getUictListUIProxy().delKDTableColumn(item);
        }
        UictRuleSetProxy.deleteRule(item, node);
        return true;
    }

    private void deleteItemInAllList(BizConfigureItemInfo item, BizConfigureTreeNode node) {
        node.getConfigureItems().remove(item);
        if (node.getList() != null) {
            node.getList().remove(item);
        }
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.deleteItemInAllList(item, (BizConfigureTreeNode)((Object)node.getChildAt(i)));
        }
    }

    public boolean reItem(BizConfigureTreeNode node) throws Exception {
        if (node == null) {
            logger.warn((Object)"node\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u5b57\u6bb5\u65b0\u589e\u64cd\u4f5c!");
            return false;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this.editUI);
        uiContext.put("isEntry", BizConfigureHelper.isEntry(node));
        uiContext.put("BizConfigureTreeNode", node);
        uiContext.put("BizUnitInfo", this.bizConfigureHelper.getBizUnit());
        BizConfigureItemInfo item = new BizConfigureItemInfo();
        item.setConfiguredField(true);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(ReItemUI.class.getName(), (Map)uiContext);
        IUIObject uiObject = uiWindow.getUIObject();
        uiObject.setOprtState("EDIT");
        uiObject.setDataObject((IObjectValue)item);
        uiWindow.show();
        boolean ret = false;
        if ("confirm".equals(((ReItemUI)uiObject).getExitStatus())) {
            ComponentInfo component;
            if (node.getUserObject() instanceof ComponentInfo && "com.kingdee.bos.ctrl.kdf.table.KDTable".equals((component = (ComponentInfo)node.getUserObject()).getClassType())) {
                PropertyInfo pInfo = item.getProperty();
                this.getUictEditUIProxy().createEntryComponent(item, node, pInfo);
                BizConfigureItemCollection items = node.getConfigureItems();
                items.add(item);
                ((BizConfigureTreeNode)((Object)node.getRoot())).setUseUILayout(true);
                EntityObjectInfo subEntity = BizConfigureHelper.getSubEntityByComponentInfo(this.bizConfigureHelper.getBizUnit(), component);
                if (subEntity != null) {
                    boolean isExistSubEntity = this.existSubEntity(subEntity.getName(), this.bizConfigureHelper.getBizUnit().getQuery());
                    if (isExistSubEntity) {
                        String entryName = BizConfigureHelper.getEntryNameByComponentInfo(component);
                        BizConfigureHelper.setEntryItemQueryFieldName(entryName, this.bizConfigureHelper.getBizUnit().getQuery(), item);
                        this.getUictListUIProxy().createKDTableProperty(item);
                    }
                    return true;
                }
                return false;
            }
            Table table = node.getTable();
            if (table == null) {
                logger.info((Object)"\u5f53\u524d\u8282\u70b9\u6ca1\u6709\u5e03\u5c40\u8868\u683c\u5bf9\u8c61\uff0c\u65e0\u6cd5\u6dfb\u52a0\u5b57\u6bb5\uff0c\u8bf7\u9009\u62e9\u5176\u5b83\u8282\u70b9...");
                return false;
            }
            TableRow row = table.getRow(table.getRowCount() - 1);
            int columnNum = table.getColumnCount();
            boolean newRow = true;
            int insertColumnIndex = 0;
            for (int i = 0; i < columnNum; ++i) {
                if (row.getCell(i).getData() != null || row.getCell(i).isMerged()) continue;
                newRow = false;
                insertColumnIndex = i;
                break;
            }
            if (newRow) {
                int newTop = row.getTop() + row.getHeight() + DefaultTableCalculator.VSPACE;
                row = table.addRow();
                row.setTop(newTop);
                row.setHeight(DefaultTableCalculator.VLARGESPACE);
            }
            TableCell cell = row.getCell(insertColumnIndex);
            int x = table.getColumn(insertColumnIndex).getLeft();
            int y = row.getTop();
            int height = row.getHeight();
            int width = 270;
            item.setBounds(new Rectangle(x, y, width, height));
            item.setWidth(1);
            item.setHeight(1);
            cell.setData(item);
            PropertyInfo pInfo = item.getProperty();
            ComponentInfo cInfo = this.getUictEditUIProxy().createComponent(item, node, pInfo);
            item.setProperty(pInfo);
            cInfo.setConstraint((Object)item.getBounds());
            item.setComponent(cInfo);
            BizConfigureItemCollection items = node.getConfigureItems();
            items.add(item);
            ((BizConfigureTreeNode)((Object)node.getRoot())).getConfigureItems().add(item);
            BizConfigureItemCollection list = node.getList();
            list.add(item);
            ((BizConfigureTreeNode)((Object)node.getRoot())).setUseUILayout(true);
            BizConfigureHelper.setHeadItemQueryFieldName(this.bizConfigureHelper.getBizUnit().getEntity(), this.bizConfigureHelper.getBizUnit().getQuery(), item);
            this.getUictListUIProxy().createKDTableProperty(item);
            UIObjectInfo uiObj = this.bizConfigureHelper.getUIModel();
            uiObj.getComponents().add(cInfo);
            BizFieldInfo field = new BizFieldInfo();
            field.setName(item.getName());
            field.setControlName(cInfo.getName());
            field.setBizDataType(ItemUIManager.getBizDataType(pInfo));
            this.bizConfigureHelper.getBizUnit().getFields().add(field);
            ret = true;
        }
        return ret;
    }

    public boolean setExtendedProperty(BizConfigureItemInfo item, BizConfigureTreeNode node) throws Exception {
        ComponentInfo component;
        if (item == null || node == null) {
            logger.warn((Object)"item \u6216 node\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u8bbe\u7f6e\u6269\u5c55\u5c5e\u6027\u64cd\u4f5c!");
            return false;
        }
        EntityObjectInfo entity = this.bizConfigureHelper.getBizUnit().getEntity();
        if (node.getUserObject() instanceof ComponentInfo && "com.kingdee.bos.ctrl.kdf.table.KDTable".equals((component = (ComponentInfo)node.getUserObject()).getClassType())) {
            entity = BizConfigureHelper.getSubEntityByComponentInfo(this.bizConfigureHelper.getBizUnit(), component);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this.editUI);
        uiContext.put("ENTITY_OBJECT_INFO", entity);
        uiContext.put("PROPERTY_INFO", item.getProperty());
        uiContext.put("queryInfo", this.bizConfigureHelper.getBizUnit().getQuery());
        uiContext.put("queryFieldName", item.getQueryFieldName());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(ExtendedPropertyUI.class.getName(), (Map)uiContext);
        IUIObject uiObject = uiWindow.getUIObject();
        uiWindow.show();
        boolean ret = false;
        if ("confirm".equals(((ExtendedPropertyUI)uiObject).getExitStatus())) {
            ret = true;
        }
        return ret;
    }

    public void showRef(BizConfigureItemInfo item, BizConfigureTreeNode node) throws Exception {
        if (item == null || node == null) {
            logger.warn((Object)"item \u6216 node\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u770b\u5f15\u7528!");
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this.editUI);
        uiContext.put("BizConfigureItemInfo", item);
        uiContext.put("BizConfigureTreeNode", node);
        uiContext.put("BizUnitInfo", this.bizConfigureHelper.getBizUnit());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(MetadataRefDetailUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    private boolean existSubEntity(String subEntityName, JoinQueryInfo query) {
        try {
            SubEntityInfo subEntity = this.getSubEntity(subEntityName, query);
            return subEntity != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private SubEntityInfo getSubEntity(String subEntityName, JoinQueryInfo query) throws Exception {
        SubObjectInfo obj = null;
        SubEntityInfo subEntity = null;
        SubEntityInfo returnEntity = null;
        int n = query.getSubObjects().size();
        for (int i = 0; i < n; ++i) {
            EntityObjectInfo entity;
            obj = query.getSubObjects().get(i);
            if (!(obj instanceof SubEntityInfo) || !StringUtils.equalsIgnoreCase((String)(entity = (subEntity = (SubEntityInfo)obj).getEntityRef()).getName().trim(), (String)subEntityName.trim())) continue;
            returnEntity = subEntity;
            break;
        }
        if (returnEntity != null) {
            return returnEntity;
        }
        throw new Exception("Can't found SubEntity: [" + subEntityName + "] in Query :" + query.getPackage() + "." + query.getName());
    }

    public static BizDataType getBizDataType(PropertyInfo prop) {
        if (prop == null) {
            return null;
        }
        if (prop instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
            if (ownProp.getEnumType() != null) {
                return BizDataType.ENUM;
            }
            DataType dataType = ownProp.getDataType();
            if (DataType.BOOLEAN.equals((Object)dataType)) {
                return BizDataType.BOOLEAN;
            }
            if (DataType.STRING.equals((Object)dataType)) {
                return BizDataType.STRING;
            }
            if (DataType.INTEGER.equals((Object)dataType)) {
                return BizDataType.INTEGER;
            }
            if (DataType.DECIMAL.equals((Object)dataType) || DataType.FLOAT.equals((Object)dataType) || DataType.DOUBLE.equals((Object)dataType)) {
                return BizDataType.DECIMAL;
            }
            if (DataType.DATE.equals((Object)dataType) || DataType.TIMESTAMP.equals((Object)dataType)) {
                return BizDataType.DATE;
            }
            if (DataType.TIME.equals((Object)dataType)) {
                return BizDataType.TIME;
            }
            return null;
        }
        return BizDataType.OBJECT;
    }

    private UictEditUIProxy getUictEditUIProxy() {
        if (this.uictEditUIProxy == null) {
            this.uictEditUIProxy = new UictEditUIProxy(this.bizConfigureHelper.getBizUnit(), this.bizConfigureHelper.getUIModel());
        }
        return this.uictEditUIProxy;
    }

    private UictEntityProxy getUictEntityProxy() {
        if (this.uictEntityProxy == null) {
            this.uictEntityProxy = new UictEntityProxy(this.bizConfigureHelper.getBizUnit());
        }
        return this.uictEntityProxy;
    }

    private UictQueryProxy getUictQueryProxy() {
        if (this.uictQueryProxy == null) {
            this.uictQueryProxy = new UictQueryProxy(this.bizConfigureHelper.getBizUnit());
        }
        return this.uictQueryProxy;
    }

    private UictListUIProxy getUictListUIProxy() {
        if (this.uictListUIProxy == null) {
            this.uictListUIProxy = new UictListUIProxy(this.bizConfigureHelper.getListUIModel(), this.bizConfigureHelper.getListUITable());
        }
        return this.uictListUIProxy;
    }
}

