/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client;

import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.IMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.service.permission.PermissionType;
import com.kingdee.bos.service.permission.metadata.BizPropertyCollection;
import com.kingdee.bos.service.permission.metadata.BizPropertyInfo;
import com.kingdee.bos.service.permission.metadata.BizRefCollection;
import com.kingdee.bos.service.permission.metadata.BizRefInfo;
import com.kingdee.bos.service.permission.metadata.DependenceInfo;
import com.kingdee.bos.service.permission.metadata.EntityObjectRefInfo;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.service.permission.metadata.RefPermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.RefPermissionItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uict.client.AbstractPermissionEditorUI;
import com.kingdee.eas.base.uict.client.BizRefDialogUI;
import com.kingdee.eas.base.uict.client.DepenceDialogUI;
import com.kingdee.eas.base.uict.client.ExtendedPropertyDialogUI;
import com.kingdee.eas.base.uict.client.PropertyRefDialogUI;
import com.kingdee.eas.base.uict.client.SelectBizUI;
import com.kingdee.eas.base.uict.client.permission.PermissionDefineHelper;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class PermissionEditorUI
extends AbstractPermissionEditorUI {
    public static final String PERMISSION_INFO = "permission_info";
    private static final Logger logger = CoreUIObject.getLogger((Class)PermissionEditorUI.class);
    private static String[] itemType = EnumUtils.getEnumNames((Class)PermissionType.class);
    private PermissionInfo model;
    private PermissionItemInfo selectedItem;
    private DefaultKingdeeTreeNode treeRoot = new DefaultKingdeeTreeNode();

    public PermissionEditorUI() throws Exception {
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        for (int i = 0; i < itemType.length; ++i) {
            this.cobType.addItem((Object)itemType[i]);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Object object = this.getUIContext().get(PERMISSION_INFO);
        if (object != null && object instanceof PermissionInfo) {
            this.model = (PermissionInfo)((PermissionInfo)object).trueClone();
            this.tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.treeRoot));
            this.refreshTreeRoot();
        }
    }

    public void storeFields() {
    }

    protected void btnSave_actionPerformed(ActionEvent e) {
        IMetadataStore mds = MetadataStoreFactory.getMetadataStore(null);
        try {
            this.synLastSelected();
            mds.saveConfigureMetadata((AbstractMetaDataValue)this.model, false);
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
        MsgBox.showInfo((String)"\u4fdd\u5b58\u6210\u529f");
    }

    protected void btnRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.synLastSelected();
        this.refreshTreeRoot();
    }

    protected void refreshTreeRoot() {
        this.treeRoot.removeAllChildren();
        PermissionItemCollection col = this.model.getPermissionItems();
        PermissionDefineHelper.generateItemTree(this.treeRoot, col);
        ((KingdeeTreeModel)this.tree.getModel()).reload();
    }

    public void tree_valueChanged(TreeSelectionEvent e) {
        DefaultKingdeeTreeNode treeNode;
        if (e.getOldLeadSelectionPath() != null && e.getOldLeadSelectionPath().getLastPathComponent() != null && (treeNode = (DefaultKingdeeTreeNode)e.getOldLeadSelectionPath().getLastPathComponent()).getUserObject() instanceof PermissionItemInfo) {
            this.storeField((PermissionItemInfo)treeNode.getUserObject());
        }
        if (e.getNewLeadSelectionPath() != null && e.getNewLeadSelectionPath().getLastPathComponent() != null) {
            treeNode = (DefaultKingdeeTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
            if (treeNode.getUserObject() instanceof PermissionItemInfo) {
                this.loadField((PermissionItemInfo)treeNode.getUserObject());
                this.selectedItem = (PermissionItemInfo)treeNode.getUserObject();
            } else {
                this.loadField(null);
                this.selectedItem = null;
            }
        }
        this.refreshGlobal();
    }

    private void synLastSelected() {
        Object userobj;
        DefaultKingdeeTreeNode selectedNode;
        TreePath path = this.tree.getSelectionPath();
        if (path != null && (selectedNode = (DefaultKingdeeTreeNode)path.getLastPathComponent()) != null && (userobj = selectedNode.getUserObject()) instanceof PermissionItemInfo) {
            PermissionItemInfo pii = (PermissionItemInfo)userobj;
            this.storeField(pii);
        }
    }

    private void storeField(PermissionItemInfo pi) {
        pi.setName(this.txtName.getText());
        pi.setDescription(this.txtDes.getText());
        pi.setType((String)this.cobType.getSelectedItem());
        pi.setAlias(this.txtAlias.getText(), new Locale("L1"));
        pi.setAlias(this.txtAlias.getText(), new Locale("L2"));
        pi.setAlias(STConverter.sc2tc((String)this.txtAlias.getText()), new Locale("L3"));
        pi.setGroup(this.txtGroup.getText(), new Locale("L1"));
        pi.setGroup(this.txtGroup.getText(), new Locale("L2"));
        pi.setGroup(STConverter.sc2tc((String)this.txtGroup.getText()), new Locale("L3"));
        pi.setGroupName(this.txtGroupName.getText());
    }

    private void loadField(PermissionItemInfo pi) {
        if (pi != null) {
            this.txtName.setText(pi.getName());
            this.txtAlias.setText(pi.getAlias());
            this.txtDes.setText(pi.getDescription());
            this.txtGroup.setText(pi.getGroup());
            this.txtGroupName.setText(pi.getGroupName());
            String type = pi.getType();
            if (StringUtils.isEmpty((String)type)) {
                this.cobType.setSelectedItem((Object)itemType[itemType.length - 1]);
            } else {
                this.cobType.setSelectedItem((Object)type);
            }
            EntityObjectRefInfo eori = pi.getEntityObjectMetadataRef();
            if (eori != null) {
                this.txtEntity.setText(eori.getEntityMetaInfo().getFullName());
            } else {
                this.txtEntity.setText("");
            }
        } else {
            this.txtName.setText(null);
            this.txtAlias.setText(null);
            this.txtDes.setText(null);
            this.txtGroup.setText(null);
            this.txtGroupName.setText(null);
            this.cobType.setSelectedItem((Object)itemType[itemType.length - 1]);
            this.txtEntity.setText("");
        }
    }

    protected void btnEntity_actionPerformed(ActionEvent e) throws Exception {
        Object obj;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("selectBizType", "bizentity");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(SelectBizUI.class.getName(), (Map)uiContext);
        SelectBizUI sbUI = (SelectBizUI)uiWindow.getUIObject();
        uiWindow.show();
        if ("confirm".equals(sbUI.getExitStatus()) && (obj = sbUI.getReturnValue()) != null && obj instanceof EntityObjectInfo && this.selectedItem != null) {
            EntityObjectInfo newModel = (EntityObjectInfo)obj;
            if (newModel.getType() == null) {
                logger.error((Object)("the selected entity [" + newModel.getFullName() + "] type is null"));
                return;
            }
            MetaDataInfo md = new MetaDataInfo();
            md.setPackage(newModel.getPackage());
            md.setName(newModel.getName());
            md.setMetaDataType(MetaDataTypeList.ENTITY.toString());
            EntityObjectRefInfo eori = this.selectedItem.getEntityObjectMetadataRef();
            if (eori == null) {
                eori = new EntityObjectRefInfo();
                this.selectedItem.setEntityObjectMetadataRef(eori);
            }
            eori.setEntityMetaInfo(md);
            eori.setEnitityType(newModel.getType().toString());
            String fullName = newModel.getFullName();
            this.txtEntity.setText(fullName);
        }
    }

    protected void btnListAdd_actionPerformed(ActionEvent e) throws Exception {
        String group = null;
        String groupName = null;
        TreePath path = this.tree.getSelectionPath();
        DefaultKingdeeTreeNode selectedNode = null;
        DefaultKingdeeTreeNode parentNode = null;
        int count = this.treeRoot.getChildCount();
        if (count == 0 || path == null) {
            parentNode = this.treeRoot;
        } else {
            selectedNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            if (selectedNode != null) {
                Object userobj = selectedNode.getUserObject();
                if (userobj instanceof String && selectedNode.getChildCount() > 0) {
                    selectedNode = (DefaultKingdeeTreeNode)selectedNode.getChildAt(0);
                }
                parentNode = (DefaultKingdeeTreeNode)selectedNode.getParent();
                userobj = selectedNode.getUserObject();
                if (userobj instanceof PermissionItemInfo) {
                    group = ((PermissionItemInfo)userobj).getGroup();
                    groupName = ((PermissionItemInfo)userobj).getGroupName();
                } else {
                    groupName = "";
                    for (DefaultKingdeeTreeNode un = parentNode; un != null && !"root".equals(un.getText()); un = (DefaultKingdeeTreeNode)un.getParent()) {
                        groupName = !StringUtils.isEmpty((String)groupName) ? un.getText() + "." + groupName : un.getText();
                    }
                }
            }
        }
        if (StringUtils.isEmpty(group)) {
            group = "EAS\u7cfb\u7edf";
        }
        if (StringUtils.isEmpty(groupName)) {
            groupName = "EAS\u7cfb\u7edf";
        }
        PermissionItemInfo item = new PermissionItemInfo();
        item.setUserDefined(false);
        item.setName("NewPermissionItem" + this.model.getPermissionItems().size());
        item.setString("innerID", BOSUuid.create((String)"PERMITEM").toString());
        String alias = "\u65b0\u589e\u6743\u9650\u9879" + this.model.getPermissionItems().size();
        item.setAlias(alias, new Locale("L1"));
        item.setAlias(alias, new Locale("L2"));
        item.setAlias(STConverter.sc2tc((String)alias), new Locale("L3"));
        item.setGroup(group, new Locale("L1"));
        item.setGroup(group, new Locale("L2"));
        item.setGroup(STConverter.sc2tc((String)group), new Locale("L3"));
        item.setGroupName(groupName);
        item.setType(PermissionType.OTHER.getName());
        item.setExtendedProperty("orgRelation", "ControlUnit");
        item.setExtendedProperty("permItemType", "30");
        item.setExtendedProperty("enableDataPermission", "false");
        this.model.getPermissionItems().add(item);
        this.refreshTreeRoot();
        this.refreshGlobal();
        PermissionDefineHelper.setSelectedByUserObject(this.tree, this.treeRoot, item);
    }

    protected void btnListUp_actionPerformed(ActionEvent e) throws Exception {
        super.btnListUp_actionPerformed(e);
    }

    protected void btnListDown_actionPerformed(ActionEvent e) throws Exception {
        super.btnListDown_actionPerformed(e);
    }

    protected void btnListDelete_actionPerformed(ActionEvent e) throws Exception {
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            if (selectedNode != null && selectedNode.getUserObject() instanceof PermissionItemInfo) {
                this.model.getPermissionItems().remove((PermissionItemInfo)selectedNode.getUserObject());
                this.tree.removeNodeFromParent((MutableTreeNode)selectedNode);
            }
            this.refreshGlobal();
        }
    }

    protected void btnBizRefAdd_actionPerformed(ActionEvent e) throws Exception {
        BizRefInfo bizRefInfo;
        if (this.selectedItem == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(BizRefDialogUI.class.getName(), (Map)uiContext);
        BizRefDialogUI brdUI = (BizRefDialogUI)uiWindow.getUIObject();
        uiWindow.show();
        if ("confirm".equals(brdUI.getExitStatus()) && (bizRefInfo = brdUI.getBizRefInfo()) != null && bizRefInfo.getBizMetadataInfo() != null && this.selectedItem != null) {
            bizRefInfo.setUserDefined(false);
            this.selectedItem.getBizRefs().add(bizRefInfo);
        }
        this.refreshBizRef();
    }

    protected void btnBizRefUp_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void btnBizRefDown_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void btnBizRefDelete_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.bizRefSectionTable);
        for (int i = 0; i < rowIndex.length; ++i) {
            BizRefInfo bri = (BizRefInfo)this.bizRefSectionTable.getRow(rowIndex[i]).getUserObject();
            if (bri == null || this.selectedItem == null) continue;
            this.selectedItem.getBizRefs().remove(bri);
        }
        this.refreshBizRef();
    }

    public void bizRefSectionTable_tableSelectChanged(KDTSelectEvent e) {
        this.refreshBizProperty();
    }

    protected void btnExtendAdd_actionPerformed(ActionEvent e) throws Exception {
        PermissionDefineHelper.ExtendPropertyInfo epi;
        if (this.selectedItem == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(ExtendedPropertyDialogUI.class.getName(), (Map)uiContext);
        ExtendedPropertyDialogUI epdUI = (ExtendedPropertyDialogUI)uiWindow.getUIObject();
        epdUI.setOprtState("ADDNEW");
        uiWindow.show();
        if ("confirm".equals(epdUI.getExitStatus()) && (epi = epdUI.getExt()) != null && this.selectedItem != null) {
            this.selectedItem.setExtendedProperty(epi.getKey().toString(), epi.getValue().toString());
        }
        this.refreshExt();
    }

    protected void btnExtendEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.selectedItem == null) {
            return;
        }
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.extendSectionTable);
        if (rowIndex.length > 0) {
            PermissionDefineHelper.ExtendPropertyInfo epi;
            PermissionDefineHelper.ExtendPropertyInfo exist = (PermissionDefineHelper.ExtendPropertyInfo)this.extendSectionTable.getRow(rowIndex[0]).getUserObject();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put("Owner", this);
            uiContext.put("info", exist);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(ExtendedPropertyDialogUI.class.getName(), (Map)uiContext);
            ExtendedPropertyDialogUI epdUI = (ExtendedPropertyDialogUI)uiWindow.getUIObject();
            epdUI.setOprtState("EDIT");
            uiWindow.show();
            if ("confirm".equals(epdUI.getExitStatus()) && (epi = epdUI.getExt()) != null && this.selectedItem != null) {
                this.selectedItem.setExtendedProperty(epi.getKey().toString(), epi.getValue().toString());
            }
        }
        this.refreshExt();
    }

    protected void btnExtendDelete_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.extendSectionTable);
        if (rowIndex.length > 0) {
            PermissionDefineHelper.ExtendPropertyInfo exist = (PermissionDefineHelper.ExtendPropertyInfo)this.extendSectionTable.getRow(rowIndex[0]).getUserObject();
            if (this.selectedItem != null) {
                this.selectedItem.removeExtendedProperty(exist.getKey().toString());
            }
        }
        this.refreshExt();
    }

    protected void btnBizPropertyAdd_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.bizRefSectionTable);
        if (rowIndex.length > 0) {
            BizRefInfo bri = (BizRefInfo)this.bizRefSectionTable.getRow(rowIndex[0]).getUserObject();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put("Owner", this);
            uiContext.put("biz ref info", bri);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(PropertyRefDialogUI.class.getName(), (Map)uiContext);
            PropertyRefDialogUI brdUI = (PropertyRefDialogUI)uiWindow.getUIObject();
            uiWindow.show();
        }
        this.refreshBizProperty();
    }

    protected void btnBizPropertyUp_actionPerformed(ActionEvent e) throws Exception {
        super.btnBizPropertyUp_actionPerformed(e);
    }

    protected void btnBizPropertyDown_actionPerformed(ActionEvent e) throws Exception {
        super.btnBizPropertyDown_actionPerformed(e);
    }

    protected void btnBizPropertyDelete_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.bizRefSectionTable);
        if (rowIndex.length > 0) {
            BizRefInfo bri = (BizRefInfo)this.bizRefSectionTable.getRow(rowIndex[0]).getUserObject();
            int[] rowIndex2 = KDTableUtil.getSelectedRows((KDTable)this.bizPropertySectionTable);
            for (int i = 0; i < rowIndex2.length; ++i) {
                BizPropertyInfo bpi = (BizPropertyInfo)this.bizPropertySectionTable.getRow(rowIndex2[i]).getUserObject();
                if (bpi == null) continue;
                bri.getBizPropertys().remove(bpi);
            }
        }
        this.refreshBizProperty();
    }

    protected void btnDepedenceAdd_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("PermissionInfo", this.model);
        uiContext.put("DependenceInfo", this.getDependenceInfo());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(DepenceDialogUI.class.getName(), (Map)uiContext);
        DepenceDialogUI depUI = (DepenceDialogUI)uiWindow.getUIObject();
        uiWindow.show();
        this.refreshDepence();
    }

    protected void btnDepedenceUp_actionPerformed(ActionEvent e) throws Exception {
        super.btnDepedenceUp_actionPerformed(e);
    }

    protected void btnDepedenceDown_actionPerformed(ActionEvent e) throws Exception {
        super.btnDepedenceDown_actionPerformed(e);
    }

    protected void btnDepedenceDelete_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.depedenceSectionTable);
        DependenceInfo di = this.getDependenceInfo();
        for (int i = 0; i < rowIndex.length; ++i) {
            RefPermissionItemInfo refing = (RefPermissionItemInfo)this.depedenceSectionTable.getRow(rowIndex[i]).getUserObject();
            if (refing == null || di == null) continue;
            di.getNewReferingItems().remove(refing);
        }
        this.refreshDepence();
    }

    private DependenceInfo getDependenceInfo() {
        if (this.selectedItem != null) {
            DependenceInfo dInfo = null;
            Iterator it = this.model.getDependences().iterator();
            while (it.hasNext()) {
                dInfo = (DependenceInfo)it.next();
                if (dInfo == null || dInfo.getReferedItem() == null || dInfo.getReferedItem().getName() == null || !dInfo.getReferedItem().getName().equals(this.selectedItem.getName())) continue;
                return dInfo;
            }
            dInfo = new DependenceInfo();
            dInfo.setReferedItem(this.selectedItem);
            return dInfo;
        }
        return null;
    }

    public void refreshGlobal() {
        this.refreshBizRef();
        this.refreshBizProperty();
        this.refreshDepence();
        this.refreshExt();
    }

    protected void refreshBizRef() {
        this.bizRefSectionTable.removeRows();
        if (this.selectedItem == null) {
            return;
        }
        BizRefCollection brc = this.selectedItem.getBizRefs();
        int size = brc.size();
        for (int i = 0; i < size; ++i) {
            BizRefInfo bri = brc.get(i);
            MetaDataInfo mdi = bri.getBizMetadataInfo();
            IRow row = this.bizRefSectionTable.addRow();
            row.setUserObject((Object)bri);
            row.getCell("bizRefColumn").setValue((Object)mdi.getFullName());
        }
    }

    protected void refreshBizProperty() {
        this.bizPropertySectionTable.removeRows();
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.bizRefSectionTable);
        if (rowIndex.length > 0) {
            BizRefInfo bri = (BizRefInfo)this.bizRefSectionTable.getRow(rowIndex[0]).getUserObject();
            BizPropertyCollection bpc = bri.getBizPropertys();
            int size = bpc.size();
            for (int i = 0; i < size; ++i) {
                BizPropertyInfo bpi = bpc.get(i);
                IRow row = this.bizPropertySectionTable.addRow();
                row.setUserObject((Object)bpi);
                row.getCell("bizPropertyColumn").setValue((Object)PermissionDefineHelper.getPropertyText(bpi, bri));
            }
        }
    }

    protected void refreshDepence() {
        this.depedenceSectionTable.removeRows();
        if (this.selectedItem == null) {
            return;
        }
        DependenceInfo di = this.getDependenceInfo();
        RefPermissionItemCollection rpic = di.getNewReferingItems();
        Iterator iter = rpic.iterator();
        while (iter.hasNext()) {
            RefPermissionItemInfo refing = (RefPermissionItemInfo)iter.next();
            IRow row = this.depedenceSectionTable.addRow();
            row.setUserObject((Object)refing);
            PermissionInfo md = refing.getPermission();
            row.getCell("perNameColumn").setValue((Object)(md == null ? "" : md.getFullName()));
            String name = refing.getPermissionItem().getName();
            row.getCell("perItemNameColumn").setValue((Object)(name != null ? name : ""));
            String alias = refing.getPermissionItem().getAlias();
            row.getCell("perAliasColumn").setValue((Object)(alias != null ? alias : ""));
            String description = refing.getPermissionItem().getDescription();
            row.getCell("perDesColumn").setValue((Object)(description != null ? description : ""));
            row.getCell("perTypeColumn").setValue((Object)"");
        }
    }

    protected void refreshExt() {
        this.extendSectionTable.removeRows();
        if (this.selectedItem == null) {
            return;
        }
        Map extMap = this.selectedItem.getExtendedProperties();
        Set keySet = extMap.keySet();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Object value = extMap.get(key);
            IRow row = this.extendSectionTable.addRow();
            PermissionDefineHelper.ExtendPropertyInfo epi = new PermissionDefineHelper.ExtendPropertyInfo(key, value);
            row.setUserObject((Object)epi);
            row.getCell("nameColumn").setValue(key);
            row.getCell("valueColumn").setValue(value);
        }
    }
}

