/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uict.client.AbstractPermissionListUI;
import com.kingdee.eas.base.uict.client.PermissionAddNewDialogUI;
import com.kingdee.eas.base.uict.client.PermissionEditorUI;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class PermissionListUI
extends AbstractPermissionListUI {
    private static final Logger logger = CoreUIObject.getLogger((Class)PermissionListUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.initWorkButton();
        this.listTable.checkParsed();
        this.refresh();
    }

    public void storeFields() {
    }

    protected void initWorkButton() {
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
    }

    private void refresh() {
        this.listTable.removeRows();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        IObjectCollection ioc = loader.getConfigureCollection(MetaDataTypeList.PERMISSION);
        if (ioc == null) {
            return;
        }
        int size = ioc.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue obj = ioc.getObject(i);
            if (!(obj instanceof PermissionInfo)) continue;
            PermissionInfo pi = (PermissionInfo)obj;
            IRow row = this.listTable.addRow();
            row.getCell("nameColumn").setValue((Object)pi.getName());
            row.getCell("aliasColumn").setValue((Object)pi.getAlias());
            row.getCell("packageColumn").setValue((Object)pi.getPackage());
            row.setUserObject((Object)pi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(PermissionInfo pi) {
        if (pi != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put("Owner", this);
            try {
                uiContext.put("permission_info", pi);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(PermissionEditorUI.class.getName(), (Map)uiContext);
                uiWindow.show();
            }
            catch (UIException e1) {
                logger.error((Object)e1);
            }
            finally {
                this.refresh();
            }
        }
    }

    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(PermissionAddNewDialogUI.class.getName(), (Map)uiContext);
            PermissionAddNewDialogUI sbUI = (PermissionAddNewDialogUI)uiWindow.getUIObject();
            uiWindow.show();
            if ("confirm".equals(sbUI.getExitStatus())) {
                PermissionInfo pi = sbUI.getPermissionInfo();
                this.open(pi);
            }
        }
        catch (UIException e1) {
            logger.error((Object)e1);
        }
    }

    protected void btnEdit_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.listTable);
        if (rowIndex.length > 0) {
            PermissionInfo pi = (PermissionInfo)this.listTable.getRow(rowIndex[0]).getUserObject();
            this.open(pi);
        }
    }

    protected void btnRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh();
    }
}

