/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.metadata.ui.ActionCollection;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.service.permission.metadata.BizPropertyCollection;
import com.kingdee.bos.service.permission.metadata.BizPropertyInfo;
import com.kingdee.bos.service.permission.metadata.BizRefInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.uict.client.AbstractPropertyRefDialogUI;
import com.kingdee.eas.base.uict.client.permission.EntityTreeCreator;
import com.kingdee.eas.base.uict.client.permission.FacadeTreeCreator;
import com.kingdee.eas.base.uict.client.permission.PermissionDefineHelper;
import com.kingdee.eas.base.uict.client.permission.UITreeCreator;
import com.kingdee.eas.base.uict.client.util.UictUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class PropertyRefDialogUI
extends AbstractPropertyRefDialogUI {
    private static final Logger logger = CoreUIObject.getLogger((Class)PropertyRefDialogUI.class);
    private String EXIT_STATUS = null;
    public static final String CONFIRM_EXIT = "confirm";
    public static final String CANCEL_EXIT = "cancel";
    public static final String BIZREF_INFO = "biz ref info";
    private DefaultKingdeeTreeNode root;
    private BizRefInfo bri;
    private List selected = new ArrayList();

    public PropertyRefDialogUI() throws Exception {
        this.tree.setShowCheckBox(true);
        this.tree.setSyncChecked(true);
        this.tree.setRootVisible(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Object object = this.getUIContext().get(BIZREF_INFO);
        if (object != null && object instanceof BizRefInfo) {
            this.bri = (BizRefInfo)object;
            MetaDataInfo mdi = this.bri.getBizMetadataInfo();
            this.root = new DefaultKingdeeTreeNode((Object)"root");
            if (MetaDataTypeList.ENTITY.toString().equals(mdi.getMetaDataType())) {
                EntityTreeCreator btc = new EntityTreeCreator();
                EntityObjectInfo eoi = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(mdi.getFullName()));
                this.root = btc.create(eoi);
            } else if (MetaDataTypeList.FACADE.toString().equals(mdi.getMetaDataType())) {
                FacadeTreeCreator ftc = new FacadeTreeCreator();
                FacadeInfo fi = UictUtils.loadFacade((IMetaDataPK)new MetaDataPK(mdi.getFullName()));
                this.root = ftc.create(fi);
            } else if (MetaDataTypeList.UIOBJECT.toString().equals(mdi.getMetaDataType())) {
                UITreeCreator utc = new UITreeCreator();
                UIObjectInfo uoi = UictUtils.loadUI((IMetaDataPK)new MetaDataPK(mdi.getFullName()));
                this.root = utc.create(uoi);
            } else if (MetaDataTypeList.WEBUIOBJECT.toString().equals(mdi.getMetaDataType()) || MetaDataTypeList.BASEQUERY.toString().equals(mdi.getMetaDataType())) {
                // empty if block
            }
            if (this.root != null) {
                this.tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.root));
                this.tree.expandAllNodes(true, (TreeNode)this.root);
                this.initChecked(this.bri);
            }
        }
    }

    public void storeFields() {
    }

    private void initChecked(BizRefInfo bri) {
        if (bri == null) {
            return;
        }
        Iterator it = bri.getBizPropertys().iterator();
        BizPropertyInfo property = null;
        MetaDataInfo mdi = bri.getBizMetadataInfo();
        if (MetaDataTypeList.UIOBJECT.toString().equals(bri.getBizMetadataInfo().getMetaDataType())) {
            while (it.hasNext()) {
                property = (BizPropertyInfo)it.next();
                ActionInfo action = this.getActionByClassName(mdi, property.getProperty());
                this.selected.add(action);
            }
        } else if (!MetaDataTypeList.WEBUIOBJECT.toString().equals(bri.getBizMetadataInfo().getMetaDataType())) {
            MethodInfo method;
            if (MetaDataTypeList.ENTITY.toString().equals(bri.getBizMetadataInfo().getMetaDataType())) {
                while (it.hasNext()) {
                    property = (BizPropertyInfo)it.next();
                    method = PermissionDefineHelper.getMethodByInnerID(mdi, property.getProperty());
                    this.selected.add(method);
                }
            } else if (MetaDataTypeList.FACADE.toString().equals(bri.getBizMetadataInfo().getMetaDataType())) {
                while (it.hasNext()) {
                    property = (BizPropertyInfo)it.next();
                    method = PermissionDefineHelper.getMethodByInnerID(mdi, property.getProperty());
                    this.selected.add(method);
                }
            }
        }
        if (this.root != null) {
            int size = this.root.getChildCount();
            for (int i = 0; i < size; ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.root.getChildAt(i);
                this.selectNodes(node);
            }
        }
    }

    private void selectNodes(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return;
        }
        if (node.getChildCount() > 0) {
            int size = node.getChildCount();
            for (int i = 0; i < size; ++i) {
                DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)node.getChildAt(i);
                this.selectNodes(child);
            }
        }
        if (this.selected.contains(node.getUserObject())) {
            node.setChecked(true);
        }
    }

    private ActionInfo getActionByClassName(MetaDataInfo meta, String actionClassName) {
        if (meta == null) {
            return null;
        }
        MetaDataPK pk = new MetaDataPK(meta.getPackage(), meta.getName());
        IObjectValue newModel = UictUtils.loadMD(PermissionDefineHelper.getBOSObjectType(meta.getMetaDataType()), (IMetaDataPK)pk);
        if (newModel == null) {
            return null;
        }
        ActionCollection actions = this.getActionCollection((UIObjectInfo)newModel);
        if (actions == null) {
            return null;
        }
        Iterator it = actions.iterator();
        while (it.hasNext()) {
            ActionInfo action = (ActionInfo)it.next();
            if (!actionClassName.equals(action.getClassName())) continue;
            return action;
        }
        return null;
    }

    private ActionCollection getActionCollection(UIObjectInfo ui) {
        ArrayList allui = new ArrayList();
        this.listUIParents(allui, ui);
        ActionCollection actions = new ActionCollection();
        int n = allui.size();
        for (int i = 0; i < n; ++i) {
            UIObjectInfo uiInfo = (UIObjectInfo)allui.get(i);
            ActionCollection actions2 = uiInfo.getActions();
            for (int j = 0; j < actions2.size(); ++j) {
                ActionInfo a = actions2.get(j);
                actions.add(a);
            }
        }
        return actions;
    }

    private void listUIParents(List list, UIObjectInfo ui) {
        UIObjectInfo parent = ui.getParent();
        if (parent != null) {
            this.listUIParents(list, parent);
        }
        list.add(ui);
    }

    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.bri != null) {
            BizPropertyCollection bpc = this.bri.getBizPropertys();
            bpc.clear();
            ArrayList nodes = new ArrayList();
            PermissionDefineHelper.getCheckedNode((DefaultKingdeeTreeNode)this.tree.getModel().getRoot(), nodes);
            int size = nodes.size();
            for (int i = 0; i < size; ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)nodes.get(i);
                String p = "";
                if (node.getUserObject() instanceof MethodInfo) {
                    p = ((MethodInfo)node.getUserObject()).getString("innerID");
                } else if (node.getUserObject() instanceof ActionInfo) {
                    p = ((ActionInfo)node.getUserObject()).getClassName();
                }
                if (p == null) {
                    p = "";
                }
                BizPropertyInfo prop = new BizPropertyInfo();
                prop.setUserDefined(true);
                prop.setProperty(p);
                bpc.add(prop);
            }
        }
        this.EXIT_STATUS = CONFIRM_EXIT;
        this.destroyWindow();
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.EXIT_STATUS = CANCEL_EXIT;
        this.destroyWindow();
    }

    public String getExitStatus() {
        return this.EXIT_STATUS;
    }
}

