/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client;

import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.DataSourceType;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.uict.client.AbstractRuleValidateTab;
import com.kingdee.eas.base.uict.client.util.BizEventDefHelper;
import com.kingdee.eas.base.uict.client.util.BizUictFactory;
import com.kingdee.eas.base.uict.client.util.IEventHandler;
import com.kingdee.eas.base.uict.client.util.IEventRuleManager;
import com.kingdee.eas.base.uict.client.util.UictEvent;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RuleValidateTab
extends AbstractRuleValidateTab
implements IEventHandler {
    private static final Logger logger = CoreUIObject.getLogger((Class)RuleValidateTab.class);
    private IEventRuleManager bizEventRuleManager = null;
    private BizUnitInfo bizUnitInfo = null;

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map values = (Map)this.getUserObject();
        this.bizUnitInfo = (BizUnitInfo)values.get("BizUnitInfo");
        BizUictFactory.createOperationPanel(this.pnlOperation, this.getEventRuleManager(), false);
        this.initFieldsList();
        this.getEventRuleManager().registerStyledRuleEditor((Component)this.txtPaneRuleEditor);
    }

    public IEventRuleManager getEventRuleManager() {
        if (this.bizEventRuleManager == null) {
            this.bizEventRuleManager = (IEventRuleManager)BizUictFactory.createInstanceFromClass(BizUictFactory.BIZ_RULE_MANAGER);
        }
        return this.bizEventRuleManager;
    }

    public List getActions() {
        String rule = this.getEventRuleManager().getRules();
        if (rule != null && !"".equals(rule)) {
            rule = BizEventDefHelper.prefixAndSuffixFormat(rule, "UIRuleUtil.throwException(", ")", true);
            LinkedList<String> actions = new LinkedList<String>();
            actions.add(rule);
            return actions;
        }
        return null;
    }

    public void setActions(List actions) {
        if (actions != null) {
            String rules = "";
            String itemStr = null;
            int m = actions.size();
            for (int i = 0; i < m; ++i) {
                itemStr = (String)actions.get(i);
                itemStr = BizEventDefHelper.prefixAndSuffixFormat(itemStr, "UIRuleUtil.throwException(", ")", false);
                rules = rules + itemStr;
            }
            this.getEventRuleManager().setRules(rules);
        }
    }

    private void initFieldsList() {
        BizFieldCollection fieldCol = this.bizUnitInfo.getFields();
        this.initList(fieldCol, "", "");
        this.listItemView.addMouseListener((MouseListener)new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                try {
                    Object source;
                    if (e.getButton() == 1 && e.getClickCount() == 2 && (source = e.getSource()) instanceof KDList) {
                        KDList list = (KDList)source;
                        Object selectedItem = list.getSelectedValue();
                        UictEvent uictEvent = new UictEvent(e.getSource(), e.getID(), null);
                        uictEvent.setEventCode(3);
                        uictEvent.setAttachment(selectedItem);
                        RuleValidateTab.this.getEventRuleManager().actionPerformed(uictEvent);
                    }
                }
                catch (Exception err) {
                    logger.error((Object)err.getMessage());
                }
            }
        });
    }

    private void initList(BizFieldCollection fields, String pLabel, String pName) {
        String item1 = "";
        String item2 = "";
        if (!StringUtils.isEmpty((String)pLabel)) {
            item1 = pLabel + ".";
            item2 = pName + ".";
        }
        for (int i = 0; i < fields.size(); ++i) {
            EntityObjectInfo entity;
            if (fields.get(i).getAlias() == null || !fields.get(i).isFieldsManageVisible() || ObjectStateType.DELETED.equals((Object)fields.get(i).getObjectState())) continue;
            if (fields.get(i) instanceof BizGroupFieldInfo) {
                String str1 = item1 + fields.get(i).getAlias();
                String str2 = item2 + fields.get(i).getName();
                this.initList(((BizGroupFieldInfo)fields.get(i)).getFields(), str1, str2);
                continue;
            }
            if (fields.get(i).getAlias() == null) continue;
            String realName = item2 + fields.get(i).getName();
            String aliasName = item1 + fields.get(i).getAlias();
            this.appendItemAndLabel(realName, aliasName);
            if (!DataSourceType.BASEDATA.equals((Object)fields.get(i).getDataSourceType()) || (entity = fields.get(i).getDataSource()) == null) continue;
            PropertyCollection props = entity.getInheritedNoDuplicatedProperties();
            int size = props.size();
            for (int j = 0; j < size; ++j) {
                String propName = props.get(j).getName();
                String propAlias = props.get(j).getAlias();
                if (propAlias == null) continue;
                this.appendItemAndLabel(realName + "." + propName, aliasName + "." + propAlias);
            }
        }
    }

    private void appendItemAndLabel(String item, String label) {
        this.listItemView.addElement((Object)label);
        this.getEventRuleManager().appendItemAndLabel(item, label);
    }
}

