/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.UserPromptBox;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.uict.IUserOrgUict;
import com.kingdee.eas.base.uict.UserOrgUictFactory;
import com.kingdee.eas.base.uict.client.AbstractUictAccreditUI;
import com.kingdee.eas.base.uict.client.ConfigureParam;
import com.kingdee.eas.base.uict.client.UserOrgUictListUI;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.OUUnionF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class UictAccreditUI
extends AbstractUictAccreditUI {
    private static final Logger logger = CoreUIObject.getLogger((Class)UictAccreditUI.class);
    private ConfigureParam cfgParam;
    public static final String BIZ_CONFIGURE_INFO = "BizConfigureInfo";

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.getParameter();
        this.initOrgF7();
        this.initWorkButton();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return UserOrgUictFactory.getRemoteInstance();
    }

    private void getParameter() {
        Object obj = this.getUIContext().get(BIZ_CONFIGURE_INFO);
        if (!(obj instanceof ConfigureParam)) {
            return;
        }
        ConfigureParam cp = (ConfigureParam)obj;
        this.kdlBizUnit.setText("\u4e1a\u52a1\u5355\u5143:" + cp.getBizUnitInfo().getAlias());
        this.kdlMethod.setText("\u65b9\u6848\u540d\u79f0:" + cp.getConfigureName());
        this.cfgParam = cp;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAccredit.setIcon(EASResource.getIcon((String)"imgTbtn_allotmultipopedom"));
        this.btnDisaccredit.setIcon(EASResource.getIcon((String)"imgTbtn_deletemultipopedom"));
        this.btnAllList.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
    }

    private void initOrgF7() throws EASBizException, BOSException {
        IObjectPK curUserPK = ToolUtils.getCurrentUserPK();
        OUUnionF7 orgF7 = new OUUnionF7((IUIObject)this);
        orgF7.setShowAssistantOrg(true);
        orgF7.setShowSub(true);
        orgF7.setMultiCUs(true);
        orgF7.setCuIdList(PermissionRangeHelper.getBizUserCUOrgRange(null, (IObjectPK)curUserPK));
        orgF7.disableTheOUWhichIsOnlyAdmin();
        orgF7.setMultiSelect(false);
        orgF7.setContainOUSealUp(false);
        if (!Administrator.isCUAdmin(null, (IObjectPK)curUserPK)) {
            List userOrgRangeList = PermissionRangeHelper.getUserOrgId(null, (IObjectPK)curUserPK, (OrgRangeType)OrgRangeType.BIZ_ORG_TYPE);
            orgF7.useFilter(ToolUtils.trans2Map((Collection)userOrgRangeList));
        }
        this.pmtOrg.setSelector((KDPromptSelector)orgF7);
        this.pmtOrg.setEditable(false);
    }

    public void actionAccredit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAccredit_actionPerformed(e);
        this.checkOrgIsNull();
        UserPromptBox pmt = new UserPromptBox((IUIObject)this);
        pmt.setEntityViewInfo(this.getUserFilter());
        pmt.show();
        Object[] users = (Object[])pmt.getData();
        if (!pmt.isCanceled()) {
            this.checkEmpty(users);
            List orgIdList = this.getOrgList();
            List userIdList = this.getUserList(users);
            List configureIdList = this.getConfigureIdList();
            List bizUnitPKList = this.getBizUnitPKList();
            String cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            IUserOrgUict iUserOrgUict = UserOrgUictFactory.getRemoteInstance();
            iUserOrgUict.addBatch(userIdList, orgIdList, configureIdList, bizUnitPKList, cuId);
            MsgBox.showInfo((String)"\u5206\u914d\u6210\u529f");
        }
    }

    public void actionDisaccredit_actionPerformed(ActionEvent e) throws Exception {
        super.actionDisaccredit_actionPerformed(e);
        this.checkOrgIsNull();
        UserPromptBox pmt = new UserPromptBox((IUIObject)this);
        pmt.setEntityViewInfo(this.getUserFilter());
        pmt.show();
        Object[] users = (Object[])pmt.getData();
        if (!pmt.isCanceled()) {
            this.checkEmpty(users);
            List userIdList = this.getUserList(users);
            List orgIdList = this.getOrgList();
            List configureIdList = this.getConfigureIdList();
            List bizUnitPKList = this.getBizUnitPKList();
            IUserOrgUict iUserOrgUict = UserOrgUictFactory.getRemoteInstance();
            iUserOrgUict.deleteBatch(userIdList, orgIdList, configureIdList, bizUnitPKList);
            MsgBox.showInfo((String)"\u53d6\u6d88\u5206\u914d\u6210\u529f");
        }
    }

    private EntityViewInfo getUserFilter() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FullOrgUnitInfo org = (FullOrgUnitInfo)this.pmtOrg.getData();
        if (org != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getUserWithBizOrgSql(org.getId().toString()), CompareType.INNER));
        }
        evi.setFilter(filter);
        return evi;
    }

    private String getUserWithBizOrgSql(String orgPK) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT OrgRange.FUserID FROM T_PM_OrgRange OrgRange ");
        sql.append(" INNER JOIN T_PM_User U ON U.FID = OrgRange.FUserID ").append(" WHERE U.FIsDelete = 0 ").append(" AND OrgRange.FOrgID = '").append(orgPK).append("' AND OrgRange.FType = 10 ");
        return sql.toString();
    }

    public void actionAllList_actionPerformed(ActionEvent e) throws Exception {
        UIContext uictx = new UIContext();
        uictx.put((Object)"Owner", (Object)this);
        uictx.put((Object)"bizUnitPK", (Object)this.cfgParam.getBizUnitInfo().getFullName());
        uictx.put((Object)"configureID", (Object)this.cfgParam.getConfigureID());
        uictx.put((Object)"orgID", (Object)this.getOrgID());
        UITools.showUI((Object)((Object)this), (String)UserOrgUictListUI.class.getName(), (UIContext)uictx);
    }

    private void checkEmpty(Object[] users) {
        if (users == null || users.length == 0) {
            MsgBox.showInfo((String)"\u6ca1\u6709\u9009\u62e9\u7528\u6237\uff01");
            SysUtil.abort();
        }
    }

    private void checkOrgIsNull() {
        if (this.pmtOrg.getData() == null) {
            MsgBox.showInfo((String)"\u6ca1\u6709\u9009\u62e9\u7ec4\u7ec7\uff01");
            SysUtil.abort();
        }
    }

    private List getConfigureIdList() {
        ArrayList<String> configureIdList = new ArrayList<String>();
        configureIdList.add(this.cfgParam.getConfigureID());
        return configureIdList;
    }

    private List getBizUnitPKList() {
        ArrayList<String> bizUnitPKList = new ArrayList<String>();
        bizUnitPKList.add(this.cfgParam.getBizUnitInfo().getFullName());
        return bizUnitPKList;
    }

    private List getUserList(Object[] users) {
        ArrayList<String> userIdList = new ArrayList<String>();
        for (int i = users.length - 1; i >= 0; --i) {
            userIdList.add(((UserInfo)users[i]).getId().toString());
        }
        return userIdList;
    }

    private List getOrgList() {
        FullOrgUnitInfo org = (FullOrgUnitInfo)this.pmtOrg.getData();
        ArrayList<String> orgIdList = new ArrayList<String>();
        orgIdList.add(org.getId().toString());
        return orgIdList;
    }

    private String getOrgID() {
        FullOrgUnitInfo org = (FullOrgUnitInfo)this.pmtOrg.getData();
        if (org == null) {
            return "";
        }
        ArrayList orgIdList = new ArrayList();
        return org.getId().toString();
    }
}

