/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client;

import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import com.kingdee.eas.base.uict.client.AbstractUictEditorUI;
import com.kingdee.eas.base.uict.client.designer.Table;
import com.kingdee.eas.base.uict.client.designer.TableCell;
import com.kingdee.eas.base.uict.client.designer.TableColumn;
import com.kingdee.eas.base.uict.client.designer.TableRow;
import com.kingdee.eas.base.uict.client.editor.Context;
import com.kingdee.eas.base.uict.client.editor.UictEditPartViewer;
import com.kingdee.eas.base.uict.client.editor.listener.ISelectionChangedListener;
import com.kingdee.eas.base.uict.client.editor.listener.SelectionChangedEvent;
import com.kingdee.eas.base.uict.client.editor.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.base.uict.client.editor.request.Resize4SiteRequest;
import com.kingdee.eas.base.uict.client.editor.request.RowPosition4SiteRequest;
import com.kingdee.eas.base.uict.client.editor.util.cursor.CursorHelper;
import com.kingdee.eas.base.uict.client.editor.util.figure.FigureHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class UictEditorUI
extends AbstractUictEditorUI
implements MouseListener,
MouseMotionListener,
ISelectionChangedListener {
    private static final Logger logger = CoreUIObject.getLogger((Class)UictEditorUI.class);
    private static final int rulerV = 20;
    private static final int rulerH = 15;
    private static final Font f9 = new Font("Times New Roman", 0, 9);
    private static final Color lightBlue = new Color(215, 231, 244);
    private static final Color lightPink = new Color(167, 44, 250);
    private UictEditPartViewer viewer;
    private List rowList = new ArrayList(10);
    private List columnList = new ArrayList(5);
    private KDPopupMenu popMenu = new KDPopupMenu();
    private JRadioButtonMenuItem rulerPop = null;
    private JRadioButtonMenuItem tablePop = null;
    private boolean isResizing;
    private int x;
    private int y;
    private int border;
    private int x2;
    private int y2;
    private int cor = -1;

    public UictEditorUI() throws Exception {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.initPopupmenu();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawArea(g);
        if (this.tablePop.isSelected() && Context.STATUS_VIEW != this.viewer.getContext().getStatus()) {
            this.drawRowAndColumnRuler(g);
            this.drawResizeLine(g);
        } else {
            this.drawRuler(g);
        }
    }

    protected void initPopupmenu() {
        this.popMenu = new KDPopupMenu();
        this.rulerPop = new JRadioButtonMenuItem("\u663e\u793a\u6807\u5c3a");
        this.rulerPop.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                if (UictEditorUI.this.rulerPop.isSelected()) {
                    UictEditorUI.this.tablePop.setSelected(false);
                    UictEditorUI.this.repaint();
                }
            }
        });
        this.popMenu.add((JMenuItem)this.rulerPop);
        this.tablePop = new JRadioButtonMenuItem("\u663e\u793a\u8868\u683c");
        this.tablePop.setSelected(true);
        this.tablePop.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                if (UictEditorUI.this.tablePop.isSelected()) {
                    UictEditorUI.this.rulerPop.setSelected(false);
                    UictEditorUI.this.repaint();
                }
            }
        });
        this.popMenu.add((JMenuItem)this.tablePop);
    }

    private void drawArea(Graphics g) {
        g.setColor(Color.black);
        g.drawLine(20, 0, 20, this.getHeight());
        g.drawLine(0, 15, this.getWidth(), 15);
        g.setColor(Color.black);
    }

    private void drawRuler(Graphics g) {
        int i;
        Font back = g.getFont();
        g.setFont(f9);
        g.setColor(Color.black);
        for (i = 0; i < this.getWidth() - 20; i += 5) {
            if (i % 5 == 0) {
                g.drawLine(i + 20, 11, i + 20, 15);
            }
            if (i % 25 == 0) {
                g.drawLine(i + 20, 7, i + 20, 15);
            }
            if (i % 50 != 0) continue;
            g.drawLine(i + 20, 0, i + 20, 15);
            g.drawString(i + "", i + 3 + 20, 9);
        }
        for (i = 0; i < this.getHeight() - 15; i += 5) {
            if (i % 5 == 0) {
                g.drawLine(15, i + 15, 20, i + 15);
            }
            if (i % 25 == 0) {
                g.drawLine(10, i + 15, 20, i + 15);
            }
            if (i % 50 != 0) continue;
            g.drawLine(0, i + 15, 20, i + 15);
            String num = i + "";
            for (int j = 0; j < num.length(); ++j) {
                g.drawString(num.charAt(j) + "", 3, i + 10 + 15 + j * 8);
            }
        }
        g.setFont(back);
    }

    private void drawRowAndColumnRuler(Graphics g) {
        JViewport port = (JViewport)this.viewer.getParent();
        Point p = port.getViewPosition();
        int positiony = (int)p.getY();
        int n = this.rowList.size();
        for (int i = 0; i < n; ++i) {
            RC row = (RC)this.rowList.get(i);
            if (row.isSelected) {
                g.setColor(lightBlue);
            } else {
                g.setColor(Color.lightGray);
            }
            g.fillRect(0, row.param1 - positiony, 20, row.param2 - row.param1);
            g.setColor(Color.black);
            g.drawLine(0, row.param1 - positiony, 20, row.param1 - positiony);
            g.drawLine(0, row.param2 - positiony, 20, row.param2 - positiony);
            g.setColor(Color.black);
            int y = row.param1 + ((row.param2 - row.param1) / 2 + 5);
            g.drawString(i + 1 + "", 1, y - positiony);
        }
        int n2 = this.columnList.size();
        for (int i = 0; i < n2; ++i) {
            RC column = (RC)this.columnList.get(i);
            if (column.isSelected) {
                g.setColor(lightBlue);
            } else {
                g.setColor(Color.lightGray);
            }
            g.fillRect(column.param1, 0, column.param2 - column.param1, 15);
            g.setColor(Color.black);
            g.drawLine(column.param1, 0, column.param1, 15);
            g.drawLine(column.param2, 0, column.param2, 15);
            g.setColor(Color.black);
            int x = column.param1 + ((column.param2 - column.param1) / 2 + 5);
            g.drawString(i + 1 + "", x, 12);
        }
        this.repaint();
    }

    private void drawResizeLine(Graphics g) {
        if (this.isResizing) {
            g.setColor(Color.gray);
            if (this.border == 2) {
                int height = this.y2;
                int y_off = this.y;
                BufferedImage img = FigureHelper.drawAlphaImage(new Dimension(20, height), 0.4f, Color.gray, true);
                g.drawImage(img, 0, y_off, 20, height, (ImageObserver)((Object)this));
            } else if (this.border == 3) {
                int height = Math.abs(this.y - this.y2);
                int y_off = this.y > this.y2 ? this.y2 : this.y;
                BufferedImage img = FigureHelper.drawAlphaImage(new Dimension(20, height), 0.4f, Color.gray, true);
                g.drawImage(img, 0, y_off, 20, height, (ImageObserver)((Object)this));
            } else {
                int width = Math.abs(this.x - this.x2);
                int x_off = this.x > this.x2 ? this.x2 : this.x;
                BufferedImage img = FigureHelper.drawAlphaImage(new Dimension(width, 15), 0.4f, Color.gray, true);
                g.drawImage(img, x_off, 0, width, 15, (ImageObserver)((Object)this));
            }
        }
    }

    public void refreshRuler() {
        Table table;
        if (this.viewer != null && this.tablePop.isSelected() && (table = this.viewer.getNode().getTable()) != null) {
            this.rowList.clear();
            this.columnList.clear();
            BizConfigureItemInfo item = null;
            int sRow = -1;
            int mRowSpan = 1;
            int sColumn = -1;
            int mColumnSpan = 1;
            boolean find = false;
            if (this.viewer.getSelection() != null) {
                item = ((BizConfigureItemInfoAdapter)this.viewer.getSelection().getModel()).getItem();
                int m = table.getRowCount();
                block0: for (int i = 0; i < m; ++i) {
                    int n = table.getColumnCount();
                    for (int j = 0; j < n; ++j) {
                        TableCell cell = table.getCell(i, j);
                        if (cell.getData() == item) {
                            if (!cell.isMerged()) {
                                sRow = cell.getRowIndex();
                                sColumn = cell.getColumnIndex();
                            } else if (cell.isMerged() && cell == cell.getMergedCell()) {
                                sRow = cell.getRowIndex();
                                mRowSpan = cell.getRowSpan();
                                sColumn = cell.getColumnIndex();
                                mColumnSpan = cell.getColumnSpan();
                            }
                            find = true;
                            continue block0;
                        }
                        if (find) continue block0;
                    }
                }
            }
            int m = table.getRowCount();
            for (int i = 0; i < m; ++i) {
                TableRow row = table.getRow(i);
                if (find && sRow != -1 && i >= sRow && i <= sRow + mRowSpan - 1) {
                    this.rowList.add(new RC(row.getTop() + 15 + 2, row.getTop() + row.getHeight() + 15 + 2, true));
                    continue;
                }
                this.rowList.add(new RC(row.getTop() + 15 + 2, row.getTop() + row.getHeight() + 15 + 2, false));
            }
            int n = table.getColumnCount();
            for (int j = 0; j < n; ++j) {
                TableColumn column = table.getColumn(j);
                if (find && sColumn != -1 && j >= sColumn && j <= sColumn + mColumnSpan - 1) {
                    this.columnList.add(new RC(column.getLeft() + 20 + 2, column.getLeft() + column.getWidth() + 20 + 2, true));
                    continue;
                }
                this.columnList.add(new RC(column.getLeft() + 20 + 2, column.getLeft() + column.getWidth() + 20 + 2, false));
            }
        }
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 1 && SwingUtilities.isRightMouseButton(e) && (e.getY() < 15 || e.getX() < 20)) {
            this.popMenu.show((Component)((Object)this), e.getX(), e.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.isResizing) {
            if (this.border == 2 || this.border == 3) {
                this.viewer.sendRequest(null, new RowPosition4SiteRequest(this.viewer, this.cor, this.border, this.y - 15));
            } else {
                this.viewer.sendRequest(null, new Resize4SiteRequest(this.viewer, this.cor, this.border, this.x - 20));
            }
            this.isResizing = false;
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.x = e.getX();
            this.y = e.getY();
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        JViewport port = (JViewport)this.viewer.getParent();
        Point p = port.getViewPosition();
        int positiony = (int)p.getY();
        this.setCursor(CursorHelper.getDefaultCursor());
        if (this.tablePop.isSelected() && Context.STATUS_VIEW != this.viewer.getContext().getStatus()) {
            int i;
            int n;
            this.x = e.getX();
            this.y = e.getY();
            this.isResizing = false;
            this.cor = -1;
            if (this.y <= 15 && this.x >= 20) {
                n = this.columnList.size();
                for (i = 0; i < n; ++i) {
                    RC column = (RC)this.columnList.get(i);
                    if (this.x >= column.param1 - 1 && e.getX() <= column.param1 + 1) {
                        this.isResizing = true;
                        this.border = 0;
                        this.cor = i;
                        this.x2 = column.param2;
                        this.setCursor(CursorHelper.getResizeHorizontalCursor());
                        return;
                    }
                    if (this.x < column.param2 - 1 || this.x > column.param2 + 1) continue;
                    this.isResizing = true;
                    this.border = 1;
                    this.cor = i;
                    this.x2 = column.param1;
                    this.setCursor(CursorHelper.getResizeHorizontalCursor());
                    return;
                }
            }
            if (this.x <= 20 && this.y >= 15) {
                n = this.rowList.size();
                for (i = 0; i < n; ++i) {
                    RC row = (RC)this.rowList.get(i);
                    if (this.y >= row.param1 - 1 - positiony && this.y <= row.param1 + 1 - positiony) {
                        this.isResizing = true;
                        this.border = 2;
                        this.cor = i;
                        this.y2 = Math.abs(row.param1 - row.param2);
                        this.setCursor(CursorHelper.getResizeVerticalCursor());
                        return;
                    }
                    if (this.y < row.param2 - 1 - positiony || this.y > row.param2 + 1 - positiony) continue;
                    this.isResizing = true;
                    this.border = 3;
                    this.cor = i;
                    this.y2 = row.param1 - positiony;
                    this.setCursor(CursorHelper.getResizeVerticalCursor());
                    return;
                }
            }
        }
    }

    public void setViewer(UictEditPartViewer viewer) {
        this.viewer = viewer;
    }

    public void storeFields() {
        super.storeFields();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.refreshRuler();
    }

    class RC {
        public int param1;
        public int param2;
        public boolean isSelected = false;

        public RC(int param1, int param2, boolean isSelected) {
            this.param1 = param1;
            this.param2 = param2;
            this.isSelected = isSelected;
        }
    }
}

