/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.designer;

import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.eas.base.uict.BizConfigureItemCollection;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import com.kingdee.eas.base.uict.EmptyConfigureItemInfo;
import com.kingdee.eas.base.uict.client.BizConfigureTreeNode;
import com.kingdee.eas.base.uict.client.designer.ITableCalculateStrategy;
import com.kingdee.eas.base.uict.client.designer.Table;
import com.kingdee.eas.base.uict.client.designer.TableCell;
import com.kingdee.eas.base.uict.client.designer.TableColumn;
import com.kingdee.eas.base.uict.client.designer.TableRow;
import com.kingdee.eas.base.uict.client.util.BizConfigureHelper;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Iterator;

public class DefaultTableCalculator
implements ITableCalculateStrategy {
    public static int HSPACE = 8;
    public static int VSPACE = 8;
    public static int HLARGESPACE = 50;
    public static int VLARGESPACE = 20;
    private HashSet nodesTraival = new HashSet();

    public Table calculate(BizConfigureTreeNode treeNode, boolean includeInvisible) {
        if (treeNode.getUserObject() == null || !(treeNode.getUserObject() instanceof ComponentInfo)) {
            return null;
        }
        ComponentInfo component = (ComponentInfo)treeNode.getUserObject();
        this.nodesTraival.clear();
        this.traivalNode(treeNode);
        Rectangle rect = BizConfigureHelper.getBounds2(component);
        if (rect == null) {
            return null;
        }
        Table table = new Table(rect);
        BizConfigureItemCollection items = treeNode.getConfigureItems();
        if (items.size() > 0) {
            int n = items.size();
            for (int i = 0; i < n; ++i) {
                BizConfigureItemInfo item = items.get(i);
                if (!includeInvisible && !item.isVisible()) continue;
                Iterator nodeIterator = this.nodesTraival.iterator();
                String componentName = item.getName().toString();
                boolean isAddIn = true;
                while (nodeIterator.hasNext()) {
                    BizConfigureTreeNode node = (BizConfigureTreeNode)((Object)nodeIterator.next());
                    ComponentInfo cInfo = (ComponentInfo)node.getUserObject();
                    if (!cInfo.getName().equals(componentName)) continue;
                    isAddIn = false;
                }
                if (!isAddIn) continue;
                this.addConfigureItemToTable(table, item);
            }
        } else {
            this.addEmptyItemToTable(table);
        }
        this.adjustTableRows(table);
        this.adjustTableColumns(table);
        this.adjustTableCells(table);
        return table;
    }

    private void traivalNode(BizConfigureTreeNode root) {
        int j = root.getChildCount();
        for (int i = 0; i < j; ++i) {
            BizConfigureTreeNode node = (BizConfigureTreeNode)((Object)root.getChildAt(i));
            ComponentInfo cInfo = (ComponentInfo)node.getUserObject();
            String visible = cInfo.getExtendedProperty("_Container_Visible");
            if ("false".equals(visible)) {
                this.nodesTraival.add(node);
            }
            if (node.getChildCount() <= 0) continue;
            this.traivalNode(node);
        }
    }

    private int calculateRowSpan(Table table, int index, int height) {
        int result = 1;
        TableRow row = table.getRow(index);
        int n = table.getRowCount();
        for (int i = index + 1; i < n; ++i) {
            TableRow nextRow = table.getRow(i);
            if (this.fuzzyCompare(row.getTop() + height, nextRow.getTop(), VSPACE) <= 0) break;
            ++result;
        }
        return result;
    }

    private int calculateColumnSpan(Table table, int index, int width) {
        int result = 1;
        TableColumn column = table.getColumn(index);
        int n = table.getColumnCount();
        for (int i = index + 1; i < n; ++i) {
            TableColumn nextColumn = table.getColumn(i);
            if (this.fuzzyCompare(column.getLeft() + width, nextColumn.getLeft(), VSPACE) <= 0) break;
            ++result;
        }
        return result;
    }

    private void adjustTableCells(Table table) {
        int result = 0;
        boolean changeRow = true;
        boolean changeColumn = true;
        while (changeRow || changeColumn) {
            changeRow = false;
            changeColumn = false;
            for (int i = 0; i < table.getRowCount(); ++i) {
                TableRow row = table.getRow(i);
                for (int j = 0; j < table.getColumnCount(); ++j) {
                    BizConfigureItemInfo item;
                    Rectangle bounds;
                    TableColumn column = table.getColumn(j);
                    TableCell cell = table.getCell(i, j);
                    table.unMergeCell(cell);
                    if (cell.getData() == null || !(cell.getData() instanceof BizConfigureItemInfo) || (bounds = (item = (BizConfigureItemInfo)cell.getData()).getBounds()) == null) continue;
                    int rowSpan = this.calculateRowSpan(table, i, bounds.height);
                    int columnSpan = this.calculateColumnSpan(table, j, bounds.width);
                    result = this.fuzzyCompare(row.getTop() + bounds.height, table.getRow(i + rowSpan - 1).getTop() + table.getRow(i + rowSpan - 1).getHeight(), VLARGESPACE);
                    if (result != 0) {
                        TableRow newRow;
                        if (result > 0) {
                            newRow = table.insertRow(i + rowSpan);
                            newRow.setTop(table.getRow(i + rowSpan - 1).getTop() + table.getRow(i + rowSpan - 1).getHeight());
                            newRow.setHeight(row.getTop() + bounds.height - newRow.getTop());
                        } else if (result < 0) {
                            newRow = table.splitRow(i + rowSpan - 1, row.getTop() + bounds.height);
                        }
                        changeRow = true;
                        ++rowSpan;
                    }
                    if ((result = this.fuzzyCompare(column.getLeft() + bounds.width, table.getColumn(j + columnSpan - 1).getLeft() + table.getColumn(j + columnSpan - 1).getWidth(), HLARGESPACE)) != 0) {
                        TableColumn newColumn;
                        if (result > 0) {
                            newColumn = table.insertColumn(j + columnSpan);
                            newColumn.setLeft(table.getColumn(j + columnSpan - 1).getLeft() + table.getColumn(j + columnSpan - 1).getWidth());
                            newColumn.setWidth(column.getLeft() + bounds.width - newColumn.getLeft());
                        } else if (result < 0) {
                            newColumn = table.splitColumn(j + columnSpan - 1, column.getLeft() + bounds.width);
                        }
                        changeColumn = true;
                        ++columnSpan;
                    }
                    item.setWidth(columnSpan);
                    item.setHeight(rowSpan);
                    if (rowSpan == 1 && columnSpan == 1) continue;
                    table.mergeCell(i, j, i + rowSpan - 1, j + columnSpan - 1);
                }
            }
        }
    }

    private void adjustTableRows(Table table) {
        if (table == null || table.getRowCount() == 0) {
            return;
        }
        int largestHeight = 0;
        int validHeight = 0;
        int m = table.getRowCount() - 1;
        for (int i = 0; i < m; ++i) {
            if (table.getRow(i).getTop() + table.getRow(i).getHeight() <= table.getRow(i + 1).getTop()) continue;
            largestHeight = table.getRow(i + 1).getTop() - table.getRow(i).getTop();
            validHeight = 0;
            int n = table.getColumnCount();
            for (int j = 0; j < n; ++j) {
                BizConfigureItemInfo item;
                Rectangle bounds;
                TableCell cell = table.getCell(i, j);
                if (cell.getData() == null || !(cell.getData() instanceof BizConfigureItemInfo) || (bounds = (item = (BizConfigureItemInfo)cell.getData()).getBounds()) == null || bounds.height >= largestHeight || bounds.width <= validHeight) continue;
                validHeight = bounds.height;
            }
            if (validHeight == 0) {
                table.getRow(i).setHeight(largestHeight);
                continue;
            }
            table.getRow(i).setHeight(validHeight);
        }
    }

    private void adjustTableColumns(Table table) {
        if (table == null || table.getColumnCount() == 0) {
            return;
        }
        int largestWidth = 0;
        int validWidth = 0;
        int n = table.getColumnCount() - 1;
        for (int j = 0; j < n; ++j) {
            if (table.getColumn(j).getLeft() + table.getColumn(j).getWidth() <= table.getColumn(j + 1).getLeft()) continue;
            largestWidth = table.getColumn(j + 1).getLeft() - table.getColumn(j).getLeft() - HSPACE;
            validWidth = 0;
            int m = table.getRowCount();
            for (int i = 0; i < m; ++i) {
                BizConfigureItemInfo item;
                Rectangle bounds;
                TableCell cell = table.getCell(i, j);
                if (cell.getData() == null || !(cell.getData() instanceof BizConfigureItemInfo) || (bounds = (item = (BizConfigureItemInfo)cell.getData()).getBounds()) == null || bounds.width >= largestWidth || bounds.width <= validWidth) continue;
                validWidth = bounds.width;
            }
            if (validWidth == 0) {
                table.getColumn(j).setWidth(largestWidth);
                continue;
            }
            table.getColumn(j).setWidth(validWidth);
        }
    }

    private TableRow createRow(Table table, BizConfigureItemInfo item) {
        TableRow row;
        int i;
        int top = item.getBounds().y;
        int height = item.getBounds().height;
        int n = table.getRowCount();
        for (i = 0; i < n && top >= (row = table.getRow(i)).getTop(); ++i) {
        }
        row = i == table.getRowCount() ? table.addRow() : table.insertRow(i);
        row.setTop(top);
        row.setHeight(height);
        return row;
    }

    private int fuzzyCompare(int a, int b, int scope) {
        if (Math.abs(a - b) <= scope) {
            return 0;
        }
        if (a > b) {
            return 1;
        }
        return -1;
    }

    private TableColumn createColumn(Table table, BizConfigureItemInfo item) {
        TableColumn column;
        int i;
        int left = item.getBounds().x;
        int width = item.getBounds().width;
        int n = table.getColumnCount();
        for (i = 0; i < n && left >= (column = table.getColumn(i)).getLeft(); ++i) {
        }
        column = i == table.getColumnCount() ? table.addColumn() : table.insertColumn(i);
        column.setLeft(left);
        column.setWidth(width);
        return column;
    }

    private void addConfigureItemToTable(Table table, BizConfigureItemInfo item) {
        Rectangle rect = item.getBounds();
        if (rect == null) {
            return;
        }
        TableRow row = this.findRow(table, rect.y);
        TableColumn column = this.findColumn(table, rect.x);
        if (row == null) {
            row = this.createRow(table, item);
        }
        if (column == null) {
            column = this.createColumn(table, item);
        }
        table.getCell(row.getIndex(), column.getIndex()).setData(item);
    }

    private void addEmptyItemToTable(Table table) {
        EmptyConfigureItemInfo empty = new EmptyConfigureItemInfo();
        empty.setBounds(new Rectangle(10, 10, 170, 19));
        TableRow row = this.createRow(table, empty);
        TableColumn column = this.createColumn(table, empty);
    }

    private TableRow findRow(Table table, int top) {
        int n = table.getRowCount();
        for (int i = 0; i < n; ++i) {
            TableRow item = table.getRow(i);
            if (item.getTop() - VSPACE >= top || top >= item.getTop() + VSPACE) continue;
            return item;
        }
        return null;
    }

    private TableColumn findColumn(Table table, int left) {
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn item = table.getColumn(i);
            if (item.getLeft() - HSPACE >= left || left >= item.getLeft() + HSPACE) continue;
            return item;
        }
        return null;
    }
}

