/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.designer;

import com.kingdee.eas.base.uict.BizConfigureItemCollection;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import com.kingdee.eas.base.uict.EmptyConfigureItemInfo;
import com.kingdee.eas.base.uict.client.designer.DefaultTableCalculator;
import com.kingdee.eas.base.uict.client.designer.Table;
import com.kingdee.eas.base.uict.client.designer.TableCell;
import com.kingdee.eas.base.uict.client.designer.TableColumn;
import com.kingdee.eas.base.uict.client.designer.TableRow;
import java.awt.Rectangle;

public class TableListConverter {
    private Table table = null;

    public TableListConverter(Table table) {
        this.table = table;
    }

    public BizConfigureItemCollection generateList() {
        BizConfigureItemCollection list = new BizConfigureItemCollection();
        if (this.table != null) {
            int m = this.table.getRowCount();
            for (int i = 0; i < m; ++i) {
                int n = this.table.getColumnCount();
                for (int j = 0; j < n; ++j) {
                    TableCell cell = this.table.getCell(i, j);
                    if (cell.isMerged() && cell != cell.getMergedCell()) continue;
                    Object data = cell.getData();
                    if (data != null) {
                        list.add((BizConfigureItemInfo)data);
                        continue;
                    }
                    list.add(new EmptyConfigureItemInfo());
                }
            }
        }
        return list;
    }

    private BizConfigureItemCollection reGenerateList(BizConfigureItemCollection list) {
        if (list != null) {
            list.clear();
            if (this.table != null) {
                boolean isRowNull = true;
                for (int i = 0; i < this.table.getRowCount(); ++i) {
                    TableCell cell;
                    int j;
                    isRowNull = true;
                    for (j = 0; j < this.table.getColumnCount(); ++j) {
                        cell = this.table.getCell(i, j);
                        if (cell.getData() == null) continue;
                        isRowNull = false;
                        break;
                    }
                    if (isRowNull) {
                        this.table.removeRow(i);
                        --i;
                        continue;
                    }
                    int n = this.table.getColumnCount();
                    for (j = 0; j < n; ++j) {
                        cell = this.table.getCell(i, j);
                        if (cell.isMerged() && cell != cell.getMergedCell()) continue;
                        Object data = cell.getData();
                        if (data != null) {
                            list.add((BizConfigureItemInfo)data);
                            continue;
                        }
                        EmptyConfigureItemInfo empty = new EmptyConfigureItemInfo();
                        cell.setData(empty);
                        list.add(empty);
                    }
                }
            }
        }
        return list;
    }

    private void resetTable(int columnCount) {
        int i;
        if (this.table.getColumnCount() > columnCount) {
            for (int i2 = this.table.getColumnCount() - 1; i2 > columnCount - 1; --i2) {
                this.table.removeColumn(i2);
            }
        } else if (this.table.getColumnCount() < columnCount) {
            int width = this.table.getWidth() / columnCount - 16;
            for (i = this.table.getColumnCount(); i < columnCount; ++i) {
                this.table.addColumn();
            }
            int n = this.table.getColumnCount();
            for (i = 0; i < n; ++i) {
                this.table.getColumn(i).setLeft(8 + width * i + 8 * i);
                this.table.getColumn(i).setWidth(width);
            }
        }
        int m = this.table.getRowCount();
        for (i = 0; i < m; ++i) {
            int n = this.table.getColumnCount();
            for (int j = 0; j < n; ++j) {
                TableCell cell = this.table.getCell(i, j);
                if (cell.isMerged() && cell == cell.getMergedCell()) {
                    this.table.unMergeCell(cell);
                }
                cell.setData(null);
            }
        }
    }

    public boolean validateTableColumnCount(BizConfigureItemCollection list, int columnCount) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            BizConfigureItemInfo item = list.get(i);
            if (item.getWidth() <= columnCount) continue;
            return false;
        }
        return true;
    }

    private void ensureRows(Table table, int rowCount) {
        if (table.getRowCount() < rowCount) {
            int beginPos = DefaultTableCalculator.VSPACE;
            TableRow lastRow = table.getRow(table.getRowCount() - 1);
            if (lastRow != null) {
                beginPos = lastRow.getTop() + lastRow.getHeight() + DefaultTableCalculator.VSPACE;
            }
            for (int i = table.getRowCount(); i < rowCount; ++i) {
                TableRow row = table.addRow();
                row.setTop(beginPos);
                row.setHeight(DefaultTableCalculator.VLARGESPACE);
                beginPos += DefaultTableCalculator.VLARGESPACE + DefaultTableCalculator.VSPACE;
            }
        }
    }

    public void updateTable(BizConfigureItemCollection list, int columnCount) {
        BizConfigureItemInfo item;
        TableCell cell;
        if (this.table == null) {
            return;
        }
        int index = 0;
        this.resetTable(columnCount);
        boolean notEnoughWidth = false;
        if (!this.validateTableColumnCount(list, columnCount)) {
            return;
        }
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            for (int j = 0; j < this.table.getColumnCount(); ++j) {
                cell = this.table.getCell(i, j);
                if (index >= list.size()) continue;
                item = list.get(index);
                this.ensureRows(this.table, i + item.getHeight());
                if (!cell.isMerged()) {
                    if (item.getWidth() > 1) {
                        if (this.table.getColumnCount() - j >= item.getWidth()) {
                            notEnoughWidth = false;
                            for (int k = j + 1; k < j + item.getWidth(); ++k) {
                                if (!this.table.getCell(i, k).isMerged()) continue;
                                notEnoughWidth = true;
                                break;
                            }
                            if (!notEnoughWidth) {
                                this.table.getCell(i, j).setData(list.get(index));
                                this.table.mergeCell(i, j, i + item.getHeight() - 1, j + item.getWidth() - 1);
                                ++index;
                            }
                        }
                    } else {
                        this.table.getCell(i, j).setData(list.get(index));
                        if (item.getHeight() > 1) {
                            this.table.mergeCell(i, j, i + item.getHeight() - 1, j);
                        }
                        ++index;
                    }
                }
                if (index >= list.size()) continue;
                item = list.get(index);
                if (j != this.table.getColumnCount() - 1) continue;
                this.ensureRows(this.table, i + item.getHeight() + 1);
            }
        }
        this.reGenerateList(list);
        int m = this.table.getRowCount();
        for (int i = 0; i < m; ++i) {
            int n = this.table.getColumnCount();
            for (int j = 0; j < n; ++j) {
                cell = this.table.getCell(i, j);
                if (cell.isMerged() && cell != cell.getMergedCell() || cell.getData() == null) continue;
                item = (BizConfigureItemInfo)cell.getData();
                Rectangle rect = new Rectangle();
                rect.x = this.table.getColumn(cell.getColumnIndex()).getLeft();
                rect.y = this.table.getRow(cell.getRowIndex()).getTop();
                rect.width = this.table.getColumn(cell.getColumnIndex()).getWidth();
                rect.height = this.table.getRow(cell.getRowIndex()).getHeight();
                if (cell.getRowSpan() > 1) {
                    TableRow spanEndRow = this.table.getRow(cell.getRowIndex() + cell.getRowSpan() - 1);
                    rect.height = spanEndRow.getTop() + spanEndRow.getHeight() - rect.y;
                }
                if (cell.getColumnSpan() > 1) {
                    TableColumn spanEndColumn = this.table.getColumn(cell.getColumnIndex() + cell.getColumnSpan() - 1);
                    rect.width = spanEndColumn.getLeft() + spanEndColumn.getWidth() - rect.x;
                }
                item.setBounds(rect);
            }
        }
        this.processEmptyHeight(this.table);
        int heightDiff = 0;
        int n = this.table.getRowCount();
        for (int i = 0; i < n; ++i) {
            int currentRowHeight = this.table.getRow(i).getHeight();
            int maxRowHeight = this.getMaxRowHeight(this.table, i);
            if (maxRowHeight == -1) continue;
            heightDiff = maxRowHeight - currentRowHeight;
            this.adjustRowHeight(this.table, i, heightDiff);
        }
    }

    private void processEmptyHeight(Table table) {
        int maxHeight = -1;
        int n = table.getRowCount();
        for (int i = 0; i < n; ++i) {
            TableCell cell;
            int j;
            TableRow row = table.getRow(i);
            maxHeight = -1;
            int m = table.getColumnCount();
            for (j = 0; j < m; ++j) {
                cell = row.getCell(j);
                if (cell.isMerged() && cell != cell.getMergedCell() || cell.getData() == null || cell.getRowSpan() != 1 || cell.getData() instanceof EmptyConfigureItemInfo) continue;
                BizConfigureItemInfo item = (BizConfigureItemInfo)cell.getData();
                maxHeight = maxHeight < item.getBounds().height ? item.getBounds().height : maxHeight;
            }
            m = table.getColumnCount();
            for (j = 0; j < m; ++j) {
                cell = row.getCell(j);
                if (cell.isMerged() && cell != cell.getMergedCell() || cell.getData() == null || cell.getRowSpan() != 1 || !(cell.getData() instanceof EmptyConfigureItemInfo)) continue;
                ((BizConfigureItemInfo)cell.getData()).getBounds().height = maxHeight != -1 ? maxHeight : 20;
            }
        }
    }

    private void adjustRowHeight(Table table, int rowIndex, int diff) {
        TableRow row = table.getRow(rowIndex);
        row.setHeight(row.getHeight() + diff);
        int n = table.getRowCount();
        for (int i = rowIndex + 1; i < n; ++i) {
            row = table.getRow(i);
            row.setTop(row.getTop() + diff);
            int m = table.getColumnCount();
            for (int j = 0; j < m; ++j) {
                TableCell cell = row.getCell(j);
                BizConfigureItemInfo item = (BizConfigureItemInfo)cell.getData();
                if (item == null || item.getBounds() == null) continue;
                item.getBounds().y = row.getTop();
            }
        }
    }

    private int getMaxRowHeight(Table table, int rowIndex) {
        int maxRowHeight = -1;
        TableRow row = table.getRow(rowIndex);
        int m = table.getColumnCount();
        for (int j = 0; j < m; ++j) {
            TableCell cell = row.getCell(j);
            if (cell.getRowSpan() > 1) {
                return -1;
            }
            BizConfigureItemInfo item = (BizConfigureItemInfo)cell.getData();
            if (item == null || item.getBounds() == null || item.getBounds().height <= maxRowHeight) continue;
            maxRowHeight = item.getBounds().height;
        }
        return maxRowHeight;
    }
}

