/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.editor;

import com.kingdee.eas.base.uict.client.editor.EditPart;
import com.kingdee.eas.base.uict.client.editor.EditPartViewer;
import com.kingdee.eas.base.uict.client.editor.EditPolicy;
import com.kingdee.eas.base.uict.client.editor.Request;
import com.kingdee.eas.base.uict.client.editor.commands.Command;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractEditPart
implements EditPart {
    protected Rectangle rect = new Rectangle();
    protected Object model;
    protected EditPartViewer viewer;
    private Map policies = new HashMap();
    private List iter = new ArrayList(5);

    public AbstractEditPart() {
        this.createEditPolicies();
    }

    public void setViewer(EditPartViewer viewer) {
        this.viewer = viewer;
    }

    public EditPartViewer getViewer() {
        return this.viewer;
    }

    public Object getModel() {
        return this.model;
    }

    public void setModel(Object obj) {
        this.model = obj;
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    protected abstract void refreshVisuals();

    protected abstract void createEditPolicies();

    public void installEditPolicy(Object key, EditPolicy editPolicy) {
        this.policies.put(key, editPolicy);
        editPolicy.setHost(this);
    }

    public Iterator getEditPolicyIterator() {
        Set set = this.policies.keySet();
        this.iter.clear();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            this.iter.add(this.policies.get(i.next()));
        }
        return this.iter.iterator();
    }

    public void sendRequest(Request request) {
        Set set = this.policies.keySet();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            Command command;
            EditPolicy ep = (EditPolicy)this.policies.get(i.next());
            if (!ep.understandsRequest(request) || (command = ep.getCommand(request)) == null) continue;
            this.getViewer().getCommandStack().execute(command);
        }
    }

    public void performRequest(Request request) {
    }

    public Rectangle getBounds() {
        return this.rect;
    }
}

