/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.editor;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import com.kingdee.eas.base.uict.client.editor.AbstractEditPart;
import com.kingdee.eas.base.uict.client.editor.EditPartViewer;
import com.kingdee.eas.base.uict.client.editor.Request;
import com.kingdee.eas.base.uict.client.editor.UictEditPartViewer;
import com.kingdee.eas.base.uict.client.editor.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.base.uict.client.editor.policy.ChangeContainerPolicy;
import com.kingdee.eas.base.uict.client.editor.policy.DirectEditPolicy;
import com.kingdee.eas.base.uict.client.editor.policy.ResizePolicy;
import com.kingdee.eas.base.uict.client.editor.ui.UictDetailPanel;
import com.kingdee.eas.base.uict.client.editor.util.figure.FigureHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class CommonEditPart
extends AbstractEditPart {
    private static final Logger logger = CoreUIObject.getLogger((Class)CommonEditPart.class);
    private BufferedImage figure;
    private Component component;
    private boolean isMoveIn = false;
    private boolean isSelected = false;
    private boolean isMultiSelected = false;
    private BasicStroke _3fbs = new BasicStroke(3.0f);

    public CommonEditPart(BizConfigureItemInfo item) {
        if (item == null) {
            logger.error((Object)"BizConfigureItemInfo is null,can not create the editpart!");
            return;
        }
        ComponentInfo cInfo = item.getComponent();
        Rectangle rect = item.getBounds();
        FigureHelper.ComponentParam cp = FigureHelper.getComponentParam(item);
        this.component = CommonEditPart.createComponent(cInfo, cp);
        if (this.component != null) {
            this.component.setBounds(rect);
        }
    }

    public void activate() {
        ((BizConfigureItemInfoAdapter)this.getModel()).addPropertyChangeListener(this);
    }

    public void deactivate() {
        ((BizConfigureItemInfoAdapter)this.getModel()).removePropertyChangeListener(this);
    }

    public void performRequest(Request request) {
        if ("move in".equals(request.getType())) {
            if (!this.isMoveIn) {
                this.isMoveIn = true;
                this.refreshVisuals();
            }
        } else if ("move out".equals(request.getType())) {
            if (this.isMoveIn) {
                this.isMoveIn = false;
                this.refreshVisuals();
            }
        } else if ("selected".equals(request.getType())) {
            if (!this.isSelected) {
                this.isSelected = true;
                this.isMultiSelected = false;
                this.refreshVisuals();
            }
        } else if ("multiselected".equals(request.getType())) {
            if (!this.isMultiSelected) {
                this.isSelected = false;
                this.isMultiSelected = true;
                this.refreshVisuals();
            }
        } else if ("unselected".equals(request.getType()) && (this.isSelected || this.isMultiSelected)) {
            this.isSelected = false;
            this.isMultiSelected = false;
            this.refreshVisuals();
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("DirectEditPolicy", new DirectEditPolicy());
        this.installEditPolicy("ChangeContainerPolicy", new ChangeContainerPolicy());
        this.installEditPolicy("ResizePolicy", new ResizePolicy());
    }

    public BufferedImage getFigure() {
        if (this.figure == null) {
            this.figure = this.createFigure();
        }
        return this.figure;
    }

    public Component getComponent() {
        return this.component;
    }

    protected BufferedImage createFigure() {
        return FigureHelper.drawAlphaImage(this.getBounds().getSize(), 0.0f, Color.white, false);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("rectangle") && evt.getPropertyName().equals("rectangle") && evt.getNewValue() instanceof Rectangle && (Rectangle)evt.getNewValue() != null) {
            if (this.component != null && !((Rectangle)evt.getNewValue()).equals(this.component.getBounds())) {
                this.component.setBounds((Rectangle)evt.getNewValue());
            }
            if (this.figure == null || this.figure.getWidth() != (int)((Rectangle)evt.getNewValue()).getWidth() || this.figure.getHeight() != (int)((Rectangle)evt.getNewValue()).getHeight()) {
                this.refreshVisuals();
            }
        }
    }

    public void setViewer(EditPartViewer viewer) {
        super.setViewer(viewer);
        if (this.component != null) {
            ((UictEditPartViewer)viewer).add(this.component);
        }
    }

    public void refreshVisuals() {
        Graphics g;
        this.figure = this.createFigure();
        if (this.isMoveIn) {
            g = this.figure.getGraphics();
            g.setColor(Color.red);
            ((Graphics2D)g).setStroke(this._3fbs);
            g.drawRect(0, 0, this.figure.getWidth() - 1, this.figure.getHeight() - 1);
        }
        if (this.isSelected) {
            g = this.figure.getGraphics();
            g.setColor(Color.orange);
            ((Graphics2D)g).setStroke(this._3fbs);
            g.drawRect(0, 0, this.figure.getWidth() - 1, this.figure.getHeight() - 1);
        }
        if (this.isMultiSelected) {
            g = this.figure.getGraphics();
            g.setColor(Color.green);
            ((Graphics2D)g).setStroke(this._3fbs);
            g.drawRect(0, 0, this.figure.getWidth() - 1, this.figure.getHeight() - 1);
        }
    }

    public Rectangle getBounds() {
        return ((BizConfigureItemInfoAdapter)this.getModel()).getItem().getBounds();
    }

    private static Component createComponent(ComponentInfo cInfo, FigureHelper.ComponentParam cp) {
        if (cInfo == null) {
            return null;
        }
        Component control = null;
        String classType = cInfo.getClassType();
        try {
            control = (Component)Class.forName(classType).newInstance();
            control.setName(cInfo.getName());
            if (control instanceof JComponent) {
                ((JComponent)control).setOpaque(true);
            }
            control.setEnabled(cp.enabled);
            Method method = null;
            try {
                method = control.getClass().getMethod("setRequired", Boolean.TYPE);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (method != null) {
                method.invoke((Object)control, cp.required);
            }
            if ("com.kingdee.bos.ctrl.swing.KDCheckBox".equals(cInfo.getClassType())) {
                if (control instanceof KDCheckBox) {
                    ((KDCheckBox)control).setText(cp.boundLabelText);
                }
            } else if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(cInfo.getClassType())) {
                PropertyInfo propInfo = cInfo.getPropertyByName("formatXml");
                if (propInfo != null) {
                    ((KDTable)control).setFormatXml(propInfo.getValue());
                    ((KDTable)control).checkParsed();
                    String buildDetail = cInfo.getExtendedProperty("buildDetail");
                    if ("true".equals(buildDetail)) {
                        UictDetailPanel udp = new UictDetailPanel((KDTable)control);
                        control = udp;
                    }
                }
            } else if ("com.kingdee.bos.ctrl.swing.KDLabel".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDButton".equals(cInfo.getClassType())) {
                method = null;
                try {
                    method = control.getClass().getMethod("setText", String.class);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (method != null) {
                    method.invoke((Object)control, cp.text);
                }
                if ("com.kingdee.bos.ctrl.swing.KDLabel".equals(cInfo.getClassType())) {
                    KDLabel label = (KDLabel)control;
                    label.setBackground(Color.gray);
                }
            }
            if (cInfo.getParent() != null) {
                if ("com.kingdee.bos.ctrl.swing.KDScrollPane".equals(cInfo.getParent().getClassType())) {
                    cInfo = cInfo.getParent();
                    KDScrollPane scrollPaneNoteField = new KDScrollPane();
                    scrollPaneNoteField.getViewport().add(control, null);
                    control = scrollPaneNoteField;
                }
                if ("com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(cInfo.getParent().getClassType())) {
                    KDLabelContainer lblContainer = new KDLabelContainer();
                    lblContainer.setBoundLabelText(cp.boundLabelText);
                    lblContainer.setBoundLabelLength(cp.boundLabelLength);
                    lblContainer.setBoundLabelUnderline(cp.boundLabelUnderline);
                    lblContainer.setBoundLabelAlignment(cp.boundLabelAlignment);
                    lblContainer.getBoundLabel().setOpaque(true);
                    lblContainer.setBoundEditor((JComponent)control);
                    control = lblContainer;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return control;
    }
}

