/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.editor;

import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.eas.base.uict.client.BizConfigureTreeNode;
import com.kingdee.eas.base.uict.client.editor.AbstractEditPart;
import com.kingdee.eas.base.uict.client.editor.EditPartViewer;
import com.kingdee.eas.base.uict.client.editor.UictEditPartViewer;
import com.kingdee.eas.base.uict.client.editor.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.base.uict.client.editor.ui.UictKDTabbedPane;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JScrollPane;

public class TabbedPaneEditPart
extends AbstractEditPart {
    BizConfigureTreeNode tabbedPanelNode;
    protected UictKDTabbedPane tabbedPane;
    protected List childViewerList = new ArrayList(3);

    public TabbedPaneEditPart(BizConfigureTreeNode tabbedPanelNode, Rectangle rect) {
        this.tabbedPanelNode = tabbedPanelNode;
        this.tabbedPane = new UictKDTabbedPane();
        this.tabbedPane.setBounds(rect);
    }

    private void deepPanel(BizConfigureTreeNode node, UictKDTabbedPane tabpane) {
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            BizConfigureTreeNode child = (BizConfigureTreeNode)((Object)node.getChildAt(i));
            if (!(child.getUserObject() instanceof ComponentInfo)) continue;
            ComponentInfo cInfo = (ComponentInfo)child.getUserObject();
            String title = cInfo.getConstraint() instanceof String ? cInfo.getConstraint().toString() : "\u5206\u7ec4";
            if ("com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(cInfo.getClassType())) {
                UictKDTabbedPane childTabbedPane = new UictKDTabbedPane();
                childTabbedPane.setContext(this.viewer.getContext());
                this.deepPanel(child, childTabbedPane);
                tabpane.add((Component)((Object)childTabbedPane), title);
                continue;
            }
            UictEditPartViewer childViewer = new UictEditPartViewer(child, null, this.viewer.getContext());
            JScrollPane sp = this.createScrollPane(childViewer);
            tabpane.add(sp, title);
            this.childViewerList.add(childViewer);
        }
    }

    private JScrollPane createScrollPane(UictEditPartViewer innerViewer) {
        JScrollPane sp = new JScrollPane();
        sp.setViewportView(innerViewer);
        sp.setHorizontalScrollBarPolicy(30);
        sp.setVerticalScrollBarPolicy(20);
        sp.setBounds(innerViewer.getBounds());
        return sp;
    }

    public void setViewer(EditPartViewer viewer) {
        this.viewer = viewer;
        this.tabbedPane.setContext(viewer.getContext());
        this.deepPanel(this.tabbedPanelNode, this.tabbedPane);
        ((UictEditPartViewer)viewer).getMaskPanel().add((Component)((Object)this.tabbedPane));
        ((UictEditPartViewer)viewer).revalidate();
        Iterator iter = this.childViewerList.iterator();
        while (iter.hasNext()) {
            UictEditPartViewer childViewer = (UictEditPartViewer)iter.next();
            ((UictEditPartViewer)viewer).addChildViewer(childViewer);
            childViewer.setParentViewer((UictEditPartViewer)viewer);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("rectangle") && this.tabbedPane != null && evt.getNewValue() instanceof Rectangle) {
            this.tabbedPane.setBounds((Rectangle)evt.getNewValue());
        }
    }

    public Component getComponent() {
        return this.tabbedPane;
    }

    public BufferedImage getFigure() {
        return null;
    }

    protected void createEditPolicies() {
    }

    protected void refreshVisuals() {
    }

    public void activate() {
        ((BizConfigureItemInfoAdapter)this.getModel()).addPropertyChangeListener(this);
    }

    public void deactivate() {
        ((BizConfigureItemInfoAdapter)this.getModel()).removePropertyChangeListener(this);
    }
}

