/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.editor;

import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import com.kingdee.eas.base.uict.client.BizConfigureTreeNode;
import com.kingdee.eas.base.uict.client.editor.CommonEditPart;
import com.kingdee.eas.base.uict.client.editor.Context;
import com.kingdee.eas.base.uict.client.editor.EditPart;
import com.kingdee.eas.base.uict.client.editor.EditPartFactory;
import com.kingdee.eas.base.uict.client.editor.EditPartManager;
import com.kingdee.eas.base.uict.client.editor.EditPartViewer;
import com.kingdee.eas.base.uict.client.editor.Request;
import com.kingdee.eas.base.uict.client.editor.UictEditPartFactory;
import com.kingdee.eas.base.uict.client.editor.commands.Command;
import com.kingdee.eas.base.uict.client.editor.commands.CommandStack;
import com.kingdee.eas.base.uict.client.editor.listener.ISelectionChangedListener;
import com.kingdee.eas.base.uict.client.editor.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.base.uict.client.editor.policy.CombineOrSplitCellPolicy;
import com.kingdee.eas.base.uict.client.editor.policy.DeleteRowOrColumnPolicy;
import com.kingdee.eas.base.uict.client.editor.policy.InsertRowOrColumnPolicy;
import com.kingdee.eas.base.uict.client.editor.request.ChangeContainerRequest;
import com.kingdee.eas.base.uict.client.editor.request.CombineCellRequest;
import com.kingdee.eas.base.uict.client.editor.request.DeleteColumnRequest;
import com.kingdee.eas.base.uict.client.editor.request.DeleteRowRequest;
import com.kingdee.eas.base.uict.client.editor.request.DirectEditByInsteadRequest;
import com.kingdee.eas.base.uict.client.editor.request.DirectEditRequest;
import com.kingdee.eas.base.uict.client.editor.request.InsertColumnRequest;
import com.kingdee.eas.base.uict.client.editor.request.InsertRowRequest;
import com.kingdee.eas.base.uict.client.editor.request.MoveInRequest;
import com.kingdee.eas.base.uict.client.editor.request.MoveOutRequest;
import com.kingdee.eas.base.uict.client.editor.request.MultiSelectedRequest;
import com.kingdee.eas.base.uict.client.editor.request.ResizeRequest;
import com.kingdee.eas.base.uict.client.editor.request.RowPositionRequest;
import com.kingdee.eas.base.uict.client.editor.request.SelectedRequest;
import com.kingdee.eas.base.uict.client.editor.request.UnSelectedRequest;
import com.kingdee.eas.base.uict.client.editor.ui.UictKDTabbedPane;
import com.kingdee.eas.base.uict.client.editor.util.Area;
import com.kingdee.eas.base.uict.client.editor.util.TableHelper;
import com.kingdee.eas.base.uict.client.editor.util.UictEditorHelper;
import com.kingdee.eas.base.uict.client.editor.util.cursor.CursorHelper;
import com.kingdee.eas.base.uict.client.editor.util.figure.FigureHelper;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class UictEditPartViewer
extends JPanel
implements EditPartViewer,
MouseListener,
MouseMotionListener,
KeyListener,
PropertyChangeListener {
    private static Logger logger = Logger.getLogger((Class)UictEditPartViewer.class);
    private EditPartFactory factory;
    private Context context;
    private CommandStack commandStack;
    private EditPartManager partManager;
    int x;
    int y;
    int tx;
    int ty;
    Dimension initCavansSize = new Dimension();
    private BufferedImage imageComponent = null;
    private SelectedRequest selectedRequest = new SelectedRequest();
    private MultiSelectedRequest multiSelectedRequest = new MultiSelectedRequest();
    private UnSelectedRequest unSelectedRequest = new UnSelectedRequest();
    private MoveInRequest moveInRequest = new MoveInRequest();
    private MoveOutRequest moveOutRequest = new MoveOutRequest();
    private BizConfigureTreeNode node;
    private List gridList;
    private Map itemAdapterMap = new HashMap();
    private UictEditPartViewer parentViewer;
    private List childViewer = new ArrayList(2);
    private boolean drawBorder = false;
    private boolean isResizing = false;
    private boolean isExited = false;
    private int border = 0;
    private BasicStroke _5fbs = new BasicStroke(4.0f);
    private BasicStroke _3fbs = new BasicStroke(3.0f);
    private KDPopupMenu popMenu = new KDPopupMenu();
    private JMenuItem insertRowPop = null;
    private JMenuItem addRowPop = null;
    private JMenuItem insertColumnPop = null;
    private JMenuItem addColumnPop = null;
    private JMenuItem delRowPop = null;
    private JMenuItem delColumnPop = null;
    private JMenuItem combinePop = null;
    private JMenuItem splitPop = null;
    private JMenuItem widthPop = null;
    private JCheckBoxMenuItem showGridPop = null;
    private JCheckBoxMenuItem showContainerPop = null;
    private JPanel maskPanel = new JPanel(){

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            UictEditPartViewer.this.paintMaskPanel(g);
        }

        public boolean isFocusTraversable() {
            return true;
        }
    };
    Area area;

    public UictEditPartViewer(BizConfigureTreeNode node, Rectangle rect, Context context) {
        this.maskPanel.setOpaque(false);
        this.maskPanel.setBackground(Color.black);
        this.maskPanel.setLayout(null);
        this.maskPanel.addMouseListener(this);
        if (Context.STATUS_VIEW != context.getStatus()) {
            this.maskPanel.addMouseMotionListener(this);
            this.maskPanel.addKeyListener(this);
        }
        this.maskPanel.setBounds(new Rectangle(0, 0, 9999, 9999));
        if (rect != null) {
            this.setBounds(rect);
            this.initCavansSize.height = rect.height;
            this.initCavansSize.width = rect.width;
        }
        this.setLayout(null);
        this.add(this.maskPanel);
        this.context = context;
        this.context.addPropertyChangeListener(this);
        this.commandStack = context.getCommandStack();
        this.node = node;
        node.updateTable();
        this.refreshGrid();
        this.factory = new UictEditPartFactory(node);
        this.partManager = new EditPartManager(this);
        this.createEditPart();
        this.initPopupmenu();
    }

    protected void initPopupmenu() {
        this.popMenu = new KDPopupMenu();
        this.insertRowPop = new JMenuItem("\u63d2\u5165\u884c");
        this.insertRowPop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UictEditPartViewer.this.insertOrAddPop_actionPerformed(e, "insert row", 0);
            }
        });
        this.popMenu.add(this.insertRowPop);
        this.addRowPop = new JMenuItem("\u6dfb\u52a0\u884c");
        this.addRowPop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UictEditPartViewer.this.insertOrAddPop_actionPerformed(e, "insert row", 1);
            }
        });
        this.popMenu.add(this.addRowPop);
        this.insertColumnPop = new JMenuItem("\u63d2\u5165\u5217");
        this.insertColumnPop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UictEditPartViewer.this.insertOrAddPop_actionPerformed(e, "insert column", 0);
            }
        });
        this.popMenu.add(this.insertColumnPop);
        this.addColumnPop = new JMenuItem("\u6dfb\u52a0\u5217");
        this.addColumnPop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UictEditPartViewer.this.insertOrAddPop_actionPerformed(e, "insert column", 1);
            }
        });
        this.popMenu.add(this.addColumnPop);
        this.delRowPop = new JMenuItem("\u5220\u9664\u884c");
        this.delRowPop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UictEditPartViewer.this.delRowPop_actionPerformed(e);
            }
        });
        this.popMenu.add(this.delRowPop);
        this.delColumnPop = new JMenuItem("\u5220\u9664\u5217");
        this.delColumnPop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UictEditPartViewer.this.delColumnPop_actionPerformed(e);
            }
        });
        this.popMenu.add(this.delColumnPop);
        this.popMenu.addSeparator();
        this.combinePop = new JMenuItem("\u5408\u5e76\u5355\u5143\u683c");
        this.combinePop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UictEditPartViewer.this.combinePop_actionPerformed(e);
            }
        });
        this.popMenu.add(this.combinePop);
        this.splitPop = new JMenuItem("\u62c6\u5206\u5355\u5143\u683c");
        this.splitPop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UictEditPartViewer.this.splitPop_actionPerformed(e);
            }
        });
        this.popMenu.add(this.splitPop);
        this.widthPop = new JMenuItem("\u5360\u7528\u5217\u6570");
        this.widthPop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UictEditPartViewer.this.widthPop_actionPerformed(e);
            }
        });
        this.popMenu.add(this.widthPop);
        this.popMenu.addSeparator();
        this.showGridPop = new JCheckBoxMenuItem("\u663e\u793a\u8868\u683c");
        this.showGridPop.setSelected(this.context.isShowGrid());
        this.showGridPop.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                UictEditPartViewer.this.context.setShowGrid(UictEditPartViewer.this.showGridPop.isSelected());
            }
        });
        this.popMenu.add((JMenuItem)this.showGridPop);
        this.showContainerPop = new JCheckBoxMenuItem("\u663e\u793a\u5bb9\u5668\u63d0\u793a");
        this.showContainerPop.setSelected(this.context.isShowContainer());
        this.showContainerPop.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                UictEditPartViewer.this.context.setShowContainer(UictEditPartViewer.this.showContainerPop.isSelected());
            }
        });
        this.popMenu.add((JMenuItem)this.showContainerPop);
    }

    public Context getContext() {
        return this.context;
    }

    public Map getItemAdapterMap() {
        return this.itemAdapterMap;
    }

    public BizConfigureTreeNode getNode() {
        return this.node;
    }

    public EditPartFactory getEditPartFactory() {
        return this.factory;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.partManager.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener l) {
        this.partManager.removeSelectionChangedListener(l);
    }

    public void select(EditPart editpart) {
        this.partManager.select(editpart);
    }

    public EditPart getSelection() {
        return this.partManager.getSelection();
    }

    public CommandStack getCommandStack() {
        return this.commandStack;
    }

    public JPanel getMaskPanel() {
        return this.maskPanel;
    }

    public void refreshGrid() {
        if (this.node != null) {
            this.gridList = TableHelper.getTableGridAreas(this.node.getTable());
        }
        this.refreshEditorUIRuler();
    }

    private void refreshEditorUIRuler() {
        if (this == this.context.getRootViewer() && this.context.getEditorUI() != null) {
            this.context.getEditorUI().refreshRuler();
        }
    }

    public void createEditPart() {
        if (this.factory == null) {
            logger.info((Object)"factory is null...");
            throw new NullPointerException("factory is null...");
        }
        Iterator iter = this.node.getList().iterator();
        while (iter.hasNext()) {
            EditPart part;
            BizConfigureItemInfoAdapter item = new BizConfigureItemInfoAdapter((BizConfigureItemInfo)iter.next());
            if (UictEditorHelper.contains(this.partManager, item.getItem()) || (part = this.factory.createEditPart(item)) == null) continue;
            part.setViewer(this);
            this.partManager.add(part);
            this.itemAdapterMap.put(item.getItem(), item);
        }
        UictEditorHelper.retainAll(this.partManager, this.itemAdapterMap, this.node.getList(), this);
    }

    public void paintMaskPanel(Graphics g) {
        Rectangle rt;
        int maxHeight = this.initCavansSize.height;
        int maxWidth = this.initCavansSize.width;
        Iterator iter = this.partManager.iterator();
        while (iter.hasNext()) {
            EditPart part = (EditPart)iter.next();
            BufferedImage figure = part.getFigure();
            Rectangle rect = part.getBounds();
            if (Context.STATUS_VIEW != this.context.getStatus() && figure != null) {
                g.drawImage(figure, rect.x, rect.y, figure.getWidth(), figure.getHeight(), this);
            }
            int conY = rect.y + rect.height;
            int conX = rect.x + rect.width;
            maxHeight = maxHeight < conY ? conY : maxHeight;
            maxWidth = maxWidth < conX ? conX : maxWidth;
        }
        EditPart selection = this.partManager.getSelection();
        if (selection != null && (rt = selection.getBounds()) != null) {
            int dir = 15;
            FigureHelper.drawPoint(g, rt, dir, Color.black);
        }
        maxHeight = maxHeight < this.initCavansSize.height ? this.initCavansSize.height : maxHeight;
        int n = maxWidth = maxWidth < this.initCavansSize.width ? this.initCavansSize.width : maxWidth;
        if (maxHeight != this.getHeight() || maxWidth != this.getWidth()) {
            Dimension viewerSize = this.getSize();
            Dimension newSize = new Dimension(viewerSize);
            newSize.height = maxHeight;
            newSize.width = maxWidth;
            this.setPreferredSize(newSize);
            this.revalidate();
        }
        if (Context.STATUS_VIEW != this.context.getStatus() && this.imageComponent != null && !this.isExited) {
            g.drawImage(this.imageComponent, this.x - this.tx, this.y - this.ty, this.imageComponent.getWidth(), this.imageComponent.getHeight(), this);
        }
        if (this.context.isShowGrid() && Context.STATUS_VIEW != this.context.getStatus()) {
            this.createGrid(g);
        }
        if (this.isResizing) {
            g.setColor(Color.gray);
            if (this.border == 2 || this.border == 3) {
                g.drawLine(0, this.y, this.getWidth(), this.y);
            } else {
                g.drawLine(this.x, 0, this.x, this.getHeight());
            }
        }
        if (this.drawBorder && this.context.isShowContainer()) {
            g.setColor(Color.blue);
            ((Graphics2D)g).setStroke(this._5fbs);
            g.drawRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private void createGrid(Graphics g) {
        float[] dash = new float[]{5.0f};
        BasicStroke bs = new BasicStroke(1.0f, 0, 0, 5.0f, dash, 0.0f);
        Graphics2D g_2d = (Graphics2D)g;
        Stroke back = g_2d.getStroke();
        g_2d.setStroke(bs);
        g_2d.setColor(Color.blue);
        if (this.gridList != null) {
            Iterator iter = this.gridList.iterator();
            while (iter.hasNext()) {
                this.area = (Area)iter.next();
                g_2d.drawLine(this.area.xLeft, this.area.yTop, this.area.xRight, this.area.yTop);
                g_2d.drawLine(this.area.xRight, this.area.yTop, this.area.xRight, this.area.yBottom);
                g_2d.drawLine(this.area.xLeft, this.area.yBottom, this.area.xRight, this.area.yBottom);
                g_2d.drawLine(this.area.xLeft, this.area.yTop, this.area.xLeft, this.area.yBottom);
            }
        }
        g_2d.setStroke(back);
    }

    public UictEditPartViewer getParentViewer() {
        return this.parentViewer;
    }

    public void setParentViewer(UictEditPartViewer parentViewer) {
        this.parentViewer = parentViewer;
    }

    public List getChildViewer() {
        return this.childViewer;
    }

    public void addChildViewer(UictEditPartViewer viewer) {
        this.childViewer.add(viewer);
    }

    public void mouseClicked(MouseEvent e) {
        if (Context.STATUS_VIEW == this.context.getStatus()) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(e) && !e.isControlDown()) {
            logger.info((Object)"single click...");
            Iterator iter = this.partManager.iterator();
            boolean findSelected = false;
            while (iter.hasNext()) {
                EditPart part = (EditPart)iter.next();
                Rectangle rect = part.getBounds();
                if ((double)e.getX() >= rect.getX() && (double)e.getX() <= rect.getX() + rect.getWidth() && (double)e.getY() >= rect.getY() && (double)e.getY() <= rect.getY() + rect.getHeight()) {
                    this.partManager.select(part);
                    part.performRequest(this.selectedRequest);
                    findSelected = true;
                    continue;
                }
                part.performRequest(this.unSelectedRequest);
            }
            if (!findSelected) {
                this.partManager.select(null);
            }
            this.partManager.clearMultiSelected();
            this.repaint();
        } else if (SwingUtilities.isLeftMouseButton(e) && e.isControlDown()) {
            logger.info((Object)"multi click...");
            if (this.partManager.getSelection() != null) {
                this.partManager.addMultiSelected(this.partManager.getSelection());
                this.partManager.getSelection().performRequest(this.multiSelectedRequest);
                this.partManager.select(null);
            }
            Iterator iter = this.partManager.iterator();
            while (iter.hasNext()) {
                EditPart part = (EditPart)iter.next();
                Rectangle rect = part.getBounds();
                if (!((double)e.getX() >= rect.getX()) || !((double)e.getX() <= rect.getX() + rect.getWidth()) || !((double)e.getY() >= rect.getY()) || !((double)e.getY() <= rect.getY() + rect.getHeight())) continue;
                if (this.partManager.containsMultiSelected(part)) {
                    this.partManager.removeMultiSelected(part);
                    part.performRequest(this.unSelectedRequest);
                    continue;
                }
                this.partManager.addMultiSelected(part);
                part.performRequest(this.multiSelectedRequest);
            }
            this.repaint();
        } else if (e.getClickCount() == 1 && SwingUtilities.isRightMouseButton(e)) {
            logger.info((Object)"single right click...");
            if (this.partManager.getMultiSelected().size() == 0) {
                Iterator iter = this.partManager.iterator();
                boolean findSelected = false;
                while (iter.hasNext()) {
                    EditPart part = (EditPart)iter.next();
                    Rectangle rect = part.getBounds();
                    if ((double)e.getX() >= rect.getX() && (double)e.getX() <= rect.getX() + rect.getWidth() && (double)e.getY() >= rect.getY() && (double)e.getY() <= rect.getY() + rect.getHeight()) {
                        this.partManager.select(part);
                        part.performRequest(this.selectedRequest);
                        findSelected = true;
                        continue;
                    }
                    part.performRequest(this.unSelectedRequest);
                }
                if (!findSelected) {
                    this.partManager.select(null);
                }
                this.partManager.clearMultiSelected();
                this.repaint();
            }
            if (this.partManager.getSelection() == null) {
                this.insertRowPop.setEnabled(false);
                this.addRowPop.setEnabled(false);
                this.insertColumnPop.setEnabled(false);
                this.addColumnPop.setEnabled(false);
                this.delRowPop.setEnabled(false);
                this.delColumnPop.setEnabled(false);
                this.splitPop.setEnabled(false);
                this.widthPop.setEnabled(false);
            } else {
                this.insertRowPop.setEnabled(true);
                this.addRowPop.setEnabled(true);
                this.insertColumnPop.setEnabled(true);
                this.addColumnPop.setEnabled(true);
                this.delRowPop.setEnabled(true);
                this.delColumnPop.setEnabled(true);
                this.splitPop.setEnabled(true);
                this.widthPop.setEnabled(true);
            }
            if (this.partManager.getMultiSelected().size() >= 2) {
                this.combinePop.setEnabled(true);
            } else {
                this.combinePop.setEnabled(false);
            }
            this.popMenu.show((Component)this, e.getX(), e.getY());
        }
        if (!SwingUtilities.isLeftMouseButton(e) || e.getClickCount() == 2) {
            // empty if block
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.isExited = false;
        this.context.setMouseInViewer(this);
        this.drawBorder = true;
        this.repaint();
        if (this.context.getDragViewer() != null && this.context.getDragViewer() != this) {
            this.setCursor(CursorHelper.getDragCursor());
        }
    }

    public void mouseExited(MouseEvent e) {
        this.isExited = true;
        this.setCursor(CursorHelper.getDefaultCursor());
        this.drawBorder = false;
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            logger.info((Object)"press...");
            this.x = e.getX();
            this.y = e.getY();
            if (!this.isResizing && !e.isControlDown()) {
                this.setAllEditPartUnSelected();
                Iterator iter = this.partManager.iterator();
                while (iter.hasNext()) {
                    EditPart part = (EditPart)iter.next();
                    Rectangle rect = part.getBounds();
                    if (!((double)e.getX() >= rect.getX()) || !((double)e.getX() <= rect.getX() + rect.getWidth()) || !((double)e.getY() >= rect.getY()) || !((double)e.getY() <= rect.getY() + rect.getHeight())) continue;
                    this.tx = (int)((double)e.getX() - rect.getX());
                    this.ty = (int)((double)e.getY() - rect.getY());
                    this.imageComponent = FigureHelper.drawAlphaImage(rect.getSize(), 0.3f, Color.gray, true);
                    this.partManager.target(null);
                    this.partManager.source(part);
                    this.context.setDragViewer(this);
                    this.partManager.select(part);
                    part.performRequest(this.selectedRequest);
                    return;
                }
                this.imageComponent = null;
            } else {
                this.imageComponent = null;
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            logger.info((Object)"released...");
            if (!this.isResizing) {
                if (this.imageComponent == null) {
                    return;
                }
                if (this == this.context.getMouseInViewer()) {
                    if (this.partManager.getTarget() != null && this.partManager.getSource() != null) {
                        if (e.isAltDown()) {
                            this.partManager.getSource().sendRequest(new DirectEditRequest(this.partManager.getTarget(), this.partManager.getSource(), this));
                        } else {
                            this.partManager.getSource().sendRequest(new DirectEditByInsteadRequest(this.partManager.getTarget(), this.partManager.getSource(), this));
                        }
                        this.partManager.getTarget().performRequest(this.moveOutRequest);
                    }
                } else {
                    this.partManager.getSource().sendRequest(new ChangeContainerRequest(this.partManager.getSource(), this, this.context.getMouseInViewer()));
                    this.context.getMouseInViewer().setCursor(CursorHelper.getDefaultCursor());
                }
                this.context.setDragViewer(null);
                this.imageComponent = null;
            } else {
                if (this.border == 2 || this.border == 3) {
                    this.partManager.getSource().sendRequest(new RowPositionRequest(this.partManager.getSource(), this, this.border, this.y));
                } else {
                    this.partManager.getSource().sendRequest(new ResizeRequest(this.partManager.getSource(), this, this.border, this.x));
                }
                this.isResizing = false;
            }
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        UictKDTabbedPane tab;
        if (this.isExited && (tab = this.context.getMouseInTabbedPane()) != null) {
            MouseEvent me = SwingUtilities.convertMouseEvent((Component)e.getSource(), e, (Component)((Object)tab));
            tab.dispatchEvent(me);
            return;
        }
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.x = e.getX();
            this.y = e.getY();
            if (!this.isResizing) {
                Iterator iter = this.partManager.iterator();
                EditPart moveInPart = null;
                this.partManager.target(null);
                while (iter.hasNext()) {
                    EditPart part = (EditPart)iter.next();
                    Rectangle rect = part.getBounds();
                    if ((double)e.getX() >= rect.getX() && (double)e.getX() <= rect.getX() + rect.getWidth() && (double)e.getY() >= rect.getY() && (double)e.getY() <= rect.getY() + rect.getHeight()) {
                        moveInPart = part;
                        continue;
                    }
                    part.performRequest(this.moveOutRequest);
                }
                if (moveInPart != null) {
                    this.partManager.target(moveInPart);
                    moveInPart.performRequest(this.moveInRequest);
                }
            }
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.partManager.getSelection() != null) {
            this.setCursor(CursorHelper.getDefaultCursor());
            this.isResizing = false;
            Rectangle rect = this.partManager.getSelection().getBounds();
            if (e.getX() >= rect.x - 1 && e.getX() <= rect.x + 1 && e.getY() >= rect.y && e.getY() <= rect.y + rect.height) {
                this.isResizing = true;
                this.border = 0;
                this.setCursor(CursorHelper.getResizeHorizontalCursor());
            } else if (e.getX() >= rect.x + rect.width - 1 && e.getX() <= rect.x + rect.width + 1 && e.getY() >= rect.y && e.getY() <= rect.y + rect.height) {
                this.isResizing = true;
                this.border = 1;
                this.setCursor(CursorHelper.getResizeHorizontalCursor());
            } else if (e.getX() >= rect.x + 1 && e.getX() <= rect.x + rect.width - 1 && e.getY() >= rect.y - 1 && e.getY() <= rect.y + 1) {
                this.isResizing = true;
                this.border = 2;
                this.setCursor(CursorHelper.getResizeVerticalCursor());
            } else if (e.getX() >= rect.x + 1 && e.getX() <= rect.x + rect.width - 1 && e.getY() >= rect.y + rect.height - 1 && e.getY() <= rect.y + rect.height + 1) {
                this.isResizing = true;
                this.border = 3;
                this.setCursor(CursorHelper.getResizeVerticalCursor());
            }
        }
    }

    private void insertOrAddPop_actionPerformed(ActionEvent e, String cor, int ioa) {
        Command command;
        InsertRowOrColumnPolicy policy = new InsertRowOrColumnPolicy();
        Request request = null;
        request = "insert row".equals(cor) ? new InsertRowRequest(this.partManager.getSelection(), ioa, 1, this) : new InsertColumnRequest(this.partManager.getSelection(), ioa, 1, this);
        if (policy.understandsRequest(request) && (command = policy.getCommand(request)) != null) {
            this.getCommandStack().execute(command);
        }
    }

    private void delRowPop_actionPerformed(ActionEvent e) {
        if (this.partManager.getSelection() != null) {
            Command command;
            DeleteRowOrColumnPolicy policy = new DeleteRowOrColumnPolicy();
            DeleteRowRequest request = new DeleteRowRequest(this.partManager.getSelection(), this);
            if (policy.understandsRequest(request) && (command = policy.getCommand(request)) != null) {
                this.commandStack.execute(command);
            }
        } else {
            MsgBox.showInfo((Component)this, (String)"\u8bf7\u9009\u4e2d\u5220\u9664\u884c\u7684\u4efb\u610f\u4e00\u4e2a\u5355\u5143\u683c\uff01");
            return;
        }
    }

    private void delColumnPop_actionPerformed(ActionEvent e) {
        if (this.partManager.getSelection() != null) {
            Command command;
            DeleteRowOrColumnPolicy policy = new DeleteRowOrColumnPolicy();
            DeleteColumnRequest request = new DeleteColumnRequest(this.partManager.getSelection(), this);
            if (policy.understandsRequest(request) && (command = policy.getCommand(request)) != null) {
                this.commandStack.execute(command);
            }
        } else {
            MsgBox.showInfo((Component)this, (String)"\u8bf7\u9009\u4e2d\u5220\u9664\u5217\u7684\u4efb\u610f\u4e00\u4e2a\u5355\u5143\u683c\uff01");
            return;
        }
    }

    private void combinePop_actionPerformed(ActionEvent e) {
        Command command;
        CombineOrSplitCellPolicy policy = new CombineOrSplitCellPolicy();
        CombineCellRequest request = new CombineCellRequest(this.partManager.getMultiSelected(), this);
        if (policy.understandsRequest(request) && (command = policy.getCommand(request)) != null) {
            this.commandStack.execute(command);
        }
    }

    private void splitPop_actionPerformed(ActionEvent e) {
        if (this.partManager.getSelection() == null) {
            MsgBox.showInfo((Component)this, (String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5355\u5143\u683c\uff01");
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("UictEditPartViewer", this);
        uiContext.put("EditPart", this.partManager.getSelection());
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create("com.kingdee.eas.base.uict.client.SplitCellUI", (Map)uiContext);
            uiWindow.show();
        }
        catch (UIException e1) {
            logger.error((Object)e1);
        }
    }

    private void widthPop_actionPerformed(ActionEvent e) {
        if (this.partManager.getSelection() == null) {
            MsgBox.showInfo((Component)this, (String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5355\u5143\u683c\uff01");
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("UictEditPartViewer", this);
        uiContext.put("EditPart", this.partManager.getSelection());
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create("com.kingdee.eas.base.uict.client.SetItemWidthUI", (Map)uiContext);
            uiWindow.show();
        }
        catch (UIException e1) {
            logger.error((Object)e1);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("showgrid")) {
            this.showGridPop.setSelected((Boolean)evt.getNewValue());
        } else if (evt.getPropertyName().equals("showcontainer")) {
            this.showContainerPop.setSelected((Boolean)evt.getNewValue());
        }
    }

    void setAllEditPartUnSelected() {
        if (this.partManager != null) {
            this.partManager.select(null);
            this.partManager.clearMultiSelected();
            Iterator iter = this.partManager.iterator();
            while (iter.hasNext()) {
                EditPart part = (EditPart)iter.next();
                part.performRequest(new UnSelectedRequest());
            }
        }
    }

    public void keyPressed(KeyEvent e) {
        logger.info((Object)(">>key " + e.getKeyCode() + " press...."));
        if (e.isControlDown() && 89 == e.getKeyCode() && this.commandStack.canRedo()) {
            this.commandStack.redo();
        } else if (e.isControlDown() && 90 == e.getKeyCode() && this.commandStack.canUndo()) {
            this.commandStack.undo();
        }
    }

    public void keyReleased(KeyEvent e) {
        logger.info((Object)(">>key " + e.getKeyCode() + " release...."));
    }

    public void keyTyped(KeyEvent arg0) {
    }

    public EditPartManager getPartManager() {
        return this.partManager;
    }

    public void sendRequest(EditPart part, Request req) {
        if (part == null) {
            Iterator iter = this.partManager.iterator();
            while (iter.hasNext() && ((part = (EditPart)iter.next()) == null || !(part instanceof CommonEditPart))) {
            }
        }
        part.sendRequest(req);
    }
}

