/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.editor.commands;

import com.kingdee.eas.base.uict.BizConfigureItemCollection;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import com.kingdee.eas.base.uict.client.BizConfigureTreeNode;
import com.kingdee.eas.base.uict.client.editor.EditPart;
import com.kingdee.eas.base.uict.client.editor.UictEditPartViewer;
import com.kingdee.eas.base.uict.client.editor.commands.Command;
import com.kingdee.eas.base.uict.client.editor.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.base.uict.client.editor.request.CombineCellRequest;
import com.kingdee.eas.base.uict.client.editor.util.TableHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CombineCellCommand
extends Command {
    private boolean canCombine = true;
    private UictEditPartViewer viwer;
    private BizConfigureTreeNode node;
    private Map itemAdapterMap;
    private BizConfigureItemCollection itemList;
    private BizConfigureItemCollection oldList = new BizConfigureItemCollection();
    private List oldWidth = new ArrayList(5);
    private List combine = new ArrayList(5);
    private int start;
    private int end;

    public CombineCellCommand(CombineCellRequest request) {
        this.viwer = request.getViwer();
        this.node = this.viwer.getNode();
        this.itemAdapterMap = this.viwer.getItemAdapterMap();
        this.itemList = this.node.getList();
        List rCombine = request.getCombine();
        Iterator iter = rCombine.iterator();
        while (iter.hasNext()) {
            this.combine.add(((BizConfigureItemInfoAdapter)((EditPart)iter.next()).getModel()).getItem());
        }
        CombineCellCommand.sort(this.itemList, this.combine);
        this.canCombine = TableHelper.validateCombine(this.node.getTable(), this.combine, this.itemList);
        if (this.canCombine) {
            this.start = this.itemList.indexOf((BizConfigureItemInfo)this.combine.get(0));
            this.end = this.itemList.indexOf((BizConfigureItemInfo)this.combine.get(this.combine.size() - 1));
        }
    }

    public void execute() {
        if (!this.canCombine) {
            return;
        }
        if (this.itemList != null) {
            BizConfigureItemInfo item;
            this.oldList.clear();
            Iterator iter = this.itemList.iterator();
            while (iter.hasNext()) {
                this.oldList.add((BizConfigureItemInfo)iter.next());
            }
            this.oldWidth.clear();
            for (int i = this.start; i <= this.end; ++i) {
                item = this.itemList.get(i);
                this.oldWidth.add(new Integer(item.getWidth()));
            }
            TableHelper.combineCell(this.itemList, this.start, this.end);
            this.node.updateTable();
            this.viwer.createEditPart();
            this.viwer.refreshGrid();
            for (int i = 0; i < this.itemList.size(); ++i) {
                item = this.itemList.get(i);
                Object obj = this.itemAdapterMap.get(item);
                if (!(obj instanceof BizConfigureItemInfoAdapter)) continue;
                ((BizConfigureItemInfoAdapter)obj).fireProperty("rectangle", null, item.getBounds());
            }
            this.viwer.repaint();
        }
    }

    public void undo() {
        Object obj;
        int i;
        if (!this.canCombine) {
            return;
        }
        this.itemList.clear();
        Iterator iter = this.oldList.iterator();
        while (iter.hasNext()) {
            this.itemList.add((BizConfigureItemInfo)iter.next());
        }
        int index = 0;
        for (i = this.start; i <= this.end; ++i) {
            obj = this.oldWidth.get(index);
            if (obj != null) {
                this.itemList.get(i).setWidth((Integer)obj);
            }
            ++index;
        }
        this.node.updateTable();
        this.viwer.createEditPart();
        this.viwer.refreshGrid();
        for (i = 0; i < this.itemList.size(); ++i) {
            BizConfigureItemInfo item = this.itemList.get(i);
            obj = this.itemAdapterMap.get(item);
            if (!(obj instanceof BizConfigureItemInfoAdapter)) continue;
            ((BizConfigureItemInfoAdapter)obj).fireProperty("rectangle", null, item.getBounds());
        }
        this.viwer.repaint();
    }

    private static void sort(BizConfigureItemCollection ll, List lb) {
        if (ll != null && lb != null) {
            BizConfigureItemCollection lt = new BizConfigureItemCollection();
            int size = ll.size();
            for (int i = 0; i < size; ++i) {
                lt.add(ll.get(i));
            }
            Iterator iter = lt.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (lb.contains(obj)) continue;
                iter.remove();
            }
            lb.clear();
            iter = lt.iterator();
            while (iter.hasNext()) {
                lb.add(iter.next());
            }
        }
    }
}

