/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.editor.commands;

import com.kingdee.eas.base.uict.BizConfigureItemCollection;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import com.kingdee.eas.base.uict.EmptyConfigureItemInfo;
import com.kingdee.eas.base.uict.client.BizConfigureTreeNode;
import com.kingdee.eas.base.uict.client.designer.TableCell;
import com.kingdee.eas.base.uict.client.designer.TableColumn;
import com.kingdee.eas.base.uict.client.editor.UictEditPartViewer;
import com.kingdee.eas.base.uict.client.editor.commands.Command;
import com.kingdee.eas.base.uict.client.editor.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.base.uict.client.editor.request.DeleteColumnRequest;
import com.kingdee.eas.base.uict.client.editor.util.ColumnInfo;
import com.kingdee.eas.base.uict.client.editor.util.TableHelper;
import com.kingdee.eas.base.uict.client.editor.util.UictEditorHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DeleteColumnCommand
extends Command {
    private UictEditPartViewer viwer;
    private BizConfigureTreeNode node;
    private Map itemAdapterMap;
    private int column;
    private BizConfigureItemCollection itemList;
    private BizConfigureItemCollection oldList = new BizConfigureItemCollection();
    private List columnCoordinate = new ArrayList();
    private boolean result;

    public DeleteColumnCommand(DeleteColumnRequest request) {
        this.viwer = request.getViwer();
        this.node = this.viwer.getNode();
        this.itemAdapterMap = this.viwer.getItemAdapterMap();
        this.itemList = this.node.getList();
        BizConfigureItemInfo item = ((BizConfigureItemInfoAdapter)request.getSourceEditPart().getModel()).getItem();
        if (this.node != null && this.node.getTable() != null) {
            if (this.node.getTable().getColumnCount() <= 1) {
                this.result = false;
                UictEditorHelper.showMsgBoxInfo("\u4e0d\u80fd\u8fdb\u5217\u5220\u9664\uff01");
                return;
            }
            int m = this.node.getTable().getRowCount();
            for (int i = 0; i < m; ++i) {
                int n = this.node.getTable().getColumnCount();
                for (int j = 0; j < n; ++j) {
                    TableCell cell = this.node.getTable().getCell(i, j);
                    if (cell.getData() != item) continue;
                    this.column = cell.getColumnIndex();
                    for (int k = 0; k < m; ++k) {
                        cell = this.node.getTable().getCell(k, this.column);
                        BizConfigureItemInfo cellItem = null;
                        if (cell.getData() != null) {
                            cellItem = (BizConfigureItemInfo)cell.getData();
                        }
                        if (cell.isMerged() && cell.getColumnSpan() != 1) {
                            cellItem = (BizConfigureItemInfo)cell.getMergedCell().getData();
                        }
                        if (cellItem != null && cellItem.getComponent() != null && ("com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(cellItem.getComponent().getClassType()) || "com.kingdee.bos.ctrl.swing.KDPanel".equals(cellItem.getComponent().getClassType()) || "com.kingdee.bos.ctrl.kdf.table.KDTable".equals(cellItem.getComponent().getClassType())) || (!cell.isMerged() || cell.getColumnSpan() == 1) && (cell.getData() == null || cell.getData() instanceof EmptyConfigureItemInfo)) continue;
                        this.result = false;
                        UictEditorHelper.showMsgBoxInfo("\u4e0d\u80fd\u8fdb\u5217\u5220\u9664\uff01");
                        return;
                    }
                    this.result = true;
                    this.columnCoordinate.clear();
                    int count = this.node.getTable().getColumnCount();
                    for (int h = 0; h < count; ++h) {
                        TableColumn tableColumn = this.node.getTable().getColumn(h);
                        this.columnCoordinate.add(new ColumnInfo(tableColumn.getLeft(), tableColumn.getWidth()));
                    }
                    return;
                }
            }
        }
    }

    public void execute() {
        if (this.itemList != null && this.result) {
            this.oldList.clear();
            Iterator iter = this.itemList.iterator();
            while (iter.hasNext()) {
                this.oldList.add((BizConfigureItemInfo)iter.next());
            }
            TableHelper.removeColumn(this.node.getTable(), this.column, this.itemList);
            this.node.setColumnCount(this.node.getTable().getColumnCount());
            this.node.updateTable();
            this.viwer.createEditPart();
            this.viwer.refreshGrid();
            for (int i = 0; i < this.itemList.size(); ++i) {
                BizConfigureItemInfo item = this.itemList.get(i);
                Object obj = this.itemAdapterMap.get(item);
                if (!(obj instanceof BizConfigureItemInfoAdapter)) continue;
                ((BizConfigureItemInfoAdapter)obj).fireProperty("rectangle", null, item.getBounds());
            }
            this.viwer.repaint();
        }
    }

    public void undo() {
        if (this.itemList != null && this.result) {
            this.itemList.clear();
            Iterator iter = this.oldList.iterator();
            while (iter.hasNext()) {
                this.itemList.add((BizConfigureItemInfo)iter.next());
            }
            TableHelper.recoverRemoveColumn(this.node.getTable());
            TableHelper.resetTableColumnCoordinate(this.node.getTable(), this.columnCoordinate);
            this.node.setColumnCount(this.node.getTable().getColumnCount());
            this.node.updateTable();
            this.viwer.createEditPart();
            this.viwer.refreshGrid();
            for (int i = 0; i < this.itemList.size(); ++i) {
                BizConfigureItemInfo item = this.itemList.get(i);
                Object obj = this.itemAdapterMap.get(item);
                if (!(obj instanceof BizConfigureItemInfoAdapter)) continue;
                ((BizConfigureItemInfoAdapter)obj).fireProperty("rectangle", null, item.getBounds());
            }
            this.viwer.repaint();
        }
    }
}

