/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.editor.commands;

import com.kingdee.eas.base.uict.BizConfigureItemCollection;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import com.kingdee.eas.base.uict.EmptyConfigureItemInfo;
import com.kingdee.eas.base.uict.client.BizConfigureTreeNode;
import com.kingdee.eas.base.uict.client.designer.TableCell;
import com.kingdee.eas.base.uict.client.editor.UictEditPartViewer;
import com.kingdee.eas.base.uict.client.editor.commands.Command;
import com.kingdee.eas.base.uict.client.editor.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.base.uict.client.editor.request.DeleteRowRequest;
import com.kingdee.eas.base.uict.client.editor.util.UictEditorHelper;
import java.util.Iterator;
import java.util.Map;

public class DeleteRowCommand
extends Command {
    private UictEditPartViewer viwer;
    private BizConfigureTreeNode node;
    private Map itemAdapterMap;
    private int index;
    private int count;
    private BizConfigureItemCollection itemList;
    private BizConfigureItemCollection oldList = new BizConfigureItemCollection();
    private boolean result;

    public DeleteRowCommand(DeleteRowRequest request) {
        this.viwer = request.getViwer();
        this.node = this.viwer.getNode();
        this.itemAdapterMap = this.viwer.getItemAdapterMap();
        this.itemList = this.node.getList();
        BizConfigureItemInfo item = ((BizConfigureItemInfoAdapter)request.getSourceEditPart().getModel()).getItem();
        if (this.node != null && this.node.getTable() != null) {
            if (this.node.getTable().getRowCount() <= 1) {
                this.result = false;
                UictEditorHelper.showMsgBoxInfo("\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\uff01");
                return;
            }
            int m = this.node.getTable().getRowCount();
            for (int i = 0; i < m; ++i) {
                int n = this.node.getTable().getColumnCount();
                for (int j = 0; j < n; ++j) {
                    int k;
                    TableCell cell = this.node.getTable().getCell(i, j);
                    if (cell.getData() != item) continue;
                    int row = cell.getRowIndex();
                    for (k = 0; k < n; ++k) {
                        cell = this.node.getTable().getCell(row, k);
                        if ((!cell.isMerged() || cell.getRowSpan() == 1) && (cell.getData() == null || cell.getData() instanceof EmptyConfigureItemInfo)) continue;
                        this.result = false;
                        UictEditorHelper.showMsgBoxInfo("\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\uff01");
                        return;
                    }
                    this.index = -1;
                    this.count = 0;
                    for (k = 0; k < n; ++k) {
                        cell = this.node.getTable().getCell(row, k);
                        if (cell.getData() == null) continue;
                        if (this.index == -1) {
                            this.index = this.itemList.indexOf((BizConfigureItemInfo)cell.getData());
                        }
                        ++this.count;
                    }
                    if (this.index != -1 && this.count > 0) {
                        this.result = true;
                        return;
                    }
                    this.result = false;
                    UictEditorHelper.showMsgBoxInfo("\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\uff01");
                    return;
                }
            }
        }
    }

    public void execute() {
        if (this.itemList != null && this.result) {
            this.oldList.clear();
            Iterator iter = this.itemList.iterator();
            while (iter.hasNext()) {
                this.oldList.add((BizConfigureItemInfo)iter.next());
            }
            for (int i = 0; i < this.count; ++i) {
                this.itemList.removeObject(this.index);
            }
            this.node.updateTable();
            this.viwer.createEditPart();
            this.viwer.refreshGrid();
            for (int i = 0; i < this.itemList.size(); ++i) {
                BizConfigureItemInfo item = this.itemList.get(i);
                Object obj = this.itemAdapterMap.get(item);
                if (!(obj instanceof BizConfigureItemInfoAdapter)) continue;
                ((BizConfigureItemInfoAdapter)obj).fireProperty("rectangle", null, item.getBounds());
            }
            this.viwer.repaint();
        }
    }

    public void undo() {
        if (this.itemList != null && this.result) {
            this.itemList.clear();
            Iterator iter = this.oldList.iterator();
            while (iter.hasNext()) {
                this.itemList.add((BizConfigureItemInfo)iter.next());
            }
            this.node.updateTable();
            this.viwer.createEditPart();
            this.viwer.refreshGrid();
            for (int i = 0; i < this.itemList.size(); ++i) {
                BizConfigureItemInfo item = this.itemList.get(i);
                Object obj = this.itemAdapterMap.get(item);
                if (!(obj instanceof BizConfigureItemInfoAdapter)) continue;
                ((BizConfigureItemInfoAdapter)obj).fireProperty("rectangle", null, item.getBounds());
            }
            this.viwer.repaint();
        }
    }
}

