/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.editor.commands;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.uict.BizConfigureItemCollection;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import com.kingdee.eas.base.uict.client.BizConfigureTreeNode;
import com.kingdee.eas.base.uict.client.editor.EditPart;
import com.kingdee.eas.base.uict.client.editor.UictEditPartViewer;
import com.kingdee.eas.base.uict.client.editor.commands.Command;
import com.kingdee.eas.base.uict.client.editor.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.base.uict.client.editor.request.DirectEditRequest;
import java.util.Iterator;
import java.util.Map;

public class DirectEditCommand
extends Command {
    private int targetIndex;
    private int sourceIndex;
    private UictEditPartViewer viwer;
    private BizConfigureTreeNode node;
    private Map itemAdapterMap;
    private BizConfigureItemCollection itemList;
    private BizConfigureItemCollection oldList = new BizConfigureItemCollection();

    public DirectEditCommand(DirectEditRequest request) {
        this.viwer = request.getViwer();
        this.node = this.viwer.getNode();
        this.itemAdapterMap = this.viwer.getItemAdapterMap();
        this.itemList = this.node.getList();
        EditPart target = request.getTargetEditPart();
        EditPart source = request.getSourceEditPart();
        if (target != null && source != null && this.itemList != null) {
            this.targetIndex = this.itemList.indexOf(((BizConfigureItemInfoAdapter)target.getModel()).getItem());
            this.sourceIndex = this.itemList.indexOf(((BizConfigureItemInfoAdapter)source.getModel()).getItem());
        }
    }

    public void execute() {
        if (this.targetIndex == this.sourceIndex) {
            return;
        }
        if (this.itemList != null) {
            this.oldList.clear();
            Iterator iter = this.itemList.iterator();
            while (iter.hasNext()) {
                this.oldList.add((BizConfigureItemInfo)iter.next());
            }
            DirectEditCommand.swap(this.itemList, this.targetIndex, this.sourceIndex);
            this.node.updateTable();
            this.viwer.createEditPart();
            this.viwer.refreshGrid();
            for (int i = 0; i < this.itemList.size(); ++i) {
                BizConfigureItemInfo item = this.itemList.get(i);
                Object obj = this.itemAdapterMap.get(item);
                if (!(obj instanceof BizConfigureItemInfoAdapter)) continue;
                ((BizConfigureItemInfoAdapter)obj).fireProperty("rectangle", null, item.getBounds());
            }
            this.viwer.repaint();
        }
    }

    public void undo() {
        if (this.targetIndex == this.sourceIndex) {
            return;
        }
        if (this.itemList != null) {
            this.itemList.clear();
            Iterator iter = this.oldList.iterator();
            while (iter.hasNext()) {
                this.itemList.add((BizConfigureItemInfo)iter.next());
            }
            this.node.updateTable();
            this.viwer.createEditPart();
            this.viwer.refreshGrid();
            for (int i = 0; i < this.itemList.size(); ++i) {
                BizConfigureItemInfo item = this.itemList.get(i);
                Object obj = this.itemAdapterMap.get(item);
                if (!(obj instanceof BizConfigureItemInfoAdapter)) continue;
                ((BizConfigureItemInfoAdapter)obj).fireProperty("rectangle", null, item.getBounds());
            }
            this.viwer.repaint();
        }
    }

    public static void swap(BizConfigureItemCollection ll, int index1, int index2) {
        BizConfigureItemInfo o1 = ll.get(index2);
        ll.removeObject(index2);
        ll.addObject(index1, (IObjectValue)o1);
    }
}

