/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.editor.commands;

import com.kingdee.eas.base.uict.BizConfigureItemCollection;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import com.kingdee.eas.base.uict.client.BizConfigureTreeNode;
import com.kingdee.eas.base.uict.client.designer.TableCell;
import com.kingdee.eas.base.uict.client.designer.TableColumn;
import com.kingdee.eas.base.uict.client.editor.UictEditPartViewer;
import com.kingdee.eas.base.uict.client.editor.commands.Command;
import com.kingdee.eas.base.uict.client.editor.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.base.uict.client.editor.request.InsertColumnRequest;
import com.kingdee.eas.base.uict.client.editor.util.ColumnInfo;
import com.kingdee.eas.base.uict.client.editor.util.TableHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class InsertColumnCommand
extends Command {
    private UictEditPartViewer viwer;
    private BizConfigureTreeNode node;
    private Map itemAdapterMap;
    private int index;
    private int num;
    private int ioa;
    private BizConfigureItemInfo selected;
    private BizConfigureItemCollection itemList;
    private BizConfigureItemCollection oldList = new BizConfigureItemCollection();
    private List columnCoordinate = new ArrayList();
    private boolean result;

    public InsertColumnCommand(InsertColumnRequest request) {
        this.viwer = request.getViwer();
        this.node = this.viwer.getNode();
        this.selected = ((BizConfigureItemInfoAdapter)request.getSource().getModel()).getItem();
        this.ioa = request.getIoa();
        this.num = request.getNumber();
        this.itemAdapterMap = this.viwer.getItemAdapterMap();
        this.itemList = this.node.getList();
        this.columnCoordinate.clear();
        int count = this.node.getTable().getColumnCount();
        for (int i = 0; i < count; ++i) {
            TableColumn column = this.node.getTable().getColumn(i);
            this.columnCoordinate.add(new ColumnInfo(column.getLeft(), column.getWidth()));
        }
    }

    public void execute() {
        if (this.itemList != null) {
            this.oldList.clear();
            Iterator iter = this.itemList.iterator();
            while (iter.hasNext()) {
                this.oldList.add((BizConfigureItemInfo)iter.next());
            }
            if (0 == this.ioa) {
                TableCell cell = TableHelper.getItemCell(this.node.getTable(), this.selected);
                this.index = cell.getColumnIndex();
            } else {
                this.index = this.node.getTable().getColumnCount();
            }
            this.result = TableHelper.insertColumn(this.node.getTable(), this.index, this.num, this.itemList);
            if (this.result) {
                this.node.setColumnCount(this.node.getColumnCount() + this.num);
                this.node.updateTable();
                this.viwer.createEditPart();
                this.viwer.refreshGrid();
                for (int i = 0; i < this.itemList.size(); ++i) {
                    BizConfigureItemInfo item = this.itemList.get(i);
                    Object obj = this.itemAdapterMap.get(item);
                    if (!(obj instanceof BizConfigureItemInfoAdapter)) continue;
                    ((BizConfigureItemInfoAdapter)obj).fireProperty("rectangle", null, item.getBounds());
                }
                this.viwer.repaint();
            }
        }
    }

    public void undo() {
        if (this.itemList != null && this.result) {
            this.itemList.clear();
            Iterator iter = this.oldList.iterator();
            while (iter.hasNext()) {
                this.itemList.add((BizConfigureItemInfo)iter.next());
            }
            TableHelper.recoverInsertColumn(this.node.getTable(), this.index, this.num);
            TableHelper.resetTableColumnCoordinate(this.node.getTable(), this.columnCoordinate);
            this.node.setColumnCount(this.node.getColumnCount() - this.num);
            this.node.updateTable();
            this.viwer.createEditPart();
            this.viwer.refreshGrid();
            for (int i = 0; i < this.itemList.size(); ++i) {
                BizConfigureItemInfo item = this.itemList.get(i);
                Object obj = this.itemAdapterMap.get(item);
                if (!(obj instanceof BizConfigureItemInfoAdapter)) continue;
                ((BizConfigureItemInfoAdapter)obj).fireProperty("rectangle", null, item.getBounds());
            }
            this.viwer.repaint();
        }
    }
}

