/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.editor.commands;

import com.kingdee.eas.base.uict.BizConfigureItemCollection;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import com.kingdee.eas.base.uict.client.BizConfigureTreeNode;
import com.kingdee.eas.base.uict.client.designer.TableCell;
import com.kingdee.eas.base.uict.client.editor.UictEditPartViewer;
import com.kingdee.eas.base.uict.client.editor.commands.Command;
import com.kingdee.eas.base.uict.client.editor.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.base.uict.client.editor.request.InsertRowRequest;
import com.kingdee.eas.base.uict.client.editor.util.TableHelper;
import java.util.Iterator;
import java.util.Map;

public class InsertRowCommand
extends Command {
    private UictEditPartViewer viwer;
    private BizConfigureTreeNode node;
    private Map itemAdapterMap;
    private int index;
    private int num;
    private int ioa;
    private BizConfigureItemInfo selected;
    private BizConfigureItemCollection itemList;
    private BizConfigureItemCollection oldList = new BizConfigureItemCollection();
    private boolean result;

    public InsertRowCommand(InsertRowRequest request) {
        this.viwer = request.getViwer();
        this.node = this.viwer.getNode();
        this.selected = ((BizConfigureItemInfoAdapter)request.getSource().getModel()).getItem();
        this.ioa = request.getIoa();
        this.num = request.getNumber();
        this.itemAdapterMap = this.viwer.getItemAdapterMap();
        this.itemList = this.node.getList();
    }

    public void execute() {
        if (this.itemList != null) {
            this.oldList.clear();
            Iterator iter = this.itemList.iterator();
            while (iter.hasNext()) {
                this.oldList.add((BizConfigureItemInfo)iter.next());
            }
            if (0 == this.ioa) {
                TableCell cell = TableHelper.getItemCell(this.node.getTable(), this.selected);
                this.index = cell.getRowIndex();
            } else {
                this.index = this.node.getTable().getRowCount();
            }
            this.result = TableHelper.insertRow(this.node.getTable(), this.index, this.num, this.itemList);
            if (this.result) {
                this.node.updateTable();
                this.viwer.createEditPart();
                this.viwer.refreshGrid();
                for (int i = 0; i < this.itemList.size(); ++i) {
                    BizConfigureItemInfo item = this.itemList.get(i);
                    Object obj = this.itemAdapterMap.get(item);
                    if (!(obj instanceof BizConfigureItemInfoAdapter)) continue;
                    ((BizConfigureItemInfoAdapter)obj).fireProperty("rectangle", null, item.getBounds());
                }
                this.viwer.repaint();
            }
        }
    }

    public void undo() {
        if (this.itemList != null && this.result) {
            this.itemList.clear();
            Iterator iter = this.oldList.iterator();
            while (iter.hasNext()) {
                this.itemList.add((BizConfigureItemInfo)iter.next());
            }
            TableHelper.recoverInsertRow(this.node.getTable(), this.index, this.num);
            this.node.updateTable();
            this.viwer.createEditPart();
            this.viwer.refreshGrid();
            for (int i = 0; i < this.itemList.size(); ++i) {
                BizConfigureItemInfo item = this.itemList.get(i);
                Object obj = this.itemAdapterMap.get(item);
                if (!(obj instanceof BizConfigureItemInfoAdapter)) continue;
                ((BizConfigureItemInfoAdapter)obj).fireProperty("rectangle", null, item.getBounds());
            }
            this.viwer.repaint();
        }
    }
}

