/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.editor.commands;

import com.kingdee.eas.base.uict.BizConfigureItemCollection;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import com.kingdee.eas.base.uict.client.BizConfigureTreeNode;
import com.kingdee.eas.base.uict.client.designer.Table;
import com.kingdee.eas.base.uict.client.designer.TableColumn;
import com.kingdee.eas.base.uict.client.editor.UictEditPartViewer;
import com.kingdee.eas.base.uict.client.editor.commands.Command;
import com.kingdee.eas.base.uict.client.editor.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.base.uict.client.editor.request.Resize4SiteRequest;
import com.kingdee.eas.base.uict.client.editor.util.ColumnInfo;
import com.kingdee.eas.base.uict.client.editor.util.TableHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Resize4SiteCommand
extends Command {
    private UictEditPartViewer viwer;
    private BizConfigureTreeNode node;
    private Map itemAdapterMap;
    private BizConfigureItemCollection itemList;
    private List oldColumnInfo = new ArrayList(5);
    private int border;
    private int x;
    private int resizeColumn;

    public Resize4SiteCommand(Resize4SiteRequest request) {
        this.viwer = request.getViwer();
        this.node = this.viwer.getNode();
        this.itemAdapterMap = this.viwer.getItemAdapterMap();
        this.itemList = this.node.getList();
        this.border = request.getBorder();
        this.x = request.getX();
        Table table = this.node.getTable();
        if (table != null) {
            int n = table.getColumnCount();
            for (int i = 0; i < n; ++i) {
                TableColumn column = table.getColumn(i);
                this.oldColumnInfo.add(new ColumnInfo(column.getLeft(), column.getWidth()));
            }
        }
        this.resizeColumn = request.getIndex();
    }

    public void execute() {
        if (this.node.getTable() != null) {
            TableHelper.resetTableColumnWidth4Site(this.node.getTable(), this.resizeColumn, this.border, this.x, 5, 15);
            this.node.updateTable();
            this.viwer.refreshGrid();
            for (int i = 0; i < this.itemList.size(); ++i) {
                BizConfigureItemInfo item = this.itemList.get(i);
                Object obj = this.itemAdapterMap.get(item);
                if (!(obj instanceof BizConfigureItemInfoAdapter)) continue;
                ((BizConfigureItemInfoAdapter)obj).fireProperty("rectangle", null, item.getBounds());
            }
            this.viwer.repaint();
        }
    }

    public void undo() {
        if (this.node.getTable() != null) {
            Table table = this.node.getTable();
            int columnCount = table.getColumnCount();
            int size = this.oldColumnInfo.size();
            for (int i = 0; i < size && i < columnCount; ++i) {
                ColumnInfo cinfo = (ColumnInfo)this.oldColumnInfo.get(i);
                TableColumn column = table.getColumn(i);
                column.setLeft(cinfo.leftX);
                column.setWidth(cinfo.width);
            }
            this.node.updateTable();
            this.viwer.refreshGrid();
            for (int i = 0; i < this.itemList.size(); ++i) {
                BizConfigureItemInfo item = this.itemList.get(i);
                Object obj = this.itemAdapterMap.get(item);
                if (!(obj instanceof BizConfigureItemInfoAdapter)) continue;
                ((BizConfigureItemInfoAdapter)obj).fireProperty("rectangle", null, item.getBounds());
            }
            this.viwer.repaint();
        }
    }
}

