/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.editor.commands;

import com.kingdee.eas.base.uict.BizConfigureItemCollection;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import com.kingdee.eas.base.uict.client.BizConfigureTreeNode;
import com.kingdee.eas.base.uict.client.designer.Table;
import com.kingdee.eas.base.uict.client.designer.TableCell;
import com.kingdee.eas.base.uict.client.designer.TableRow;
import com.kingdee.eas.base.uict.client.editor.EditPart;
import com.kingdee.eas.base.uict.client.editor.UictEditPartViewer;
import com.kingdee.eas.base.uict.client.editor.commands.Command;
import com.kingdee.eas.base.uict.client.editor.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.base.uict.client.editor.request.RowPositionRequest;
import com.kingdee.eas.base.uict.client.editor.util.RowInfo;
import com.kingdee.eas.base.uict.client.editor.util.TableHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ResizeHeightCommand
extends Command {
    private UictEditPartViewer viwer;
    private BizConfigureTreeNode node;
    private Map itemAdapterMap;
    private BizConfigureItemCollection itemList;
    private List oldRowInfo = new ArrayList(5);
    private int border;
    private int y;
    private int itemCellRow;
    private int itemCellColumn;

    public ResizeHeightCommand(RowPositionRequest request) {
        TableCell itemCell;
        this.viwer = request.getViwer();
        this.node = this.viwer.getNode();
        this.itemAdapterMap = this.viwer.getItemAdapterMap();
        this.itemList = this.node.getList();
        EditPart source = request.getSourceEditPart();
        BizConfigureItemInfo resizeItem = ((BizConfigureItemInfoAdapter)source.getModel()).getItem();
        this.border = request.getBorder();
        this.y = request.getY();
        Table table = this.node.getTable();
        if (table != null) {
            int n = table.getRowCount();
            for (int i = 0; i < n; ++i) {
                TableRow row = table.getRow(i);
                this.oldRowInfo.add(new RowInfo(row.getTop(), row.getHeight()));
            }
        }
        if ((itemCell = TableHelper.getItemCell(this.node.getTable(), resizeItem)) != null) {
            this.itemCellRow = itemCell.getRowIndex();
            this.itemCellColumn = itemCell.getColumnIndex();
        }
    }

    public void execute() {
        if (this.node.getTable() != null) {
            TableHelper.resetTableRowHeight(this.node.getTable(), this.itemCellRow, this.itemCellColumn, this.border, this.y, 5, 19);
            this.node.updateTable();
            this.viwer.refreshGrid();
            for (int i = 0; i < this.itemList.size(); ++i) {
                BizConfigureItemInfo item = this.itemList.get(i);
                Object obj = this.itemAdapterMap.get(item);
                if (!(obj instanceof BizConfigureItemInfoAdapter)) continue;
                ((BizConfigureItemInfoAdapter)obj).fireProperty("rectangle", null, item.getBounds());
            }
            this.viwer.repaint();
        }
    }

    public void undo() {
        if (this.node.getTable() != null) {
            Table table = this.node.getTable();
            int rowCount = table.getRowCount();
            int size = this.oldRowInfo.size();
            for (int i = 0; i < size && i < rowCount; ++i) {
                RowInfo rinfo = (RowInfo)this.oldRowInfo.get(i);
                TableRow row = table.getRow(i);
                row.setTop(rinfo.topX);
                row.setHeight(rinfo.height);
            }
            this.node.updateTable();
            this.viwer.refreshGrid();
            for (int i = 0; i < this.itemList.size(); ++i) {
                BizConfigureItemInfo item = this.itemList.get(i);
                Object obj = this.itemAdapterMap.get(item);
                if (!(obj instanceof BizConfigureItemInfoAdapter)) continue;
                ((BizConfigureItemInfoAdapter)obj).fireProperty("rectangle", null, item.getBounds());
            }
            this.viwer.repaint();
        }
    }
}

