/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.editor.commands;

import com.kingdee.eas.base.uict.BizConfigureItemCollection;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import com.kingdee.eas.base.uict.client.BizConfigureTreeNode;
import com.kingdee.eas.base.uict.client.editor.EditPart;
import com.kingdee.eas.base.uict.client.editor.UictEditPartViewer;
import com.kingdee.eas.base.uict.client.editor.commands.Command;
import com.kingdee.eas.base.uict.client.editor.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.base.uict.client.editor.request.SetItemWidthRequest;
import java.util.Iterator;
import java.util.Map;

public class SetItemWidthCommand
extends Command {
    private int oldWidth;
    private int newWidth;
    private boolean canReWidth = true;
    private int sourceIndex;
    private UictEditPartViewer viwer;
    private BizConfigureTreeNode node;
    private Map itemAdapterMap;
    private BizConfigureItemCollection itemList;
    private BizConfigureItemCollection oldList = new BizConfigureItemCollection();

    public SetItemWidthCommand(SetItemWidthRequest request) {
        this.viwer = request.getViwer();
        this.node = this.viwer.getNode();
        this.itemAdapterMap = this.viwer.getItemAdapterMap();
        this.itemList = this.node.getList();
        EditPart source = request.getSourceEditPart();
        this.newWidth = request.getWidth();
        this.oldWidth = ((BizConfigureItemInfoAdapter)source.getModel()).getItem().getWidth();
        BizConfigureItemInfo sourceItem = ((BizConfigureItemInfoAdapter)source.getModel()).getItem();
        this.sourceIndex = this.itemList.indexOf(sourceItem);
        if (this.node.getColumnCount() < this.newWidth || this.oldWidth == this.newWidth || this.sourceIndex < 0) {
            this.canReWidth = false;
        }
    }

    public void execute() {
        if (!this.canReWidth) {
            return;
        }
        if (this.itemList != null) {
            this.oldList.clear();
            Iterator iter = this.itemList.iterator();
            while (iter.hasNext()) {
                this.oldList.add((BizConfigureItemInfo)iter.next());
            }
            this.itemList.get(this.sourceIndex).setWidth(this.newWidth);
            this.node.updateTable();
            this.viwer.createEditPart();
            this.viwer.refreshGrid();
            for (int i = 0; i < this.itemList.size(); ++i) {
                BizConfigureItemInfo item = this.itemList.get(i);
                Object obj = this.itemAdapterMap.get(item);
                if (!(obj instanceof BizConfigureItemInfoAdapter)) continue;
                ((BizConfigureItemInfoAdapter)obj).fireProperty("rectangle", null, item.getBounds());
            }
            this.viwer.repaint();
        }
    }

    public void undo() {
        if (!this.canReWidth) {
            return;
        }
        this.itemList.clear();
        Iterator iter = this.oldList.iterator();
        while (iter.hasNext()) {
            this.itemList.add((BizConfigureItemInfo)iter.next());
        }
        this.itemList.get(this.sourceIndex).setWidth(this.oldWidth);
        this.node.updateTable();
        this.viwer.createEditPart();
        this.viwer.refreshGrid();
        for (int i = 0; i < this.itemList.size(); ++i) {
            BizConfigureItemInfo item = this.itemList.get(i);
            Object obj = this.itemAdapterMap.get(item);
            if (!(obj instanceof BizConfigureItemInfoAdapter)) continue;
            ((BizConfigureItemInfoAdapter)obj).fireProperty("rectangle", null, item.getBounds());
        }
        this.viwer.repaint();
    }
}

