/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.editor.commands;

import com.kingdee.eas.base.uict.BizConfigureItemCollection;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import com.kingdee.eas.base.uict.client.BizConfigureTreeNode;
import com.kingdee.eas.base.uict.client.editor.EditPart;
import com.kingdee.eas.base.uict.client.editor.UictEditPartViewer;
import com.kingdee.eas.base.uict.client.editor.commands.Command;
import com.kingdee.eas.base.uict.client.editor.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.base.uict.client.editor.request.SplitCellRequest;
import com.kingdee.eas.base.uict.client.editor.util.TableHelper;
import java.util.Iterator;
import java.util.Map;

public class SplitCellCommand
extends Command {
    private boolean canSplit = true;
    private UictEditPartViewer viwer;
    private BizConfigureTreeNode node;
    private Map itemAdapterMap;
    private BizConfigureItemCollection itemList;
    private BizConfigureItemCollection oldList = new BizConfigureItemCollection();
    private BizConfigureItemInfo splitItem;
    private int oldWidth;
    private int num;
    private int itemIndex;

    public SplitCellCommand(SplitCellRequest request) {
        this.viwer = request.getViwer();
        this.node = this.viwer.getNode();
        this.itemAdapterMap = this.viwer.getItemAdapterMap();
        this.itemList = this.node.getList();
        EditPart source = request.getSourceEditPart();
        this.splitItem = ((BizConfigureItemInfoAdapter)source.getModel()).getItem();
        this.oldWidth = this.splitItem.getWidth();
        this.num = request.getNum();
        this.canSplit = TableHelper.validateSplit(this.splitItem, this.num, this.itemList);
        if (this.canSplit) {
            this.itemIndex = this.itemList.indexOf(this.splitItem);
        }
    }

    public void execute() {
        if (!this.canSplit) {
            return;
        }
        if (this.itemList != null) {
            this.oldList.clear();
            Iterator iter = this.itemList.iterator();
            while (iter.hasNext()) {
                this.oldList.add((BizConfigureItemInfo)iter.next());
            }
            TableHelper.splitCell(this.itemList, this.itemIndex, this.num);
            this.node.updateTable();
            this.viwer.createEditPart();
            this.viwer.refreshGrid();
            for (int i = 0; i < this.itemList.size(); ++i) {
                BizConfigureItemInfo item = this.itemList.get(i);
                Object obj = this.itemAdapterMap.get(item);
                if (!(obj instanceof BizConfigureItemInfoAdapter)) continue;
                ((BizConfigureItemInfoAdapter)obj).fireProperty("rectangle", null, item.getBounds());
            }
            this.viwer.repaint();
        }
    }

    public void undo() {
        if (!this.canSplit) {
            return;
        }
        this.itemList.clear();
        Iterator iter = this.oldList.iterator();
        while (iter.hasNext()) {
            this.itemList.add((BizConfigureItemInfo)iter.next());
        }
        this.itemList.get(this.itemIndex).setWidth(this.oldWidth);
        this.node.updateTable();
        this.viwer.createEditPart();
        this.viwer.refreshGrid();
        for (int i = 0; i < this.itemList.size(); ++i) {
            BizConfigureItemInfo item = this.itemList.get(i);
            Object obj = this.itemAdapterMap.get(item);
            if (!(obj instanceof BizConfigureItemInfoAdapter)) continue;
            ((BizConfigureItemInfoAdapter)obj).fireProperty("rectangle", null, item.getBounds());
        }
        this.viwer.repaint();
    }
}

