/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.editor.ui;

import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.eas.base.uict.client.editor.Context;
import com.kingdee.eas.base.uict.client.editor.UictEditPartViewer;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class UictKDTabbedPane
extends KDTabbedPane
implements ChangeListener,
FocusListener,
MouseMotionListener,
MouseListener {
    private static final long serialVersionUID = -6572788437357426307L;
    private static Logger logger = Logger.getLogger((Class)UictKDTabbedPane.class);
    protected Context context;

    public UictKDTabbedPane() {
        this.addMouseMotionListener(this);
        this.addHeadMouseListener(this);
        this.addFocusListener(this);
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void stateChanged(ChangeEvent e) {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof UictEditPartViewer)) continue;
            JPanel panel = ((UictEditPartViewer)container).getMaskPanel();
            panel.setFocusable(true);
            panel.requestFocus();
            break;
        }
    }

    public void focusGained(FocusEvent arg0) {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof UictEditPartViewer)) continue;
            JPanel panel = ((UictEditPartViewer)container).getMaskPanel();
            panel.setFocusable(true);
            panel.requestFocus();
            break;
        }
    }

    public void focusLost(FocusEvent arg0) {
    }

    public void mouseDragged(MouseEvent e) {
        int index = this.mouseInTabIndex(e.getX(), e.getY());
        int selected = this.getSelectedIndex();
        if (index != -1 && selected != -1) {
            this.setSelectedIndex(index);
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        if (this.context != null) {
            this.context.setMouseInTabbedPane(this);
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.context != null && this.context.getMouseInTabbedPane() == this) {
            this.context.setMouseInTabbedPane(null);
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private int mouseInTabIndex(int x, int y) {
        List tis = this.getTabInfos();
        int size = tis.size();
        for (int i = 0; i < size; ++i) {
            TabInfo tabInfo = (TabInfo)tis.get(i);
            Rectangle bounds = tabInfo.bounds;
            if (bounds == null || x < bounds.x || x > bounds.x + bounds.width || y < bounds.y || y > bounds.y + bounds.height) continue;
            return tabInfo.index;
        }
        return -1;
    }

    private List getTabInfos() {
        ArrayList<TabInfo> tis = new ArrayList<TabInfo>(5);
        int counts = this.getTabCount();
        for (int i = 0; i < counts; ++i) {
            tis.add(new TabInfo(i, this.getBoundsAt(i)));
        }
        return tis;
    }

    private class TabInfo {
        int index;
        Rectangle bounds;

        public TabInfo(int index, Rectangle bounds) {
            this.index = index;
            this.bounds = bounds;
        }
    }
}

