/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.editor.util;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.uict.BizConfigureItemCollection;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import com.kingdee.eas.base.uict.EmptyConfigureItemInfo;
import com.kingdee.eas.base.uict.client.designer.DefaultTableCalculator;
import com.kingdee.eas.base.uict.client.designer.Table;
import com.kingdee.eas.base.uict.client.designer.TableCell;
import com.kingdee.eas.base.uict.client.designer.TableColumn;
import com.kingdee.eas.base.uict.client.designer.TableRow;
import com.kingdee.eas.base.uict.client.editor.util.Area;
import com.kingdee.eas.base.uict.client.editor.util.ColumnInfo;
import com.kingdee.eas.base.uict.client.editor.util.UictEditorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TableHelper {
    public static List getTableGridAreas(Table table) {
        if (table != null) {
            ArrayList<Area> area = new ArrayList<Area>(20);
            int m = table.getRowCount();
            for (int i = 0; i < m; ++i) {
                TableRow row = table.getRow(i);
                int n = table.getColumnCount();
                for (int j = 0; j < n; ++j) {
                    int xr;
                    int xl;
                    int yb;
                    int yt;
                    TableColumn column = table.getColumn(j);
                    TableCell cell = table.getCell(i, j);
                    if (!cell.isMerged()) {
                        yt = row.getTop();
                        yb = yt + row.getHeight();
                        xl = column.getLeft();
                        xr = xl + column.getWidth();
                        area.add(new Area(xl, xr, yb, yt));
                        continue;
                    }
                    if (!cell.isMerged() || cell != cell.getMergedCell()) continue;
                    int rowEnd = i;
                    int columnEnd = j;
                    TableRow row2 = table.getRow(rowEnd += cell.getRowSpan() - 1);
                    yt = row.getTop();
                    yb = row2.getTop() + row2.getHeight();
                    TableColumn column2 = table.getColumn(columnEnd += cell.getColumnSpan() - 1);
                    xl = column.getLeft();
                    xr = column2.getLeft() + column2.getWidth();
                    area.add(new Area(xl, xr, yb, yt));
                }
            }
            return area;
        }
        return null;
    }

    public static void resetTableColumnWidth4Site(Table table, int resizeColumn, int border, int x, int minspace, int minwidth) {
        if (table != null) {
            TableColumn column = table.getColumn(resizeColumn);
            int n = table.getColumnCount();
            if (column != null) {
                if (border == 0) {
                    if (resizeColumn == 0) {
                        int oldLeft = column.getLeft();
                        column.setLeft(x);
                        column.setWidth(oldLeft + column.getWidth() - x);
                        return;
                    }
                    TableColumn preColumn = table.getColumn(resizeColumn - 1);
                    int preRX = preColumn.getLeft() + preColumn.getWidth();
                    int selfRX = column.getLeft() + column.getWidth();
                    if (x - preRX >= minspace && selfRX - x >= minwidth) {
                        column.setLeft(x);
                        column.setWidth(selfRX - x);
                        return;
                    }
                    if (x - preRX >= minspace && selfRX - x < minwidth) {
                        column.setLeft(selfRX - minwidth);
                        column.setWidth(minwidth);
                        return;
                    }
                    if (x - preRX < minspace && selfRX - x >= minwidth) {
                        column.setLeft(preRX + minspace);
                        column.setWidth(selfRX - (preRX + minspace));
                        return;
                    }
                } else {
                    if (resizeColumn == n - 1) {
                        column.setWidth(x - column.getLeft());
                        return;
                    }
                    TableColumn nextColumn = table.getColumn(resizeColumn + 1);
                    int nextLX = nextColumn.getLeft();
                    int selfLX = column.getLeft();
                    if (nextLX - x >= minspace && x - selfLX >= minwidth) {
                        column.setWidth(x - selfLX);
                        return;
                    }
                    if (nextLX - x >= minspace && x - selfLX < minwidth) {
                        column.setWidth(minwidth);
                        return;
                    }
                    if (nextLX - x < minspace && x - selfLX >= minwidth) {
                        column.setWidth(nextLX - minspace - selfLX);
                        return;
                    }
                }
            }
        }
    }

    public static void resetTableColumnWidth(Table table, int resizeRow, int resizeColumn, int border, int x, int minspace, int minwidth) {
        if (table != null) {
            TableColumn column = table.getColumn(resizeColumn);
            TableCell cell = table.getCell(resizeRow, resizeColumn);
            int n = table.getColumnCount();
            if (cell != null) {
                if (!cell.isMerged()) {
                    if (border == 0) {
                        if (resizeColumn == 0) {
                            int oldLeft = column.getLeft();
                            column.setLeft(x);
                            column.setWidth(oldLeft + column.getWidth() - x);
                            return;
                        }
                        TableColumn preColumn = table.getColumn(resizeColumn - 1);
                        int preRX = preColumn.getLeft() + preColumn.getWidth();
                        int selfRX = column.getLeft() + column.getWidth();
                        if (x - preRX >= minspace && selfRX - x >= minwidth) {
                            column.setLeft(x);
                            column.setWidth(selfRX - x);
                            return;
                        }
                        if (x - preRX >= minspace && selfRX - x < minwidth) {
                            column.setLeft(selfRX - minwidth);
                            column.setWidth(minwidth);
                            return;
                        }
                        if (x - preRX < minspace && selfRX - x >= minwidth) {
                            column.setLeft(preRX + minspace);
                            column.setWidth(selfRX - (preRX + minspace));
                            return;
                        }
                    } else {
                        if (resizeColumn == n - 1) {
                            column.setWidth(x - column.getLeft());
                            return;
                        }
                        TableColumn nextColumn = table.getColumn(resizeColumn + 1);
                        int nextLX = nextColumn.getLeft();
                        int selfLX = column.getLeft();
                        if (nextLX - x >= minspace && x - selfLX >= minwidth) {
                            column.setWidth(x - selfLX);
                            return;
                        }
                        if (nextLX - x >= minspace && x - selfLX < minwidth) {
                            column.setWidth(minwidth);
                            return;
                        }
                        if (nextLX - x < minspace && x - selfLX >= minwidth) {
                            column.setWidth(nextLX - minspace - selfLX);
                            return;
                        }
                    }
                } else if (cell.isMerged() && cell == cell.getMergedCell()) {
                    if (border == 0) {
                        if (resizeColumn == 0) {
                            int oldLeft = column.getLeft();
                            column.setLeft(x);
                            column.setWidth(oldLeft + column.getWidth() - x);
                            return;
                        }
                        TableColumn preColumn = table.getColumn(resizeColumn - 1);
                        int preRX = preColumn.getLeft() + preColumn.getWidth();
                        int selfRX = column.getLeft() + column.getWidth();
                        if (x - preRX >= minspace && selfRX - x >= minwidth) {
                            column.setLeft(x);
                            column.setWidth(selfRX - x);
                            return;
                        }
                        if (x - preRX >= minspace && selfRX - x < minwidth) {
                            column.setLeft(selfRX - minwidth);
                            column.setWidth(minwidth);
                            return;
                        }
                        if (x - preRX < minspace && selfRX - x >= minwidth) {
                            column.setLeft(preRX + minspace);
                            column.setWidth(selfRX - (preRX + minspace));
                            return;
                        }
                    } else {
                        int columnEnd = resizeColumn;
                        for (int t = resizeColumn + 1; t < table.getColumnCount(); ++t) {
                            TableCell cell2 = table.getCell(resizeRow, t);
                            if (!cell2.isMerged() || cell != cell2.getMergedCell()) continue;
                            ++columnEnd;
                        }
                        if (columnEnd == n - 1) {
                            TableColumn mergedEndColumn = table.getColumn(columnEnd);
                            mergedEndColumn.setWidth(x - mergedEndColumn.getLeft());
                            return;
                        }
                        TableColumn nextColumn = table.getColumn(columnEnd + 1);
                        TableColumn mergedEndColumn = table.getColumn(columnEnd);
                        int nextLX = nextColumn.getLeft();
                        int selfLX = mergedEndColumn.getLeft();
                        if (nextLX - x >= minspace && x - selfLX >= minwidth) {
                            mergedEndColumn.setWidth(x - selfLX);
                            return;
                        }
                        if (nextLX - x >= minspace && x - selfLX < minwidth) {
                            mergedEndColumn.setWidth(minwidth);
                            return;
                        }
                        if (nextLX - x < minspace && x - selfLX >= minwidth) {
                            mergedEndColumn.setWidth(nextLX - minspace - selfLX);
                            return;
                        }
                    }
                }
            }
        }
    }

    public static void resetTableRowHeight4Site(Table table, int resieRow, int border, int y, int minspace, int minheight) {
        if (table != null) {
            TableRow row = table.getRow(resieRow);
            int n = table.getRowCount();
            if (row != null) {
                if (resieRow == n - 1) {
                    row.setHeight(y - row.getTop());
                    return;
                }
                TableRow nextRow = table.getRow(resieRow + 1);
                int nextLX = nextRow.getTop();
                int selfLX = row.getTop();
                if (nextLX - y >= minspace && y - selfLX >= minheight) {
                    row.setHeight(y - selfLX);
                    return;
                }
                if (nextLX - y >= minspace && y - selfLX < minheight) {
                    row.setHeight(minheight);
                    return;
                }
                if (nextLX - y < minspace && y - selfLX >= minheight) {
                    row.setHeight(nextLX - minspace - selfLX);
                    return;
                }
            }
        }
    }

    public static void resetTableRowHeight(Table table, int resizeRow, int resizeColumn, int border, int y, int minspace, int minheight) {
        if (table != null) {
            TableRow row = table.getRow(resizeRow);
            TableCell cell = table.getCell(resizeRow, resizeColumn);
            int n = table.getRowCount();
            if (cell != null) {
                if (!cell.isMerged()) {
                    if (resizeRow == n - 1) {
                        row.setHeight(y - row.getTop());
                        return;
                    }
                    TableRow nextRow = table.getRow(resizeRow + 1);
                    int nextLX = nextRow.getTop();
                    int selfLX = row.getTop();
                    if (nextLX - y >= minspace && y - selfLX >= minheight) {
                        row.setHeight(y - selfLX);
                        return;
                    }
                    if (nextLX - y >= minspace && y - selfLX < minheight) {
                        row.setHeight(minheight);
                        return;
                    }
                    if (nextLX - y < minspace && y - selfLX >= minheight) {
                        row.setHeight(nextLX - minspace - selfLX);
                        return;
                    }
                } else if (cell.isMerged() && cell == cell.getMergedCell()) {
                    int rowEnd = resizeRow;
                    for (int t = resizeRow + 1; t < table.getRowCount(); ++t) {
                        TableCell cell2 = table.getCell(t, resizeColumn);
                        if (!cell2.isMerged() || cell != cell2.getMergedCell()) continue;
                        ++rowEnd;
                    }
                    if (rowEnd == n - 1) {
                        TableRow mergedEndRow = table.getRow(rowEnd);
                        mergedEndRow.setHeight(y - mergedEndRow.getTop());
                        return;
                    }
                    TableRow nextRow = table.getRow(rowEnd + 1);
                    TableRow mergedEndRow = table.getRow(rowEnd);
                    int nextLX = nextRow.getTop();
                    int selfLX = mergedEndRow.getTop();
                    if (nextLX - y >= minspace && y - selfLX >= minheight) {
                        mergedEndRow.setHeight(y - selfLX);
                        return;
                    }
                    if (nextLX - y >= minspace && y - selfLX < minheight) {
                        mergedEndRow.setHeight(minheight);
                        return;
                    }
                    if (nextLX - y < minspace && y - selfLX >= minheight) {
                        mergedEndRow.setHeight(nextLX - minspace - selfLX);
                        return;
                    }
                }
            }
        }
    }

    public static int resetTableRowPosition(Table table, int rowIndex, int y, int minspace) {
        if (table != null) {
            TableRow preRow;
            TableRow row = table.getRow(rowIndex);
            if (rowIndex == 0 && y <= 8) {
                y = 8;
            }
            if (rowIndex != 0 && (preRow = table.getRow(rowIndex - 1)).getTop() + preRow.getHeight() >= y - minspace) {
                y = preRow.getTop() + preRow.getHeight() + minspace;
            }
            int move = y - row.getTop();
            int size = table.getRowCount();
            for (int i = rowIndex; i < size; ++i) {
                row = table.getRow(i);
                row.setTop(row.getTop() + move);
            }
            return move;
        }
        return 0;
    }

    public static void resetTableRowPosition2(Table table, int rowIndex, int move) {
        if (table != null) {
            TableRow row = null;
            int size = table.getRowCount();
            for (int i = rowIndex; i < size; ++i) {
                row = table.getRow(i);
                row.setTop(row.getTop() + move);
            }
        }
    }

    public static TableCell getItemCell(Table table, BizConfigureItemInfo item) {
        if (table != null && item != null) {
            int m = table.getRowCount();
            for (int i = 0; i < m; ++i) {
                int n = table.getColumnCount();
                for (int j = 0; j < n; ++j) {
                    TableCell cell = table.getCell(i, j);
                    if (cell.getData() != item) continue;
                    return cell;
                }
            }
        }
        return null;
    }

    public static boolean insertRow(Table table, int index, int num, BizConfigureItemCollection list) {
        if (table != null) {
            if (table.getRowCount() + num > 100) {
                return false;
            }
            if (index >= table.getRowCount()) {
                int beginPos = DefaultTableCalculator.VSPACE;
                TableRow lastRow = table.getRow(table.getRowCount() - 1);
                if (lastRow != null) {
                    beginPos = lastRow.getTop() + lastRow.getHeight() + DefaultTableCalculator.VSPACE;
                }
                for (int i = 0; i < num; ++i) {
                    TableRow row = table.addRow();
                    row.setTop(beginPos);
                    row.setHeight(DefaultTableCalculator.VLARGESPACE);
                    beginPos += DefaultTableCalculator.VLARGESPACE + DefaultTableCalculator.VSPACE;
                }
            } else if (index == 0) {
                int i;
                TableRow row = table.getRow(0);
                int beginPos = row.getTop();
                int yOffSet = 0;
                for (i = 0; i < num; ++i) {
                    row = table.insertRow(i);
                    row.setTop(beginPos);
                    row.setHeight(DefaultTableCalculator.VLARGESPACE);
                    beginPos += DefaultTableCalculator.VLARGESPACE + DefaultTableCalculator.VSPACE;
                    yOffSet += DefaultTableCalculator.VLARGESPACE + DefaultTableCalculator.VSPACE;
                }
                for (i = num; i < table.getRowCount(); ++i) {
                    row = table.getRow(i);
                    row.setTop(row.getTop() + yOffSet);
                }
            } else {
                int i;
                TableRow row = table.getRow(index);
                int beginPos = row.getTop();
                int yOffSet = 0;
                for (i = 0; i < num; ++i) {
                    row = table.insertRow(index + i);
                    row.setTop(beginPos);
                    row.setHeight(DefaultTableCalculator.VLARGESPACE);
                    beginPos += DefaultTableCalculator.VLARGESPACE + DefaultTableCalculator.VSPACE;
                    yOffSet += DefaultTableCalculator.VLARGESPACE + DefaultTableCalculator.VSPACE;
                }
                for (i = index + num; i < table.getRowCount(); ++i) {
                    row = table.getRow(i);
                    row.setTop(row.getTop() + yOffSet);
                }
                int rowNum = index + num;
                Map mergedCells = table.getMergedCells();
                for (int i2 = 0; i2 < table.getColumnCount(); ++i2) {
                    TableCell cell = table.getCell(rowNum, i2);
                    if (cell.isMerged() && cell == cell.getMergedCell()) {
                        i2 += cell.getColumnSpan() - 1;
                        continue;
                    }
                    if (!cell.isMerged() || cell == cell.getMergedCell()) continue;
                    TableCell mergedCell = cell.getMergedCell();
                    int span = mergedCell.getColumnSpan();
                    for (int j = index; j < index + num; ++j) {
                        for (int k = i2; k < i2 + span; ++k) {
                            TableCell iCell = table.getCell(j, k);
                            mergedCells.put(iCell, mergedCell);
                        }
                    }
                    if (mergedCell.getData() != null && mergedCell.getData() instanceof BizConfigureItemInfo) {
                        BizConfigureItemInfo itemInfo = (BizConfigureItemInfo)mergedCell.getData();
                        itemInfo.setHeight(itemInfo.getHeight() + num);
                    }
                    i2 += mergedCell.getColumnSpan() - 1;
                }
            }
            TableHelper.fillList(table, list);
        }
        return true;
    }

    public static void recoverInsertRow(Table table, int index, int num) {
        block12: {
            if (table == null) break block12;
            if (index + num >= table.getRowCount()) {
                for (int i = 0; i < num; ++i) {
                    table.removeRow(table.getRowCount() - 1);
                }
            } else if (index == 0) {
                int i;
                TableRow firstRow = table.getRow(0);
                TableRow row = table.getRow(num);
                int yOffSet = row.getTop() - firstRow.getTop();
                for (i = 0; i < num; ++i) {
                    table.removeRow(0);
                }
                for (i = 0; i < table.getRowCount(); ++i) {
                    row = table.getRow(i);
                    row.setTop(row.getTop() - yOffSet);
                }
            } else {
                int i;
                TableRow firstRow = table.getRow(index);
                TableRow row = table.getRow(index + num);
                int yOffSet = row.getTop() - firstRow.getTop();
                for (i = 0; i < num && table.getRowCount() > index; ++i) {
                    table.removeRow(index);
                }
                for (i = index; i < table.getRowCount(); ++i) {
                    row = table.getRow(i);
                    row.setTop(row.getTop() - yOffSet);
                }
                for (int i2 = 0; i2 < table.getColumnCount(); ++i2) {
                    TableCell cell = table.getCell(index, i2);
                    if (cell.isMerged() && cell == cell.getMergedCell()) {
                        i2 += cell.getColumnSpan() - 1;
                        continue;
                    }
                    if (!cell.isMerged() || cell == cell.getMergedCell()) continue;
                    TableCell mergedCell = cell.getMergedCell();
                    if (mergedCell.getData() != null && mergedCell.getData() instanceof BizConfigureItemInfo) {
                        BizConfigureItemInfo itemInfo = (BizConfigureItemInfo)mergedCell.getData();
                        itemInfo.setHeight(itemInfo.getHeight() - num);
                    }
                    i2 += cell.getColumnSpan() - 1;
                }
            }
        }
    }

    public static boolean insertColumn(Table table, int index, int num, BizConfigureItemCollection list) {
        if (table != null) {
            int i;
            int width = (table.getWidth() - (table.getColumnCount() + num - 1) * 8 * 2) / (table.getColumnCount() + num);
            if (width < 20) {
                return false;
            }
            int firstColumnLeft = table.getColumn(0).getLeft();
            int lastColumnRight = table.getColumn(table.getColumnCount() - 1).getLeft() + table.getColumn(table.getColumnCount() - 1).getWidth();
            boolean isMiddleColumn = true;
            TableColumn firstColumn = null;
            if (index >= table.getColumnCount() || index == 0) {
                isMiddleColumn = false;
                firstColumn = table.getColumn(0);
            }
            if (index >= table.getColumnCount()) {
                index = table.getColumnCount();
                for (i = 0; i < num; ++i) {
                    table.addColumn();
                }
            } else {
                for (i = 0; i < num; ++i) {
                    table.insertColumn(index + i);
                }
            }
            int n = table.getColumnCount();
            for (i = 0; i < n; ++i) {
                table.getColumn(i).setLeft(8 + width * i + 8 * i);
                table.getColumn(i).setWidth(width);
            }
            int firstColumnRight = table.getColumn(0).getLeft() + table.getColumn(0).getWidth();
            table.getColumn(0).setLeft(firstColumnLeft);
            table.getColumn(0).setWidth(firstColumnRight - firstColumnLeft);
            int lastColumnLeft = table.getColumn(table.getColumnCount() - 1).getLeft();
            if (lastColumnRight - lastColumnLeft > 0) {
                table.getColumn(table.getColumnCount() - 1).setWidth(lastColumnRight - lastColumnLeft);
            } else {
                table.getColumn(table.getColumnCount() - 1).setWidth(table.getWidth() - lastColumnLeft - 8);
            }
            if (isMiddleColumn) {
                int columnNum = index + num;
                Map mergedCells = table.getMergedCells();
                for (int i2 = 0; i2 < table.getRowCount(); ++i2) {
                    TableCell cell = table.getCell(i2, columnNum);
                    if (cell.isMerged() && cell == cell.getMergedCell()) {
                        i2 += cell.getRowSpan() - 1;
                        continue;
                    }
                    if (!cell.isMerged() || cell == cell.getMergedCell()) continue;
                    TableCell mergedCell = cell.getMergedCell();
                    int span = mergedCell.getRowSpan();
                    for (int j = index; j < index + num; ++j) {
                        for (int k = i2; k < i2 + span; ++k) {
                            TableCell iCell = table.getCell(k, j);
                            mergedCells.put(iCell, mergedCell);
                        }
                    }
                    if (mergedCell.getData() != null && mergedCell.getData() instanceof BizConfigureItemInfo) {
                        BizConfigureItemInfo itemInfo = (BizConfigureItemInfo)mergedCell.getData();
                        itemInfo.setWidth(itemInfo.getWidth() + num);
                    }
                    i2 += mergedCell.getRowSpan() - 1;
                }
            } else {
                Map mergedCells = table.getMergedCells();
                for (int i3 = 0; i3 < table.getRowCount(); ++i3) {
                    BizConfigureItemInfo item;
                    TableCell cell = firstColumn.getCell(i3);
                    if (!cell.isMerged() || cell != cell.getMergedCell() || !"com.kingdee.bos.ctrl.swing.KDTabbedPane".equals((item = (BizConfigureItemInfo)cell.getData()).getComponent().getClassType()) && !"com.kingdee.bos.ctrl.swing.KDPanel".equals(item.getComponent().getClassType()) && !"com.kingdee.bos.ctrl.kdf.table.KDTable".equals(item.getComponent().getClassType())) continue;
                    TableCell mergedCell = cell.getMergedCell();
                    for (int j = index; j < index + num; ++j) {
                        mergedCells.put(table.getCell(i3, j), mergedCell);
                    }
                    if (index == 0) {
                        TableCell newMergedCell = table.getCell(i3, 0);
                        newMergedCell.setData(item);
                        mergedCell.setData(null);
                        TableHelper.changeMergedCell(table, mergedCells, mergedCell, newMergedCell);
                    }
                    item.setWidth(item.getWidth() + num);
                }
            }
            TableHelper.fillList(table, list);
        }
        return true;
    }

    public static void recoverInsertColumn(Table table, int index, int num) {
        block10: {
            if (table == null) break block10;
            if (index + num >= table.getColumnCount()) {
                TableHelper.recoverColumnMerge(table, num, false);
                for (int i = 0; i < num; ++i) {
                    table.removeColumn(table.getColumnCount() - 1);
                }
            } else if (index == 0) {
                TableHelper.recoverColumnMerge(table, num, true);
                for (int i = 0; i < num; ++i) {
                    table.removeColumn(0);
                }
            } else {
                for (int i = 0; i < num && table.getColumnCount() > index; ++i) {
                    table.removeColumn(index);
                }
                for (int i = 0; i < table.getRowCount(); ++i) {
                    TableCell cell = table.getCell(i, index);
                    if (cell.isMerged() && cell == cell.getMergedCell()) {
                        i += cell.getRowSpan() - 1;
                        continue;
                    }
                    if (!cell.isMerged() || cell == cell.getMergedCell()) continue;
                    TableCell mergedCell = cell.getMergedCell();
                    if (mergedCell.getData() != null && mergedCell.getData() instanceof BizConfigureItemInfo) {
                        BizConfigureItemInfo itemInfo = (BizConfigureItemInfo)mergedCell.getData();
                        itemInfo.setWidth(itemInfo.getWidth() - num);
                    }
                    i += cell.getRowSpan() - 1;
                }
            }
        }
    }

    public static void removeColumn(Table table, int index, BizConfigureItemCollection list) {
        if (table != null && index < table.getColumnCount() && list != null) {
            int m = table.getRowCount();
            for (int k = 0; k < m; ++k) {
                TableCell cell = table.getCell(k, index);
                BizConfigureItemInfo cellItem = null;
                if (cell.getData() != null) {
                    cellItem = (BizConfigureItemInfo)cell.getData();
                }
                if (cell.isMerged() && cell.getMergedCell().getColumnSpan() != 1) {
                    cellItem = (BizConfigureItemInfo)cell.getMergedCell().getData();
                }
                if (cellItem != null && cellItem.getComponent() != null && ("com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(cellItem.getComponent().getClassType()) || "com.kingdee.bos.ctrl.swing.KDPanel".equals(cellItem.getComponent().getClassType()) || "com.kingdee.bos.ctrl.kdf.table.KDTable".equals(cellItem.getComponent().getClassType()))) {
                    cellItem.setWidth(cellItem.getWidth() - 1);
                    continue;
                }
                if (cellItem == null) continue;
                list.remove(cellItem);
            }
            TableColumn column = table.getColumn(table.getColumnCount() - 1);
            int rightOffSet = column.getLeft() + column.getWidth();
            if (index != table.getColumnCount() - 1) {
                int xOffSet = table.getColumn(index + 1).getLeft() - table.getColumn(index).getLeft();
                for (int i = index + 1; i < table.getColumnCount(); ++i) {
                    table.getColumn(i).setLeft(table.getColumn(i).getLeft() - xOffSet);
                }
            }
            table.removeColumn(index);
            column = table.getColumn(table.getColumnCount() - 1);
            column.setWidth(rightOffSet - column.getLeft());
        }
    }

    public static void recoverRemoveColumn(Table table) {
        if (table != null) {
            int m = table.getRowCount();
            for (int k = 0; k < m; ++k) {
                TableCell cell = table.getCell(k, 0);
                BizConfigureItemInfo cellItem = null;
                if (cell.getData() != null) {
                    cellItem = (BizConfigureItemInfo)cell.getData();
                }
                if (cell.isMerged() && cell.getColumnSpan() != 1) {
                    cellItem = (BizConfigureItemInfo)cell.getMergedCell().getData();
                }
                if (cellItem == null || cellItem.getComponent() == null || !"com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(cellItem.getComponent().getClassType()) && !"com.kingdee.bos.ctrl.swing.KDPanel".equals(cellItem.getComponent().getClassType()) && !"com.kingdee.bos.ctrl.kdf.table.KDTable".equals(cellItem.getComponent().getClassType())) continue;
                cellItem.setWidth(cellItem.getWidth() + 1);
            }
            table.addColumn();
        }
    }

    public static void resetTableColumnCoordinate(Table table, List columnCoordinate) {
        if (table != null && columnCoordinate != null && table.getColumnCount() == columnCoordinate.size()) {
            int size = columnCoordinate.size();
            for (int i = 0; i < size; ++i) {
                ColumnInfo info = (ColumnInfo)columnCoordinate.get(i);
                TableColumn column = table.getColumn(i);
                column.setLeft(info.leftX);
                column.setWidth(info.width);
            }
        }
    }

    public static boolean validateCombine(Table table, List combine, BizConfigureItemCollection itemList) {
        if (table != null && combine != null && itemList != null && combine.size() > 1) {
            if (combine.size() > table.getColumnCount()) {
                return false;
            }
            int width = 0;
            int size = combine.size();
            for (int i = 0; i < size; ++i) {
                if (!(combine.get(i) instanceof BizConfigureItemInfo)) {
                    return false;
                }
                width += ((BizConfigureItemInfo)combine.get(i)).getWidth();
            }
            if (width > table.getColumnCount()) {
                return false;
            }
            int itemCount = 0;
            int size2 = combine.size();
            for (int i = 0; i < size2; ++i) {
                if (combine.get(i) instanceof EmptyConfigureItemInfo) continue;
                ++itemCount;
            }
            if (itemCount > 1) {
                return false;
            }
            int index = itemList.indexOf((BizConfigureItemInfo)combine.get(0));
            int combineSize = combine.size();
            int itemSize = itemList.size();
            for (int i = 1; i < combineSize && index + i < itemSize; ++i) {
                Object obj = combine.get(i);
                if (obj == itemList.get(index + i)) continue;
                return false;
            }
            BizConfigureItemInfo first = (BizConfigureItemInfo)combine.get(0);
            BizConfigureItemInfo last = (BizConfigureItemInfo)combine.get(combineSize - 1);
            int firstRow = -1;
            int lastRow = -1;
            int m = table.getRowCount();
            block3: for (int i = 0; i < m; ++i) {
                int n = table.getColumnCount();
                for (int j = 0; j < n; ++j) {
                    TableCell cell = table.getCell(i, j);
                    if (cell.getData() == null) continue;
                    if (cell.getData() == first) {
                        firstRow = cell.getRowIndex();
                    } else if (cell.getData() == last) {
                        lastRow = cell.getRowIndex();
                    }
                    if (firstRow != -1 && lastRow != -1) continue block3;
                }
            }
            return firstRow != -1 && lastRow != -1 && firstRow == lastRow;
        }
        return false;
    }

    public static void combineCell(BizConfigureItemCollection itemList, int start, int end) {
        if (itemList != null) {
            int i;
            BizConfigureItemInfo item = null;
            for (int i2 = start; i2 <= end; ++i2) {
                if (itemList.get(i2) instanceof EmptyConfigureItemInfo) continue;
                item = itemList.get(i2);
                break;
            }
            int width = 0;
            for (i = start; i <= end; ++i) {
                width += itemList.get(i).getWidth();
            }
            if (item != null) {
                item.setWidth(width);
                for (i = start; i <= end; ++i) {
                    itemList.removeObject(start);
                }
                itemList.addObject(start, (IObjectValue)item);
            } else {
                itemList.get(start).setWidth(width);
                for (i = start + 1; i <= end; ++i) {
                    itemList.removeObject(start + 1);
                }
            }
        }
    }

    public static boolean validateSplit(BizConfigureItemInfo item, int num, BizConfigureItemCollection itemList) {
        if (item != null && num > 1) {
            if (item.getWidth() < num) {
                return false;
            }
            return UictEditorHelper.contains(itemList, item);
        }
        return false;
    }

    public static void splitCell(BizConfigureItemCollection itemList, int index, int num) {
        if (itemList != null && num > 1) {
            BizConfigureItemInfo item = itemList.get(index);
            int width = item.getWidth();
            int newWidth = width - (num - 1);
            item.setWidth(newWidth);
            for (int i = 0; i < num - 1; ++i) {
                itemList.addObject(index + 1, (IObjectValue)new EmptyConfigureItemInfo());
            }
        }
    }

    private static BizConfigureItemCollection fillList(Table table, BizConfigureItemCollection list) {
        if (list != null) {
            list.clear();
            if (table != null) {
                for (int i = 0; i < table.getRowCount(); ++i) {
                    int n = table.getColumnCount();
                    for (int j = 0; j < n; ++j) {
                        TableCell cell = table.getCell(i, j);
                        if (cell.isMerged() && cell != cell.getMergedCell()) continue;
                        Object data = cell.getData();
                        if (data != null) {
                            list.add((BizConfigureItemInfo)data);
                            continue;
                        }
                        EmptyConfigureItemInfo empty = new EmptyConfigureItemInfo();
                        cell.setData(empty);
                        list.add(empty);
                    }
                }
            }
        }
        return list;
    }

    private static void changeMergedCell(Table table, Map mergedMap, TableCell oldCell, TableCell newCell) {
        if (table != null && mergedMap != null && oldCell != null && newCell != null && oldCell != newCell) {
            for (int i = 0; i < table.getRowCount(); ++i) {
                int n = table.getColumnCount();
                for (int j = 0; j < n; ++j) {
                    TableCell cell = table.getCell(i, j);
                    if (!cell.isMerged() || oldCell != cell.getMergedCell()) continue;
                    mergedMap.put(cell, newCell);
                }
            }
        }
    }

    private static void recoverColumnMerge(Table table, int num, boolean isChangeMergedCell) {
        for (int i = 0; i < table.getRowCount(); ++i) {
            BizConfigureItemInfo item;
            TableCell cell = table.getCell(i, 0);
            if (!cell.isMerged() || cell != cell.getMergedCell() || !"com.kingdee.bos.ctrl.swing.KDTabbedPane".equals((item = (BizConfigureItemInfo)cell.getData()).getComponent().getClassType()) && !"com.kingdee.bos.ctrl.swing.KDPanel".equals(item.getComponent().getClassType()) && !"com.kingdee.bos.ctrl.kdf.table.KDTable".equals(item.getComponent().getClassType())) continue;
            if (isChangeMergedCell) {
                Map mergedCells = table.getMergedCells();
                cell.getMergedCell().setData(null);
                table.getCell(i, num).setData(item);
                TableHelper.changeMergedCell(table, mergedCells, cell.getMergedCell(), table.getCell(i, num));
            }
            item.setWidth(item.getWidth() - num);
        }
    }

    public static void main(String[] args) {
    }
}

