/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.editor.util.figure;

import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.apache.log4j.Logger;

public class FigureHelper {
    private static final Logger logger = CoreUIObject.getLogger((Class)FigureHelper.class);
    public static final int EAST = 1;
    public static final int WEST = 2;
    public static final int SOUTH = 4;
    public static final int NORTH = 8;

    public static BufferedImage drawAlphaImage(Dimension size, float alpha, Color color, boolean border) {
        if (size.width <= 0) {
            size.width = 1;
            logger.info((Object)"\u5bbd\u5ea6\u5c0f\u4e8e0,\u81ea\u52a8\u8c03\u6574\u4e3a1px");
        }
        if (size.height <= 0) {
            size.height = 19;
            logger.info((Object)"\u9ad8\u5ea6\u5c0f\u4e8e0,\u81ea\u52a8\u8c03\u6574\u4e3a19px");
        }
        BufferedImage image = new BufferedImage(size.width, size.height, 6);
        Graphics2D gm = image.createGraphics();
        gm.setColor(color);
        gm.setComposite(AlphaComposite.getInstance(4, alpha));
        gm.fillRect(0, 0, size.width, size.height);
        if (border) {
            gm.setComposite(AlphaComposite.getInstance(4, 1.0f));
            gm.setColor(Color.black);
            gm.drawRect(0, 0, size.width - 1, size.height - 1);
        }
        return image;
    }

    public static void drawPoint(Graphics g, Rectangle rect, int dir, Color color) {
        if (g != null && rect != null) {
            Point p;
            if ((dir & 1) != 0) {
                p = new Point(rect.x + rect.width - 2, rect.height / 2 + rect.y - 2);
                FigureHelper.drawSquare(g, p, color);
            }
            if ((dir & 2) != 0) {
                p = new Point(rect.x - 2, rect.height / 2 + rect.y - 2);
                FigureHelper.drawSquare(g, p, color);
            }
            if ((dir & 4) != 0) {
                p = new Point(rect.width / 2 + rect.x - 2, rect.y + rect.height - 2);
                FigureHelper.drawSquare(g, p, color);
            }
            if ((dir & 8) != 0) {
                p = new Point(rect.width / 2 + rect.x - 2, rect.y - 2);
                FigureHelper.drawSquare(g, p, color);
            }
        }
    }

    private static void drawSquare(Graphics g, Point point, Color color) {
        Color old = g.getColor();
        g.setColor(Color.white);
        g.fillRect(point.x, point.y, 6, 6);
        g.setColor(color);
        g.fillRect(point.x + 1, point.y + 1, 4, 4);
        g.setColor(old);
    }

    public static ComponentParam getComponentParam(BizConfigureItemInfo item) {
        ComponentParam cp = new ComponentParam();
        ComponentInfo cInfo = item.getComponent();
        if (cInfo == null) {
            return cp;
        }
        cp.enabled = item.isEnabled();
        cp.required = item.isRequired();
        if ("com.kingdee.bos.ctrl.swing.KDCheckBox".equals(cInfo.getClassType())) {
            cp.boundLabelText = item.getLabel();
        } else if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(cInfo.getClassType())) {
            cp.boundLabelText = StringUtils.isEmpty((String)cInfo.getAlias()) ? cInfo.getName() : cInfo.getAlias();
        } else if ("com.kingdee.bos.ctrl.swing.KDLabel".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDButton".equals(cInfo.getClassType())) {
            PropertyInfo property = cInfo.getPropertyByName("text");
            if (property != null) {
                cp.text = property.getValue();
            }
        } else if (cInfo.getParent() != null) {
            if ("com.kingdee.bos.ctrl.swing.KDScrollPane".equals(cInfo.getParent().getClassType())) {
                cInfo = cInfo.getParent();
            }
            if ("com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(cInfo.getParent().getClassType())) {
                cp.boundLabelText = item.getLabel();
                cp.boundLabelLength = item.getLabelLength();
                cp.boundLabelUnderline = item.isLabelUnderLine();
                PropertyInfo property = cInfo.getParent().getPropertyByName("boundLabelAlignment");
                if (property != null) {
                    cp.boundLabelAlignment = Integer.parseInt(property.getValue());
                }
            }
        } else {
            PropertyInfo property = cInfo.getPropertyByName("text");
            if (property != null) {
                cp.boundLabelText = property.getValue();
            }
        }
        return cp;
    }

    public static class ComponentParam {
        public String boundLabelText = "";
        public int boundLabelLength = 100;
        public boolean boundLabelUnderline = true;
        public int boundLabelAlignment = 7;
        public Color foreground = new Color(0, 0, 0);
        public boolean enabled = true;
        public boolean required = false;
        public String text = "";
    }
}

