/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.ie;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bizunit.BizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.configure.IMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectCtrl;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.RelationshipCtrl;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.function.FunctionObjectCtrl;
import com.kingdee.bos.metadata.query.JoinQueryCtrl;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.service.permission.metadata.PermissionCtrl;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BizConfigureImportExporter {
    private static final Logger logger = Logger.getLogger((Class)BizConfigureImportExporter.class);
    public static final String ENTITY = "entity";
    public static final String RELATIONSHIP = "relation";
    public static final String UIOBJECT = "ui";
    public static final String QUERY = "query";
    public static final String FUNCTION = "function";
    public static final String PERMISSION = "permission";
    private static Map map = new HashMap();
    private Context ctx;
    private EntityObjectCtrl entityCtrl;
    private RelationshipCtrl relationCtrl;
    private JoinQueryCtrl queryCtrl;
    private UIObjectCtrl uiCtrl;
    private FunctionObjectCtrl functionCtrl;
    private PermissionCtrl permissionCtrl;

    public BizConfigureImportExporter(Context ctx) {
        this.ctx = ctx;
        this.entityCtrl = new EntityObjectCtrl(ctx);
        this.relationCtrl = new RelationshipCtrl(ctx);
        this.queryCtrl = new JoinQueryCtrl(ctx);
        this.uiCtrl = new UIObjectCtrl(ctx);
        this.functionCtrl = new FunctionObjectCtrl(ctx);
        this.permissionCtrl = new PermissionCtrl(ctx);
    }

    public static BizConfigureImportExporter getInstance(Context ctx) {
        if (ctx == null) {
            return null;
        }
        BizConfigureImportExporter instance = null;
        if (map.containsKey(ctx)) {
            instance = (BizConfigureImportExporter)map.get(ctx);
        } else {
            instance = new BizConfigureImportExporter(ctx);
            map.put(ctx, instance);
        }
        return instance;
    }

    private static String getMetaDataType(String entryName) {
        if (StringUtils.isEmpty((String)entryName) || entryName.indexOf(".") <= 0) {
            return null;
        }
        int dotIndex = entryName.lastIndexOf(".");
        return entryName.substring(dotIndex + 1);
    }

    public void importData(File path) throws IOException, FileNotFoundException {
        IMetadataStore mds = MetadataStoreFactory.getMetadataStore(null);
        ArrayList metas = new ArrayList();
        this.loadAllMetadata(path, metas);
        AbstractMetaDataValue[] amv = new AbstractMetaDataValue[metas.size()];
        amv = metas.toArray(amv);
        try {
            mds.saveConfigureMetadata(amv);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void loadAllMetadata(File path, List metas) {
        if (path == null || !path.exists() || !path.isDirectory()) {
            return;
        }
        File[] fs = path.listFiles();
        for (int i = 0; i < fs.length; ++i) {
            File f = fs[i];
            if (f.isDirectory()) {
                this.loadAllMetadata(f, metas);
                continue;
            }
            String bosType = BizConfigureImportExporter.getMetaDataType(f.getName());
            if (StringUtils.isEmpty((String)bosType)) continue;
            try {
                FileInputStream fis = new FileInputStream(f);
                IObjectValue value = null;
                if (ENTITY.equals(bosType)) {
                    value = this.entityCtrl.load((InputStream)fis);
                    if (value == null) continue;
                    metas.add(value);
                    continue;
                }
                if (RELATIONSHIP.equals(bosType)) {
                    value = this.relationCtrl.load((InputStream)fis);
                    if (value == null) continue;
                    metas.add(value);
                    continue;
                }
                if (QUERY.equals(bosType)) {
                    value = this.queryCtrl.load((InputStream)fis);
                    if (value == null) continue;
                    metas.add(value);
                    continue;
                }
                if (UIOBJECT.equals(bosType)) {
                    value = this.uiCtrl.load((InputStream)fis);
                    if (value == null) continue;
                    metas.add(value);
                    continue;
                }
                if (FUNCTION.equals(bosType)) {
                    value = this.functionCtrl.load((InputStream)fis);
                    if (value == null) continue;
                    metas.add(value);
                    continue;
                }
                if (!PERMISSION.equals(bosType) || (value = this.permissionCtrl.load((InputStream)fis)) == null) continue;
                metas.add(value);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    public static String[] getRelatedMetadatasPath(String bizPk) {
        String isConfigured;
        IMetaDataLoader loader;
        EntityObjectInfo entity;
        BizUnitInfo bizUnit = null;
        try {
            bizUnit = BizConfigureImportExporter.loadBizUnit(bizPk);
        }
        catch (Exception e) {
            logger.error((Object)("load biz unit '" + bizPk + "' fail..."));
        }
        if (bizUnit == null) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        String entitypk = bizUnit.getString("entityPK");
        if (!StringUtils.isEmpty((String)entitypk) && (entity = (loader = MetaDataLoaderFactory.getRemoteMetaDataLoader()).getEntity((IMetaDataPK)new MetaDataPK(entitypk))) != null) {
            String[] subMetas = BizConfigureImportExporter.getRelatedMetadatasPath(entity);
            int n = subMetas.length;
            for (int i = 0; i < n; ++i) {
                list.add(subMetas[i]);
            }
        }
        String fullName = null;
        fullName = bizUnit.getString("queryPK");
        if (!StringUtils.isEmpty((String)fullName)) {
            fullName = StringUtils.replace((String)fullName, (String)".", (String)"/") + ".query";
            list.add(fullName);
        }
        if ("true".equalsIgnoreCase(isConfigured = bizUnit.getExtendedProperty("configured"))) {
            fullName = bizUnit.getFullName();
            if (!StringUtils.isEmpty((String)fullName)) {
                fullName = StringUtils.replace((String)fullName, (String)".", (String)"/") + ".bizunit";
                list.add(fullName);
            }
            if (!StringUtils.isEmpty((String)(fullName = bizUnit.getString("listUIPK")))) {
                fullName = StringUtils.replace((String)fullName, (String)".", (String)"/") + ".ui";
                list.add(fullName);
            }
            if (!StringUtils.isEmpty((String)(fullName = bizUnit.getString("editUIPK")))) {
                fullName = StringUtils.replace((String)fullName, (String)".", (String)"/") + ".ui";
                list.add(fullName);
            }
            if (!StringUtils.isEmpty((String)(fullName = bizUnit.getString("listUIFunctionPK")))) {
                fullName = StringUtils.replace((String)fullName, (String)".", (String)"/") + ".function";
                list.add(fullName);
            }
            if (!StringUtils.isEmpty((String)(fullName = bizUnit.getString("editUIFunctionPK")))) {
                fullName = StringUtils.replace((String)fullName, (String)".", (String)"/") + ".function";
                list.add(fullName);
            }
        }
        String[] metas = new String[list.size()];
        metas = list.toArray(metas);
        return metas;
    }

    public static String[] getRelatedMetadatasPath(EntityObjectInfo entity) {
        if (entity == null) {
            return new String[0];
        }
        String fullName = null;
        ArrayList<String> list = new ArrayList<String>();
        fullName = entity.getFullName();
        fullName = StringUtils.replace((String)fullName, (String)".", (String)"/") + ".entity";
        list.add(fullName);
        PropertyCollection props = entity.getProperties();
        int n = props.size();
        for (int i = 0; i < n; ++i) {
            EntityObjectInfo subEntity;
            if (!(props.get(i) instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo lnkProp = (LinkPropertyInfo)props.get(i);
            RelationshipInfo rel = lnkProp.getRelationship();
            if (lnkProp.isConfigured()) {
                fullName = rel.getFullName();
                fullName = StringUtils.replace((String)fullName, (String)".", (String)"/") + ".relation";
                list.add(fullName);
                continue;
            }
            if (!CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)rel.getSupplierCardinality()) && !CardinalityType.ONE_TO_UNBOUNDED.equals((Object)rel.getSupplierCardinality()) || (subEntity = rel.getSupplierObject()).equals((Object)entity)) continue;
            String[] subMetas = BizConfigureImportExporter.getRelatedMetadatasPath(subEntity);
            int m = subMetas.length;
            for (int j = 0; j < m; ++j) {
                list.add(subMetas[j]);
            }
        }
        String[] metas = new String[list.size()];
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            metas[i] = (String)list.get(i);
        }
        return metas;
    }

    private static BizUnitInfo loadBizUnit(String pk) {
        MetaDataPK mpk = new MetaDataPK(pk);
        BizUnitInfo bizUnit = null;
        if (mpk != null) {
            try {
                BizUnitCtrl bizUnitCtrl = new BizUnitCtrl(ContextManager.getContext());
                bizUnit = bizUnitCtrl.getValue((IMetaDataPK)mpk);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return bizUnit;
    }

    public static void main(String[] args) throws Exception {
    }
}

