/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.ie;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uict.BizConfigureInfo;
import com.kingdee.eas.base.uict.EntyRefCollection;
import com.kingdee.eas.base.uict.EntyRefInfo;
import com.kingdee.eas.base.uict.OrgUictCollection;
import com.kingdee.eas.base.uict.OrgUictInfo;
import com.kingdee.eas.base.uict.UserOrgUictCollection;
import com.kingdee.eas.base.uict.UserOrgUictInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.jdom.CDATA;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.output.XMLOutputter;

public class BizConfigureSerializer {
    public static final String BIZCONFIG = "BizConfigure";
    public static final String ID = "ID";
    public static final String NAME = "Name";
    public static final String DESCRIPTION = "Description";
    public static final String BIZUNITPK = "BizUnitPK";
    public static final String UIOBJECTPK = "UIObjectPK";
    public static final String UIOBJECT = "UIObject";
    public static final String LISTUIOBJECTPK = "ListUIObjectPK";
    public static final String LISTUIOBJECT = "ListUIObject";
    public static final String ORGTYPE = "OrgType";
    public static final String ORGUNIT = "OrgUnit";
    public static final String BIZRULESET = "BizRuleSet";
    public static final String RESERVER = "Reserver";
    public static final String CREATOR = "Creator";
    public static final String ORGUICTCOLS = "OrgUictCols";
    public static final String ORGUICT = "OrgUict";
    public static final String ORGUICT_USE = "Use";
    public static final String ORGUICT_DEFAULT = "DefaultCfg";
    public static final String ORGUICT_ORGID = "OrgID";
    public static final String ORGUICT_CFGID = "CfgID";
    public static final String ORGUICT_CU = "CtrlUnit";
    public static final String ORGUICT_BIZPK = "BizUnitPK";
    public static final String USERUICTCOLS = "UserUictCols";
    public static final String USERUICT = "UserUict";
    public static final String USERUICT_USER = "User";
    public static final String USERUICT_ORG = "Org";
    public static final String USERUICT_CFG = "Configure";
    public static final String USERUICT_CU = "CtrlUnit";
    public static final String ENTYREFCOLS = "EntyRefCols";
    public static final String ENTYREF = "EntyRef";
    public static final String ENTYREF_ENTYPK = "EntityPK";
    public static final String ENTYREF_PROPNAME = "PropertyName";
    public static final String ENTYREF_CFGID = "CfgID";

    public static void serialize(BizConfigureInfo model, OrgUictCollection orgUicts, UserOrgUictCollection userOrgUicts, EntyRefCollection entyRefs, OutputStream os) throws IOException {
        if (model == null || os == null) {
            return;
        }
        Document doc = new Document();
        Element root = new Element(BIZCONFIG);
        doc.setRootElement(root);
        Element element = new Element(ID);
        element.setText(model.getId().toString());
        root.addContent(element);
        element = new Element(NAME);
        element.setText(model.getName());
        root.addContent(element);
        element = new Element(DESCRIPTION);
        element.setText(model.getDescription());
        root.addContent(element);
        element = new Element("BizUnitPK");
        element.setText(model.getBizUnitPK());
        root.addContent(element);
        element = new Element(UIOBJECTPK);
        element.setText(model.getUIObjectPK());
        root.addContent(element);
        element = new Element(UIOBJECT);
        element.addContent((Text)new CDATA(model.getUIObject()));
        root.addContent(element);
        element = new Element(LISTUIOBJECTPK);
        element.setText(model.getListUIObjectPK());
        root.addContent(element);
        element = new Element(LISTUIOBJECT);
        element.addContent((Text)new CDATA(model.getListUIObject()));
        root.addContent(element);
        element = new Element(BIZRULESET);
        element.addContent((Text)new CDATA(model.getBizRuleSet()));
        root.addContent(element);
        element = new Element(RESERVER);
        element.addContent(String.valueOf(model.isReserver()));
        root.addContent(element);
        element = new Element(ORGTYPE);
        element.addContent(model.getOrgType());
        root.addContent(element);
        element = new Element(ORGUNIT);
        if (model.getOrgUnit() != null) {
            element.setText(model.getOrgUnit().getId().toString());
        }
        root.addContent(element);
        element = new Element(CREATOR);
        if (model.getCreator() != null) {
            element.setText(model.getCreator().getId().toString());
        }
        root.addContent(element);
        Element entys = BizConfigureSerializer.serializeEntys(entyRefs);
        root.addContent(entys);
        XMLOutputter output = new XMLOutputter();
        output.setOmitDeclaration(true);
        output.setNewlines(true);
        output.setIndent("\t");
        output.output(doc, os);
    }

    public static BizConfigureInfo deSerializeBizConfigure(InputStream is, OrgUictCollection orgUicts, UserOrgUictCollection userOrgUicts, EntyRefCollection entyRefs) throws IOException, JDOMException {
        if (is == null) {
            return null;
        }
        Document doc = XMLParser.parseXML((InputStream)is);
        if (doc == null) {
            return null;
        }
        if (doc != null && doc.getRootElement() != null) {
            Element root = doc.getRootElement();
            BizConfigureInfo model = new BizConfigureInfo();
            Element element = root.getChild(ID);
            if (element != null && StringUtils.isEmpty((String)element.getText())) {
                return null;
            }
            model.setId(BOSUuid.read((String)element.getText()));
            element = root.getChild(NAME);
            if (element != null) {
                model.setName(element.getText());
            }
            if ((element = root.getChild(DESCRIPTION)) != null) {
                model.setDescription(element.getText());
            }
            if ((element = root.getChild("BizUnitPK")) != null) {
                model.setBizUnitPK(element.getText());
            }
            if ((element = root.getChild(LISTUIOBJECTPK)) != null) {
                model.setListUIObjectPK(element.getText());
            }
            if ((element = root.getChild(LISTUIOBJECT)) != null) {
                model.setListUIObject(element.getText());
            }
            if ((element = root.getChild(UIOBJECTPK)) != null) {
                model.setUIObjectPK(element.getText());
            }
            if ((element = root.getChild(UIOBJECT)) != null) {
                model.setUIObject(element.getText());
            }
            if ((element = root.getChild(BIZRULESET)) != null) {
                model.setBizRuleSet(element.getText());
            }
            if ((element = root.getChild(RESERVER)) != null) {
                model.setReserver("true".equalsIgnoreCase(element.getText()));
            }
            if ((element = root.getChild(ORGTYPE)) != null) {
                model.setOrgType(element.getText());
            }
            OrgUnitInfo orgUnit = SysContext.getSysContext().getCurrentOrgUnit();
            model.setOrgUnit(orgUnit.castToFullOrgUnitInfo());
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            model.setCreator(userInfo);
            element = root.getChild(ENTYREFCOLS);
            if (entyRefs != null) {
                BizConfigureSerializer.deSerializeEntys(element, entyRefs);
            }
            return model;
        }
        return null;
    }

    private static Element serializeOrgs(OrgUictCollection orgUicts) {
        Element cols = new Element(ORGUICTCOLS);
        if (orgUicts != null) {
            int size = orgUicts.size();
            for (int i = 0; i < size; ++i) {
                OrgUictInfo orgInfo = orgUicts.get(i);
                Element item = new Element(ORGUICT);
                Element element = new Element(ID);
                element.setText(orgInfo.getId().toString());
                item.addContent(element);
                element = new Element(ORGUICT_USE);
                element.setText(String.valueOf(orgInfo.isUse()));
                item.addContent(element);
                element = new Element(ORGUICT_DEFAULT);
                element.setText(String.valueOf(orgInfo.isDefaultCfg()));
                item.addContent(element);
                element = new Element(ORGUICT_ORGID);
                element.setText(orgInfo.getOrgID());
                item.addContent(element);
                element = new Element("CfgID");
                element.setText(orgInfo.getConfigureID());
                item.addContent(element);
                element = new Element("CtrlUnit");
                element.setText(orgInfo.getCtrlUnit());
                item.addContent(element);
                element = new Element("BizUnitPK");
                element.setText(orgInfo.getBizUnitPK());
                item.addContent(element);
                cols.addContent(item);
            }
        }
        return cols;
    }

    private static void deSerializeOrgs(Element orgs, OrgUictCollection orgUicts) {
        if (orgs == null || orgUicts == null) {
            return;
        }
        List children = orgs.getChildren(ORGUICT);
        if (children == null) {
            return;
        }
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            OrgUictInfo oui = new OrgUictInfo();
            Element element = child.getChild(ID);
            if (element == null || StringUtils.isEmpty((String)element.getText())) continue;
            oui.setId(BOSUuid.read((String)element.getText()));
            element = child.getChild("CfgID");
            if (element == null || StringUtils.isEmpty((String)element.getText())) continue;
            oui.setConfigureID(element.getText());
            element = child.getChild(ORGUICT_USE);
            if (element != null) {
                oui.setUse("true".equalsIgnoreCase(element.getText()));
            }
            if ((element = child.getChild(ORGUICT_DEFAULT)) != null) {
                oui.setDefaultCfg("true".equalsIgnoreCase(element.getText()));
            }
            if ((element = child.getChild(ORGUICT_ORGID)) != null) {
                oui.setOrgID(element.getText());
            }
            if ((element = child.getChild("CtrlUnit")) != null) {
                oui.setCtrlUnit(element.getText());
            }
            if ((element = child.getChild("BizUnitPK")) != null) {
                oui.setBizUnitPK(element.getText());
            }
            orgUicts.add(oui);
        }
    }

    private static Element serializeUsers(UserOrgUictCollection userOrgUicts) {
        Element cols = new Element(USERUICTCOLS);
        if (userOrgUicts != null) {
            int size = userOrgUicts.size();
            for (int i = 0; i < size; ++i) {
                UserOrgUictInfo userInfo = userOrgUicts.get(i);
                Element item = new Element(USERUICT);
                Element element = new Element(ID);
                element.setText(userInfo.getId().toString());
                item.addContent(element);
                element = new Element(USERUICT_USER);
                if (userInfo.getUser() != null) {
                    element.setText(userInfo.getUser().getId().toString());
                }
                item.addContent(element);
                element = new Element(USERUICT_ORG);
                if (userInfo.getOrg() != null) {
                    element.setText(userInfo.getOrg().getId().toString());
                }
                item.addContent(element);
                element = new Element(USERUICT_CFG);
                if (userInfo.getConfigure() != null) {
                    element.setText(userInfo.getConfigure().getId().toString());
                }
                item.addContent(element);
                element = new Element("CtrlUnit");
                if (userInfo.getCtrlUnit() != null) {
                    element.setText(userInfo.getCtrlUnit().getId().toString());
                }
                item.addContent(element);
                cols.addContent(item);
            }
        }
        return cols;
    }

    private static void deSerializeUsers(Element users, UserOrgUictCollection userUicts) {
        if (users == null || userUicts == null) {
            return;
        }
        List children = users.getChildren(USERUICT);
        if (children == null) {
            return;
        }
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            String id;
            Element child = (Element)children.get(i);
            UserOrgUictInfo oui = new UserOrgUictInfo();
            Element element = child.getChild(ID);
            if (element == null || StringUtils.isEmpty((String)element.getText())) continue;
            oui.setId(BOSUuid.read((String)element.getText()));
            element = child.getChild(USERUICT_CFG);
            if (element == null || StringUtils.isEmpty((String)(id = element.getText()))) continue;
            BizConfigureInfo cfg = new BizConfigureInfo();
            cfg.setId(BOSUuid.read((String)id));
            oui.setConfigure(cfg);
            element = child.getChild(USERUICT_USER);
            if (element != null) {
                id = element.getText();
                UserInfo ui = new UserInfo();
                ui.setId(BOSUuid.read((String)id));
                oui.setUser(ui);
            }
            if ((element = child.getChild(USERUICT_ORG)) != null) {
                id = element.getText();
                FullOrgUnitInfo org = new FullOrgUnitInfo();
                org.setId(BOSUuid.read((String)id));
                oui.setOrg(org);
            }
            if ((element = child.getChild("CtrlUnit")) != null) {
                id = element.getText();
                CtrlUnitInfo cui = new CtrlUnitInfo();
                cui.setId(BOSUuid.read((String)id));
                oui.setCtrlUnit(cui);
            }
            userUicts.add(oui);
        }
    }

    private static Element serializeEntys(EntyRefCollection entyRefs) {
        Element cols = new Element(ENTYREFCOLS);
        if (entyRefs != null) {
            int size = entyRefs.size();
            for (int i = 0; i < size; ++i) {
                EntyRefInfo erInfo = entyRefs.get(i);
                Element item = new Element(ENTYREF);
                Element element = new Element(ID);
                element.setText(erInfo.getId().toString());
                item.addContent(element);
                element = new Element(ENTYREF_ENTYPK);
                element.setText(erInfo.getEntityPK());
                item.addContent(element);
                element = new Element(ENTYREF_PROPNAME);
                element.setText(erInfo.getPropertyName());
                item.addContent(element);
                element = new Element("CfgID");
                element.setText(erInfo.getConfigureID());
                item.addContent(element);
                cols.addContent(item);
            }
        }
        return cols;
    }

    private static void deSerializeEntys(Element entys, EntyRefCollection entyCol) {
        if (entys == null || entyCol == null) {
            return;
        }
        List children = entys.getChildren(ENTYREF);
        if (children == null) {
            return;
        }
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            EntyRefInfo eri = new EntyRefInfo();
            Element element = child.getChild(ID);
            if (element == null || StringUtils.isEmpty((String)element.getText())) continue;
            eri.setId(BOSUuid.read((String)element.getText()));
            element = child.getChild("CfgID");
            if (element == null || StringUtils.isEmpty((String)element.getText())) continue;
            eri.setConfigureID(element.getText());
            element = child.getChild(ENTYREF_ENTYPK);
            if (element != null) {
                eri.setEntityPK(element.getText());
            }
            if ((element = child.getChild(ENTYREF_PROPNAME)) != null) {
                eri.setPropertyName(element.getText());
            }
            entyCol.add(eri);
        }
    }
}

