/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.ie;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.upgrade.FileUtil;
import com.kingdee.bos.metadata.util.ZipFileUtils;
import com.kingdee.eas.base.uict.BizConfigureFactory;
import com.kingdee.eas.base.uict.BizConfigureInfo;
import com.kingdee.eas.base.uict.EntyRefCollection;
import com.kingdee.eas.base.uict.EntyRefFactory;
import com.kingdee.eas.base.uict.EntyRefInfo;
import com.kingdee.eas.base.uict.OrgUictCollection;
import com.kingdee.eas.base.uict.UserOrgUictCollection;
import com.kingdee.eas.base.uict.client.BizConfigureListUI;
import com.kingdee.eas.base.uict.client.UictProgressDlgUI;
import com.kingdee.eas.base.uict.client.ie.BizConfigureImportExporter;
import com.kingdee.eas.base.uict.client.ie.BizConfigureSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class UictExportRun
implements Runnable {
    private static final Logger logger = Logger.getLogger((Class)UictExportRun.class);
    private String configureDir;
    private String configureJar;
    private File file;
    private String[] cfgids = new String[0];
    private String[] metas;
    private BizConfigureListUI owner;
    private UictProgressDlgUI progressDlgUI;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                this.initConfigureDir();
                this.createBizXml();
                this.createDynMetas();
                this.createZip();
            }
            catch (Exception e) {
                logger.error((Object)e);
                Object var3_2 = null;
                this.progressDlgUI.stop();
                this.progressDlgUI.getUIWindow().close();
                FileUtil.deleteDir((File)new File(this.configureDir + File.separator + "import"));
                return;
            }
            Object var3_1 = null;
            this.progressDlgUI.stop();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.progressDlgUI.stop();
            this.progressDlgUI.getUIWindow().close();
            FileUtil.deleteDir((File)new File(this.configureDir + File.separator + "import"));
            throw throwable;
        }
        this.progressDlgUI.getUIWindow().close();
        FileUtil.deleteDir((File)new File(this.configureDir + File.separator + "import"));
    }

    private void initConfigureDir() {
        this.configureDir = System.getProperty("configure.path");
        String eas_home = System.getProperty("EAS_HOME");
        if (this.configureDir == null && eas_home == null) {
            throw new RuntimeException("not set configure Dir. please set -Dconfigure.path");
        }
        if (this.configureDir == null) {
            this.configureDir = eas_home + "/client/metas/configure";
        }
        logger.info((Object)("MetadataStore configure dir is " + this.configureDir));
        this.configureJar = this.configureDir + "/" + ConfigMDUtil.getAIS() + "/" + "dynamic-configure-metas.jar";
    }

    private void unjar() {
        File temp;
        if (new File(this.configureJar).exists()) {
            try {
                ZipFileUtils.unJarFile((String)this.configureJar, (String)(this.configureDir + "/export/dyn_meta"));
            }
            catch (Exception e) {
                logger.info((Object)"unjar fail...", (Throwable)e);
            }
        }
        if (!(temp = new File(this.configureDir + "/export/dyn_meta")).exists()) {
            temp.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void createBizXml() {
        ids = this.array2String(this.cfgids);
        if (StringUtils.isEmpty((String)ids)) {
            return;
        }
        try {
            bizCols = BizConfigureFactory.getRemoteInstance().getCollection("WHERE id in (" + ids + ")");
            entCols = EntyRefFactory.getRemoteInstance().getCollection("WHERE configureID in (" + ids + ")");
            itemMap = new HashMap<String, ExportItemInfo>();
            bizUnitPks = new HashSet<String>();
            size = bizCols.size();
            for (i = 0; i < size; ++i) {
                bcInfo = (BizConfigureInfo)bizCols.get(i);
                eiInfo = new ExportItemInfo();
                eiInfo.bizConfigureInfo = bcInfo;
                itemMap.put(bcInfo.getId().toString(), eiInfo);
                bizUnitPks.add(bcInfo.getBizUnitPK());
            }
            size = entCols.size();
            for (i = 0; i < size; ++i) {
                erInfo = (EntyRefInfo)entCols.get(i);
                cfgid = erInfo.getConfigureID();
                obj = itemMap.get(cfgid);
                if (!(obj instanceof ExportItemInfo)) continue;
                eiInfo = (ExportItemInfo)obj;
                eiInfo.entyRefCollection.add(erInfo);
            }
            set = itemMap.entrySet();
            i = 1;
            name = "config_";
            iter = set.iterator();
            while (iter.hasNext()) {
                block22: {
                    entry = iter.next();
                    eiInfo = (ExportItemInfo)entry.getValue();
                    file = new File(this.configureDir + "/export/xmls/" + name + i + ".xml");
                    if (!file.exists()) {
                        try {
                            file.getParentFile().mkdirs();
                            file.createNewFile();
                        }
                        catch (IOException e) {
                            UictExportRun.logger.error((Object)("create file:[" + file.getPath() + "]fail..."));
                            continue;
                        }
                    }
                    fos = null;
                    try {
                        fos = new FileOutputStream(file);
                        BizConfigureSerializer.serialize(eiInfo.bizConfigureInfo, eiInfo.orgUictCollection, eiInfo.userOrgUictCollection, eiInfo.entyRefCollection, fos);
                        var16_19 = null;
                        ** if (fos == null) goto lbl-1000
                    }
                    catch (Throwable var15_21) {
                        var16_19 = null;
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        throw var15_21;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block22;
                        catch (Exception e) {
                            UictExportRun.logger.error((Object)e);
                            var16_19 = null;
                            if (fos != null) {
                                try {
                                    fos.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                    }
                }
                ++i;
            }
            ps = new ArrayList<String>();
            iter = bizUnitPks.iterator();
            while (iter.hasNext()) {
                pk = (String)iter.next();
                amv = BizConfigureImportExporter.getRelatedMetadatasPath(pk);
                for (j = 0; j < amv.length; ++j) {
                    ps.add(amv[j]);
                }
            }
            this.metas = new String[ps.size()];
            this.metas = ps.toArray(this.metas);
        }
        catch (BOSException e) {
            UictExportRun.logger.error((Object)e);
        }
    }

    private void createDynMetas() {
        if (this.metas == null && this.metas.length == 0) {
            return;
        }
        this.unjar();
        HashSet<File> set = new HashSet<File>();
        for (int i = 0; i < this.metas.length; ++i) {
            String meta = this.metas[i];
            File mf = new File(this.configureDir + "/export/dyn_meta/" + meta);
            set.add(mf);
        }
        File temp2 = new File(this.configureDir + "/export/dyn_meta");
        this.remove(set, temp2);
        this.removeEmptyDir(temp2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createZip() {
        File exp = new File(this.configureDir + "/export");
        if (exp.exists()) {
            try {
                ZipFileUtils.zipFile((String)(this.configureDir + "/export"), (String)(this.configureDir + "/export"), (String)(this.file.getPath() + "/export.zip"));
            }
            catch (Exception e) {
                logger.error((Object)"create export.zip fail...", (Throwable)e);
            }
            finally {
                FileUtil.deleteDir((File)exp);
            }
        }
    }

    private void remove(Set set, File file) {
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.remove(set, files[i]);
                continue;
            }
            if (set.contains(files[i])) continue;
            files[i].delete();
        }
    }

    private void removeEmptyDir(File file) {
        if (file.isDirectory()) {
            File[] fs = file.listFiles();
            if (fs.length == 0) {
                file.delete();
            } else {
                for (int i = 0; i < fs.length; ++i) {
                    this.removeEmptyDir(fs[i]);
                }
            }
        }
    }

    private String array2String(String[] ids) {
        String ret = "";
        if (ids != null) {
            for (int i = 0; i < ids.length; ++i) {
                ret = i == 0 ? ret + "'" + ids[i] + "'" : ret + ",'" + ids[i] + "'";
            }
        }
        return ret;
    }

    public void setCfgIDs(String[] cfgids) {
        if (cfgids == null) {
            logger.info((Object)"configure id array is null...");
            throw new IllegalArgumentException("configure id array can not be null");
        }
        this.cfgids = cfgids;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public BizConfigureListUI getOwner() {
        return this.owner;
    }

    public void setOwner(BizConfigureListUI owner) {
        this.owner = owner;
    }

    public UictProgressDlgUI getProgressDlgUI() {
        return this.progressDlgUI;
    }

    public void setProgressDlgUI(UictProgressDlgUI progressDlgUI) {
        this.progressDlgUI = progressDlgUI;
    }

    public static void main(String[] args) {
    }

    class ExportItemInfo {
        public BizConfigureInfo bizConfigureInfo;
        public OrgUictCollection orgUictCollection = new OrgUictCollection();
        public UserOrgUictCollection userOrgUictCollection = new UserOrgUictCollection();
        public EntyRefCollection entyRefCollection = new EntyRefCollection();

        ExportItemInfo() {
        }
    }
}

