/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.ie;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.IMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.entity.EntityObjectCtrl;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.upgrade.FileUtil;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.metadata.util.ZipFileUtils;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uict.BizConfigureFactory;
import com.kingdee.eas.base.uict.BizConfigureInfo;
import com.kingdee.eas.base.uict.EntyRefCollection;
import com.kingdee.eas.base.uict.EntyRefFactory;
import com.kingdee.eas.base.uict.EntyRefInfo;
import com.kingdee.eas.base.uict.IBizConfigure;
import com.kingdee.eas.base.uict.IEntyRef;
import com.kingdee.eas.base.uict.IOrgUict;
import com.kingdee.eas.base.uict.IUserOrgUict;
import com.kingdee.eas.base.uict.OrgUictCollection;
import com.kingdee.eas.base.uict.OrgUictFactory;
import com.kingdee.eas.base.uict.OrgUictInfo;
import com.kingdee.eas.base.uict.UserOrgUictCollection;
import com.kingdee.eas.base.uict.UserOrgUictFactory;
import com.kingdee.eas.base.uict.UserOrgUictInfo;
import com.kingdee.eas.base.uict.client.BizConfigureListUI;
import com.kingdee.eas.base.uict.client.UictProgressDlgUI;
import com.kingdee.eas.base.uict.client.ie.BizConfigureImportExporter;
import com.kingdee.eas.base.uict.client.ie.BizConfigureSerializer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class UictImportRun
implements Runnable {
    private static final Logger logger = Logger.getLogger((Class)UictImportRun.class);
    private static final String IMPORT_BIZCFG = "\u6b63\u5728\u5bfc\u5165\u754c\u9762\u914d\u7f6e\u65b9\u6848\uff01";
    private static final String IMPORT_ORGASG = "\u6b63\u5728\u5bfc\u5165\u7ec4\u7ec7\u5206\u914d";
    private static final String IMPORT_USERASG = "\u6b63\u5728\u5bfc\u5165\u7528\u6237\u7ec4\u7ec7\u5206\u914d";
    private static final String IMPORT_ENTREF = "\u5b9e\u4f53\u5c5e\u6027\u5f15\u7528";
    private String configureDir;
    private String configureJar;
    private String fileName;
    private File file;
    private BizConfigureListUI owner;
    private UictProgressDlgUI progressDlgUI;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                this.initConfigureDir();
                this.unjar();
                boolean success = this.importXmls();
                if (success) {
                    this.importMetas();
                }
                this.progressDlgUI.setResult(success);
                FileUtil.deleteDir((File)new File(this.configureDir + "/import"));
            }
            catch (Exception e) {
                logger.error((Object)e);
                Object var3_4 = null;
                this.progressDlgUI.stop();
                this.progressDlgUI.getUIWindow().close();
                FileUtil.deleteDir((File)new File(this.configureDir + File.separator + "import"));
                return;
            }
            Object var3_3 = null;
            this.progressDlgUI.stop();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.progressDlgUI.stop();
            this.progressDlgUI.getUIWindow().close();
            FileUtil.deleteDir((File)new File(this.configureDir + File.separator + "import"));
            throw throwable;
        }
        this.progressDlgUI.getUIWindow().close();
        FileUtil.deleteDir((File)new File(this.configureDir + File.separator + "import"));
    }

    private void initConfigureDir() {
        this.configureDir = System.getProperty("configure.path");
        String eas_home = System.getProperty("EAS_HOME");
        if (this.configureDir == null && eas_home == null) {
            throw new RuntimeException("not set configure Dir. please set -Dconfigure.path");
        }
        if (this.configureDir == null) {
            this.configureDir = eas_home + "/client/metas/configure";
        }
        logger.info((Object)("MetadataStore configure dir is " + this.configureDir));
        this.configureJar = this.configureDir + "/" + "dynamic-configure-metas.jar";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean importXmls() throws Exception {
        List xmls = this.getXmls();
        Iterator iter = xmls.iterator();
        while (iter.hasNext()) {
            Exception ie222;
            Object var12_13;
            BizConfigureInfo bcInfo;
            EntyRefCollection erCols;
            FileInputStream fis;
            block11: {
                File xml = (File)iter.next();
                fis = new FileInputStream(xml);
                OrgUictCollection orgCols = new OrgUictCollection();
                UserOrgUictCollection userCols = new UserOrgUictCollection();
                erCols = new EntyRefCollection();
                bcInfo = BizConfigureSerializer.deSerializeBizConfigure(fis, orgCols, userCols, erCols);
                boolean isExist = this.infoExists(bcInfo);
                if (!isExist) break block11;
                boolean bl = false;
                var12_13 = null;
                try {
                    fis.close();
                }
                catch (Exception ie222) {
                    logger.error((Object)ie222.getStackTrace());
                }
                return bl;
            }
            this.importBizConfig(bcInfo);
            this.importEntityRef(erCols);
            IOrgUict iou = OrgUictFactory.getRemoteInstance();
            iou.updateUse(this.owner.getCurrentOrgUnit().getId().toString(), bcInfo.getId().toString(), bcInfo.getBizUnitPK(), true);
            var12_13 = null;
            try {
                fis.close();
            }
            catch (Exception ie222) {
                logger.error((Object)ie222.getStackTrace());
            }
            continue;
            {
                catch (Exception e) {
                    logger.error((Object)e);
                    var12_13 = null;
                    try {
                        fis.close();
                    }
                    catch (Exception ie222) {
                        logger.error((Object)ie222.getStackTrace());
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var12_13 = null;
                try {
                    fis.close();
                }
                catch (Exception ie222) {
                    logger.error((Object)ie222.getStackTrace());
                }
                throw throwable;
            }
        }
        return true;
    }

    public boolean infoExists(BizConfigureInfo bcInfo) {
        ArrayList importProperties = new ArrayList();
        this.loadAllMetadata(new File(this.configureDir + "/import/dyn_meta"), importProperties);
        if (importProperties.size() <= 0) {
            return false;
        }
        for (int i = 0; i < importProperties.size(); ++i) {
            EntityObjectInfo importEntity = (EntityObjectInfo)importProperties.get(i);
            PropertyCollection importProCollection = importEntity.getProperties();
            PropertyCollection entityCollection = this.getProperties(importEntity);
            if (entityCollection == null || entityCollection.size() <= 0) continue;
            for (int ip = 0; ip < importProCollection.size(); ++ip) {
                PropertyInfo importPropertyInfo = importProCollection.get(ip);
                String importName = importPropertyInfo.getName();
                for (int ep = 0; ep < entityCollection.size(); ++ep) {
                    PropertyInfo entityPropertyInfo = entityCollection.get(ep);
                    String entityName = entityPropertyInfo.getName();
                    if (!entityName.equals(importName)) continue;
                    logger.error((Object)(entityName + "\u5728\u65e7\u6709\u65b9\u6848\u4e2d\u5df2\u7ecf\u5b58\u5728"));
                    MsgBox.showInfo((Component)((Object)this.getOwner()), (String)("\u5bfc\u5165\u65b9\u6848\u5931\u8d25  , \u65b9\u6848\u4e2d\u7684\u5b57\u6bb5" + entityName + "\u5728\u65e7\u6709\u65b9\u6848\u4e2d\u5df2\u7ecf\u88ab\u4f7f\u7528  , \u8bf7\u5728\u65b9\u6848\u4e2d\u9009\u62e9\u5f7b\u5e95\u5220\u9664\u7684\u65b9\u5f0f\u5220\u9664\u5143\u6570\u636e\u7247\u6bb5\u4e2d\u8be5\u5b57\u6bb5\u4fe1\u606f"));
                    return true;
                }
            }
        }
        return false;
    }

    public PropertyCollection getProperties(EntityObjectInfo entity) {
        if (entity == null || entity.getFullName() == null) {
            return null;
        }
        String entityPK = entity.getFullName();
        EntityObjectInfo existEntity = null;
        IMetadataStore mds = MetadataStoreFactory.getMetadataStore(null);
        AbstractMetaDataValue metadata = mds.getConfigureMetadata(MetaDataTypeList.ENTITY, (IMetaDataPK)new MetaDataPK(entityPK));
        if (metadata != null && metadata instanceof EntityObjectInfo) {
            existEntity = (EntityObjectInfo)metadata;
            return existEntity.getProperties();
        }
        return null;
    }

    private void loadAllMetadata(File path, List metas) {
        if (path == null || !path.exists() || !path.isDirectory()) {
            return;
        }
        EntityObjectCtrl entityCtrl = new EntityObjectCtrl(ContextManager.getContext());
        File[] fs = path.listFiles();
        for (int i = 0; i < fs.length; ++i) {
            File f = fs[i];
            if (f.isDirectory()) {
                this.loadAllMetadata(f, metas);
                continue;
            }
            String bosType = UictImportRun.getMetaDataType(f.getName());
            if (StringUtils.isEmpty((String)bosType)) continue;
            try {
                FileInputStream fis = new FileInputStream(f);
                IObjectValue value = null;
                if (!"entity".equals(bosType) || (value = entityCtrl.load((InputStream)fis)) == null) continue;
                metas.add(value);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private static String getMetaDataType(String entryName) {
        if (StringUtils.isEmpty((String)entryName) || entryName.indexOf(".") <= 0) {
            return null;
        }
        int dotIndex = entryName.lastIndexOf(".");
        return entryName.substring(dotIndex + 1);
    }

    private void importMetas() {
        BizConfigureImportExporter ie = BizConfigureImportExporter.getInstance(ContextManager.getContext());
        try {
            ie.importData(new File(this.configureDir + "/import/dyn_meta"));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void unjar() {
        if (this.file != null && this.file.exists()) {
            try {
                ZipFileUtils.unJarFile((String)this.file.getPath(), (String)(this.configureDir + "/import"));
            }
            catch (Exception e) {
                logger.info((Object)"unjar fail...", (Throwable)e);
            }
        }
    }

    private List getXmls() {
        File importXml = new File(this.configureDir + "/import/xmls");
        ArrayList<File> xmls = new ArrayList<File>();
        if (importXml.exists() && importXml.isDirectory()) {
            File[] fs = importXml.listFiles();
            for (int i = 0; i < fs.length; ++i) {
                File xml = fs[i];
                String name = xml.getName();
                if (!name.toLowerCase().endsWith(".xml")) continue;
                xmls.add(xml);
            }
        }
        return xmls;
    }

    private void importBizConfig(BizConfigureInfo bcInfo) throws BOSException, EASBizException {
        this.progressDlgUI.setUITitle(IMPORT_BIZCFG);
        IBizConfigure ibc = BizConfigureFactory.getRemoteInstance();
        if (bcInfo == null) {
            return;
        }
        BOSUuid botId = bcInfo.getId();
        if (botId != null && botId.toString().length() > 0) {
            if (ibc.exists((IObjectPK)new ObjectUuidPK(botId))) {
                ibc.update((IObjectPK)new ObjectUuidPK(botId), (CoreBaseInfo)bcInfo);
            } else {
                ibc.addnew((IObjectPK)new ObjectUuidPK(botId), (CoreBaseInfo)bcInfo);
            }
        } else {
            ibc.addnew((CoreBaseInfo)bcInfo);
        }
    }

    private void importOrgAssign(OrgUictCollection orgCols) throws BOSException, EASBizException {
        this.progressDlgUI.setUITitle(IMPORT_ORGASG);
        IOrgUict iou = OrgUictFactory.getRemoteInstance();
        if (orgCols == null) {
            return;
        }
        int count = orgCols.size();
        for (int i = 0; i < count; ++i) {
            OrgUictInfo ouInfo = orgCols.get(i);
            BOSUuid botId = ouInfo.getId();
            if (botId != null && botId.toString().length() > 0) {
                if (iou.exists((IObjectPK)new ObjectUuidPK(botId))) {
                    iou.update((IObjectPK)new ObjectUuidPK(botId), ouInfo);
                    continue;
                }
                iou.addnew((IObjectPK)new ObjectUuidPK(botId), ouInfo);
                continue;
            }
            iou.addnew(ouInfo);
        }
    }

    private void importUserOrgAssign(UserOrgUictCollection userCols) throws BOSException, EASBizException {
        this.progressDlgUI.setUITitle(IMPORT_USERASG);
        IUserOrgUict iuou = UserOrgUictFactory.getRemoteInstance();
        if (userCols == null) {
            return;
        }
        int count = userCols.size();
        for (int i = 0; i < count; ++i) {
            UserOrgUictInfo uouInfo = userCols.get(i);
            BOSUuid botId = uouInfo.getId();
            if (botId != null && botId.toString().length() > 0) {
                if (iuou.exists((IObjectPK)new ObjectUuidPK(botId))) {
                    iuou.update((IObjectPK)new ObjectUuidPK(botId), uouInfo);
                    continue;
                }
                iuou.addnew((IObjectPK)new ObjectUuidPK(botId), uouInfo);
                continue;
            }
            iuou.addnew(uouInfo);
        }
    }

    private void importEntityRef(EntyRefCollection erCols) throws BOSException, EASBizException {
        this.progressDlgUI.setUITitle(IMPORT_ENTREF);
        IEntyRef ier = EntyRefFactory.getRemoteInstance();
        if (erCols == null) {
            return;
        }
        int count = erCols.size();
        for (int i = 0; i < count; ++i) {
            EntyRefInfo erInfo = erCols.get(i);
            BOSUuid botId = erInfo.getId();
            if (botId != null && botId.toString().length() > 0) {
                if (ier.exists((IObjectPK)new ObjectUuidPK(botId))) {
                    ier.update((IObjectPK)new ObjectUuidPK(botId), erInfo);
                    continue;
                }
                ier.addnew((IObjectPK)new ObjectUuidPK(botId), erInfo);
                continue;
            }
            ier.addnew(erInfo);
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public BizConfigureListUI getOwner() {
        return this.owner;
    }

    public void setOwner(BizConfigureListUI owner) {
        this.owner = owner;
    }

    public UictProgressDlgUI getProgressDlgUI() {
        return this.progressDlgUI;
    }

    public void setProgressDlgUI(UictProgressDlgUI progressDlgUI) {
        this.progressDlgUI = progressDlgUI;
    }
}

