/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.permission;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.MutableTreeNode;

public class EntityTreeCreator {
    public DefaultKingdeeTreeNode create(EntityObjectInfo entity) {
        if (entity == null) {
            return null;
        }
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText("root");
        EntityEntry[] ee = this.getParents(entity);
        for (int i = 0; i < ee.length; ++i) {
            DefaultKingdeeTreeNode entityNode = new DefaultKingdeeTreeNode();
            entityNode.setText(ee[i].entity.getName());
            entityNode.setUserObject((Object)ee[i].entity);
            this.createChildren(entityNode, ee[i]);
            root.add((MutableTreeNode)entityNode);
        }
        return root;
    }

    public void createChildren(DefaultKingdeeTreeNode entityNode, EntityEntry entityEntry) {
        if (entityNode != null && entityEntry != null) {
            EntityObjectInfo entity = entityEntry.entity;
            MethodCollection methods = entity.getMethods();
            int n = methods.size();
            for (int i = 0; i < n; ++i) {
                MethodInfo method = methods.get(i);
                DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode();
                child.setText(this.getMethodDeclares(method));
                child.setUserObject((Object)method);
                entityNode.add((MutableTreeNode)child);
            }
        }
    }

    public EntityEntry[] getParents(EntityObjectInfo entity) {
        if (entity == null) {
            return new EntityEntry[0];
        }
        ArrayList parents = new ArrayList();
        this.listParents(parents, entity);
        EntityEntry[] entries = new EntityEntry[parents.size()];
        for (int i = 0; i < parents.size(); ++i) {
            EntityObjectInfo e = (EntityObjectInfo)parents.get(i);
            entries[i] = new EntityEntry(e);
        }
        return entries;
    }

    private void listParents(List list, EntityObjectInfo entity) {
        EntityObjectInfo parent = entity.getBaseEntity();
        if (parent != null) {
            this.listParents(list, parent);
        }
        list.add(entity);
    }

    private String getMethodDeclares(MethodInfo info) {
        StringBuffer sb = new StringBuffer(info.getName());
        sb.append("(");
        ParameterCollection parmas = info.getParameters();
        for (int i = 0; i < parmas.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(parmas.get(i).getDataType());
            sb.append(" ");
            sb.append(parmas.get(i).getName());
        }
        sb.append(")");
        return sb.toString();
    }

    static class EntityEntry {
        public EntityObjectInfo entity;

        public EntityEntry(EntityObjectInfo entity) {
            this.entity = entity;
        }
    }

    public static class MethodEntry {
        public MethodInfo method;
        public EntityObjectInfo parent;

        public MethodEntry(MethodInfo m, EntityObjectInfo e) {
            this.method = m;
            this.parent = e;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodEntry) {
                MethodEntry that = (MethodEntry)obj;
                if (that == null || that.method == null || this.method == null) {
                    return false;
                }
                String otherInnerID = that.method.getString("innerID");
                String thisInnerID = this.method.getString("innerID");
                return otherInnerID.equals(thisInnerID);
            }
            return false;
        }
    }
}

