/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.permission;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.ui.ActionCollection;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.MutableTreeNode;

public class UITreeCreator {
    public DefaultKingdeeTreeNode create(UIObjectInfo entity) {
        if (entity == null) {
            return null;
        }
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText("root");
        UIObjectEntry[] ee = this.getParents(entity);
        for (int i = 0; i < ee.length; ++i) {
            DefaultKingdeeTreeNode uiNode = new DefaultKingdeeTreeNode();
            uiNode.setText(ee[i].ui.getName());
            uiNode.setUserObject((Object)ee[i].ui);
            this.createChildren(uiNode, ee[i]);
            root.add((MutableTreeNode)uiNode);
        }
        return root;
    }

    public void createChildren(DefaultKingdeeTreeNode uiNode, UIObjectEntry uiEntry) {
        if (uiNode != null && uiEntry != null) {
            UIObjectInfo ui = uiEntry.ui;
            ActionCollection methods = ui.getOwnedActions();
            int n = methods.size();
            for (int i = 0; i < n; ++i) {
                ActionInfo action = methods.get(i);
                DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode();
                child.setText(action.getClassName());
                child.setUserObject((Object)action);
                uiNode.add((MutableTreeNode)child);
            }
        }
    }

    public UIObjectEntry[] getParents(UIObjectInfo entity) {
        if (entity == null) {
            return new UIObjectEntry[0];
        }
        ArrayList parents = new ArrayList();
        this.listParents(parents, entity);
        UIObjectEntry[] entries = new UIObjectEntry[parents.size()];
        for (int i = 0; i < parents.size(); ++i) {
            UIObjectInfo e = (UIObjectInfo)parents.get(i);
            entries[i] = new UIObjectEntry(e);
        }
        return entries;
    }

    private void listParents(List list, UIObjectInfo ui) {
        UIObjectInfo parent = ui.getParent();
        if (parent != null) {
            this.listParents(list, parent);
        }
        list.add(ui);
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children;
        if (parentElement instanceof UIObjectEntry) {
            UIObjectInfo UIObject = ((UIObjectEntry)parentElement).ui;
            ActionCollection actions = UIObject.getOwnedActions();
            children = new ActionEntry[actions.size()];
            int n = actions.size();
            for (int i = 0; i < n; ++i) {
                ActionInfo action = actions.get(i);
                children[i] = new ActionEntry(action, UIObject);
            }
        } else {
            children = new Object[]{};
        }
        return children;
    }

    public Object getParent(Object element) {
        if (element instanceof UIObjectEntry) {
            return null;
        }
        if (element instanceof ActionEntry) {
            return ((ActionEntry)element).parent;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof UIObjectEntry) {
            return ((UIObjectEntry)element).ui.getName();
        }
        if (element instanceof ActionEntry) {
            return ((ActionEntry)element).action.getClassName();
        }
        return "?";
    }

    static class UIObjectEntry {
        public UIObjectInfo ui;

        public UIObjectEntry(UIObjectInfo ui) {
            this.ui = ui;
        }
    }

    public static class ActionEntry {
        public ActionInfo action;
        public UIObjectInfo parent;

        public ActionEntry(ActionInfo a, UIObjectInfo ui) {
            this.action = a;
            this.parent = ui;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ActionEntry) {
                ActionEntry that = (ActionEntry)obj;
                String otherName = that.action.getName();
                String thisName = this.action.getName();
                return otherName.equals(thisName);
            }
            return false;
        }
    }
}

