/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.util;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.bizrule.ConditionRuleInfo;
import com.kingdee.bos.metadata.bizrule.common.AbstractExpressionInfo;
import com.kingdee.bos.metadata.bizrule.common.ActionInfo;
import com.kingdee.bos.metadata.bizrule.common.ConditionInfo;
import com.kingdee.bos.metadata.bizrule.common.EventType;
import com.kingdee.bos.metadata.bizrule.common.ExpressionType;
import com.kingdee.bos.metadata.bizrule.common.SimpleExpressionInfo;
import com.kingdee.bos.metadata.bizrule.util.RuleJCodeWriter;
import com.kingdee.bos.metadata.bizunit.BIMException;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.parser.BizExpressionParser;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.StringComparator;
import com.kingdee.eas.base.uict.BizConfigRes;
import com.kingdee.eas.base.uict.BizConfigureEventInfo;
import com.kingdee.eas.base.uict.RuleTypeEnum;
import com.kingdee.eas.base.uict.client.expression.BizExpCodeGenerator;
import com.kingdee.eas.base.uict.client.expression.BizExpressionType;
import com.kingdee.eas.base.uict.client.expression.BizSettingExpression;
import com.kingdee.eas.base.uict.client.util.BizConfigureHelper;
import com.kingdee.eas.base.uict.client.util.UniqueString;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BizEventDefHelper {
    private static final Logger logger = CoreUIObject.getLogger((Class)BizConfigureHelper.class);
    public static final String THROW_EXCEPTION_PREFIX = "UIRuleUtil.throwException(";
    public static final String THROW_EXCEPTION_SUFFIX = ")";
    private static Map eventTypeLabelMap = null;

    public static String getLabelValueByEventType(String eventTypeName) {
        if (eventTypeLabelMap == null) {
            eventTypeLabelMap = new HashMap();
            eventTypeLabelMap.put(EventType.INITIAL.getName(), BizConfigRes.getString("EventType.INITIAL"));
            eventTypeLabelMap.put(EventType.CHANGE.getName(), "\u66f4\u65b0");
            eventTypeLabelMap.put(EventType.SUBMIT.getName(), BizConfigRes.getString("EventType.SUBMIT"));
        }
        return (String)eventTypeLabelMap.get(eventTypeName);
    }

    public static AbstractExpressionInfo parseScript(BizUnitInfo bizUnitInfo, String ruleScript) throws Exception {
        BizExpressionParser parser = new BizExpressionParser(bizUnitInfo);
        return parser.parse(ruleScript);
    }

    public static ConditionRuleInfo createRuleFromEventInfo(BizUnitInfo bizUnit, String eventObjectName, BizConfigureEventInfo eventInfo) throws BIMException {
        ConditionRuleInfo conditionRuleInfo = new ConditionRuleInfo();
        conditionRuleInfo.setEventObjectName(eventObjectName);
        conditionRuleInfo.setEventType(eventInfo.getEventType());
        conditionRuleInfo.setName(eventInfo.getRuleName());
        conditionRuleInfo.setRuleType(eventInfo.getRuleType());
        try {
            int i;
            int m;
            if (eventInfo.isUseCondition()) {
                ConditionInfo condition = BizEventDefHelper.genCondition(bizUnit, eventInfo.getCondition());
                conditionRuleInfo.setCondition(condition);
            }
            String ruleScript = null;
            if (eventInfo.getActions() != null) {
                m = eventInfo.getActions().size();
                for (i = 0; i < m; ++i) {
                    ruleScript = (String)eventInfo.getActions().get(i);
                    conditionRuleInfo.getActions().add(BizEventDefHelper.genAction(bizUnit, ruleScript, conditionRuleInfo));
                }
            }
            if (eventInfo.getExceptionActions() != null) {
                m = eventInfo.getExceptionActions().size();
                for (i = 0; i < m; ++i) {
                    ruleScript = (String)eventInfo.getExceptionActions().get(i);
                    conditionRuleInfo.getExceptionActions().add(BizEventDefHelper.genAction(bizUnit, ruleScript, conditionRuleInfo));
                }
            }
        }
        catch (BIMException bime) {
            throw bime;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return conditionRuleInfo;
    }

    private static ConditionInfo genCondition(BizUnitInfo bizUnit, String ruleScript) throws Exception {
        ConditionInfo condition = new ConditionInfo();
        condition.setName(UniqueString.getUniqueString());
        AbstractExpressionInfo expressionInfo = BizEventDefHelper.parseScript(bizUnit, ruleScript);
        String javaCode = RuleJCodeWriter.parseExpression2Java((AbstractExpressionInfo)expressionInfo, null);
        SimpleExpressionInfo simpleExpressoinInfo = BizEventDefHelper.createSimpleExpression(ruleScript, javaCode);
        condition.setExpression((AbstractExpressionInfo)simpleExpressoinInfo);
        return condition;
    }

    private static ActionInfo genAction(BizUnitInfo bizUnit, String ruleScript, ConditionRuleInfo conditionRuleInfo) throws Exception {
        ActionInfo action = new ActionInfo();
        String javaCode = "";
        if (RuleTypeEnum.SET_FIELD_PROPERTY.getName().endsWith(conditionRuleInfo.getRuleType())) {
            String strLeft = ruleScript.substring(0, ruleScript.indexOf(61)).trim();
            String strProp = strLeft.substring(strLeft.lastIndexOf(46) + 1);
            String eventObjectFieldName = strLeft.substring(0, strLeft.lastIndexOf(46)).trim();
            BizFieldInfo bizFieldInfo = null;
            String eventObject = null;
            if (eventObjectFieldName.indexOf(46) != -1) {
                bizFieldInfo = bizUnit.getFieldByName(eventObjectFieldName.substring(0, eventObjectFieldName.indexOf(46)));
                eventObject = bizFieldInfo.getControlName() + eventObjectFieldName.substring(eventObjectFieldName.indexOf(46));
            } else {
                bizFieldInfo = bizUnit.getFieldByName(eventObjectFieldName);
                eventObject = bizFieldInfo.getControlName();
            }
            String str = ruleScript.substring(ruleScript.indexOf(61) + 1).trim();
            BizSettingExpression setExp = null;
            if ("enabled".equalsIgnoreCase(strProp)) {
                setExp = new BizSettingExpression(eventObject, new Boolean(str.equals("true")), BizExpressionType.SETUIENABLED);
            } else if ("visible".equalsIgnoreCase(strProp)) {
                setExp = new BizSettingExpression(eventObject, new Boolean(str.equals("true")), BizExpressionType.SETUIVISIBLE);
            }
            BizExpCodeGenerator codeGenerator = new BizExpCodeGenerator(bizUnit.getEditUI(), bizUnit);
            javaCode = codeGenerator.generate(setExp);
        } else {
            AbstractExpressionInfo expressionInfo = BizEventDefHelper.parseScript(bizUnit, ruleScript);
            javaCode = RuleJCodeWriter.parseExpression2Java((AbstractExpressionInfo)expressionInfo, null);
            javaCode = BizEventDefHelper.formatExpression(javaCode);
            javaCode = javaCode + ";";
        }
        SimpleExpressionInfo simpleExpressoinInfo = BizEventDefHelper.createSimpleExpression(ruleScript, javaCode);
        action.setExpression((AbstractExpressionInfo)simpleExpressoinInfo);
        return action;
    }

    private static SimpleExpressionInfo createSimpleExpression(String source, String javaCode) {
        SimpleExpressionInfo exp = new SimpleExpressionInfo();
        exp.setType(ExpressionType.SCRIPT);
        exp.put("source", (Object)source);
        exp.setValue(javaCode);
        return exp;
    }

    private static String formatExpression(String exp) {
        if (StringUtils.isEmpty((String)exp)) {
            return "";
        }
        String formatExp = exp;
        if (formatExp.indexOf(THROW_EXCEPTION_PREFIX) != -1) {
            formatExp = StringUtils.replace((String)formatExp, (String)THROW_EXCEPTION_PREFIX, (String)(BizEventDefHelper.class.getName() + ".showInfo("));
        }
        formatExp = BizEventDefHelper.trimForceConvert(formatExp);
        return formatExp;
    }

    public static String trimForceConvert(String inputSource) {
        if (inputSource == null) {
            return inputSource;
        }
        StringTokenizer tokenizer = new StringTokenizer(inputSource, "(", true);
        String token = null;
        String formatSource = "";
        int index = -1;
        boolean needCheck = false;
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if ("(".equals(token)) {
                if (needCheck) {
                    formatSource = formatSource + "(";
                    continue;
                }
                needCheck = true;
                continue;
            }
            if (needCheck) {
                needCheck = false;
                index = token.indexOf(41);
                if (index != -1 && BizEventDefHelper.isClass(token.substring(0, index).trim())) {
                    formatSource = formatSource + token.substring(index + 1);
                    continue;
                }
                formatSource = formatSource + "(" + token;
                continue;
            }
            formatSource = formatSource + token;
        }
        return formatSource;
    }

    public static boolean isClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void showInfo(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    MsgBox.showInfo((String)message);
                    SysUtil.abort();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }
        });
    }

    public static String addPackageForClass(String input, String longClassName, String shortClassName) {
        if (input == null) {
            return null;
        }
        String formatExp = input;
        int startIndex = formatExp.indexOf(shortClassName);
        if (startIndex != -1 && shortClassName.length() + startIndex < input.length() && formatExp.charAt(shortClassName.length() + startIndex) == '.' && startIndex - 1 >= 0 && formatExp.charAt(startIndex - 1) != '.') {
            block7: {
                String method;
                int index = formatExp.indexOf(40, startIndex + shortClassName.length());
                if (index != -1 && !StringUtils.isEmpty((String)(method = formatExp.substring(startIndex + shortClassName.length() + 1, index)))) {
                    try {
                        Class<?> newClass = Class.forName(longClassName);
                        Method[] methods = newClass.getMethods();
                        if (methods == null) break block7;
                        int m = methods.length;
                        for (int i = 0; i < m; ++i) {
                            if (!method.equals(methods[i].getName())) continue;
                            formatExp = formatExp.substring(0, startIndex) + longClassName + formatExp.substring(startIndex + shortClassName.length());
                            break;
                        }
                    }
                    catch (ClassNotFoundException e) {
                        logger.error((Object)e);
                    }
                }
            }
            if (formatExp.indexOf(shortClassName, startIndex + longClassName.length()) != -1) {
                formatExp = formatExp.substring(0, startIndex + longClassName.length()) + BizEventDefHelper.addPackageForClass(formatExp.substring(startIndex + longClassName.length()), longClassName, shortClassName);
            }
        }
        return formatExp;
    }

    public static void addRowData2Table(KDTable table, String[] rowData) {
        if (rowData == null) {
            return;
        }
        IRow row = table.addRow();
        int m = rowData.length > table.getColumnCount() ? table.getColumnCount() : rowData.length;
        for (int j = 0; j < m; ++j) {
            row.getCell(j).setValue((Object)rowData[j]);
        }
    }

    public static String prefixAndSuffixFormat(String expr, String prefix, String suffix, boolean isAdd) {
        if (isAdd) {
            return prefix + expr + suffix;
        }
        if (expr != null && expr.startsWith(prefix) && expr.endsWith(suffix)) {
            expr = expr.substring(prefix.length(), expr.lastIndexOf(suffix));
        }
        return expr;
    }

    public static void sortListByText(List list) {
        StringComparator comparator = new StringComparator();
        int m = list.size() - 1;
        for (int i = 0; i < m; ++i) {
            DefaultKingdeeTreeNode iNode = (DefaultKingdeeTreeNode)list.get(i);
            PropertyInfo iProperty = (PropertyInfo)iNode.getUserObject();
            int n = list.size();
            for (int j = i + 1; j < n; ++j) {
                DefaultKingdeeTreeNode jNode = (DefaultKingdeeTreeNode)list.get(j);
                PropertyInfo jProperty = (PropertyInfo)jNode.getUserObject();
                if (iProperty instanceof LinkPropertyInfo && !(jProperty instanceof LinkPropertyInfo) || comparator.compare(iNode.getText(), jNode.getText()) >= 0 && (iProperty instanceof LinkPropertyInfo || !(jProperty instanceof LinkPropertyInfo))) continue;
                list.set(i, jNode);
                list.set(j, iNode);
                iNode = (DefaultKingdeeTreeNode)list.get(i);
                iProperty = (PropertyInfo)iNode.getUserObject();
            }
        }
    }
}

