/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.util;

import com.kingdee.bos.ctrl.swing.KDTextPane;
import com.kingdee.eas.base.uict.client.util.ScriptScanner;
import java.awt.Color;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.log4j.Logger;

public class EventRuleEditorDocListener
implements DocumentListener {
    private static Logger logger = Logger.getLogger((Class)EventRuleEditorDocListener.class);
    private Vector styles = null;
    private int[] tokenStyles = null;
    private ScriptScanner scriptScanner = new ScriptScanner();

    public EventRuleEditorDocListener() {
        this.initializeStyles();
    }

    public ScriptScanner getScriptScanner() {
        return this.scriptScanner;
    }

    private void initializeStyles() {
        KDTextPane ruleTextPane = new KDTextPane();
        this.styles = new Vector();
        Style style = ruleTextPane.addStyle("Black", null);
        StyleConstants.setForeground(style, Color.BLACK);
        this.styles.add(style);
        style = ruleTextPane.addStyle("Red", null);
        StyleConstants.setForeground(style, Color.RED);
        this.styles.add(style);
        style = ruleTextPane.addStyle("LightGreen", null);
        StyleConstants.setForeground(style, new Color(63, 127, 95));
        this.styles.add(style);
        style = ruleTextPane.addStyle("String", null);
        StyleConstants.setForeground(style, new Color(42, 0, 255));
        this.styles.add(style);
        style = ruleTextPane.addStyle("Key", null);
        StyleConstants.setForeground(style, new Color(127, 0, 85));
        this.styles.add(style);
        this.tokenStyles = new int[8];
        this.tokenStyles[0] = 0;
        this.tokenStyles[1] = 0;
        this.tokenStyles[2] = 4;
        this.tokenStyles[3] = 2;
        this.tokenStyles[4] = 3;
        this.tokenStyles[5] = 0;
        this.tokenStyles[6] = 0;
        this.tokenStyles[7] = 1;
    }

    public void insertUpdate(DocumentEvent e) {
        SwingUtilities.invokeLater(new StyleRunnable(e));
    }

    public void removeUpdate(DocumentEvent e) {
        SwingUtilities.invokeLater(new StyleRunnable(e));
    }

    public void changedUpdate(DocumentEvent e) {
    }

    private class StyleRunnable
    implements Runnable {
        private StyledDocument doc = null;

        public StyleRunnable(DocumentEvent e) {
            this.doc = (StyledDocument)e.getDocument();
        }

        public void run() {
            this.styleTheScript(this.doc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void styleTheScript(StyledDocument doc) {
            try {
                StyledDocument styledDocument = doc;
                synchronized (styledDocument) {
                    String ruleScript = doc.getText(0, doc.getLength());
                    if (ruleScript != null && ruleScript.length() > 0) {
                        EventRuleEditorDocListener.this.scriptScanner.setRange(ruleScript);
                        int token = -1;
                        while ((token = EventRuleEditorDocListener.this.scriptScanner.nextToken()) != -1) {
                            Style style = (Style)EventRuleEditorDocListener.this.styles.get(EventRuleEditorDocListener.this.tokenStyles[token]);
                            doc.setCharacterAttributes(((EventRuleEditorDocListener)EventRuleEditorDocListener.this).scriptScanner.fStartToken, EventRuleEditorDocListener.this.scriptScanner.getLength(), style, true);
                        }
                    }
                }
            }
            catch (BadLocationException e1) {
                logger.error((Object)e1);
            }
            catch (Exception e1) {
                logger.error((Object)e1);
            }
        }
    }
}

