/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.util;

import com.kingdee.bos.ctrl.swing.KDTextPane;
import com.kingdee.bos.metadata.bizunit.BizUnitHelper;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.eas.base.uict.client.util.EventRuleEditorDocListener;
import com.kingdee.eas.base.uict.client.util.IEventRuleManager;
import com.kingdee.eas.base.uict.client.util.ScriptScanner;
import com.kingdee.eas.base.uict.client.util.UictEvent;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EventRuleManagerImp
implements IEventRuleManager {
    private Map labelItems = new HashMap();
    private Map itemLabels = new HashMap();
    EventRuleEditorDocListener docListener = new EventRuleEditorDocListener();
    private KDTextPane regRuleEditor;

    public void registerStyledRuleEditor(Component ruleEditor) {
        if (!(ruleEditor instanceof KDTextPane)) {
            throw new IllegalArgumentException("This type RuleEditor not supported");
        }
        this.regRuleEditor = (KDTextPane)ruleEditor;
        this.regRuleEditor.getDocument().addDocumentListener(this.docListener);
    }

    public Component getStyledRuleEditor() {
        return this.regRuleEditor;
    }

    public void setRules(String rules) {
        ScriptScanner scriptScanner = new ScriptScanner();
        Iterator labels = this.labelItems.keySet().iterator();
        while (labels.hasNext()) {
            String label = (String)labels.next();
            String item = (String)this.labelItems.get(label);
            scriptScanner.registerKeyWord(item);
        }
        scriptScanner.setRange(rules);
        int tokenType = scriptScanner.nextToken();
        int previousPos = 0;
        StringBuffer buffer = new StringBuffer();
        while (tokenType != -1) {
            int currentPos = scriptScanner.fPos;
            String token = rules.substring(previousPos, currentPos);
            if (tokenType == 2) {
                String label = (String)this.itemLabels.get(token);
                if (label != null) {
                    buffer.append(label);
                } else {
                    buffer.append(token);
                }
            } else if (tokenType == 7) {
                buffer.append(token);
            } else {
                buffer.append(token);
            }
            previousPos = currentPos;
            tokenType = scriptScanner.nextToken();
        }
        if (this.regRuleEditor != null) {
            this.regRuleEditor.setText(buffer.toString());
        }
    }

    public String getRules() {
        ScriptScanner scriptScanner = this.docListener.getScriptScanner();
        String contents = this.regRuleEditor.getText();
        scriptScanner.setRange(contents);
        int tokenType = scriptScanner.nextToken();
        int previousPos = 0;
        StringBuffer buffer = new StringBuffer();
        while (tokenType != -1) {
            int currentPos = scriptScanner.fPos;
            String token = contents.substring(previousPos, currentPos);
            if (tokenType != 7 || !token.equals("[") && !token.equals("]")) {
                if (tokenType == 2) {
                    String item = (String)this.labelItems.get(token);
                    if (item != null) {
                        buffer.append(item);
                    } else {
                        buffer.append(token);
                    }
                } else if (tokenType == 7) {
                    buffer.append(token);
                } else {
                    buffer.append(token);
                }
            }
            previousPos = currentPos;
            tokenType = scriptScanner.nextToken();
        }
        return buffer.toString();
    }

    public void appendItemAndLabel(String item, String label) {
        this.labelItems.put(label, item);
        this.itemLabels.put(item, label);
        this.docListener.getScriptScanner().registerKeyWord(label);
    }

    public void actionPerformed(ActionEvent e) {
        if (e instanceof UictEvent) {
            UictEvent uictEvent = (UictEvent)e;
            switch (uictEvent.getEventCode()) {
                case 2: {
                    this.appendText((String)uictEvent.getAttachment());
                    break;
                }
                case 1: {
                    this.appendText((String)uictEvent.getAttachment());
                    break;
                }
                case 3: {
                    String text = (String)uictEvent.getAttachment();
                    this.appendText(this.renderLabel(text));
                    break;
                }
            }
        }
    }

    private void appendText(String keyword) {
        String selectedText;
        if (keyword == null) {
            return;
        }
        int position = this.regRuleEditor.getSelectionStart();
        String text = this.regRuleEditor.getText();
        if (text == null) {
            text = "";
        }
        String string = selectedText = this.regRuleEditor.getSelectedText() == null ? "" : this.regRuleEditor.getSelectedText();
        if (selectedText.length() == 0) {
            StringBuffer buffer = new StringBuffer(text);
            buffer.insert(position, keyword);
            this.regRuleEditor.setText(buffer.toString());
            this.regRuleEditor.setCaretPosition(position += keyword.length());
        } else {
            StringBuffer buffer = new StringBuffer(text);
            buffer.delete(position, position + selectedText.length());
            buffer.insert(position, keyword);
            this.regRuleEditor.setText(buffer.toString());
        }
    }

    private String renderLabel(String label) {
        if (label.startsWith("[") && label.endsWith("]")) {
            return label;
        }
        return "[" + label + "]";
    }

    private String renderOperation(String operation) {
        return " " + operation + " ";
    }

    public void parseExpression(BizUnitInfo bizUnit, String srcExp) {
        if (bizUnit == null || StringUtils.isEmpty((String)srcExp)) {
            return;
        }
        int beginIndex = 0;
        int endIndex = 0;
        String desExp = srcExp;
        while (beginIndex != -1) {
            if ((beginIndex = srcExp.indexOf("[", beginIndex)) < 0) continue;
            endIndex = srcExp.indexOf("]", beginIndex);
            if (endIndex >= 0) {
                String propertyName = srcExp.substring(beginIndex + 1, endIndex);
                desExp = BizUnitHelper.getPropertyAlias((BizUnitInfo)bizUnit, (String[])StringUtils.split((String)propertyName, (String)"."));
                this.appendItemAndLabel(propertyName, desExp);
                ++beginIndex;
                continue;
            }
            beginIndex = -1;
        }
    }
}

