/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.util;

import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.bizunitproxy.UIProxyHelper;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.dtp.model.layout.Layout;
import com.kingdee.bos.ui.dtp.model.layout.LayoutConverter;
import com.kingdee.bos.ui.dtp.model.layout.SameGridLayout;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import com.kingdee.eas.base.uict.BizDataTypeEnum;
import com.kingdee.eas.base.uict.DataSourceEnum;
import com.kingdee.eas.base.uict.client.BizConfigureTreeNode;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class UictEditUIProxy {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.uict.client.util.UictEditUIProxy");
    private static double MaxFloat = 3.4028234663852886E38;
    private static double MinFloat = -3.4028234663852886E38;
    private String dataObjectName = null;
    private BizUnitInfo bizUnit = null;

    public UictEditUIProxy(BizUnitInfo bizUnit, UIObjectInfo uiModel) {
        if (bizUnit != null && uiModel != null) {
            UIProxyHelper uiProxyHelper = UIProxyHelper.getInstance();
            this.dataObjectName = uiProxyHelper.findDataObjectName(uiModel, bizUnit, false);
            this.bizUnit = bizUnit;
        }
    }

    public ComponentInfo createComponent(BizConfigureItemInfo item, BizConfigureTreeNode node, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        if (item == null) {
            logger.error((Object)"BizConfigureItemInfo \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u521b\u5efaComponentInfo");
            return null;
        }
        if (node == null) {
            logger.error((Object)"BizConfigureTreeNode \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u521b\u5efaComponentInfo");
            return null;
        }
        if (pInfo == null) {
            logger.error((Object)"PropertyInfo \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u521b\u5efaComponentInfo");
            return null;
        }
        if (node.getUserObject() instanceof ComponentInfo) {
            ComponentInfo container = (ComponentInfo)node.getUserObject();
            LayoutInfo layoutInfo = container.getLayoutInfo();
            ComponentInfo cInfo = null;
            if (BizDataTypeEnum.STRING.equals((Object)item.getDataType())) {
                cInfo = this.createTextField(container, item, layoutInfo, pInfo);
            } else if (BizDataTypeEnum.INTEGER.equals((Object)item.getDataType()) || BizDataTypeEnum.DECIMAL.equals((Object)item.getDataType()) || BizDataTypeEnum.AMOUNT.equals((Object)item.getDataType()) || BizDataTypeEnum.PRICE.equals((Object)item.getDataType()) || BizDataTypeEnum.QUANTITY.equals((Object)item.getDataType())) {
                cInfo = this.createFormattedTextField(container, item, layoutInfo, pInfo);
            } else if (BizDataTypeEnum.DATE.equals((Object)item.getDataType())) {
                cInfo = this.createDatePicker(container, item, layoutInfo, pInfo);
            } else if (BizDataTypeEnum.BOOLEAN.equals((Object)item.getDataType())) {
                cInfo = this.createCheckBox(container, item, layoutInfo, pInfo);
            } else if (BizDataTypeEnum.ENUM.equals((Object)item.getDataType())) {
                cInfo = this.createComboBox(container, item, layoutInfo, pInfo);
            } else if (BizDataTypeEnum.NOTE.equals((Object)item.getDataType())) {
                cInfo = this.createTextArea(container, item, layoutInfo, pInfo);
            } else if (BizDataTypeEnum.OBJECT.equals((Object)item.getDataType())) {
                cInfo = this.createBizPromptBox(container, item, layoutInfo, pInfo);
            }
            if (cInfo != null) {
                cInfo.setConfigured(true);
            }
            return cInfo;
        }
        return null;
    }

    public void updateComponent(BizConfigureItemInfo item) {
        ComponentInfo parent;
        ComponentInfo control;
        if (item == null) {
            logger.warn((Object)"BizConfigureItemInfo \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0ComponentInfo");
            return;
        }
        if (item.getComponent() == null) {
            logger.warn((Object)"BizConfigureItemInfo \u4e2d\u7684 ComponentInfo \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0ComponentInfo");
        }
        if (!(control = item.getComponent()).getClassType().equals("com.kingdee.bos.ctrl.swing.KDCheckBox") && (parent = control.getParent()) != null) {
            if (parent.getClassType().equals("com.kingdee.bos.ctrl.swing.KDScrollPane") && parent.getParent() != null) {
                parent = parent.getParent();
            }
            if (parent.getClassType().equals("com.kingdee.bos.ctrl.swing.KDLabelContainer")) {
                PropertyCollection props = parent.getProperties();
                props.add(this.createBoundLabelTextProperty(item));
                if (item.isConfiguredField()) {
                    props.add(this.createBoundLabelLengthProperty(item));
                    props.add(this.createBoundLabelUnderlineProperty(item));
                }
            }
        }
        control.setAlias(item.getAlias());
    }

    public void createEntryComponent(BizConfigureItemInfo item, BizConfigureTreeNode node, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        if (item == null) {
            logger.error((Object)"BizConfigureItemInfo \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u521b\u5efaComponentInfo");
            return;
        }
        if (node == null) {
            logger.error((Object)"BizConfigureTreeNode \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u521b\u5efaComponentInfo");
            return;
        }
        if (pInfo == null) {
            logger.error((Object)"PropertyInfo \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u521b\u5efaComponentInfo");
            return;
        }
        ComponentInfo kdtControl = (ComponentInfo)node.getUserObject();
        this.createKDTableProperty(item, kdtControl, node.getName(), pInfo);
    }

    public void updateEntryComponent(BizConfigureItemInfo item, BizConfigureTreeNode node) {
        if (item == null) {
            logger.warn((Object)"BizConfigureItemInfo \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0ComponentInfo");
            return;
        }
        ComponentInfo kdtControl = (ComponentInfo)node.getUserObject();
        this.updateKDTableProperty(item, kdtControl);
    }

    private void createKDTableProperty(BizConfigureItemInfo item, ComponentInfo kdtControl, String linkPropName, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        TableInfo tableInfo = null;
        PropertyInfo property = kdtControl.getProperties().get("formatXml");
        if (property == null) {
            return;
        }
        tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)property.getValue());
        if (tableInfo == null) {
            tableInfo = new TableInfo();
            HeaderInfo headerInfo = new HeaderInfo();
            headerInfo.setName("header");
            tableInfo.addHeader(headerInfo);
        }
        this.addKDTableColumn(kdtControl, tableInfo, item, linkPropName, pInfo);
        PropertyInfo propInfo = new PropertyInfo();
        propInfo.setName("formatXml");
        propInfo.setType(String.class.getName());
        propInfo.setMultiLanguage(true);
        propInfo.setValue(KDTableDesignerHelper.getXmlFrom((TableInfo)tableInfo));
        kdtControl.getProperties().add(propInfo);
    }

    public void updateKDTableProperty(BizConfigureItemInfo item, ComponentInfo kdtControl) {
        int[] indexs;
        String oldColName;
        TableInfo tableInfo = null;
        PropertyInfo property = kdtControl.getProperties().get("formatXml");
        if (property == null) {
            return;
        }
        tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)property.getValue());
        List columns = tableInfo.getColumns();
        ColumnInfo column = UIProxyHelper.findColumn((List)columns, (String)(oldColName = item.getControlName()), (int[])(indexs = new int[]{-1}));
        if (column != null) {
            column.setHide(!item.isVisible());
            column.setWidth(-1);
            column.setLock(!item.isEnabled());
            if (tableInfo.getHeaderCount() > 0) {
                HeaderInfo headerInfo = (HeaderInfo)tableInfo.getHeaders().get(0);
                int columnIndex = columns.indexOf(column);
                if (headerInfo.getCells().size() > columnIndex) {
                    String cellName = item.getLabel();
                    ((CellInfo)headerInfo.getCells().get(columnIndex)).setName(cellName);
                }
            }
            PropertyInfo propInfo = new PropertyInfo();
            propInfo.setName("formatXml");
            propInfo.setType(String.class.getName());
            propInfo.setMultiLanguage(true);
            propInfo.setValue(KDTableDesignerHelper.getXmlFrom((TableInfo)tableInfo));
            kdtControl.getProperties().add(propInfo);
        }
    }

    public static String getNumberFormat(int precision) {
        String format = "0.";
        for (int i = 0; i < precision; ++i) {
            format = format + "0";
        }
        return format;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addKDTableColumn(ComponentInfo kdTable, TableInfo tableInfo, BizConfigureItemInfo item, String linkPropName, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        int[] indexs;
        CardinalityType cardinal;
        HeaderInfo headerInfo;
        if (kdTable == null || tableInfo == null || item == null || StringUtils.isEmpty((String)this.dataObjectName) || pInfo == null) {
            return;
        }
        if (tableInfo.getHeaderCount() == 0) {
            headerInfo = new HeaderInfo();
            headerInfo.setName("header");
            tableInfo.addHeader(headerInfo);
        } else {
            headerInfo = (HeaderInfo)tableInfo.getHeaders().get(0);
        }
        String propName = item.getPropertyName();
        if (StringUtils.isEmpty((String)propName)) {
            if (!DataSourceEnum.BASEDATAEXT.equals((Object)item.getDataSourceType()) || StringUtils.isEmpty((String)item.getDataField())) return;
            propName = item.getDataField();
        } else {
            propName = linkPropName + "." + propName;
        }
        if (pInfo instanceof LinkPropertyInfo ? !CardinalityType.ONE.equals((Object)(cardinal = ((LinkPropertyInfo)pInfo).getRelationship().getSupplierCardinality())) && !CardinalityType.ZERO_TO_ONE.equals((Object)cardinal) : !(pInfo instanceof OwnPropertyInfo)) {
            return;
        }
        String colName = item.getName();
        List columns = tableInfo.getColumns();
        ColumnInfo existCol = UictEditUIProxy.findColumn(columns, colName, indexs = new int[]{-1});
        if (existCol != null) {
            tableInfo.removeColumn(existCol);
            if (headerInfo != null && headerInfo.getCellCount() > indexs[0]) {
                headerInfo.removeCell((CellInfo)headerInfo.getCells().get(indexs[0]));
            }
        }
        ColumnInfo column = new ColumnInfo();
        column.setName(colName);
        column.setHide(!item.isVisible());
        column.setWidth(-1);
        column.setLock(!item.isEnabled());
        if (item.getDataType() == BizDataTypeEnum.DECIMAL || item.getDataType() == BizDataTypeEnum.AMOUNT || item.getDataType() == BizDataTypeEnum.PRICE || item.getDataType() == BizDataTypeEnum.QUANTITY) {
            column.setFormatString(UictEditUIProxy.getNumberFormat(item.getScale()));
        } else if (item.getDataType() == BizDataTypeEnum.INTEGER) {
            column.setFormatString("0");
        } else if (item.getDataType() == BizDataTypeEnum.DATE) {
            column.setFormatString("yyyy-M-d");
        } else if (item.getDataType() == BizDataTypeEnum.TIME) {
            column.setFormatString("h:mm:ss");
        }
        item.setControlName(colName);
        tableInfo.addColumn(column);
        CellInfo cell = new CellInfo();
        String cellName = item.getLabel();
        if (StringUtils.isEmpty((String)cellName)) {
            cell.setName(item.getName());
        } else {
            cell.setName(cellName);
        }
        cell.setColSpan(0);
        cell.setRowSpan(0);
        headerInfo.addCell(cell);
        PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
        propertyBindingInfo.setPropertyName(colName + ".text");
        propertyBindingInfo.setPropertyType(Object.class.getName());
        propertyBindingInfo.setAccessType(2);
        propertyBindingInfo.setAutoMode(false);
        propertyBindingInfo.setBindingObject(this.dataObjectName);
        propertyBindingInfo.setBingdingField(propName);
        propertyBindingInfo.setOverride(true);
        propertyBindingInfo.setExtendedProperty("configured", "true");
        if (pInfo instanceof OwnPropertyInfo) {
            propertyBindingInfo.setFieldType(((OwnPropertyInfo)pInfo).getJavaType());
        } else if (pInfo instanceof LinkPropertyInfo) {
            propertyBindingInfo.setFieldType(Object.class.getName());
        }
        kdTable.getPropertyBindings().add(propertyBindingInfo);
    }

    public void delKDTableColumn(ComponentInfo kdTable, BizConfigureItemInfo item) {
        if (kdTable == null || item == null) {
            return;
        }
        TableInfo tableInfo = null;
        PropertyInfo property = kdTable.getProperties().get("formatXml");
        if (property != null) {
            tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)property.getValue());
        }
        if (tableInfo != null) {
            int[] indexs;
            String colName;
            List columns;
            ColumnInfo column;
            HeaderInfo headerInfo = null;
            if (tableInfo.getHeaderCount() != 0) {
                headerInfo = (HeaderInfo)tableInfo.getHeaders().get(0);
            }
            if ((column = UictEditUIProxy.findColumn(columns = tableInfo.getColumns(), colName = item.getControlName(), indexs = new int[]{-1})) != null) {
                tableInfo.removeColumn(column);
                if (headerInfo != null && headerInfo.getCellCount() > indexs[0]) {
                    logger.info((Object)("\u5220\u9664EditUI\u7684\u5206\u5f55\u5217:" + colName + "..."));
                    headerInfo.removeCell((CellInfo)headerInfo.getCells().get(indexs[0]));
                }
                property.setValue(KDTableDesignerHelper.getXmlFrom((TableInfo)tableInfo));
            }
        }
        kdTable.getPropertyBindings().removeObject((Object)(item.getControlName() + ".text"));
    }

    private static ColumnInfo findColumn(List columns, String columnName, int[] indexs) {
        if (columns == null || columns.isEmpty() || StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        ColumnInfo colInfo = null;
        Iterator iter = columns.iterator();
        indexs[0] = -1;
        while (iter.hasNext()) {
            indexs[0] = indexs[0] + 1;
            colInfo = (ColumnInfo)iter.next();
            if (!columnName.equals(colInfo.getName())) continue;
            return colInfo;
        }
        return null;
    }

    private ComponentInfo createLabelContainer(ComponentInfo container, BizConfigureItemInfo item, LayoutInfo layoutInfo) {
        ComponentInfo labelContainer = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDLabelContainer");
        labelContainer.setParent(container);
        labelContainer.setName("cont" + item.getName());
        Object constraint = this.createContraint(layoutInfo, item);
        labelContainer.setConstraint(constraint);
        labelContainer.setContainer(true);
        PropertyCollection props = labelContainer.getProperties();
        props.add(this.createBoundLabelTextProperty(item));
        props.add(this.createBoundLabelLengthProperty(item));
        props.add(this.createBoundLabelUnderlineProperty(item));
        props.add(this.createVisibleProperty(item));
        return labelContainer;
    }

    private Object createContraint(LayoutInfo layoutInfo, BizConfigureItemInfo item) {
        return item.getBounds();
    }

    private ComponentInfo createTextField(ComponentInfo container, BizConfigureItemInfo item, LayoutInfo layoutInfo, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        ComponentInfo labelContainer = this.createLabelContainer(container, item, layoutInfo);
        if (labelContainer == null) {
            return null;
        }
        return this.createTextFieldForLabelContainer(labelContainer, item, pInfo);
    }

    private ComponentInfo createFormattedTextField(ComponentInfo container, BizConfigureItemInfo item, LayoutInfo layoutInfo, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        ComponentInfo labelContainer = this.createLabelContainer(container, item, layoutInfo);
        if (labelContainer == null) {
            return null;
        }
        return this.createFormattedTextFieldForLabelContainer(labelContainer, item, pInfo);
    }

    private ComponentInfo createDatePicker(ComponentInfo container, BizConfigureItemInfo item, LayoutInfo layoutInfo, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        ComponentInfo labelContainer = this.createLabelContainer(container, item, layoutInfo);
        if (labelContainer == null) {
            return null;
        }
        return this.createDatePickerForLabelContainer(labelContainer, item, pInfo);
    }

    private ComponentInfo createCheckBox(ComponentInfo container, BizConfigureItemInfo item, LayoutInfo layoutInfo, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        ComponentInfo checkBox = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDCheckBox");
        checkBox.setUserDefined(true);
        checkBox.setParent(container);
        checkBox.setName("chk" + item.getName());
        Object constraint = this.createContraint(layoutInfo, item);
        checkBox.setConstraint(constraint);
        PropertyCollection props = checkBox.getProperties();
        props.add(this.createLabelTextProperty(item));
        props.add(this.createVisibleProperty(item));
        PropertyBindingCollection pbs = checkBox.getPropertyBindings();
        pbs.add(this.createSelectedPropBinding(item, pInfo));
        item.setControlName(checkBox.getName());
        return checkBox;
    }

    private ComponentInfo createComboBox(ComponentInfo container, BizConfigureItemInfo item, LayoutInfo layoutInfo, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        ComponentInfo labelContainer = this.createLabelContainer(container, item, layoutInfo);
        if (labelContainer == null) {
            return null;
        }
        return this.createComboBoxForLabelContainer(labelContainer, item, pInfo);
    }

    private ComponentInfo createTextArea(ComponentInfo container, BizConfigureItemInfo item, LayoutInfo layoutInfo, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        ComponentInfo labelContainer = this.createLabelContainer(container, item, layoutInfo);
        if (labelContainer == null) {
            return null;
        }
        ComponentInfo scrollPane = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDScrollPane");
        scrollPane.setName("scrollPane" + item.getName());
        scrollPane.setConstraint((Object)String.valueOf(7));
        scrollPane.setContainer(true);
        UIProxyHelper.setLayout((ComponentInfo)scrollPane, (LayoutInfo)LayoutConverter.convertToInfo((Layout)new SameGridLayout(1, 1)));
        labelContainer.getComponents().add(scrollPane);
        scrollPane.setParent(labelContainer);
        return this.createTextAreaForLabelContainer(scrollPane, item, pInfo);
    }

    private ComponentInfo createBizPromptBox(ComponentInfo container, BizConfigureItemInfo item, LayoutInfo layoutInfo, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        ComponentInfo labelContainer = this.createLabelContainer(container, item, layoutInfo);
        if (labelContainer == null) {
            return null;
        }
        return this.createBizPromptBoxForLabelContainer(labelContainer, item, pInfo);
    }

    private ComponentInfo createBizPromptBoxForLabelContainer(ComponentInfo container, BizConfigureItemInfo item, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        ComponentInfo f7 = new ComponentInfo("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox");
        f7.setUserDefined(true);
        f7.setName("prmt" + item.getName());
        f7.setParent(container);
        PropertyCollection props = f7.getProperties();
        PropertyInfo prop = this.createQueryInfoProperty(item);
        if (prop != null) {
            props.add(prop);
        }
        props.add(this.createEditableProperty(item));
        props.add(this.createDisplayFormatProperty(item));
        props.add(this.createEditFormatProperty(item));
        props.add(this.createCommitFormatProperty(item));
        props.add(this.createRequiredProperty(item));
        PropertyBindingCollection pbs = f7.getPropertyBindings();
        pbs.add(this.createF7DataPropBinding(this.bizUnit.getEntity(), this.dataObjectName, pInfo));
        item.setControlName(f7.getName());
        return f7;
    }

    private ComponentInfo createTextFieldForLabelContainer(ComponentInfo container, BizConfigureItemInfo item, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        ComponentInfo text = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDTextField");
        text.setUserDefined(true);
        text.setName("txt" + item.getName());
        text.setConstraint(container.getConstraint());
        text.setParent(container);
        PropertyCollection props = text.getProperties();
        props.add(this.createVisibleProperty(item));
        props.add(this.createTextProperty(item));
        props.add(this.createMaxLengthProperty(item));
        props.add(this.createRequiredProperty(item));
        PropertyBindingCollection pbs = text.getPropertyBindings();
        pbs.add(this.createTextPropBinding(item, pInfo));
        item.setControlName(text.getName());
        return text;
    }

    private ComponentInfo createFormattedTextFieldForLabelContainer(ComponentInfo container, BizConfigureItemInfo item, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        ComponentInfo text = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDFormattedTextField");
        text.setUserDefined(true);
        text.setName("txt" + item.getName());
        text.setParent(container);
        PropertyCollection props = text.getProperties();
        props.add(this.createVisibleProperty(item));
        props.add(this.createDataTypeProperty(item));
        props.add(this.createSupportedEmptyProperty(item));
        if (item.getDataType() == BizDataTypeEnum.DECIMAL || item.getDataType() == BizDataTypeEnum.QUANTITY || item.getDataType() == BizDataTypeEnum.PRICE || item.getDataType() == BizDataTypeEnum.AMOUNT) {
            props.add(UictEditUIProxy.createMinimumValueProperty(item.getLength(), item.getScale()));
            props.add(UictEditUIProxy.createMaximumValueProperty(item.getLength(), item.getScale()));
            props.add(UictEditUIProxy.createPrecisionProperty(item.getScale()));
        }
        PropertyBindingCollection pbs = text.getPropertyBindings();
        pbs.add(this.createValuePropBinding(item, pInfo));
        props.add(this.createRequiredProperty(item));
        item.setControlName(text.getName());
        return text;
    }

    private ComponentInfo createDatePickerForLabelContainer(ComponentInfo container, BizConfigureItemInfo item, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        ComponentInfo picker = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDDatePicker");
        picker.setUserDefined(true);
        picker.setName("pk" + item.getName());
        picker.setParent(container);
        PropertyCollection props = picker.getProperties();
        props.add(this.createVisibleProperty(item));
        props.add(this.createRequiredProperty(item));
        PropertyBindingCollection pbs = picker.getPropertyBindings();
        pbs.add(this.createValuePropBinding(item, pInfo));
        item.setControlName(picker.getName());
        return picker;
    }

    private ComponentInfo createComboBoxForLabelContainer(ComponentInfo container, BizConfigureItemInfo item, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        ComponentInfo combo = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDComboBox");
        combo.setUserDefined(true);
        combo.setName("chk" + item.getName());
        combo.setParent(container);
        PropertyCollection props = combo.getProperties();
        props.add(this.createVisibleProperty(item));
        props.add(this.createItemsProperty(pInfo, item));
        props.add(this.createRequiredProperty(item));
        PropertyBindingCollection pbs = combo.getPropertyBindings();
        pbs.add(this.createSelectedItemPropBinding(item, pInfo));
        item.setControlName(combo.getName());
        return combo;
    }

    private ComponentInfo createTextAreaForLabelContainer(ComponentInfo container, BizConfigureItemInfo item, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        ComponentInfo text = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDTextArea");
        text.setUserDefined(true);
        text.setName("txt" + item.getName());
        text.setParent(container);
        PropertyCollection props = text.getProperties();
        props.add(this.createVisibleProperty(item));
        props.add(this.createTextProperty(item));
        props.add(this.createRequiredProperty(item));
        props.add(this.createMaxLengthProperty(item));
        PropertyBindingCollection pbs = text.getPropertyBindings();
        pbs.add(this.createTextPropBinding(item, pInfo));
        item.setControlName(text.getName());
        return text;
    }

    private PropertyInfo createBoundLabelTextProperty(BizConfigureItemInfo item) {
        if (item == null) {
            return null;
        }
        String text = item.getLabel();
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("boundLabelText");
        prop.setType(String.class.getName());
        prop.setMultiLanguage(true);
        prop.setValue(text);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createBoundLabelLengthProperty(BizConfigureItemInfo item) {
        if (item == null) {
            return null;
        }
        int length = item.getLabelLength();
        length = length < 0 ? -1 : length;
        PropertyInfo prop = new PropertyInfo();
        prop.setName("boundLabelLength");
        prop.setType("int");
        prop.setValue(String.valueOf(length));
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createBoundLabelUnderlineProperty(BizConfigureItemInfo item) {
        if (item == null) {
            return null;
        }
        boolean ul = item.isLabelUnderLine();
        PropertyInfo prop = new PropertyInfo();
        prop.setName("boundLabelUnderline");
        prop.setType("boolean");
        prop.setValue(String.valueOf(ul));
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createVisibleProperty(BizConfigureItemInfo item) {
        if (item == null) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("visible");
        prop.setType("boolean");
        prop.setValue(String.valueOf(item.isVisible()));
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createRequiredProperty(BizConfigureItemInfo item) {
        if (item == null) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("required");
        prop.setType("boolean");
        prop.setValue(String.valueOf(item.isRequired()));
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createEnableProperty(BizConfigureItemInfo item) {
        if (item == null) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("enabled");
        prop.setType("boolean");
        prop.setValue(String.valueOf(item.isEnabled()));
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createMaxLengthProperty(BizConfigureItemInfo item) {
        if (item == null) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("maxLength");
        prop.setType("int");
        prop.setValue(String.valueOf(item.getLength()));
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createLabelTextProperty(BizConfigureItemInfo item) {
        if (item == null) {
            return null;
        }
        String text = item.getLabel();
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("text");
        prop.setType(String.class.getName());
        prop.setMultiLanguage(true);
        prop.setValue(text);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createTextProperty(BizConfigureItemInfo item) {
        if (item == null) {
            return null;
        }
        String text = item.getDefaultValue();
        if (text == null) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("text");
        prop.setType(String.class.getName());
        prop.setMultiLanguage(true);
        prop.setValue(text);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createItemsProperty(com.kingdee.bos.metadata.entity.PropertyInfo pInfo, BizConfigureItemInfo item) {
        BizEnumInfo bizEnum = null;
        if (BizDataTypeEnum.ENUM.equals((Object)item.getDataType()) && item.getEnumType() != null) {
            bizEnum = item.getEnumType();
        } else {
            if (pInfo == null || !(pInfo instanceof OwnPropertyInfo)) {
                return null;
            }
            if (((OwnPropertyInfo)pInfo).getEnumType() == null) {
                return null;
            }
            bizEnum = ((OwnPropertyInfo)pInfo).getEnumType();
        }
        PropertyInfo conPropInfo = new PropertyInfo();
        conPropInfo.setName("items");
        conPropInfo.setType(String.class.getName());
        conPropInfo.setMultiLanguage(true);
        String value = "[Enum]";
        if (!StringUtils.isEmpty((String)bizEnum.getPackage())) {
            value = value + bizEnum.getPackage() + ".";
        }
        value = value + bizEnum.getName();
        conPropInfo.setValue(value);
        return conPropInfo;
    }

    private PropertyInfo createSupportedEmptyProperty(BizConfigureItemInfo item) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("supportedEmpty");
        prop.setType("boolean");
        prop.setValue(String.valueOf(item.isRequired()));
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createDataTypeProperty(BizConfigureItemInfo item) {
        if (item == null) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("dataType");
        prop.setType("int");
        prop.setOverride(true);
        BizDataTypeEnum type = item.getDataType();
        if (BizDataTypeEnum.AMOUNT.equals((Object)type) || BizDataTypeEnum.DECIMAL.equals((Object)type) || BizDataTypeEnum.PRICE.equals((Object)type) || BizDataTypeEnum.QUANTITY.equals((Object)type)) {
            prop.setValue(String.valueOf(1));
        } else if (BizDataTypeEnum.INTEGER.equals((Object)type)) {
            prop.setValue(String.valueOf(0));
        } else {
            return null;
        }
        return prop;
    }

    public static PropertyInfo createMinimumValueProperty(int length, int scale) {
        if (length <= scale) {
            return null;
        }
        String format = UictEditUIProxy.getMininumValue(length, scale);
        format = "\"" + format + "\"";
        PropertyInfo prop = new PropertyInfo();
        prop.setName("minimumValue");
        prop.setType(BigDecimal.class.getName());
        prop.setValue(format);
        prop.setOverride(true);
        return prop;
    }

    public static PropertyInfo createMaximumValueProperty(int length, int scale) {
        if (length <= scale) {
            return null;
        }
        String format = UictEditUIProxy.getMaximumValue(length, scale);
        format = "\"" + format + "\"";
        PropertyInfo prop = new PropertyInfo();
        prop.setName("maximumValue");
        prop.setType(BigDecimal.class.getName());
        prop.setValue(format);
        prop.setOverride(true);
        return prop;
    }

    public static String getMininumValue(int length, int scale) {
        int i;
        if (length <= scale) {
            return null;
        }
        int realLength = length - scale;
        String format = "-";
        double minValue = MinFloat;
        for (i = 0; i < realLength; ++i) {
            format = format + "9";
        }
        if (scale > 0) {
            format = format + ".";
            for (i = 0; i < scale; ++i) {
                format = format + "9";
            }
        }
        try {
            if (Double.parseDouble(format) > minValue) {
                minValue = Double.parseDouble(format);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return String.valueOf(minValue);
    }

    public static String getMaximumValue(int length, int scale) {
        int i;
        if (length <= scale) {
            return null;
        }
        int realLength = length - scale;
        String format = "";
        double maxValue = MaxFloat;
        for (i = 0; i < realLength; ++i) {
            format = format + "9";
        }
        if (scale > 0) {
            format = format + ".";
            for (i = 0; i < scale; ++i) {
                format = format + "9";
            }
        }
        try {
            if (Double.parseDouble(format) < maxValue) {
                maxValue = Double.parseDouble(format);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return String.valueOf(maxValue);
    }

    public static PropertyInfo createPrecisionProperty(int precision) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("precision");
        prop.setType("int");
        prop.setValue(String.valueOf(precision));
        prop.setOverride(true);
        return prop;
    }

    private PropertyBindingInfo createTextPropBinding(BizConfigureItemInfo item, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        if (StringUtils.isEmpty((String)this.dataObjectName) || item == null || pInfo == null) {
            return null;
        }
        String propName = pInfo.getName();
        if (StringUtils.isEmpty((String)propName)) {
            if (DataSourceEnum.BASEDATAEXT.equals((Object)item.getDataSourceType()) && !StringUtils.isEmpty((String)item.getDataField())) {
                propName = item.getDataField();
            } else {
                return null;
            }
        }
        if (!(pInfo instanceof OwnPropertyInfo)) {
            return null;
        }
        PropertyBindingInfo pb = new PropertyBindingInfo();
        pb.setPropertyName("text");
        pb.setPropertyType(String.class.getName());
        pb.setBindingObject(this.dataObjectName);
        pb.setBingdingField(propName);
        pb.setFieldType(((OwnPropertyInfo)pInfo).getJavaType());
        pb.setAccessType(2);
        pb.setAutoMode(false);
        pb.setOverride(true);
        return pb;
    }

    private PropertyBindingInfo createValuePropBinding(BizConfigureItemInfo item, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        if (StringUtils.isEmpty((String)this.dataObjectName) || item == null || pInfo == null) {
            return null;
        }
        String propName = pInfo.getName();
        if (StringUtils.isEmpty((String)propName)) {
            if (DataSourceEnum.BASEDATAEXT.equals((Object)item.getDataSourceType()) && !StringUtils.isEmpty((String)item.getDataField())) {
                propName = item.getDataField();
            } else {
                return null;
            }
        }
        if (!(pInfo instanceof OwnPropertyInfo)) {
            return null;
        }
        PropertyBindingInfo pb = new PropertyBindingInfo();
        pb.setPropertyName("value");
        pb.setPropertyType(Object.class.getName());
        pb.setBindingObject(this.dataObjectName);
        pb.setBingdingField(item.getName());
        pb.setFieldType(((OwnPropertyInfo)pInfo).getJavaType());
        pb.setAccessType(2);
        pb.setAutoMode(false);
        pb.setOverride(true);
        return pb;
    }

    private PropertyBindingInfo createSelectedPropBinding(BizConfigureItemInfo item, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        if (StringUtils.isEmpty((String)this.dataObjectName) || item == null || pInfo == null) {
            return null;
        }
        String propName = pInfo.getName();
        if (StringUtils.isEmpty((String)propName)) {
            if (DataSourceEnum.BASEDATAEXT.equals((Object)item.getDataSourceType()) && !StringUtils.isEmpty((String)item.getDataField())) {
                propName = item.getDataField();
            } else {
                return null;
            }
        }
        if (!(pInfo instanceof OwnPropertyInfo)) {
            return null;
        }
        PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
        propertyBindingInfo.setPropertyName("selected");
        propertyBindingInfo.setPropertyType("boolean");
        propertyBindingInfo.setAccessType(2);
        propertyBindingInfo.setAutoMode(false);
        propertyBindingInfo.setBindingObject(this.dataObjectName);
        propertyBindingInfo.setBingdingField(propName);
        propertyBindingInfo.setFieldType(((OwnPropertyInfo)pInfo).getJavaType());
        propertyBindingInfo.setOverride(true);
        return propertyBindingInfo;
    }

    private PropertyBindingInfo createSelectedItemPropBinding(BizConfigureItemInfo item, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        if (StringUtils.isEmpty((String)this.dataObjectName) || item == null || pInfo == null) {
            return null;
        }
        String propName = pInfo.getName();
        if (StringUtils.isEmpty((String)propName)) {
            return null;
        }
        if (pInfo == null || !(pInfo instanceof OwnPropertyInfo)) {
            return null;
        }
        if (((OwnPropertyInfo)pInfo).getEnumType() == null) {
            return null;
        }
        PropertyBindingInfo pb = new PropertyBindingInfo();
        pb.setPropertyName("selectedItem");
        pb.setPropertyType(Object.class.getName());
        pb.setBindingObject(this.dataObjectName);
        pb.setBingdingField(propName);
        pb.setFieldType(((OwnPropertyInfo)pInfo).getEnumType().getClassName());
        pb.setAccessType(2);
        pb.setAutoMode(false);
        pb.setOverride(true);
        return pb;
    }

    private PropertyBindingInfo createF7DataPropBinding(EntityObjectInfo entity, String dataObjName, com.kingdee.bos.metadata.entity.PropertyInfo pInfo) {
        if (StringUtils.isEmpty((String)dataObjName) || pInfo == null || !(pInfo instanceof LinkPropertyInfo) || entity == null) {
            return null;
        }
        String propName = pInfo.getName();
        PropertyBindingInfo pb = new PropertyBindingInfo();
        pb.setPropertyName("data");
        pb.setPropertyType(Object.class.getName());
        pb.setBindingObject(dataObjName);
        pb.setBingdingField(propName);
        pb.setFieldType(((LinkPropertyInfo)pInfo).getRelationship().getSupplierObject().getObjectValueClass());
        pb.setAccessType(2);
        pb.setAutoMode(false);
        pb.setOverride(true);
        return pb;
    }

    private PropertyInfo createQueryInfoProperty(BizConfigureItemInfo item) {
        if (item == null) {
            return null;
        }
        String sQueryPK = item.getDataSource().getExtendedProperty("defaultF7Query");
        PropertyInfo prop = new PropertyInfo();
        prop.setName("queryInfo");
        prop.setType(String.class.getName());
        prop.setValue(sQueryPK);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createEditableProperty(BizConfigureItemInfo item) {
        if (item == null) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("editable");
        prop.setType("boolean");
        prop.setValue(String.valueOf(item.isEnabled()));
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createEditFormatProperty(BizConfigureItemInfo item) {
        if (item == null) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("editFormat");
        prop.setType(String.class.getName());
        prop.setValue("$number$");
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createCommitFormatProperty(BizConfigureItemInfo item) {
        if (item == null) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("commitFormat");
        prop.setType(String.class.getName());
        prop.setValue("$number$");
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createDisplayFormatProperty(BizConfigureItemInfo item) {
        if (item == null) {
            return null;
        }
        String sDataField = item.getDataField();
        PropertyInfo prop = new PropertyInfo();
        prop.setName("displayFormat");
        prop.setType(String.class.getName());
        if (StringUtils.isEmpty((String)sDataField)) {
            prop.setValue("$name$");
        } else {
            prop.setValue(UictEditUIProxy.parseStrToDisplayField(sDataField));
        }
        prop.setOverride(true);
        return prop;
    }

    public static String parseStrToDisplayField(String sDisField) {
        if (StringUtils.isEmpty((String)sDisField)) {
            return "$number$";
        }
        String strFirst = "";
        String strLeft = "";
        String strSecond = "";
        String strRight = "";
        String strTemp = "";
        String sDisplayFormat = "";
        boolean bAddDisField = false;
        int iPos = sDisField.indexOf("+");
        if (iPos > 0) {
            strFirst = sDisField.substring(0, iPos).trim();
            String sKey = "";
            strTemp = sDisField.substring(iPos + 2);
            sDisplayFormat = "$" + strFirst + "$";
            if (sDisField.trim().length() > iPos && strTemp.trim().length() > 0 && (iPos = strTemp.indexOf("+")) > 0) {
                strLeft = strTemp.substring(0, iPos);
                strLeft = strLeft.replaceAll("\"", "");
                sDisplayFormat = sDisplayFormat + strLeft;
                if (strTemp.trim().length() > iPos + 1 && (strTemp = strTemp.substring(iPos + 2)).trim().length() > 0 && (iPos = strTemp.indexOf("+")) > 0) {
                    strSecond = strTemp.substring(0, iPos);
                    sDisplayFormat = sDisplayFormat + "$" + strSecond.trim() + "$";
                    if (strTemp.length() > iPos + 1) {
                        strRight = strTemp.substring(iPos + 2);
                        strRight = strRight.replaceAll("\"", "");
                        sDisplayFormat = sDisplayFormat + strRight;
                    }
                }
            }
        } else {
            strFirst = sDisField.trim();
            sDisplayFormat = "$" + strFirst + "$";
        }
        return sDisplayFormat;
    }
}

